/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;

public class ClassifierJCL
extends ClassifierByRecord {
    public static final int JCL_EXTENSION_CA7 = 1;
    public static final int JCL_EXTENSION_CONTROL_M = 2;
    public static final int SYMBOL_TEXT_MAX_LENGTH = 230;
    private boolean after_first_proc;
    private boolean first_proc;
    private boolean J_Continuation;
    private int commentCount_ControlM;
    private int continuedOperatorLines;
    private int linesWithJclExtension_CA7;
    private int linesWithJclExtension_ControlM;
    private int noncomment_aft_proc;
    private String Name;
    private String Operator;
    private String Parameter;

    public ClassifierJCL(ScanProperties scanProperties) {
        super(scanProperties);
        this.init();
    }

    private int calculateSLOC(int lineCount) {
        return lineCount - this.blankLineCount - this.getCommentCount();
    }

    @Override
    public String getLanguageCd() {
        return "JCL";
    }

    @Override
    public String getLanguageDescription() {
        return "JCL";
    }

    @Override
    public int getLanguageId() {
        return 14;
    }

    private void captureIncludeFromControlM(String record, int index) {
        if (index == -1) {
            return;
        }
        String subRecord = record.substring(index + 7).trim();
        String memberName = (index = subRecord.indexOf(" ")) != -1 ? subRecord.substring(0, index) : subRecord;
        this.RecordIncludedSource(1, memberName);
    }

    private boolean checkStatementsForCA7(String iRecord) {
        String record = iRecord.trim();
        if (!record.startsWith("#")) {
            return false;
        }
        int length = record.length();
        if (length < 3) {
            return false;
        }
        String token = record.substring(0, 3);
        if (token.equals("#JI") || token.equals("#JO") || token.equals("#XI") || token.equals("#XO")) {
            return true;
        }
        if (length < 4) {
            return false;
        }
        token = record.substring(0, 4);
        if (token.equals("#ARF") || token.equals("#HLD") || token.equals("#JCL") || token.equals("#MNT") || token.equals("#MSG") || token.equals("#NOX") || token.equals("#NTR") || token.equals("#RES") || token.equals("#SCC") || token.equals("#VER")) {
            return true;
        }
        if (length < 5) {
            return false;
        }
        token = record.substring(0, 5);
        return token.equals("#JEND") || token.equals("#XEND") || token.equals("#7UNI");
    }

    private boolean checkStatementsForControlM(String iRecord) {
        String record = iRecord.trim();
        if (record.startsWith("*")) {
            ++this.commentCount_ControlM;
            ++this.linesWithJclExtension_ControlM;
            this.score += 5;
            return true;
        }
        if (record.startsWith("%%")) {
            if (record.startsWith("%%ELSE") || record.startsWith("%%ENDIF") || record.startsWith("%%IF") || record.startsWith("%%GLOBAL") || record.startsWith("%%GOTO") || record.startsWith("%%LABEL") || record.startsWith("%%LISTVAR") || record.startsWith("%%LISTVARS") || record.startsWith("%%RESOLVE") || record.startsWith("%%SET")) {
                ++this.linesWithJclExtension_ControlM;
                this.score += 10;
            } else if (record.startsWith("%%INCLIB")) {
                ++this.linesWithJclExtension_ControlM;
                this.score += 10;
                int i = record.indexOf("%INCMEM");
                this.captureIncludeFromControlM(record, i);
            } else if (record.startsWith("%%LIBSYM")) {
                ++this.linesWithJclExtension_ControlM;
                this.score += 10;
                int i = record.indexOf("%MEMSYM");
                this.captureIncludeFromControlM(record, i);
            } else {
                ++this.linesWithJclExtension_ControlM;
                this.score += 5;
            }
            return true;
        }
        return false;
    }

    private void clearTokenFields() {
        this.continuedOperatorLines = 0;
        this.Name = "";
        this.Operator = "";
        this.Parameter = "";
    }

    private void CompleteJStatement(int iLineCount) {
        int parmLength;
        if (this.Name.equals("JOBLIB") || this.Name.equals("STEPLIB")) {
            ++this.reserveWordCount;
            this.score += 50;
        }
        if (this.Operator.equals("CNTL") || this.Operator.equals("COMMAND") || this.Operator.equals("ELSE") || this.Operator.equals("ENDCNTL") || this.Operator.equals("ENDIF") || this.Operator.equals("IF") || this.Operator.equals("JCLLIB") || this.Operator.equals("OUTPUT") || this.Operator.equals("SET") || this.Operator.equals("XMIT")) {
            ++this.reserveWordCount;
        } else if (this.Operator.equals("COPY") || this.Operator.equals("INCLUDE")) {
            if (this.Parameter.contains("MEMBER=(")) {
                ++this.reserveWordCount;
                String pChar = this.Parameter.substring(8);
                this.RecordIncludedSource(1, pChar);
            } else if (this.Parameter.contains("MEMBER=")) {
                ++this.reserveWordCount;
                String pChar = this.Parameter.substring(7);
                this.RecordIncludedSource(1, pChar);
            }
        } else if (this.Operator.equals("DD")) {
            ++this.reserveWordCount;
            this.score += 500;
            if (this.identifierMode == 'U') {
                this.identifierMode = (char)67;
            }
        } else if (this.Operator.equals("EXEC")) {
            ++this.reserveWordCount;
            this.score += 500;
            this.metaData.incrementNumValue(53);
            if (this.identifierMode == 'U') {
                this.identifierMode = (char)67;
            }
            if (this.Parameter.length() != 0) {
                if (this.Parameter.contains("PGM=")) {
                    this.metaData.incrementNumValue(54);
                } else {
                    int pSearchChar = this.Parameter.indexOf(",");
                    if (pSearchChar != -1) {
                        this.Parameter = this.Parameter.substring(0, pSearchChar);
                    }
                    if (this.Parameter.contains("PROC=")) {
                        String pChar = this.Parameter.substring(5);
                        this.RecordIncludedSource(9, pChar);
                    } else {
                        this.RecordIncludedSource(9, this.Parameter);
                    }
                }
            }
        } else if (this.Operator.equals("JOB") || this.Operator.equals("JOB,")) {
            ++this.reserveWordCount;
            this.score += 500;
            this.metaData.incrementNumValue(52);
            if (this.identifierMode == 'U') {
                this.identifierMode = (char)67;
            }
        } else if (this.Operator.equals("PROC")) {
            ++this.reserveWordCount;
            if (this.first_proc) {
                this.metaData.setNonCommentBefore1st(iLineCount - this.continuedOperatorLines - this.blankLineCount - this.getCommentCount() - 1);
                this.first_proc = false;
            }
        } else if (this.Operator.equals("PEND")) {
            ++this.reserveWordCount;
            this.after_first_proc = true;
        }
        if (this.Name.length() != 0) {
            this.metaData.addSymbolUserDefined(this.Name);
        }
        if ((parmLength = this.Parameter.length()) != 0) {
            if (parmLength > 230) {
                String parmFrag;
                String s = this.Parameter;
                this.Parameter = parmFrag = s.substring(0, 229);
            }
            this.metaData.addSymbolUserDefined(this.Parameter);
        }
    }

    private boolean containsCA7() {
        return this.linesWithJclExtension_CA7 != 0;
    }

    private boolean containsControlM() {
        return this.linesWithJclExtension_ControlM != 0;
    }

    @Override
    public boolean getIgnoreCase() {
        return true;
    }

    private void init() {
        this.after_first_proc = false;
        this.commentCount_ControlM = 0;
        this.first_proc = true;
        this.J_Continuation = false;
        this.linesWithJclExtension_CA7 = 0;
        this.linesWithJclExtension_ControlM = 0;
        this.noncomment_aft_proc = 0;
        this.clearTokenFields();
    }

    @Override
    public void isScoreBad(int lineCount, String languageHint) {
        if (this.reserveWordCount != 0) {
            return;
        }
        if (lineCount == this.commentCount_ControlM) {
            this.score = 0;
            return;
        }
        int commentCount = this.getCommentCount();
        if (lineCount == commentCount) {
            return;
        }
        if (lineCount == commentCount + this.linesWithJclExtension_ControlM) {
            return;
        }
        this.score = 0;
    }

    @Override
    public ClassifierMetaData processEndOfFile(int lineCount) {
        if (this.after_first_proc) {
            this.metaData.setNonAfter(this.noncomment_aft_proc);
        }
        if (this.containsCA7()) {
            this.metaData.setJclExtension(1);
        } else if (this.containsControlM()) {
            this.metaData.setJclExtension(2);
        }
        this.metaData.setBlanklines(this.blankLineCount);
        this.metaData.setNonCommentLines(this.calculateSLOC(lineCount));
        this.metaData.setTotalLines(lineCount);
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        this.init();
        this.identifierMode = (char)85;
        this.metaData = new ClassifierMetaData();
    }

    @Override
    public void processOneRecord(int recordCount, String literalRecord, String record, String languageHint) {
        if (this.checkStatementsForCA7(record)) {
            return;
        }
        if (this.checkStatementsForControlM(record)) {
            return;
        }
        if (this.identifierMode == 'U' && !record.startsWith("/")) {
            if (record.startsWith(" ")) {
                String tempChar = record.trim();
                if (tempChar.length() == 0) {
                    return;
                }
            } else if (!languageHint.equals("JCL")) {
                this.rejectThisLanguageCd();
                return;
            }
        }
        if (!record.startsWith("/")) {
            return;
        }
        if (record.startsWith("/*")) {
            if (this.after_first_proc) {
                ++this.noncomment_aft_proc;
            }
            return;
        }
        if (!record.startsWith("//")) {
            return;
        }
        if (record.startsWith("//*")) {
            this.score += 5;
            this.metaData.incrementCommentLines();
            return;
        }
        this.score += 8;
        if (record.equals("//")) {
            return;
        }
        String jclText = record.substring(2).trim();
        if (jclText.length() == 0) {
            return;
        }
        if (this.after_first_proc) {
            ++this.noncomment_aft_proc;
        }
        String[] tokens = StringUtils.splitQuoted(jclText, ' ', false, false, true);
        if (this.J_Continuation) {
            ++this.continuedOperatorLines;
            if (tokens.length != 0) {
                this.Parameter = String.valueOf(this.Parameter) + tokens[0];
            }
            this.J_Continuation = false;
        } else {
            this.clearTokenFields();
            if (record.startsWith("// ")) {
                if (tokens.length == 1) {
                    this.Operator = tokens[0];
                } else if (tokens.length > 1) {
                    this.Operator = tokens[0];
                    this.Parameter = tokens[1];
                }
            } else if (tokens.length == 1) {
                this.Name = tokens[0];
            } else if (tokens.length == 2) {
                this.Name = tokens[0];
                this.Operator = tokens[1];
            } else if (tokens.length > 2) {
                this.Name = tokens[0];
                this.Operator = tokens[1];
                this.Parameter = tokens[2];
            }
        }
        if (this.Parameter.endsWith(",")) {
            this.J_Continuation = true;
        } else {
            this.CompleteJStatement(recordCount);
            this.clearTokenFields();
        }
    }

    private void RecordIncludedSource(int inclTypeId, String inclName) {
        if (this.DMHU997(inclName)) {
            this.metaData.captureInclude(inclTypeId, inclName);
        }
    }

    private boolean DMHU997(String iFileName) {
        String validFirstChar;
        String validChars;
        int MEMBER_NAME_LENGTH;
        if (this.isWindows) {
            MEMBER_NAME_LENGTH = 255;
            validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$#@1234567890-._ ~";
            validFirstChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$#@1234567890-._~";
        } else {
            MEMBER_NAME_LENGTH = 11;
            validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$#@1234567890-";
            validFirstChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$#@";
        }
        int length = iFileName.length();
        if (length > MEMBER_NAME_LENGTH - 1) {
            return false;
        }
        if (length < 1) {
            return false;
        }
        boolean invalidCharFound = false;
        char[] validCharArray = validChars.toCharArray();
        int i = 0;
        while (i < iFileName.length()) {
            boolean foundCharInArray = false;
            int j = 0;
            while (j < validCharArray.length) {
                if (iFileName.charAt(i) == validCharArray[j]) {
                    foundCharInArray = true;
                    break;
                }
                ++j;
            }
            if (!foundCharInArray) {
                invalidCharFound = true;
                break;
            }
            ++i;
        }
        if (invalidCharFound) {
            return false;
        }
        String firstChar = iFileName.substring(0, 1);
        return validFirstChar.contains(firstChar);
    }
}

