/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecord;

public class ClassifierISPF
extends ClassifierByRecord {
    private boolean requiredSection = false;
    private int panelSections = 0;

    public ClassifierISPF(ScanProperties scanProperties) {
        super(scanProperties);
    }

    @Override
    public String getLanguageCd() {
        return "ISPF";
    }

    @Override
    public String getLanguageDescription() {
        return "ISPF Panel";
    }

    @Override
    public int getLanguageId() {
        return 12;
    }

    @Override
    public void isScoreBad(int iLineCount, String languageHint) {
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        this.metaData.setTotalLines(iLineCount);
        this.metaData.setBlanklines(this.blankLineCount);
        this.metaData.setNonCommentLines(iLineCount - this.blankLineCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        this.currentToken = "";
        this.previousToken = "";
        this.reserveWordCount = 0;
        this.identifierMode = (char)85;
        this.metaData = new ClassifierMetaData();
    }

    @Override
    public void processOneRecord(int recordCount, String literalRecord, String inputRecord, String languageHint) {
        String recordTrimmed;
        char[] inputRecordCharArray = inputRecord.toCharArray();
        int columnCurrentRecord = 1;
        int index = 0;
        while (index < inputRecordCharArray.length && inputRecordCharArray[index] == ' ') {
            columnCurrentRecord = (short)(columnCurrentRecord + 1);
            ++index;
        }
        if (index == inputRecordCharArray.length) {
            ++this.blankLineCount;
            return;
        }
        String record = inputRecord.substring(index);
        if (record.startsWith("/*") && (recordTrimmed = record.trim()).endsWith("*/")) {
            this.metaData.incrementCommentLines();
            return;
        }
        if (columnCurrentRecord == 1) {
            if (record.startsWith(")ABC") || record.startsWith(")ABCINIT") || record.startsWith(")ABCPROC") || record.startsWith(")AREA") || record.startsWith(")ATTR") || record.startsWith(")CCSID") || record.startsWith(")FIELD") || record.startsWith(")HELP") || record.startsWith(")INIT") || record.startsWith(")LIST") || record.startsWith(")MODEL") || record.startsWith(")PANEL") || record.startsWith(")PNTS") || record.startsWith(")PROC") || record.startsWith(")REINIT")) {
                ++this.panelSections;
                this.increaseScore(100);
            } else if (record.startsWith(")BODY") || record.startsWith(")END")) {
                ++this.panelSections;
                this.requiredSection = true;
                this.increaseScore(500);
            }
        }
    }
}

