/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierReservedWord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsEASY;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierASM;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierC;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCOB;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCPP;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierJCL;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLI;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLX;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;

public class ClassifierEASY
extends ClassifierByRecord {
    private boolean EASY_majorKeyWordFound = false;
    private char EASY_featurestate = (char)73;
    private char EASY_keywordFlag1 = (char)70;
    private char EASY_keywordFlag2 = (char)70;
    private char EASY_keywordFlag3 = (char)70;
    private char EASY_keywordFlag4 = (char)70;
    private char EASY_tokenState = (char)83;
    private char stringDelimiter = (char)32;
    private String EASY_majorKeyWordToken = "";

    public ClassifierEASY(ScanProperties scanProperties) {
        super(scanProperties);
    }

    private int calculateSLOC(int lineCount) {
        return lineCount - this.blankLineCount - this.getCommentCount();
    }

    @Override
    public String getLanguageCd() {
        return "EASY";
    }

    @Override
    public String getLanguageDescription() {
        return "CA-Easytrieve";
    }

    @Override
    public int getLanguageId() {
        return 8;
    }

    private void AccumulatePointsForTheScore(ClassifierReservedWord rw, int lineCount) {
        int tokenWordType = rw.getTokenWordType();
        switch (tokenWordType) {
            case 1: {
                if (this.currentToken.equals("X") && !this.EASY_majorKeyWordToken.equals("FILE")) {
                    this.EASY_majorKeyWordToken.equals("DEFINE");
                }
                this.increaseScore(rw.getTokenWeight());
                break;
            }
            case 3: {
                this.increaseScore(rw.getTokenWeight());
                ++this.reserveWordCount;
                if (this.currentToken.equals("DEFINE") || this.currentToken.equals("FILE") || this.currentToken.equals("JOB") || this.currentToken.equals("PARM") || this.currentToken.equals("REPORT") || this.currentToken.equals("SORT")) {
                    if (this.tokenNumberOnLine == 1) {
                        this.EASY_majorKeyWordFound = true;
                        this.EASY_majorKeyWordToken = this.currentToken;
                    }
                } else if (this.currentToken.equals("MACRO") && this.tokenNumberOnLine == 1) {
                    this.EASY_majorKeyWordFound = true;
                    this.EASY_majorKeyWordToken = this.currentToken;
                    this.metaData.setNonCommentBefore1st(this.calculateSLOC(lineCount) - 1);
                }
                if (this.EASY_keywordFlag1 != 'F' || this.EASY_keywordFlag2 != '.' || !this.previousToken.equals("PROC")) break;
                this.increaseScore(250);
                break;
            }
            default: {
                this.increaseScore(rw.getTokenWeight());
            }
        }
    }

    private void CompleteToken(int lineCount, String languageHint) {
        this.tokenNumberOnLine = (short)(this.tokenNumberOnLine + 1);
        this.EASY_tokenState = (char)83;
        this.EASY_keywordFlag1 = this.EASY_keywordFlag2;
        this.EASY_keywordFlag2 = this.EASY_keywordFlag3;
        this.EASY_keywordFlag3 = this.EASY_keywordFlag4;
        if (this.currentToken.charAt(0) == '\"' || this.currentToken.charAt(0) == '\'' || this.currentToken.charAt(0) == '(' || this.currentToken.charAt(0) == ')') {
            this.EASY_keywordFlag4 = (char)70;
            this.previousToken = this.currentToken;
            this.currentToken = "";
            return;
        }
        ClassifierReservedWord rw = null;
        if (ReservedWordsEASY.containsKey(this.currentToken)) {
            String value = ReservedWordsEASY.get(this.currentToken);
            rw = this.allocateReserveWord(this.currentToken, value);
        }
        if (rw != null) {
            this.EASY_keywordFlag4 = (char)84;
            this.AccumulatePointsForTheScore(rw, lineCount);
        } else {
            this.EASY_keywordFlag4 = this.currentToken.charAt(0) == '.' ? (char)46 : (char)70;
        }
        switch (this.EASY_featurestate) {
            case 'E': {
                if (!languageHint.equals("EASY")) {
                    if (this.currentToken.equals("CICS")) {
                        this.rejectThisLanguageCd();
                        break;
                    }
                    if (this.currentToken.equals("SQL")) {
                        this.rejectThisLanguageCd();
                        break;
                    }
                }
                this.EASY_featurestate = (char)73;
                break;
            }
            case 'I': {
                if (!this.currentToken.equals("EXEC") && !this.currentToken.equals("EXECUTE")) break;
                this.EASY_featurestate = (char)69;
                break;
            }
        }
        this.previousToken = this.currentToken;
        this.currentToken = "";
    }

    public boolean getEasyMajorKeyWordFound() {
        return this.EASY_majorKeyWordFound;
    }

    @Override
    public void isScoreBad(int lineCount, String languageHint) {
        int commentLines;
        int nonBlankLines;
        int nonComments;
        if (!this.getEasyMajorKeyWordFound()) {
            this.score = 0;
        } else if (this.reserveWordCount <= 99 && (double)this.reserveWordCount < (double)(nonComments = (nonBlankLines = lineCount - this.blankLineCount) - (commentLines = this.getCommentCount())) * 0.2) {
            this.score = 0;
        }
    }

    @Override
    public void isScoreStillBad(int lineCount, ClassifierASM classifierASM, ClassifierC classifierC, ClassifierCOB classifierCOB, ClassifierCPP classifierCPP, ClassifierEASY classifierEASY, ClassifierJCL classifierJCL, ClassifierPLI classifierPLI, ClassifierPLX classifierPLX) {
        int cScore = classifierC.getScore();
        int cppScore = classifierCPP.getScore();
        if (cScore != 0 && cppScore != 0 && (cScore > this.score || cppScore > this.score)) {
            this.score = 0;
        }
    }

    private boolean lastCharOnTheRecord(int index, char[] inputRecordCharArray) {
        boolean rc = true;
        ++index;
        while (index < inputRecordCharArray.length) {
            if (inputRecordCharArray[index] == ' ') {
                ++index;
                continue;
            }
            rc = false;
            break;
        }
        return rc;
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        this.metaData.setTotalLines(iLineCount);
        this.metaData.setBlanklines(this.blankLineCount);
        this.metaData.setNonCommentLines(iLineCount - this.blankLineCount - this.getCommentCount());
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        this.currentToken = "";
        this.EASY_featurestate = (char)73;
        this.EASY_keywordFlag1 = (char)70;
        this.EASY_keywordFlag2 = (char)70;
        this.EASY_keywordFlag3 = (char)70;
        this.EASY_keywordFlag4 = (char)70;
        this.EASY_majorKeyWordFound = false;
        this.EASY_majorKeyWordToken = "";
        this.EASY_tokenState = (char)83;
        this.previousToken = "";
        this.reserveWordCount = 0;
        this.identifierMode = (char)85;
        this.metaData = new ClassifierMetaData();
    }

    @Override
    public void processOneRecord(int recordCount, String literalRecord, String inputRecord, String languageHint) {
        char[] inputRecordCharArray = inputRecord.toCharArray();
        int columnCurrentRecord = 1;
        int index = 0;
        while (index < inputRecordCharArray.length && inputRecordCharArray[index] == ' ') {
            columnCurrentRecord = (short)(columnCurrentRecord + 1);
            ++index;
        }
        if (index == inputRecordCharArray.length) {
            ++this.blankLineCount;
            return;
        }
        String record = inputRecord.substring(index);
        if (record.startsWith("/*")) {
            return;
        }
        if (record.charAt(0) == '*') {
            if (columnCurrentRecord != 7) {
                this.increaseScore(5);
                this.metaData.incrementCommentLines();
            }
            return;
        }
        if (record.length() > 7 && record.charAt(6) == '*') {
            return;
        }
        this.tokenNumberOnLine = 0;
        boolean newLine = true;
        int prevChar = 32;
        while (index < inputRecordCharArray.length) {
            String ifDecimalPoint;
            boolean isDelimiter = inputRecordCharArray[index] == '(' || inputRecordCharArray[index] == ')' || inputRecordCharArray[index] == ',' || inputRecordCharArray[index] == ':' || inputRecordCharArray[index] == '=' || inputRecordCharArray[index] == '\'' || inputRecordCharArray[index] == ' ' ? true : (inputRecordCharArray[index] == '.' ? (this.currentToken.length() == 0 ? false : (!StringUtils.isNumeric(this.currentToken) ? true : ((record = inputRecord.substring(index)).length() == 1 ? true : !StringUtils.isNumeric(ifDecimalPoint = record.substring(1, 2))))) : false);
            boolean tokenComplete = false;
            block0 : switch (this.EASY_tokenState) {
                case 'B': {
                    if (!newLine && inputRecordCharArray[index] == ' ') break;
                    tokenComplete = true;
                    break;
                }
                case 'C': {
                    if (newLine) {
                        tokenComplete = true;
                        break;
                    }
                    if (inputRecordCharArray[index] == ' ') {
                        this.EASY_tokenState = (char)66;
                        break;
                    }
                    if (isDelimiter) {
                        tokenComplete = true;
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[index];
                    break;
                }
                case 'E': {
                    if (inputRecordCharArray[index] == this.stringDelimiter) {
                        this.EASY_tokenState = (char)81;
                        break;
                    }
                    tokenComplete = true;
                    break;
                }
                case 'Q': {
                    if (inputRecordCharArray[index] == this.stringDelimiter) {
                        this.EASY_tokenState = (char)69;
                    }
                    if ((inputRecordCharArray[index] == '+' || inputRecordCharArray[index] == '-') && this.lastCharOnTheRecord(index, inputRecordCharArray)) break;
                    this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[index];
                    break;
                }
                case 'S': {
                    switch (inputRecordCharArray[index]) {
                        case ' ': {
                            break block0;
                        }
                        case 'X': {
                            this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[index];
                            this.EASY_tokenState = (char)88;
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.stringDelimiter = inputRecordCharArray[index];
                            this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[index];
                            this.EASY_tokenState = (char)81;
                            break block0;
                        }
                    }
                    if ((inputRecordCharArray[index] == '+' || inputRecordCharArray[index] == '-') && this.lastCharOnTheRecord(index, inputRecordCharArray)) break;
                    this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[index];
                    if (isDelimiter) {
                        ++index;
                        tokenComplete = true;
                        break;
                    }
                    this.EASY_tokenState = (char)67;
                    break;
                }
                case 'X': {
                    switch (inputRecordCharArray[index]) {
                        case ' ': {
                            this.EASY_tokenState = (char)66;
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.stringDelimiter = inputRecordCharArray[index];
                            this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[index];
                            this.EASY_tokenState = (char)81;
                            break block0;
                        }
                    }
                    if (isDelimiter) {
                        tokenComplete = true;
                        break;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + inputRecordCharArray[index];
                    this.EASY_tokenState = (char)67;
                    break;
                }
            }
            if (tokenComplete || this.currentToken.length() >= 255) {
                this.CompleteToken(recordCount, languageHint);
                if (this.identifierMode == 'R') {
                    break;
                }
            } else {
                if (prevChar != 32) {
                    prevChar = inputRecordCharArray[index];
                }
                ++index;
            }
            newLine = false;
        }
        if (this.identifierMode == 'R') {
            return;
        }
        if (prevChar == 43 || prevChar == 45) {
            return;
        }
        if (this.EASY_tokenState != 'S') {
            this.CompleteToken(recordCount, languageHint);
        }
    }
}

