/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierReservedWord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsCPP;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierASM;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierC;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCOB;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierEASY;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierJCL;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLI;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLX;

public class ClassifierCPP
extends ClassifierC {
    public ClassifierCPP(ScanProperties scanProperties) {
        super(scanProperties);
    }

    @Override
    protected ClassifierReservedWord checkIfReservedWord() {
        ClassifierReservedWord rw = null;
        if (ReservedWordsCPP.containsKey(this.currentToken)) {
            String value = ReservedWordsCPP.get(this.currentToken);
            rw = this.allocateReserveWord(this.currentToken, value);
        }
        return rw;
    }

    @Override
    public String getLanguageCd() {
        return "CPP";
    }

    @Override
    public String getLanguageDescription() {
        return "C++";
    }

    @Override
    public int getLanguageId() {
        return 7;
    }

    @Override
    protected void AccumulatePointsForTheScore(ClassifierReservedWord rw) {
        this.score += rw.getTokenWeight();
        switch (rw.getTokenWordType()) {
            case 1: {
                ++this.reserveWordCount;
                break;
            }
            case 5: {
                ++this.languageWordCount;
                break;
            }
        }
    }

    @Override
    public void isScoreBad(int iLineCount, String languageHint) {
        if (this.languageWordCount == 0 && this.reserveWordCount == 0) {
            this.score = 0;
        }
    }

    @Override
    public void isScoreStillBad(int lineCount, ClassifierASM classifierASM, ClassifierC classifierC, ClassifierCOB classifierCOB, ClassifierCPP classifierCPP, ClassifierEASY classifierEASY, ClassifierJCL classifierJCL, ClassifierPLI classifierPLI, ClassifierPLX classifierPLX) {
        int cppScore = classifierCPP.getScore();
        if (this.score == cppScore) {
            this.score = 0;
        }
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
    }
}

