/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierReservedWord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.reservedWords.ReservedWordsCOB;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecordCobPliPlx;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class ClassifierCOB
extends ClassifierByRecordCobPliPlx {
    private static final String FIGURATIVE_CONSTANTS = "'HIGH-VALUE', 'HIGH-VALUES', 'LOW-VALUE', 'LOW-VALUES', 'NULL', 'NULLS', 'SPACE', 'SPACES', 'ZERO', 'ZEROES', 'ZEROS'";
    private static Set<String> figurativeConstants;
    private boolean buildingPictureClause;
    private boolean C_Continuation;
    private boolean C_NewLine;
    private boolean CBL_marker;
    private boolean found_COPY_IN;
    private boolean found_IDMS_SECTION;
    private boolean idDivFound;
    private boolean inRemarksParaFlag;
    private boolean invalidCOBOLsequence;
    private boolean suspectFreeFormatCobol;
    private boolean validatedPrevCol7Comment;
    private boolean watchForCommentDelimiter;
    private char C_StringDelimiter;
    private char C_TokenState;
    private char inDivision;
    private int compilerDirectingCount_COBOL;
    private int inclTypeId;
    private int inputRecordCount;
    private int periodWORDperiod;
    private int pictureCount;
    private int verbCount_COBOL;
    private String includedDDName;
    private String includedMemberName;
    private String literalRecord;

    static {
        String[] fcs;
        figurativeConstants = new HashSet<String>();
        String[] stringArray = fcs = StringUtils.split(FIGURATIVE_CONSTANTS, ",");
        int n = fcs.length;
        int n2 = 0;
        while (n2 < n) {
            String fc = stringArray[n2];
            fc = StringUtils.strip(fc, "'");
            fc = fc.trim();
            figurativeConstants.add(fc);
            ++n2;
        }
    }

    public ClassifierCOB(ScanProperties scanProperties) {
        super(scanProperties);
        this.initializeInstanceVariables();
    }

    private void addToCurrentToken(char text) {
        this.currentToken = String.valueOf(this.currentToken) + text;
    }

    private void addToLiteralToken() {
        this.literalToken = String.valueOf(this.literalToken) + this.literalRecord.charAt(this.columnCurrentRecord - 1);
    }

    private void captureEntryPointName() {
        if (this.previousPreviousToken.equals("PROGRAM-ID") && this.previousToken.equals(".") || this.previousToken.equals("PROGRAM-ID")) {
            this.metaData.addEntryPoint(this.currentToken);
        } else if (this.previousToken.equals("ENTRY") && !this.previousPreviousToken.equals("TO")) {
            this.metaData.addEntryPoint(this.currentToken);
        }
    }

    @Override
    protected boolean checkPlusPlusInclude(String inputRecord) {
        String s;
        if (inputRecord.length() < 18) {
            return false;
        }
        if (!this.scanProperties.getAllowIncludeInAnyColumn()) {
            if (!this.scanProperties.getExpandIncludeInComment() && ((s = inputRecord.substring(6)).startsWith("*") || s.startsWith("/"))) {
                return false;
            }
            s = inputRecord.substring(7);
        } else {
            s = inputRecord.substring(6);
            if (s.startsWith("*") || s.startsWith("/")) {
                if (!this.scanProperties.getExpandIncludeInComment()) {
                    return false;
                }
                s = inputRecord.substring(7);
            }
            while (s.startsWith(" ")) {
                s = s.substring(1);
            }
        }
        return this.capturePlusPlusIncludeName(s, this.scanProperties.getTruncateFilenames());
    }

    @Override
    public String getLanguageCd() {
        return "COB";
    }

    @Override
    public String getLanguageDescription() {
        return "COBOL";
    }

    @Override
    protected String getEndExecToken() {
        return "END-EXEC";
    }

    @Override
    public int getLanguageId() {
        return 6;
    }

    private void AccumulatePointsForTheScore(char[] inputRecordCharArray, ClassifierReservedWord rw) {
        int attrTypeId;
        this.periodWORDperiod = 0;
        if (this.EXEC_CICS_flag || this.EXEC_SQL_flag) {
            return;
        }
        if (!(!this.inRemarksParaFlag || this.tokenNumberOnLine == 1 && (this.currentToken.equalsIgnoreCase("ID") || this.currentToken.equalsIgnoreCase("IDENTIFICATION") || this.currentToken.equalsIgnoreCase("ENVIRONMENT") || this.currentToken.equalsIgnoreCase("DATA") || this.currentToken.equalsIgnoreCase("PROCEDURE")))) {
            return;
        }
        int tokenWordType = rw.getTokenWordType();
        switch (tokenWordType) {
            case 1: {
                if (this.currentToken.equalsIgnoreCase("FILLER")) {
                    if (this.tokenNumberOnLine != 2 && !StringUtils.isNumeric(this.previousToken)) break;
                    this.increaseScore(rw.getTokenWeight());
                    break;
                }
                this.increaseScore(rw.getTokenWeight());
                if (this.currentToken.equalsIgnoreCase("PIC")) {
                    if (inputRecordCharArray[this.ircaIndex] == '\'') break;
                    ++this.pictureCount;
                    break;
                }
                if (!this.currentToken.equalsIgnoreCase("PICTURE")) break;
                ++this.pictureCount;
                break;
            }
            case 3: {
                this.increaseScore(rw.getTokenWeight());
                ++this.verbCount_COBOL;
            }
            default: {
                this.increaseScore(rw.getTokenWeight());
            }
        }
        if (this.tokenNumberOnLine == 1 && (this.currentToken.equalsIgnoreCase("BASIS") || this.currentToken.equalsIgnoreCase("CBL") || this.currentToken.equalsIgnoreCase("COPY") || this.currentToken.equalsIgnoreCase("DELETE") || this.currentToken.equalsIgnoreCase("EJECT") || this.currentToken.equalsIgnoreCase("ENTER") || this.currentToken.equalsIgnoreCase("INSERT") || this.currentToken.equalsIgnoreCase("PROCESS") || this.currentToken.equalsIgnoreCase("READY") || this.currentToken.equalsIgnoreCase("RESET") || this.currentToken.equalsIgnoreCase("REPLACE") || this.currentToken.equalsIgnoreCase("SERVICE") || this.currentToken.equalsIgnoreCase("SKIP1") || this.currentToken.equalsIgnoreCase("SKIP2") || this.currentToken.equalsIgnoreCase("SKIP3") || this.currentToken.equalsIgnoreCase("TITLE") || this.currentToken.equalsIgnoreCase("USE") || this.currentToken.equalsIgnoreCase("*CBL") || this.currentToken.equalsIgnoreCase("*CONTROL"))) {
            ++this.compilerDirectingCount_COBOL;
            this.increaseScore(2);
        }
        if ((attrTypeId = rw.getTokenAttrTypeId()) != 0 && this.inDivision == 'P') {
            this.metaData.incrementNumValue(attrTypeId);
            if (this.debug == 2) {
                System.out.println("attrTypeId[" + attrTypeId + "] recordCount[" + this.inputRecordCount + "] currentToken[" + this.currentToken + "]");
            }
        }
    }

    private void CaptureCopyName() {
        String inclName = this.includedMemberName.length() > 5 && this.includedMemberName.substring(0, 5).equalsIgnoreCase("LIB$:") ? this.includedMemberName.substring(5) : this.includedMemberName;
        if (this.inclTypeId == 4) {
            this.metaData.captureInclude(inclName, this.includedDDName, this.debug);
            this.includedDDName = "";
        } else {
            this.metaData.captureInclude(this.inclTypeId, inclName);
        }
        this.found_COPY_IN = false;
        this.inclTypeId = 3;
        this.includedMemberName = "";
    }

    private boolean CheckAlternateLocationOfINC(String inputRecord) {
        if (inputRecord.length() < 12) {
            return false;
        }
        String record = inputRecord.substring(6);
        String recordTrimmed = record.trim();
        if (recordTrimmed.length() == 0) {
            return false;
        }
        if (recordTrimmed.startsWith("-INC ")) {
            return this.captureIncMemberName(recordTrimmed);
        }
        return false;
    }

    private boolean checkContinuedLiteral(char[] inputRecordCharArray) {
        if (this.C_Continuation) {
            this.columnCurrentRecord = (short)8;
            this.ircaIndex = 7;
            this.skipLeadingWhiteSpace(inputRecordCharArray);
            if (this.ircaIndex >= inputRecordCharArray.length) {
                return false;
            }
            if (inputRecordCharArray[this.ircaIndex] == '\"' || inputRecordCharArray[this.ircaIndex] == '\'') {
                this.moveToNextCharOnRecord();
            }
            return true;
        }
        if (inputRecordCharArray.length < 12) {
            this.TokenComplete(inputRecordCharArray);
            return true;
        }
        if (inputRecordCharArray[7] != ' ' || inputRecordCharArray[8] != ' ' || inputRecordCharArray[9] != ' ' || inputRecordCharArray[10] != ' ') {
            this.TokenComplete(inputRecordCharArray);
            return true;
        }
        String inputRecord = String.valueOf(inputRecordCharArray);
        String areaB = inputRecord.substring(11);
        areaB.trim();
        if (areaB.charAt(0) != this.C_StringDelimiter) {
            this.TokenComplete(inputRecordCharArray);
            return true;
        }
        this.addToCurrentToken('.');
        if (this.currentToken.length() >= 160) {
            this.TokenComplete(inputRecordCharArray);
            this.periodWORDperiod = 0;
            return false;
        }
        this.columnCurrentRecord = 1;
        this.skipLeadingWhiteSpace(inputRecordCharArray);
        return this.ircaIndex < inputRecordCharArray.length;
    }

    @Override
    protected boolean checkForBlankLine(String record) {
        if (record.length() > 6) {
            String recordTrimmed = record.substring(6);
            if (recordTrimmed.length() > 65) {
                recordTrimmed = recordTrimmed.substring(0, 65);
            }
            if ((recordTrimmed = recordTrimmed.trim()).length() != 0) {
                return false;
            }
        }
        ++this.blankLineCount;
        return true;
    }

    private void checkForFreeFormatCobol(String inputRecord) {
        char column1char = inputRecord.charAt(0);
        char column7char = inputRecord.charAt(6);
        switch (column1char) {
            case 'D': {
                if (this.validatedPrevCol7Comment) break;
                this.suspectFreeFormatCobol = true;
                break;
            }
            case '*': 
            case '/': {
                if (this.validatedPrevCol7Comment || column7char == '*' || column7char == 'D' || column7char == '-') break;
                this.suspectFreeFormatCobol = true;
                break;
            }
            case '-': {
                if (this.validatedPrevCol7Comment) break;
                this.increaseScore(1);
                this.C_Continuation = true;
                this.suspectFreeFormatCobol = true;
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkIfCurrentCharIsADelimiter(char currentChar, char[] inputRecordCharArray) {
        if (currentChar == '.') {
            if (this.EXEC_SQL_flag) {
                return true;
            }
            if (this.columnCurrentRecord + 1 == 72) {
                return true;
            }
            if (this.ircaIndex + 1 == inputRecordCharArray.length) {
                return true;
            }
            char nextChar = inputRecordCharArray[this.ircaIndex + 1];
            if (nextChar != ' ' && nextChar != '\n' && nextChar != '\t') return false;
            return true;
        }
        if (this.buildingPictureClause) {
            if (currentChar != ' ') return false;
            return true;
        }
        if (currentChar == '/' && this.C_TokenState != 'Q' && (this.ircaIndex < 7 || inputRecordCharArray[6] != '*' && inputRecordCharArray[6] != '/')) {
            if (!this.suspectFreeFormatCobol) return true;
            this.watchForCommentDelimiter = true;
            return false;
        } else {
            if (currentChar == '*' && this.C_TokenState != 'Q') {
                return true;
            }
            if (currentChar == ' ' || currentChar == '(' || currentChar == ')' || currentChar == ',' || currentChar == ':' || currentChar == ';' || currentChar == '\'' || currentChar == '>' || currentChar == '<' || currentChar == '+' || currentChar == '\"') {
                return true;
            }
            if (currentChar != '=') return false;
            if (this.ircaIndex + 1 == inputRecordCharArray.length) {
                return true;
            }
            char nextChar = inputRecordCharArray[this.ircaIndex + 1];
            if (nextChar == '=') return false;
            return true;
        }
    }

    private boolean CheckOtherColumnSevenValues(String inputRecord, String languageHint) {
        if (this.identifierMode == 'C' || this.CBL_marker || this.suspectFreeFormatCobol) {
            return false;
        }
        String col7 = inputRecord.substring(6, 7);
        if (StringUtils.isNumeric(col7)) {
            boolean letItGo = true;
            int column = 1;
            while (column < 7) {
                if (inputRecord.substring(column - 1, 1).equals("*")) break;
                if (!inputRecord.substring(column - 1, 1).equals(" ") && !StringUtils.isNumeric(inputRecord.substring(column - 1, 1))) {
                    letItGo = false;
                    break;
                }
                column = (short)(column + 1);
            }
            if (letItGo) {
                return false;
            }
        }
        if (languageHint.equals("COB")) {
            return false;
        }
        if (col7.startsWith("$")) {
            return true;
        }
        this.rejectThisLanguageCd();
        return true;
    }

    private boolean findFirstCharacterOnLine(char[] inputRecordCharArray) {
        if (this.C_TokenState == 'Q') {
            if (!this.checkContinuedLiteral(inputRecordCharArray)) {
                return false;
            }
            if (this.C_TokenState == 'S') {
                return this.findStartOfLine(inputRecordCharArray);
            }
            return true;
        }
        return this.findStartOfLine(inputRecordCharArray);
    }

    private boolean findStartOfLine(char[] inputRecordCharArray) {
        if (this.suspectFreeFormatCobol) {
            this.columnCurrentRecord = 1;
            this.ircaIndex = 0;
        } else {
            this.suspectFreeFormatCobol = false;
            this.columnCurrentRecord = (short)7;
            this.ircaIndex = 6;
        }
        this.skipLeadingWhiteSpace(inputRecordCharArray);
        if (this.ircaIndex >= inputRecordCharArray.length) {
            return false;
        }
        if (inputRecordCharArray[this.ircaIndex] == '*') {
            this.increaseScore(5);
            this.metaData.incrementCommentLines();
            return false;
        }
        return !this.EXEC_CICS_flag && !this.EXEC_SQL_flag || inputRecordCharArray[this.ircaIndex] != 'D' || this.ircaIndex != 6;
    }

    public int getCompilerDirectingCount() {
        return this.compilerDirectingCount_COBOL;
    }

    @Override
    public boolean getIgnoreCase() {
        return false;
    }

    public boolean getInvalidCOBOLsequence() {
        return this.invalidCOBOLsequence;
    }

    public int getPictureCount() {
        return this.pictureCount;
    }

    public int getVerbCount() {
        return this.verbCount_COBOL;
    }

    private boolean nextTokenIsPictureClause() {
        return this.currentToken.equalsIgnoreCase("PIC") || this.currentToken.equalsIgnoreCase("PICTURE") || (this.previousToken.equalsIgnoreCase("PIC") || this.previousToken.equalsIgnoreCase("PICTURE")) && this.currentToken.equalsIgnoreCase("IS");
    }

    private void TokenComplete(char[] inputRecordCharArray) {
        boolean checkSymbolFurther;
        this.tokenNumberOnLine = (short)(this.tokenNumberOnLine + 1);
        this.debugReportCompletedToken(this.inputRecordCount, this.tokenNumberOnLine, this.currentToken);
        if (this.EXEC_SQL_flag) {
            this.captureExecStatementText();
        }
        if (checkSymbolFurther = this.scoreCompletedToken(inputRecordCharArray)) {
            this.checkSymanticState();
        }
        if (this.EXEC_SQL_flag && this.currentToken.equalsIgnoreCase(this.getEndExecToken())) {
            this.EXEC_SQL_flag = false;
            this.syntaxState = 16;
        }
        this.resetTokenState();
    }

    private void handleDivisionToken() {
        if (this.previousTokenNumberOnLine == 1) {
            if (this.previousToken.equalsIgnoreCase("ID") || this.previousToken.equalsIgnoreCase("IDENTIFICATION")) {
                this.inDivision = (char)73;
                this.idDivFound = true;
                this.metaData.incrementNumValue(34);
                this.inRemarksParaFlag = false;
                if (this.identifierMode == 'U') {
                    this.identifierMode = (char)67;
                }
            } else if (this.previousToken.equalsIgnoreCase("ENVIRONMENT")) {
                this.inDivision = (char)69;
                this.metaData.incrementNumValue(35);
                this.inRemarksParaFlag = false;
                if (this.identifierMode == 'U') {
                    this.identifierMode = (char)67;
                }
            } else if (this.previousToken.equalsIgnoreCase("DATA")) {
                this.inDivision = (char)68;
                this.metaData.incrementNumValue(36);
                this.inRemarksParaFlag = false;
                if (this.identifierMode == 'U') {
                    this.identifierMode = (char)67;
                }
            } else if (this.previousToken.equalsIgnoreCase("PROCEDURE")) {
                this.inDivision = (char)80;
                this.metaData.incrementNumValue(37);
                this.inRemarksParaFlag = false;
                if (this.identifierMode == 'U') {
                    this.identifierMode = (char)67;
                }
            }
        }
    }

    private void HandlePeriodToken() {
        this.metaData.addSymbolReserved(this.currentToken);
        if (this.syntaxState == 14) {
            this.CaptureCopyName();
            this.syntaxState = 16;
            return;
        }
        if (this.EXEC_SQL_flag) {
            return;
        }
        if (this.periodWORDperiod == 0) {
            this.periodWORDperiod = 1;
        } else if (this.periodWORDperiod == 2) {
            this.invalidCOBOLsequence = true;
            this.periodWORDperiod = 0;
        }
        if (this.inDivision == 'P' && this.tokenNumberOnLine == 2 && this.currentToken.equals(".") && this.previousTokenColumnNo < 12 && !ReservedWordsCOB.containsKey(this.previousToken.toUpperCase())) {
            this.metaData.addProcedureLabel(this.previousToken);
        }
    }

    private void initializeInstanceVariables() {
        this.buildingPictureClause = false;
        this.C_Continuation = false;
        this.C_NewLine = false;
        this.C_StringDelimiter = (char)32;
        this.C_TokenState = (char)83;
        this.CBL_marker = false;
        this.compilerDirectingCount_COBOL = 0;
        this.found_COPY_IN = false;
        this.found_IDMS_SECTION = false;
        this.idDivFound = false;
        this.inclTypeId = 3;
        this.includedDDName = "";
        this.includedMemberName = "";
        this.inDivision = (char)32;
        this.inputRecordCount = 0;
        this.inRemarksParaFlag = false;
        this.invalidCOBOLsequence = false;
        this.literalRecord = null;
        this.periodWORDperiod = 0;
        this.pictureCount = 0;
        this.suspectFreeFormatCobol = false;
        this.validatedPrevCol7Comment = false;
        this.verbCount_COBOL = 0;
        this.watchForCommentDelimiter = false;
    }

    @Override
    public void isScoreBad(int lineCount, String languageHint) {
        if (this.getInvalidCOBOLsequence()) {
            this.score = 0;
        } else if (this.getVerbCount() == 0 && this.getPictureCount() == 0 && this.getCompilerDirectingCount() == 0) {
            if (this.suspectFreeFormatCobol) {
                this.score = 0;
            } else {
                int numberOfComments = this.getCommentCount();
                if (numberOfComments == 0) {
                    if (lineCount == 1) {
                        if (this.score < 5) {
                            this.score = 0;
                        }
                    } else if (lineCount < 5 && this.score < 9) {
                        this.score = 0;
                    }
                }
            }
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int iLineCount) {
        this.metaData.setTotalLines(iLineCount);
        this.metaData.setBlanklines(this.blankLineCount);
        this.metaData.setNonCommentLines(iLineCount - this.blankLineCount - this.getCommentCount());
        if (this.found_IDMS_SECTION) {
            this.metaData.addNumValue(25, 1);
        }
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        this.initializeInstanceVariables();
        this.currentToken = "";
        this.EXEC_CICS_flag = false;
        this.EXEC_SQL_flag = false;
        this.identifierMode = (char)85;
        this.mapName = null;
        this.mapSetName = null;
        this.metaData = new ClassifierMetaData(this.scanProperties.getCaptureComments(), this.scanProperties.getCaptureEntryPoints(), this.scanProperties.getCaptureExecStatements(), this.scanProperties.getCaptureLiterals(), this.scanProperties.getCapturePictures(), this.scanProperties.getCaptureSymbolsReserved(), this.scanProperties.getCaptureSymbolsUserDefined());
        this.previousToken = "";
        this.previousPreviousToken = "";
        this.syntaxState = 16;
        this.typeOfControlTransfer = null;
    }

    @Override
    public void processOneRecord(int inputRecordCount, String literalRecord, String inputRecord, String languageHint) {
        char[] inputRecordCharArray;
        this.inputRecordCount = inputRecordCount;
        this.literalRecord = literalRecord;
        if (this.checkAlternateFormsOfCopy(inputRecord)) {
            return;
        }
        this.CBL_marker = this.idDivFound ? false : inputRecord.contains("CBL ") || inputRecord.contains("CBL\n") || inputRecord.contains("PROCESS ") || inputRecord.contains("PROCESS\n");
        this.C_Continuation = false;
        this.checkForFreeFormatCobol(inputRecord);
        if (!this.suspectFreeFormatCobol) {
            if (this.CheckAlternateLocationOfINC(inputRecord)) {
                return;
            }
            if (this.ValidateColumnSeven(inputRecord, languageHint)) {
                return;
            }
        }
        if (this.C_TokenState == 'E') {
            this.C_TokenState = (char)67;
        }
        if (this.C_TokenState == 'Q' && this.suspectFreeFormatCobol) {
            this.C_TokenState = (char)67;
        }
        if (!this.findFirstCharacterOnLine(inputRecordCharArray = inputRecord.toCharArray())) {
            return;
        }
        this.C_NewLine = true;
        this.watchForCommentDelimiter = false;
        if (this.C_TokenState == 'S') {
            this.tokenNumberOnLine = 0;
        }
        while (this.ircaIndex < inputRecordCharArray.length && this.columnCurrentRecord != 73 && inputRecordCharArray[this.ircaIndex] != '\n') {
            if (inputRecordCharArray[this.ircaIndex] == ' ' && this.ircaIndex + 3 < inputRecordCharArray.length && inputRecordCharArray[this.ircaIndex + 1] == '*' && inputRecordCharArray[this.ircaIndex + 2] == '>' && inputRecordCharArray[this.ircaIndex + 3] == ' ') {
                this.increaseScore(5);
                break;
            }
            char currentChar = inputRecordCharArray[this.ircaIndex];
            boolean C_IsDelimiter = this.checkIfCurrentCharIsADelimiter(currentChar, inputRecordCharArray);
            if (this.identifierMode == 'R') break;
            block0 : switch (this.C_TokenState) {
                case 'S': {
                    if (currentChar == ' ' || currentChar == '\t') {
                        this.moveToNextCharOnRecord();
                        break;
                    }
                    this.currentTokenColumnNo = this.columnCurrentRecord;
                    if (currentChar == 'X') {
                        this.addToCurrentToken(currentChar);
                        ++this.ircaIndex;
                        if (this.ircaIndex + 1 >= inputRecordCharArray.length) {
                            this.C_TokenState = (char)67;
                            break;
                        }
                        currentChar = inputRecordCharArray[this.ircaIndex];
                        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
                        if (currentChar == '\"' || currentChar == '\'') {
                            this.C_TokenState = (char)88;
                            break;
                        }
                        this.C_TokenState = (char)67;
                        break;
                    }
                    if (currentChar == '\"' || currentChar == '\'') {
                        this.C_StringDelimiter = currentChar;
                        this.addToCurrentToken(currentChar);
                        this.addToLiteralToken();
                        this.moveToNextCharOnRecord();
                        this.C_TokenState = (char)81;
                        break;
                    }
                    this.addToCurrentToken(currentChar);
                    this.moveToNextCharOnRecord();
                    if (C_IsDelimiter) {
                        this.TokenComplete(inputRecordCharArray);
                        break;
                    }
                    this.C_TokenState = (char)67;
                    break;
                }
                case 'C': {
                    if (this.C_NewLine && !this.C_Continuation) {
                        this.TokenComplete(inputRecordCharArray);
                        this.tokenNumberOnLine = 0;
                        break;
                    }
                    if (C_IsDelimiter) {
                        this.TokenComplete(inputRecordCharArray);
                        if (currentChar != ' ') break;
                        this.moveToNextCharOnRecord();
                        break;
                    }
                    this.addToCurrentToken(currentChar);
                    this.moveToNextCharOnRecord();
                    break;
                }
                case 'B': {
                    if (this.C_NewLine) {
                        if (this.C_Continuation) {
                            this.C_TokenState = (char)67;
                            break;
                        }
                        this.TokenComplete(inputRecordCharArray);
                        break;
                    }
                    if (inputRecordCharArray[this.ircaIndex] == ' ' || inputRecordCharArray[this.ircaIndex] == '\t') {
                        this.moveToNextCharOnRecord();
                        break;
                    }
                    this.C_TokenState = (char)83;
                    break;
                }
                case 'Q': {
                    if (currentChar == this.C_StringDelimiter) {
                        this.C_TokenState = (char)69;
                    }
                    this.addToCurrentToken(currentChar);
                    this.addToLiteralToken();
                    this.moveToNextCharOnRecord();
                    break;
                }
                case 'E': {
                    if (currentChar == this.C_StringDelimiter) {
                        this.addToCurrentToken(currentChar);
                        this.addToLiteralToken();
                        this.moveToNextCharOnRecord();
                        this.C_TokenState = (char)81;
                        break;
                    }
                    this.TokenComplete(inputRecordCharArray);
                    break;
                }
                case 'X': {
                    switch (inputRecordCharArray[this.ircaIndex]) {
                        case '\t': 
                        case ' ': {
                            this.TokenComplete(inputRecordCharArray);
                            this.moveToNextCharOnRecord();
                            this.C_TokenState = (char)66;
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.C_StringDelimiter = inputRecordCharArray[this.ircaIndex];
                            this.addToCurrentToken(currentChar);
                            this.moveToNextCharOnRecord();
                            this.C_TokenState = (char)81;
                            break block0;
                        }
                    }
                    if (C_IsDelimiter) {
                        this.TokenComplete(inputRecordCharArray);
                        break;
                    }
                    this.addToCurrentToken(currentChar);
                    this.moveToNextCharOnRecord();
                    this.C_TokenState = (char)67;
                    break;
                }
            }
            if (this.currentToken.length() >= 160) {
                this.TokenComplete(inputRecordCharArray);
                if (this.identifierMode == 'R') break;
            }
            this.C_NewLine = false;
            this.C_Continuation = false;
        }
        while (this.C_TokenState == 'Q' && this.ircaIndex++ < 72) {
            this.addToCurrentToken(' ');
            this.literalToken = String.valueOf(this.literalToken) + ' ';
        }
        this.periodWORDperiod = 0;
    }

    private void resetTokenState() {
        this.buildingPictureClause = this.nextTokenIsPictureClause();
        this.previousPreviousToken = this.previousToken;
        this.previousToken = this.currentToken;
        this.previousTokenNumberOnLine = this.tokenNumberOnLine;
        this.previousTokenColumnNo = this.currentTokenColumnNo;
        this.currentToken = "";
        this.currentTokenColumnNo = 0;
        this.literalToken = "";
        this.C_TokenState = (char)83;
    }

    private boolean scoreCompletedToken(char[] inputRecordCharArray) {
        if (this.currentToken.length() == 1) {
            if (this.currentToken.equals(".")) {
                this.HandlePeriodToken();
                return false;
            }
            if (this.currentToken.equals("'") || this.currentToken.equals("\"")) {
                this.periodWORDperiod = 0;
                return false;
            }
            if (this.currentToken.equals("*") || this.currentToken.equals(":") || this.currentToken.equals(",") || this.currentToken.equals("=") || this.currentToken.equals("/") || this.currentToken.equals(">") || this.currentToken.equals("(") || this.currentToken.equals("<") || this.currentToken.equals("+") || this.currentToken.equals(")")) {
                this.metaData.addSymbolReserved(this.currentToken);
                this.periodWORDperiod = 0;
                return false;
            }
            if (this.currentToken.equals(";")) {
                this.metaData.addSymbolReserved(this.currentToken);
                this.periodWORDperiod = 0;
                this.EXEC_CICS_flag = false;
                this.EXEC_SQL_flag = false;
                return false;
            }
        }
        ClassifierReservedWord rw = null;
        String currentTokenUC = this.currentToken.toUpperCase();
        if (ReservedWordsCOB.containsKey(currentTokenUC)) {
            String value = ReservedWordsCOB.get(currentTokenUC);
            rw = this.allocateReserveWord(currentTokenUC, value);
        }
        if (rw == null) {
            this.processNonReservedWord();
        } else {
            this.processReservedWord(rw, inputRecordCharArray);
        }
        return true;
    }

    private void skipLeadingWhiteSpace(char[] inputRecordCharArray) {
        while (this.ircaIndex < inputRecordCharArray.length && (inputRecordCharArray[this.ircaIndex] == ' ' || inputRecordCharArray[this.ircaIndex] == '\t')) {
            this.moveToNextCharOnRecord();
        }
    }

    private boolean isCICSKeyword(String currentToken) {
        return currentToken.equalsIgnoreCase("DFHCOMMAREA") || currentToken.equalsIgnoreCase("DFHEIBLK");
    }

    private void processNonReservedWord() {
        if (this.inRemarksParaFlag) {
            this.periodWORDperiod = 0;
        } else if (this.currentToken.startsWith("\"") || this.currentToken.startsWith("'")) {
            this.metaData.addLiteral(this.literalToken);
            this.captureEntryPointName();
        } else if (!this.currentToken.startsWith("-")) {
            if (this.buildingPictureClause) {
                this.metaData.addPicture(this.currentToken);
            } else if (StringUtils.isNumeric(this.currentToken)) {
                if (this.previousPreviousToken.equalsIgnoreCase("VALUE")) {
                    if (this.previousToken.equals("-") || this.previousToken.equals("+")) {
                        this.metaData.addLiteral(String.valueOf(this.previousToken) + this.currentToken);
                    } else {
                        this.metaData.addLiteral(this.currentToken);
                    }
                } else {
                    this.metaData.addLiteral(this.currentToken);
                }
            } else {
                this.metaData.addSymbolUserDefined(this.currentToken);
                if (this.isCICSKeyword(this.currentToken)) {
                    this.metaData.setAttnListKey(30);
                } else if (this.inDivision == 'P') {
                    this.periodWORDperiod = this.periodWORDperiod == 1 ? 2 : 0;
                } else {
                    this.captureEntryPointName();
                }
            }
        }
    }

    private void processReservedWord(ClassifierReservedWord rw, char[] inputRecordCharArray) {
        this.metaData.addSymbolReserved(this.currentToken);
        this.AccumulatePointsForTheScore(inputRecordCharArray, rw);
    }

    private void checkSymanticState() {
        switch (this.syntaxState) {
            case 0: {
                this.processState_assignmentStmt();
                break;
            }
            case 3: {
                this.processState_call();
                break;
            }
            case 4: {
                this.processState_mapOrMapset();
                break;
            }
            case 5: {
                this.processState_copy();
                break;
            }
            case 6: {
                this.processState_copyIn();
                break;
            }
            case 7: {
                this.processState_exec();
                break;
            }
            case 8: {
                this.processState_execCics();
                break;
            }
            case 9: {
                this.processState_execCicsReceiveOrSend();
                break;
            }
            case 10: {
                this.processState_execSql();
                break;
            }
            case 12: {
                this.processState_execSqlStmt();
                break;
            }
            case 11: {
                this.processState_execSqlClauseFrom();
                break;
            }
            case 13: {
                this.processState_execSqlStmtInclude();
                break;
            }
            case 14: {
                this.processState_inOfOrReplacing();
                break;
            }
            case 15: {
                this.processState_execCicsLinkOrXctl();
                break;
            }
            case 19: {
                this.processState_program();
                break;
            }
            default: {
                this.processState_normalToken();
            }
        }
    }

    private void processState_assignmentStmt() {
        if (this.previousToken.equalsIgnoreCase("MOVE")) {
            if (this.currentToken.startsWith("\"") || this.currentToken.startsWith("'") || figurativeConstants.contains(this.currentToken) || StringUtils.isNumeric(this.currentToken)) {
                this.syntaxState = 16;
            } else if (this.assignmentSymbolFrom == null) {
                this.assignmentSymbolFrom = this.currentToken;
            }
        } else if (this.previousToken.equalsIgnoreCase("CORR") || this.previousToken.equalsIgnoreCase("CORRESPONDING")) {
            if (this.assignmentSymbolFrom == null) {
                this.assignmentSymbolFrom = this.currentToken;
            }
        } else if (this.previousToken.equalsIgnoreCase("TO")) {
            if (this.assignmentSymbolFrom != null) {
                this.metaData.addAssignment(this.assignmentSymbolFrom, this.currentToken);
            }
            this.assignmentSymbolFrom = null;
            this.syntaxState = 16;
        } else if (this.currentToken.equals(".") || !this.currentToken.equals("CORR") && !this.currentToken.equals("CORRESPONDING") && !this.currentToken.equals("MOVE") && !this.currentToken.equals("TO") && ReservedWordsCOB.containsKey(this.currentToken.toUpperCase())) {
            this.assignmentSymbolFrom = null;
            this.syntaxState = 16;
        }
    }

    private void processState_call() {
        String literalText = this.getLiteralText();
        if (literalText != null) {
            if (literalText.equalsIgnoreCase("AERTDLI")) {
                this.metaData.incrementNumValue(59);
            } else if (literalText.equalsIgnoreCase("AIBTDLI")) {
                this.metaData.incrementNumValue(43);
            } else if (literalText.equalsIgnoreCase("CBLTDLI")) {
                this.metaData.incrementNumValue(38);
            }
            this.metaData.addControlTransfer(this.typeOfControlTransfer, literalText);
        }
        this.syntaxState = 16;
    }

    private void processState_copy() {
        this.includedMemberName = this.currentToken;
        this.found_COPY_IN = false;
        this.syntaxState = 14;
    }

    private void processState_normalToken() {
        if (this.currentToken.equalsIgnoreCase("DIVISION")) {
            this.handleDivisionToken();
        } else if (!this.inRemarksParaFlag) {
            if (this.currentToken.equalsIgnoreCase("CALL")) {
                this.typeOfControlTransfer = this.currentToken;
                this.syntaxState = 3;
            } else if (this.currentToken.equalsIgnoreCase("COPY")) {
                this.syntaxState = 5;
            } else if (this.currentToken.equalsIgnoreCase("EXEC") || this.currentToken.equalsIgnoreCase("EXECUTE")) {
                this.syntaxState = 7;
            } else if (this.currentToken.equalsIgnoreCase(this.getEndExecToken())) {
                this.EXEC_CICS_flag = false;
            } else if (this.currentToken.equalsIgnoreCase("MOVE")) {
                this.assignmentSymbolFrom = null;
                this.syntaxState = 0;
            } else if (this.currentToken.equalsIgnoreCase("REMARKS") && this.inDivision == 'I') {
                this.inRemarksParaFlag = true;
            } else if (this.inDivision == 'E' && this.currentToken.equalsIgnoreCase("SECTION") && this.previousToken.equalsIgnoreCase("IDMS-CONTROL")) {
                this.found_IDMS_SECTION = true;
                this.metaData.addSymbolReserved(this.previousToken);
                this.increaseScore(2);
            }
        }
    }

    private void processState_copyIn() {
        if (!this.found_COPY_IN) {
            this.found_COPY_IN = true;
            this.inclTypeId = 4;
            this.includedDDName = this.currentToken;
            this.syntaxState = 14;
        } else {
            this.syntaxState = 6;
        }
    }

    private void processState_inOfOrReplacing() {
        if (this.currentToken.equalsIgnoreCase("IN") || this.currentToken.equalsIgnoreCase("OF")) {
            this.syntaxState = 6;
        } else if (this.currentToken.equalsIgnoreCase("REPLACING")) {
            this.metaData.incrementNumValue(64);
            this.CaptureCopyName();
            this.syntaxState = 16;
        }
    }

    private boolean ValidateColumnSeven(String inputRecord, String languageHint) {
        boolean rc;
        if (inputRecord.length() < 7) {
            return true;
        }
        char column7char = inputRecord.charAt(6);
        switch (column7char) {
            case ' ': {
                rc = false;
                break;
            }
            case 'D': {
                rc = false;
                break;
            }
            case '*': 
            case '/': {
                this.increaseScore(5);
                this.metaData.incrementCommentLines();
                String commentText = inputRecord.substring(6);
                if (commentText.length() > 66) {
                    commentText = commentText.substring(0, 66);
                }
                this.metaData.addComment(commentText.trim());
                rc = true;
                this.validatedPrevCol7Comment = true;
                break;
            }
            case '-': {
                this.increaseScore(1);
                this.C_Continuation = true;
                rc = false;
                break;
            }
            default: {
                rc = this.CheckOtherColumnSevenValues(inputRecord, languageHint);
            }
        }
        return rc;
    }
}

