/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;

public class ClassifierByRecordCobPliPlx
extends ClassifierByRecord {
    protected String assignmentSymbolFrom = null;

    protected ClassifierByRecordCobPliPlx(ScanProperties scanProperties) {
        super(scanProperties);
    }

    protected boolean capturePlusPlusIncludeName(String record, boolean truncateFilenames) {
        if (!record.startsWith("++INCLUDE ")) {
            return false;
        }
        String includedText = record.substring(9);
        if ((includedText = includedText.trim()).length() == 0) {
            return false;
        }
        String[] tokens = StringUtils.split(includedText, " ");
        String memberName = tokens[0];
        if (memberName.length() == 0) {
            return false;
        }
        String[] multiPartName = StringUtils.split(memberName, ".");
        String includedName = multiPartName[0];
        if (truncateFilenames && includedName.length() > 8) {
            includedName = includedName.substring(0, 8);
        }
        this.metaData.captureInclude(5, includedName);
        return true;
    }

    protected boolean checkAlternateFormsOfCopy(String inputRecord) {
        if (this.checkHyphenInclude(inputRecord)) {
            return true;
        }
        return this.checkPlusPlusInclude(inputRecord);
    }

    private boolean checkHyphenInclude(String inputRecord) {
        if (inputRecord.length() < 5) {
            return false;
        }
        if (!inputRecord.startsWith("-INC ")) {
            return false;
        }
        return this.captureIncMemberName(inputRecord);
    }

    protected boolean captureIncMemberName(String inputRecord) {
        String record = inputRecord.substring(4);
        String recordTrimmed = record.trim();
        if (recordTrimmed.length() == 0) {
            return false;
        }
        String[] token = StringUtils.split(recordTrimmed);
        String memberName = token[0];
        if (memberName.contains(".")) {
            String[] subToken = StringUtils.split(memberName, ".");
            memberName = subToken[0];
        } else if (memberName.contains(";")) {
            String[] subToken = StringUtils.split(memberName, ";");
            memberName = subToken[0];
        }
        this.metaData.captureInclude(6, memberName);
        return true;
    }

    protected boolean checkPlusPlusInclude(String inputRecord) {
        return false;
    }

    protected void processState_exec() {
        if (this.execStatementText != null) {
            this.metaData.addExecStatement(this.execStatementText.toString());
        }
        this.execStatementText = new StringBuffer("EXEC");
        if (this.currentToken.equalsIgnoreCase("CICS")) {
            this.EXEC_CICS_flag = true;
            this.metaData.incrementNumValue(30);
            this.syntaxState = 8;
        } else if (this.currentToken.equalsIgnoreCase("DLI")) {
            this.metaData.incrementNumValue(31);
            this.syntaxState = 16;
        } else if (this.currentToken.equalsIgnoreCase("IDMS")) {
            this.metaData.incrementNumValue(32);
            this.syntaxState = 16;
        } else if (this.currentToken.equalsIgnoreCase("SQL")) {
            this.EXEC_SQL_flag = true;
            this.metaData.incrementNumValue(33);
            this.captureExecStatementText();
            this.syntaxState = 10;
        }
    }
}

