/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.Classifier;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierASM;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierC;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCOB;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCPP;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierEASY;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierJCL;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLI;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLX;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.IClassifierByRecord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;

public class ClassifierByRecord
extends Classifier
implements IClassifierByRecord {
    protected static final int SYNTAX_STATE_ASSIGNMENT_STMT = 0;
    protected static final int SYNTAX_STATE_C_INCLUDE = 1;
    protected static final int SYNTAX_STATE_C_INCLUDE_NAME = 2;
    protected static final int SYNTAX_STATE_CALL = 3;
    protected static final int SYNTAX_STATE_CICS_MAP_MAPSET = 4;
    protected static final int SYNTAX_STATE_COPY = 5;
    protected static final int SYNTAX_STATE_COPY_IN = 6;
    protected static final int SYNTAX_STATE_EXEC = 7;
    protected static final int SYNTAX_STATE_EXEC_CICS = 8;
    protected static final int SYNTAX_STATE_EXEC_CICS_RECEIVE_SEND = 9;
    protected static final int SYNTAX_STATE_EXEC_SQL = 10;
    protected static final int SYNTAX_STATE_EXEC_SQL_CLAUSE_FROM = 11;
    protected static final int SYNTAX_STATE_EXEC_SQL_STMT = 12;
    protected static final int SYNTAX_STATE_EXEC_SQL_STMT_INCLUDE = 13;
    protected static final int SYNTAX_STATE_IN_OF_or_REPLACING = 14;
    protected static final int SYNTAX_STATE_LINK_XCTL = 15;
    protected static final int SYNTAX_STATE_NORMAL = 16;
    protected static final int SYNTAX_STATE_PLI_INCLUDE = 17;
    protected static final int SYNTAX_STATE_PLI_PROC = 18;
    protected static final int SYNTAX_STATE_PROGRAM = 19;
    protected boolean EXEC_CICS_flag = false;
    protected boolean EXEC_SQL_flag = false;
    protected int ircaIndex = 0;
    protected int syntaxState = 16;
    protected short columnCurrentRecord = 1;
    protected short currentTokenColumnNo = 0;
    protected short previousTokenColumnNo = 0;
    protected short previousTokenNumberOnLine = 0;
    protected short tokenNumberOnLine = 0;
    protected String currentToken = "";
    private String execSqlStatement = "";
    protected String literalToken = "";
    protected String mapName = null;
    protected String mapSetName = null;
    protected String previousPreviousToken = "";
    protected String previousToken = "";
    protected String typeOfControlTransfer = null;
    protected StringBuffer execStatementText = null;

    protected ClassifierByRecord(ScanProperties scanProperties) {
        super(scanProperties);
    }

    protected void captureExecStatementText() {
        if (this.currentToken.length() > 1 && this.previousToken.length() > 1) {
            this.execStatementText.append(" ");
        } else if (!(this.currentToken.equals(",") || this.currentToken.equals(".") || this.currentToken.equals("(") || this.currentToken.equals(")") || this.previousToken.equals(".") || this.previousToken.equals("(") || this.previousToken.equals(":"))) {
            this.execStatementText.append(" ");
        }
        this.execStatementText.append(this.currentToken);
    }

    protected boolean checkForBlankLine(String iRecord) {
        String recordTrimmed = iRecord.trim();
        if (recordTrimmed.length() != 0) {
            return false;
        }
        ++this.blankLineCount;
        return true;
    }

    protected void debugReportCompletedToken(int fileLineNo, int tokenNumberOnLine, String token) {
        if (this.debug == 2) {
            System.out.println("   " + this.getLanguageCd() + " " + StringUtils.format("%06d", fileLineNo) + " " + StringUtils.format("%02d", tokenNumberOnLine) + " " + token);
        }
    }

    protected void debugReportScore() {
        if (this.debug == 2) {
            System.out.println("   " + this.getLanguageCd() + " score[" + this.score + "]");
        }
    }

    protected String getEndExecToken() {
        return "END-EXEC";
    }

    @Override
    public String getLanguageDescription() {
        return "unknown";
    }

    @Override
    public int getLanguageId() {
        return 22;
    }

    protected String getLiteralText() {
        char delimiter = this.currentToken.charAt(0);
        if (delimiter != '\'' && delimiter != '\"') {
            return null;
        }
        String literalText = this.currentToken.substring(1);
        literalText = literalText.substring(0, literalText.length() - 1);
        return literalText;
    }

    @Override
    public void isScoreBad(int lineCount, String languageHint) {
    }

    @Override
    public void isScoreStillBad(int lineCount, ClassifierASM classifierASM, ClassifierC classifierC, ClassifierCOB classifierCOB, ClassifierCPP classifierCPP, ClassifierEASY classifierEASY, ClassifierJCL classifierJCL, ClassifierPLI classifierPLI, ClassifierPLX classifierPLX) {
    }

    private boolean isSpecificToOneClassifier(String iRecord) {
        if (this.identifierMode != 'U') {
            return false;
        }
        String languageCd = this.getLanguageCd();
        return !languageCd.equals("PLX") && (iRecord.startsWith(" /*") && iRecord.contains("*/") ? languageCd.equals("ASM") || languageCd.equals("COB") : iRecord.startsWith(" !"));
    }

    protected void moveToNextCharOnRecord() {
        this.columnCurrentRecord = (short)(this.columnCurrentRecord + 1);
        ++this.ircaIndex;
    }

    public void process(int recordCount, String iRecord, String languageHint) {
        if (this.getIdentifierMode() == 'R') {
            return;
        }
        if (this.checkForBlankLine(iRecord)) {
            return;
        }
        if (this.isSpecificToOneClassifier(iRecord)) {
            return;
        }
        String record = this.getIgnoreCase() ? iRecord.toUpperCase() : iRecord;
        this.processOneRecord(recordCount, iRecord, record, languageHint);
    }

    protected void processState_execCics() {
        if (this.currentToken.equalsIgnoreCase("HANDLE")) {
            this.metaData.incrementNumValue(83);
            this.syntaxState = 16;
        } else if (this.currentToken.equalsIgnoreCase("LINK") || this.currentToken.equalsIgnoreCase("XCTL")) {
            this.metaData.incrementNumValue(83);
            this.typeOfControlTransfer = this.currentToken;
            this.syntaxState = 15;
        } else if (this.currentToken.equalsIgnoreCase("RECEIVE") || this.currentToken.equalsIgnoreCase("SEND")) {
            this.mapName = null;
            this.mapSetName = null;
            this.syntaxState = 9;
        } else {
            this.syntaxState = 16;
        }
    }

    protected void processState_execCicsLinkOrXctl() {
        if (this.currentToken.equalsIgnoreCase(this.getEndExecToken())) {
            this.EXEC_CICS_flag = false;
            this.syntaxState = 16;
        } else if (this.currentToken.equalsIgnoreCase("PROGRAM")) {
            this.syntaxState = 19;
        }
    }

    protected void processState_execCicsReceiveOrSend() {
        if (this.currentToken.equalsIgnoreCase(this.getEndExecToken())) {
            this.EXEC_CICS_flag = false;
            this.syntaxState = 16;
        } else if (this.currentToken.equalsIgnoreCase("MAP") || this.currentToken.equalsIgnoreCase("MAPSET")) {
            this.syntaxState = 4;
        }
    }

    protected void processState_execSql() {
        this.execSqlStatement = this.currentToken;
        if (this.execSqlStatement.equalsIgnoreCase("INCLUDE")) {
            this.score += 10;
            this.syntaxState = 13;
        } else {
            this.syntaxState = 12;
        }
    }

    protected void processState_execSqlClauseFrom() {
        if (this.currentToken.equalsIgnoreCase(this.getEndExecToken()) || this.currentToken.equalsIgnoreCase("GROUP") || this.currentToken.equalsIgnoreCase("HAVING") || this.currentToken.equals("(") || this.currentToken.equalsIgnoreCase("SELECT") || this.currentToken.equalsIgnoreCase("SKIP") || this.currentToken.equalsIgnoreCase("WHERE")) {
            this.syntaxState = 12;
        } else if (this.previousToken.equalsIgnoreCase("FROM") || this.previousToken.equals(",")) {
            this.metaData.addTableOrViewName(this.currentToken);
        } else if (!this.previousPreviousToken.equalsIgnoreCase("FROM") && !this.previousPreviousToken.equals(",")) {
            this.syntaxState = 12;
        }
    }

    protected void processState_execSqlStmt() {
        if (this.currentToken.equalsIgnoreCase(this.getEndExecToken())) {
            this.EXEC_SQL_flag = false;
            if (this.execStatementText != null) {
                this.metaData.addExecStatement(this.execStatementText.toString());
            }
            this.execStatementText = null;
            this.syntaxState = 16;
        } else if (this.execSqlStatement.equalsIgnoreCase("SELECT")) {
            if (this.currentToken.equalsIgnoreCase("FROM")) {
                this.syntaxState = 11;
            }
        } else {
            this.captureExecSqlTableOrViewName();
        }
    }

    private void captureExecSqlTableOrViewName() {
        if (this.execSqlStatement.equalsIgnoreCase("ALTER")) {
            if (this.previousToken.equalsIgnoreCase("LIKE")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("COMMENT")) {
            if (this.previousToken.equalsIgnoreCase("ON") || this.previousToken.equalsIgnoreCase("TABLE")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("CREATE")) {
            if (this.previousToken.equalsIgnoreCase("FOR") || this.previousToken.equalsIgnoreCase("LIKE") || this.previousToken.equalsIgnoreCase("ON") || this.previousToken.equalsIgnoreCase("STORES") || this.previousToken.equalsIgnoreCase("TABLE") || this.previousToken.equalsIgnoreCase("VIEW")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("DECLARE")) {
            if (this.currentToken.equalsIgnoreCase("TABLE")) {
                this.metaData.addTableOrViewName(this.previousToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("DELETE")) {
            if (this.previousToken.equalsIgnoreCase("DELETE") && !this.currentToken.equalsIgnoreCase("FROM") || this.previousToken.equalsIgnoreCase("FROM")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("DROP") || this.execSqlStatement.equalsIgnoreCase("GRANT") || this.execSqlStatement.equalsIgnoreCase("LOCK") || this.execSqlStatement.equalsIgnoreCase("REFRESH")) {
            if (this.previousToken.equalsIgnoreCase("TABLE")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("EXCHANGE")) {
            if (this.previousToken.equalsIgnoreCase("AND") || this.previousToken.equalsIgnoreCase("TABLE")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("INSERT") || this.execSqlStatement.equalsIgnoreCase("MERGE")) {
            if (this.previousToken.equalsIgnoreCase("INTO")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("RENAME")) {
            if (this.previousToken.equalsIgnoreCase("RENAME") || this.previousToken.equalsIgnoreCase("TABLE")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("TRUNCATE")) {
            if (this.previousToken.equalsIgnoreCase("TRUNCATE") || this.previousToken.equalsIgnoreCase("TABLE")) {
                this.metaData.addTableOrViewName(this.currentToken);
            }
        } else if (this.execSqlStatement.equalsIgnoreCase("UPDATE") && this.previousToken.equalsIgnoreCase("UPDATE")) {
            this.metaData.addTableOrViewName(this.currentToken);
        }
    }

    protected void processState_execSqlStmtInclude() {
        if (this.debug == 2) {
            System.out.println("Found EXEC SQL INCLUDE [" + this.currentToken + "]");
        }
        this.metaData.captureInclude(7, this.currentToken);
        this.syntaxState = 12;
    }

    protected void processState_mapOrMapset() {
        if (this.currentToken.equalsIgnoreCase(this.getEndExecToken())) {
            if (this.mapName != null) {
                if (this.mapSetName == null) {
                    this.metaData.addMap(this.mapName, this.mapName);
                } else {
                    this.metaData.addMap(this.mapSetName, this.mapName);
                }
            }
            this.EXEC_CICS_flag = false;
            this.syntaxState = 16;
        } else if (this.previousPreviousToken.equalsIgnoreCase("MAP") && this.previousToken.equals("(")) {
            this.mapName = this.currentToken;
        } else if (this.previousPreviousToken.equalsIgnoreCase("MAPSET") && this.previousToken.equals("(")) {
            this.mapSetName = this.currentToken;
        }
    }

    protected void processState_program() {
        if (this.currentToken.equalsIgnoreCase(this.getEndExecToken())) {
            this.EXEC_CICS_flag = false;
            this.syntaxState = 16;
        } else if (this.previousPreviousToken.equalsIgnoreCase("PROGRAM") && this.previousToken.equals("(")) {
            String literalText = this.getLiteralText();
            if (literalText != null) {
                this.metaData.addControlTransfer(this.typeOfControlTransfer, literalText);
            }
            this.syntaxState = 16;
        }
    }
}

