/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;

public class ScanProperties {
    private static final String defaultCodePage = "UTF-8";
    public static final String JSON_RESPONSE_FORMAT_ADI = "ADI";
    public static final String JSON_RESPONSE_FORMAT_DEFAULT = "";
    public static final String JSON_RESPONSE_FORMAT_IBM_SERVICES = "GBS";
    public static final String JSON_RESPONSE_FORMAT_PRETTY = "PRETTY";
    private boolean allowIncludeInAnyColumn = false;
    private boolean expandIncludeInComment = true;
    private boolean freeFormatCobol = false;
    private boolean noPLX = false;
    private boolean truncateFilenames = false;
    private String codePage = "UTF-8";
    private String languageHint = "UNKN";
    private String mvsCodePage = null;
    private boolean captureComments = false;
    private boolean captureEntryPoints = false;
    private boolean captureExecStatements = false;
    private boolean captureLiterals = false;
    private boolean capturePictures = false;
    private boolean captureSymbolsReserved = false;
    private boolean captureSymbolsUserDefined = false;
    private String jsonResponseFormat = "";
    private boolean reportNetViewMacros = false;

    public boolean getAllowIncludeInAnyColumn() {
        return this.allowIncludeInAnyColumn;
    }

    public boolean getCaptureComments() {
        return this.captureComments;
    }

    public boolean getCaptureEntryPoints() {
        return this.captureEntryPoints;
    }

    public boolean getCaptureExecStatements() {
        return this.captureExecStatements;
    }

    public boolean getCaptureLiterals() {
        return this.captureLiterals;
    }

    public boolean getCapturePictures() {
        return this.capturePictures;
    }

    public boolean getCaptureSymbolsReserved() {
        return this.captureSymbolsReserved;
    }

    public boolean getCaptureSymbolsUserDefined() {
        return this.captureSymbolsUserDefined;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public boolean getExpandIncludeInComment() {
        return this.expandIncludeInComment;
    }

    public boolean getFreeFormatCobol() {
        return this.freeFormatCobol;
    }

    public String getJsonResponseFormat() {
        return this.jsonResponseFormat;
    }

    public String getLanguageHint() {
        return this.languageHint;
    }

    public String getMvsCodePage() {
        return this.mvsCodePage;
    }

    public boolean getNoPLX() {
        return this.noPLX;
    }

    public boolean getReportNetViewMacros() {
        return this.reportNetViewMacros;
    }

    public boolean getTruncateFilenames() {
        return this.truncateFilenames;
    }

    public void setAllowIncludeInAnyColumn(String iSetting) {
        this.allowIncludeInAnyColumn = this.validateBooleanProperty(iSetting, false);
    }

    public void setCaptureComments(String setting) {
        this.captureComments = this.validateBooleanProperty(setting, false);
    }

    public void setCaptureEntryPoints(String setting) {
        this.captureEntryPoints = this.validateBooleanProperty(setting, false);
    }

    public void setCaptureExecStatements(String setting) {
        this.captureExecStatements = this.validateBooleanProperty(setting, false);
    }

    public void setCaptureLiterals(String setting) {
        this.captureLiterals = this.validateBooleanProperty(setting, false);
    }

    public void setCapturePictures(String setting) {
        this.capturePictures = this.validateBooleanProperty(setting, false);
    }

    public void setCaptureSymbolsReserved(String setting) {
        this.captureSymbolsReserved = this.validateBooleanProperty(setting, false);
    }

    public void setCaptureSymbolsUserDefined(String setting) {
        this.captureSymbolsUserDefined = this.validateBooleanProperty(setting, false);
    }

    public void setCodePage(String setting) {
        this.codePage = StringUtils.isEmpty(setting) ? defaultCodePage : setting;
    }

    public void setExpandIncludeInComment(String setting) {
        this.expandIncludeInComment = this.validateBooleanProperty(setting, true);
    }

    public void setFreeFormatCobol(String setting) {
        this.freeFormatCobol = this.validateBooleanProperty(setting, false);
    }

    public void setJsonResponseFormat(String setting) {
        this.jsonResponseFormat = StringUtils.isEmpty(setting) ? JSON_RESPONSE_FORMAT_DEFAULT : (setting.equalsIgnoreCase(JSON_RESPONSE_FORMAT_ADI) ? JSON_RESPONSE_FORMAT_ADI : (setting.equalsIgnoreCase(JSON_RESPONSE_FORMAT_IBM_SERVICES) ? JSON_RESPONSE_FORMAT_IBM_SERVICES : (setting.equalsIgnoreCase(JSON_RESPONSE_FORMAT_PRETTY) ? JSON_RESPONSE_FORMAT_PRETTY : JSON_RESPONSE_FORMAT_DEFAULT)));
    }

    public void setLanguageHint(String setting) {
        this.languageHint = this.validateLanguageHint(setting, "UNKN");
    }

    public void setMvsCodePage(String setting) {
        this.mvsCodePage = setting;
    }

    public void setNoPLX(boolean setting) {
        this.noPLX = setting;
    }

    public void setReportNetViewMacros(String setting) {
        this.reportNetViewMacros = this.validateBooleanProperty(setting, false);
    }

    public void setTruncateFilenames(String setting) {
        this.truncateFilenames = this.validateBooleanProperty(setting, false);
    }

    private boolean validateBooleanProperty(String setting, boolean defaultBooleanValue) {
        if (StringUtils.isEmpty(setting)) {
            return defaultBooleanValue;
        }
        return setting.startsWith("t") || setting.startsWith("T");
    }

    private String validateLanguageHint(String setting, String defaultLanguageHint) {
        if (StringUtils.isEmpty(setting)) {
            return defaultLanguageHint;
        }
        if (setting.equals("ASM") || setting.equals("C") || setting.equals("COB") || setting.equals("CPP") || setting.equals("EASY") || setting.equals("ISPF") || setting.equals("JCL") || setting.equals("PLI") || setting.equals("PLX") || setting.equals("SORT") || setting.equals("TEXT") || setting.equals("UNKN") || setting.equals("XML") || setting.equals("ZBND")) {
            return setting;
        }
        return defaultLanguageHint;
    }
}

