/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigEntry;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigFile;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigRuntimeException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonSerializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.IncludedFileMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.SingleFilesMetadata;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.Classifier;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierASM;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByRecord;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierByString;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierC;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCOB;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierCPP;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierEASY;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierISPF;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierJCL;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierJava;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLI;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierPLX;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierREXX;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierSORT;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierTEXT;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierXML;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.scanners.ClassifierZBND;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.utils.FileHandler;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.utils.FileTypeClassification;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.HashAlgorithms;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Dmh5210 {
    public static final char IDENTIFIER_MODE_CONFIRMED = 'C';
    public static final char IDENTIFIER_MODE_REJECTED = 'R';
    public static final char IDENTIFIER_MODE_UNKNOWN = 'U';
    public static final int DEBUG_OFF = 0;
    public static final int DEBUG_ON = 1;
    public static final int DEBUG_VERBOSE = 2;
    public static final int CLASSIFICATION_SCAN_TOOL_ID = 1000217;
    private static final String classifyConfigFile = "/com/ibm/dmh/scan/classify/classify";
    private ArrayList<ClassifierByRecord> classifiersByRecord;
    private ArrayList<ClassifierByString> classifiersByString;
    private boolean extensionDrivesScan;
    private int debug;
    private boolean needsReset = true;
    private int lineCount;
    private int MaximumSeverity;
    private int winlang;
    private ScanProperties scanProperties = new ScanProperties();
    private SingleFilesMetadata dmh5211;
    private String check_ContentMIMEType;
    private String check_FileExtension;
    private String inrec;
    private String languageHintFromExtension;
    private String[] fileRecords;

    public Dmh5210() {
        this.reset();
    }

    private void reset() {
        if (this.needsReset) {
            this.check_ContentMIMEType = null;
            this.check_FileExtension = null;
            this.classifiersByRecord = new ArrayList();
            this.classifiersByString = new ArrayList();
            this.debug = 0;
            this.dmh5211 = new SingleFilesMetadata();
            this.extensionDrivesScan = false;
            this.fileRecords = null;
            this.inrec = null;
            this.languageHintFromExtension = "";
            this.lineCount = 0;
            this.MaximumSeverity = 0;
            this.winlang = 22;
            this.classifiersByRecord.add(new ClassifierASM(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierC(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierTEXT(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierCOB(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierCPP(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierEASY(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierISPF(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierJava(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierJCL(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierPLI(this.scanProperties));
            if (!this.scanProperties.getNoPLX()) {
                this.classifiersByRecord.add(new ClassifierPLX(this.scanProperties));
            }
            this.classifiersByRecord.add(new ClassifierREXX(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierSORT(this.scanProperties));
            this.classifiersByRecord.add(new ClassifierZBND(this.scanProperties));
            this.classifiersByString.add(new ClassifierXML(this.scanProperties));
            this.needsReset = false;
        }
    }

    public void setDebug(int iSetting) {
        this.debug = iSetting;
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            classifierByRecord.setDebug(iSetting);
        }
        for (ClassifierByString classifierByString : this.classifiersByString) {
            classifierByString.setDebug(iSetting);
        }
    }

    private boolean assignLanguageBasedOnExtension(String languageHintFromUser, String iFileSpecText, String iFileContent) {
        if (!(languageHintFromUser.equals("EMP?") || languageHintFromUser.equals("GONE") || languageHintFromUser.equals("UNKN"))) {
            this.languageHintFromExtension = languageHintFromUser;
            return false;
        }
        if (this.languageHintFromExtension.equals("ASM") || this.languageHintFromExtension.equals("COB") || this.languageHintFromExtension.equals("EASY") || this.languageHintFromExtension.equals("JAVA") || this.languageHintFromExtension.equals("JCL") || this.languageHintFromExtension.equals("PLI") || this.languageHintFromExtension.equals("PLX") || this.languageHintFromExtension.equals("XML")) {
            this.extensionDrivesScan = true;
            return false;
        }
        if (!this.DMHIOAPI_CheckIfMemberExists(iFileSpecText, iFileContent)) {
            this.EOF_GONE_Member();
            return true;
        }
        if (this.languageHintFromExtension.length() == 0) {
            return false;
        }
        int lineCount = 0;
        if (this.check_ContentMIMEType.contains("text") && (lineCount = this.CountLinesInFile(iFileContent)) == 0) {
            this.EOF_EMPTY_Member();
            return true;
        }
        this.dmh5211.setLanguageCd(this.languageHintFromExtension);
        ClassifierMetaData metaData = new ClassifierMetaData();
        metaData.setLanguageCd(this.languageHintFromExtension);
        metaData.setTotalLines(lineCount);
        this.dmh5211.setMetaData(metaData);
        this.addFileHashProperty(iFileContent);
        return true;
    }

    private boolean checkFileExtension(String iFileNameNoQuotes) {
        int pChar = iFileNameNoQuotes.lastIndexOf(46);
        if (pChar == -1) {
            return false;
        }
        if (iFileNameNoQuotes.substring(pChar).length() == 1) {
            return false;
        }
        this.check_FileExtension = iFileNameNoQuotes.substring(pChar + 1);
        String charValue = this.check_FileExtension.toUpperCase();
        String workFileExtension = charValue;
        if (workFileExtension.equals("CPY")) {
            return false;
        }
        if (workFileExtension.equals("TXT")) {
            return false;
        }
        boolean foundExtensionMatch = false;
        boolean foundLanguageCd = false;
        String cfgSection = "";
        String currentCfgSection = null;
        String contentMIMEType = "";
        String languageCd = "";
        Map<String, String> values = this.getConfigMap(classifyConfigFile);
        TreeSet<String> keys = new TreeSet<String>(values.keySet());
        block0: for (String key : keys) {
            String value = values.get(key);
            int index = key.indexOf(46);
            if (index == -1) {
                cfgSection = "";
            } else {
                cfgSection = key.substring(0, index);
                key = key.substring(index + 1);
            }
            if (currentCfgSection == null) {
                currentCfgSection = cfgSection;
            } else if (!currentCfgSection.equals(cfgSection)) {
                if (foundExtensionMatch && foundLanguageCd) break;
                foundExtensionMatch = false;
                foundLanguageCd = false;
                contentMIMEType = "";
                languageCd = "";
                currentCfgSection = cfgSection;
            }
            if (key.equals("contentMIMEType")) {
                contentMIMEType = value;
                continue;
            }
            if (key.equals("fileExts")) {
                String[] tempString = value.split(",");
                int i = 0;
                while (i < tempString.length) {
                    charValue = tempString[i].toUpperCase();
                    if (charValue.equals(workFileExtension)) {
                        foundExtensionMatch = true;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (!key.equals("languageCd")) continue;
            foundLanguageCd = true;
            languageCd = value;
        }
        if (foundExtensionMatch && languageCd.length() != 0) {
            this.check_ContentMIMEType = contentMIMEType;
            this.languageHintFromExtension = languageCd;
        }
        return true;
    }

    private boolean checkForExactMatchScores() {
        boolean matchedHighestScore = false;
        int highestScore = 0;
        int numberOfClassifiers = this.classifiersByRecord.size();
        int i = 0;
        while (i < numberOfClassifiers) {
            block6: {
                block8: {
                    int score1;
                    block7: {
                        ClassifierByRecord classifierByRecord1 = this.classifiersByRecord.get(i);
                        score1 = classifierByRecord1.getScore();
                        if (score1 == 0) break block6;
                        if (highestScore != 0) break block7;
                        highestScore = score1;
                        break block8;
                    }
                    if (score1 <= highestScore) break block6;
                    highestScore = score1;
                    matchedHighestScore = false;
                }
                int j = i + 1;
                while (j < numberOfClassifiers) {
                    ClassifierByRecord classifierByRecord2 = this.classifiersByRecord.get(j);
                    int score2 = classifierByRecord2.getScore();
                    if (score2 != 0 && score2 == highestScore) {
                        matchedHighestScore = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return matchedHighestScore;
    }

    private double calculateTotalScore() {
        int totalScore = 0;
        int cScore = 0;
        int cppScore = 0;
        int pliScore = 0;
        int plxScore = 0;
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            int score = classifierByRecord.getScore();
            String languageCd = classifierByRecord.getLanguageCd();
            if (languageCd.equals("C")) {
                cScore = score;
                continue;
            }
            if (languageCd.equals("CPP")) {
                cppScore = score;
                continue;
            }
            if (languageCd.equals("PLI")) {
                pliScore = score;
                continue;
            }
            if (languageCd.equals("PLX")) {
                plxScore = score;
                continue;
            }
            totalScore += score;
        }
        totalScore = cScore == 0 || cppScore == 0 ? totalScore + cScore + cppScore : (totalScore += (cScore + cppScore) / 2);
        totalScore = pliScore == 0 || plxScore == 0 ? totalScore + pliScore + plxScore : (totalScore += (pliScore + plxScore) / 2);
        return totalScore;
    }

    private int calculateWinScore() {
        int winScore = 0;
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            int score = classifierByRecord.getScore();
            if (score <= winScore) continue;
            winScore = score;
            this.winlang = classifierByRecord.getLanguageId();
        }
        return winScore;
    }

    private boolean ChooseALanguageCode() {
        double totalScore = this.calculateTotalScore();
        if (totalScore == 0.0) {
            return false;
        }
        int winScore = this.calculateWinScore();
        if (totalScore == (double)winScore) {
            if ((double)winScore < (double)this.lineCount * 0.05) {
                this.winlang = 22;
                return false;
            }
            return true;
        }
        if (this.checkForExactMatchScores()) {
            this.winlang = 22;
            return false;
        }
        double tieBreakScore = totalScore * 0.4;
        if ((double)winScore >= tieBreakScore) {
            return true;
        }
        boolean mustBeAssembler = false;
        if (this.winlang == 2) {
            for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
                if (classifierByRecord.getLanguageId() != 2) continue;
                if (!classifierByRecord.hasMACRO_MEND()) break;
                mustBeAssembler = true;
                break;
            }
            if (mustBeAssembler) {
                return true;
            }
        }
        this.winlang = 22;
        return false;
    }

    private void ClearBadLanguageScores(String languageHint) {
        ClassifierASM classifierASM = null;
        ClassifierC classifierC = null;
        ClassifierCOB classifierCOB = null;
        ClassifierCPP classifierCPP = null;
        ClassifierEASY classifierEASY = null;
        ClassifierJCL classifierJCL = null;
        ClassifierPLI classifierPLI = null;
        ClassifierPLX classifierPLX = null;
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            switch (classifierByRecord.getLanguageId()) {
                case 2: {
                    classifierASM = (ClassifierASM)classifierByRecord;
                    break;
                }
                case 4: {
                    classifierC = (ClassifierC)classifierByRecord;
                    break;
                }
                case 6: {
                    classifierCOB = (ClassifierCOB)classifierByRecord;
                    break;
                }
                case 7: {
                    classifierCPP = (ClassifierCPP)classifierByRecord;
                    break;
                }
                case 8: {
                    classifierEASY = (ClassifierEASY)classifierByRecord;
                    break;
                }
                case 14: {
                    classifierJCL = (ClassifierJCL)classifierByRecord;
                    break;
                }
                case 16: {
                    classifierPLI = (ClassifierPLI)classifierByRecord;
                    break;
                }
                case 17: {
                    classifierPLX = (ClassifierPLX)classifierByRecord;
                    break;
                }
            }
            if (classifierByRecord.getScore() == 0) continue;
            classifierByRecord.isScoreBad(this.lineCount, languageHint);
        }
        this.reportScores();
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            if (classifierByRecord.getScore() == 0) continue;
            classifierByRecord.isScoreStillBad(this.lineCount, classifierASM, classifierC, classifierCOB, classifierCPP, classifierEASY, classifierJCL, classifierPLI, classifierPLX);
        }
        this.reportScores();
    }

    private int CountLinesInFile(String iFileContent) {
        int lineCount = 0;
        this.fileRecords = iFileContent.split("\n");
        while (this.DMHIOAPI_GetRecord(lineCount)) {
            ++lineCount;
        }
        return lineCount;
    }

    private void EOF_EMPTY_Member() {
        this.dmh5211.setLanguageCd("EMP?");
        ClassifierMetaData metaData = new ClassifierMetaData();
        metaData.setLanguageCd("EMP?");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_GONE_Member() {
        this.dmh5211.setLanguageCd("GONE");
        ClassifierMetaData metaData = new ClassifierMetaData();
        metaData.setLanguageCd("GONE");
        this.dmh5211.setMetaData(metaData);
    }

    private void EOF_UNK_Member() {
        this.dmh5211.setLanguageCd("UNKN");
        ClassifierMetaData metaData = new ClassifierMetaData();
        metaData.setLanguageCd("UNKN");
        metaData.setNonCommentLines(this.lineCount);
        metaData.setTotalLines(this.lineCount);
        this.dmh5211.setMetaData(metaData);
    }

    private ConfigFile getConfigFile(String filename) throws ConfigRuntimeException {
        InputStream inputStream;
        if (filename.indexOf(46) == -1) {
            filename = String.valueOf(filename) + ".cfg";
        }
        if ((inputStream = this.getClass().getResourceAsStream(filename)) == null) {
            throw new ConfigRuntimeException("Could not getResourceAsStream() for [" + filename + "]");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ConfigFile c = new ConfigFile(dataInputStream);
        return c;
    }

    private Map<String, String> getConfigMap(String config) throws ConfigRuntimeException {
        TreeMap<String, String> m = new TreeMap<String, String>();
        ConfigFile c = this.getConfigFile(config);
        Map<String, ConfigEntry> valueMap = c.getAllValuesMap();
        for (String key : valueMap.keySet()) {
            m.put(key, valueMap.get(key).getValue());
        }
        return m;
    }

    public String getFileTypeCd() {
        return this.dmh5211.getFileTypeCd();
    }

    public String getLanguageCd() {
        return this.dmh5211.getLanguageCd();
    }

    private boolean haveAllLanguagesBeenRejected() {
        boolean rc = true;
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            if (classifierByRecord.getIdentifierMode() == 'R') continue;
            rc = false;
            break;
        }
        return rc;
    }

    public void init(ScanProperties iScanProperties) {
        this.scanProperties = iScanProperties == null ? new ScanProperties() : iScanProperties;
        this.needsReset = true;
        this.reset();
    }

    private void InitializeFields(String iFileName) {
        this.winlang = 22;
        this.dmh5211.setMemberName(iFileName);
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            classifierByRecord.setIdentifierMode('R');
        }
    }

    private void InitializeLanguageValidators(String languageHintFromUser) {
        if (languageHintFromUser == null || languageHintFromUser.length() == 0 || languageHintFromUser.equals("UNKN")) {
            for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
                classifierByRecord.processCommonInitialization();
                classifierByRecord.processInitialization();
                classifierByRecord.setIdentifierMode('U');
            }
            return;
        }
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            classifierByRecord.processCommonInitialization();
            classifierByRecord.processInitialization();
            String languageCd = classifierByRecord.getLanguageCd();
            if (languageCd.equals(languageHintFromUser)) continue;
            classifierByRecord.setIdentifierMode('R');
        }
    }

    private void MetaDataStructureCleanup() {
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            classifierByRecord.processDeallocate();
        }
    }

    private void MemberProcessor(String iFileContent, String languageHint) {
        boolean recordRead = this.ReadTheInputFile();
        if (!recordRead || this.lineCount == 0 && this.inrec.length() == 0) {
            return;
        }
        boolean returnNow = false;
        while (recordRead) {
            if (this.haveAllLanguagesBeenRejected()) {
                returnNow = true;
                break;
            }
            if (this.winlang != 22) break;
            int tempWinLanguage = 22;
            int tempWinLanguages = 0;
            for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
                classifierByRecord.process(this.lineCount, this.inrec, languageHint);
                if (classifierByRecord.getIdentifierMode() != 'C') continue;
                tempWinLanguage = classifierByRecord.getLanguageId();
                ++tempWinLanguages;
            }
            if (tempWinLanguages == 1) {
                this.winlang = tempWinLanguage;
                break;
            }
            recordRead = this.ReadTheInputFile();
        }
        if (returnNow) {
            return;
        }
        if (!recordRead) {
            for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
                if (classifierByRecord.getScore() <= 0) continue;
                classifierByRecord.processEndOfFile(this.lineCount);
            }
        }
        this.reportScores();
        if (this.winlang == 22) {
            this.winlang = this.ProcessFileOfAllCommentsAndBlanks(this.lineCount, languageHint);
        }
        if (this.winlang == 22) {
            this.ClearBadLanguageScores(languageHint);
            this.ChooseALanguageCode();
            return;
        }
        Classifier theWinningClassifier = null;
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            if (classifierByRecord.getLanguageId() != this.winlang) continue;
            theWinningClassifier = classifierByRecord;
            break;
        }
        if (recordRead) {
            while (recordRead = this.ReadTheInputFile()) {
                ((ClassifierByRecord)theWinningClassifier).process(this.lineCount, this.inrec, languageHint);
                if (theWinningClassifier.getIdentifierMode() != 'R') continue;
                this.winlang = 22;
                break;
            }
            if (theWinningClassifier.getIdentifierMode() != 'R') {
                theWinningClassifier.processEndOfFile(this.lineCount);
            }
        }
    }

    private boolean OpenProcessCloseFile(String iFileContent, String iFileSpecText, String languageHint) {
        this.lineCount = 0;
        this.InitializeLanguageValidators(languageHint);
        if (!this.DMHIOAPI_CheckIfMemberExists(iFileSpecText, iFileContent)) {
            return false;
        }
        if (!this.DMHIOAPI_Open(iFileSpecText, iFileContent)) {
            return false;
        }
        this.MemberProcessor(iFileContent, languageHint);
        return true;
    }

    private int ProcessFileOfAllCommentsAndBlanks(int lineCount, String languageHint) {
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            int blanksAndCommentsCount;
            if (!classifierByRecord.getLanguageCd().equals(languageHint) || classifierByRecord.getScore() <= 0 || lineCount != (blanksAndCommentsCount = classifierByRecord.getBlankLineCount() + classifierByRecord.getCommentCount())) continue;
            return classifierByRecord.getLanguageId();
        }
        return 22;
    }

    public SingleFilesMetadata processSingleFile(InputStream iInputStream) {
        return this.processSingleFile(null, iInputStream);
    }

    public SingleFilesMetadata processSingleFile(String fileName, InputStream iInputStream) {
        String convertedContents;
        String codePage = this.scanProperties.getCodePage();
        try {
            convertedContents = FileHandler.readInputStream(iInputStream, codePage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.ProcessSingleFile(null, null, null, null, fileName, null, convertedContents, null);
    }

    public ClassifierMetaData processFileContentForLanguageCd(String siteName, String rmType, String containerName, String fileName, String fileContent, String languageHint) {
        this.reset();
        this.needsReset = true;
        this.dmh5211.setSiteName(siteName);
        this.dmh5211.setRmType(rmType);
        this.dmh5211.setContainerName(containerName);
        FileHandler fileHandler = new FileHandler(containerName, fileName, "");
        this.InitializeFields(fileHandler.getNormalizedFileName());
        String fileSpecText = fileHandler.getFileToOpen();
        this.ProcessFilesContent(fileHandler, fileSpecText, fileContent, languageHint);
        ClassifierMetaData metaData = this.dmh5211.getMetaData();
        return metaData;
    }

    public SingleFilesMetadata ProcessSingleFile(String siteName, String rmType, String rmDDName, String containerName, String fileName, String localName, String fileContent, InputStream inputStream) {
        String theFilesContents;
        this.reset();
        this.needsReset = true;
        FileHandler fileHandler = new FileHandler(containerName == null ? "" : containerName, fileName == null ? "" : fileName, localName == null ? "" : localName);
        this.InitializeFields(fileHandler.getNormalizedFileName());
        fileHandler.setRmType(rmType == null ? "" : rmType);
        fileHandler.setRmDDName(rmDDName == null ? "" : rmDDName);
        String fileSpecText = fileHandler.getFileToOpen();
        String codePage = this.scanProperties.getCodePage();
        if (fileContent == null) {
            if (inputStream == null) {
                theFilesContents = fileHandler.getFileContent(fileSpecText, codePage);
            } else {
                try {
                    theFilesContents = FileHandler.readInputStream(inputStream, codePage);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            theFilesContents = fileContent;
        }
        this.dmh5211.setSiteName(siteName == null ? "" : siteName);
        this.dmh5211.setRmType(fileHandler.getRmType());
        this.dmh5211.setContainerName(fileHandler.getNormalizedContainerName());
        this.ProcessFilesContent(fileHandler, fileSpecText, theFilesContents, this.scanProperties.getLanguageHint());
        ClassifierMetaData metaData = this.dmh5211.getMetaData();
        String languageCd = metaData.getLanguageCd();
        HashMap<String, Object> filesMetadata = new HashMap<String, Object>();
        filesMetadata.put("attcList", metaData.getAttcList());
        filesMetadata.put("attnList", metaData.getAttnList());
        filesMetadata.put("inclList", metaData.getInclList());
        filesMetadata.put("includedFileContainsEntry", Boolean.FALSE);
        filesMetadata.put("plxIsMain", metaData.getPlxIsMain());
        filesMetadata.put("usedAsProc", Boolean.FALSE);
        FileTypeClassification fileTypeClassification = new FileTypeClassification(languageCd, filesMetadata);
        String fileTypeCd = fileTypeClassification.getFileTypeCd();
        this.dmh5211.setFileTypeCd(fileTypeCd);
        return this.dmh5211;
    }

    private void ProcessFilesContent(FileHandler fileHandler, String fileSpecText, String fileContent, String languageHint) {
        boolean returnNow = false;
        for (ClassifierByString classifierByString : this.classifiersByString) {
            if (!classifierByString.checkString(fileContent)) continue;
            int lineCount = this.CountLinesInFile(fileContent);
            String languageCd = classifierByString.getLanguageCd();
            this.dmh5211.setLanguageCd(languageCd);
            ClassifierMetaData metaData = new ClassifierMetaData();
            metaData.setLanguageCd(languageCd);
            metaData.setTotalLines(lineCount);
            this.dmh5211.setMetaData(metaData);
            this.addFileHashProperty(fileContent);
            returnNow = true;
            break;
        }
        if (returnNow) {
            return;
        }
        this.extensionDrivesScan = false;
        this.check_ContentMIMEType = "";
        this.languageHintFromExtension = "";
        String languageHintFromUser = this.scanProperties.getLanguageHint();
        if (fileHandler != null && this.checkFileExtension(fileHandler.getNormalizedFileName())) {
            if (this.assignLanguageBasedOnExtension(languageHintFromUser, fileSpecText, fileContent)) {
                this.MetaDataStructureCleanup();
                return;
            }
            if (this.languageHintFromExtension.length() != 0) {
                languageHint = this.languageHintFromExtension;
            }
        }
        boolean rc = this.OpenProcessCloseFile(fileContent, fileSpecText, languageHint);
        this.recordDiscoveredLanguageCd(rc, this.extensionDrivesScan, fileHandler, fileContent, fileSpecText);
        this.addFileHashProperty(fileContent);
        this.MetaDataStructureCleanup();
    }

    private void addFileHashProperty(String fileContent) {
        try {
            long hash = 0L;
            if (fileContent != null) {
                String codePage = this.scanProperties.getCodePage();
                ByteArrayInputStream bis = new ByteArrayInputStream(codePage == null ? fileContent.getBytes() : fileContent.getBytes(codePage));
                hash = HashAlgorithms.useProprietaryAlgorithm(bis);
                bis.close();
            }
            this.dmh5211.getMetaData().setFileHash(hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean ReadTheInputFile() {
        boolean rc = false;
        rc = this.DMHIOAPI_GetRecord(this.lineCount);
        if (rc) {
            ++this.lineCount;
            if (this.debug == 2) {
                this.reportScores();
                System.out.println("Record[" + String.valueOf(this.lineCount) + "][" + this.inrec + "]");
            }
        }
        return rc;
    }

    private void recordDiscoveredLanguageCd(boolean iRC, boolean iExtensionDrivesScan, FileHandler iFileHandler, String fileContent, String fileSpecText) {
        if (this.ReportWinLanguage(iRC)) {
            return;
        }
        if (!iExtensionDrivesScan) {
            this.EOF_UNK_Member();
            return;
        }
        this.MetaDataStructureCleanup();
        if (iFileHandler == null) {
            this.InitializeFields("");
        } else {
            this.InitializeFields(iFileHandler.getNormalizedFileName());
        }
        String languageHint = this.scanProperties.getLanguageHint();
        boolean rc = this.OpenProcessCloseFile(fileContent, fileSpecText, languageHint);
        if (this.ReportWinLanguage(rc)) {
            return;
        }
        this.EOF_UNK_Member();
    }

    private void reportScores() {
        if (this.debug == 0) {
            return;
        }
        int tempScore = 0;
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            tempScore += classifierByRecord.getScore();
        }
        System.out.print("Scores - ");
        if (tempScore == 0) {
            System.out.println("are all zero");
        } else {
            for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
                System.out.print(String.valueOf(classifierByRecord.getLanguageCd()) + "[" + classifierByRecord.getScore() + "] ");
            }
        }
        System.out.println(" ");
    }

    private boolean ReportWinLanguage(boolean iRC) {
        if (!iRC) {
            this.EOF_GONE_Member();
            return true;
        }
        if (this.lineCount == 0) {
            this.EOF_EMPTY_Member();
            return true;
        }
        boolean rc = false;
        for (ClassifierByRecord classifierByRecord : this.classifiersByRecord) {
            int languageId = classifierByRecord.getLanguageId();
            if (this.winlang != languageId) continue;
            String languageCd = classifierByRecord.getLanguageCd();
            this.dmh5211.setLanguageCd(languageCd);
            ClassifierMetaData metaData = classifierByRecord.getMetaData();
            metaData.setLanguageCd(languageCd);
            this.dmh5211.setMetaData(metaData);
            String workString = classifierByRecord.getLanguageDescription();
            if (languageCd.equals("ASM")) {
                if (classifierByRecord.hasBMSmacro()) {
                    workString = String.valueOf(workString) + " (BMS macro)";
                } else if (classifierByRecord.hasDBDGENstatement()) {
                    workString = String.valueOf(workString) + " (DBDGEN)";
                } else if (classifierByRecord.hasPSBGENstatement()) {
                    workString = String.valueOf(workString) + " (PSBGEN)";
                }
            }
            rc = true;
            break;
        }
        return rc;
    }

    public int DMHU005() {
        return this.MaximumSeverity;
    }

    public void ResetMaximumSeverity() {
        this.MaximumSeverity = 0;
    }

    public void SetMaximumSeverity(int setting) {
        this.MaximumSeverity = setting;
    }

    private boolean DMHIOAPI_CheckIfMemberExists(String iFileSpecText, String iFileContent) {
        if (iFileContent != null) {
            return true;
        }
        File file = new File(iFileSpecText);
        return file.exists() && file.canRead();
    }

    private boolean DMHIOAPI_Open(String iFileSpecText, String iFileContent) {
        if (iFileContent != null) {
            this.fileRecords = iFileContent.split("\n");
            return true;
        }
        File file = new File(iFileSpecText);
        FileInputStream fis = null;
        String contents = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            contents = this.readInputStream(fis);
            this.fileRecords = contents.split("\n");
            fis.close();
        }
        catch (IOException e) {
            this.fileRecords = null;
            return false;
        }
        return true;
    }

    private String readInputStream(InputStream readStream) throws IOException {
        int BUFF_SIZE = 4096;
        ByteArrayOutputStream accumulator = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int readSize = readStream.read(buffer, 0, 4096);
        while (readSize >= 0) {
            accumulator.write(buffer, 0, readSize);
            readSize = readStream.read(buffer, 0, 4096);
        }
        return accumulator.toString();
    }

    private boolean DMHIOAPI_GetRecord(int iLineCount) {
        if (this.fileRecords == null) {
            return false;
        }
        if (iLineCount >= this.fileRecords.length) {
            return false;
        }
        this.inrec = this.fileRecords[iLineCount];
        while (this.inrec.endsWith("\r")) {
            this.inrec = this.inrec.substring(0, this.inrec.length() - 1);
        }
        return this.fileRecords.length != 1 || this.inrec.length() != 0;
    }

    private void generateAssignmentsForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<String, String> assignments) {
        if (assignments == null) {
            return;
        }
        if (jsonResponseFormat.equals("ADI")) {
            JsonList assignment = new JsonList();
            for (String source : assignments.keySet()) {
                JsonMap<String, String> stmt = new JsonMap<String, String>();
                stmt.put("source", source);
                stmt.put("destination", assignments.get(source));
                assignment.add(stmt);
            }
            attributes.put("moveStatements", assignment);
        }
    }

    private void generateCharacterAttributesForImportFile(Map<String, Object> attributes, Map<Integer, String> attcList) {
        if (attcList == null) {
            return;
        }
        this.reportATTCForPLIoptions(attcList);
    }

    private void generateNumericAttributesForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<Integer, Integer> attnList) {
        if (attnList == null) {
            return;
        }
        if (jsonResponseFormat.equals("ADI") || jsonResponseFormat.equals("GBS")) {
            for (Integer key : attnList.keySet()) {
                attributes.put(Dmh5210.getNumericAttrName(key, this.getLanguageCd()), attnList.get(key));
            }
        } else {
            JsonList attrs = new JsonList();
            attributes.put("attrs", attrs);
            for (Integer key : attnList.keySet()) {
                JsonMap<String, Object> attr = new JsonMap<String, Object>();
                attr.put("type", Dmh5210.getNumericAttrName(key, this.getLanguageCd()));
                attr.put("value", attnList.get(key));
                attrs.add(attr);
            }
        }
    }

    private void generateCicsMapsForImportFile(Map<String, Object> attributes, Map<String, Set<String>> mapSetList) {
        if (mapSetList == null || mapSetList.size() == 0) {
            return;
        }
        JsonList cicsMaps = new JsonList();
        attributes.put("cicsMaps", cicsMaps);
        JsonList<JsonMap<String, String>> maps = null;
        JsonMap<String, String> map = null;
        String currentMapSetName = "";
        for (String mapSetName : mapSetList.keySet()) {
            for (String mapName : mapSetList.get(mapSetName)) {
                if (mapSetName.length() == 0) {
                    mapSetName = mapName;
                }
                if (!mapSetName.equals(currentMapSetName)) {
                    JsonMap<String, Object> cicsMap = new JsonMap<String, Object>();
                    cicsMaps.add(cicsMap);
                    if (mapSetName.startsWith("\"") || mapSetName.startsWith("'")) {
                        cicsMap.put("mapSet", mapSetName.substring(1, mapSetName.length() - 1));
                        cicsMap.put("mapSetType", "literal");
                    } else {
                        cicsMap.put("mapSet", mapSetName);
                        cicsMap.put("mapSetType", "dataElement");
                    }
                    maps = new JsonList<JsonMap<String, String>>();
                    cicsMap.put("maps", maps);
                    currentMapSetName = mapSetName;
                }
                map = new JsonMap<String, String>();
                if (mapName.startsWith("\"") || mapName.startsWith("'")) {
                    map.put("map", mapName.substring(1, mapName.length() - 1));
                    map.put("mapType", "literal");
                } else {
                    map.put("map", mapName);
                    map.put("mapType", "dataElement");
                }
                maps.add(map);
            }
        }
    }

    private void generateControlTransfersForImportFile(String jsonResponseFormat, Map<String, Object> attrs, Map<String, Set<String>> iControlTransfers) {
        if (iControlTransfers == null || iControlTransfers.size() == 0) {
            return;
        }
        if (jsonResponseFormat.equals("ADI") || jsonResponseFormat.equals("GBS")) {
            for (String typeOfControlTransfer : iControlTransfers.keySet()) {
                String tag = typeOfControlTransfer.equals("LINK") ? "controlTransfersLink" : (typeOfControlTransfer.equals("XCTL") ? "controlTransfersXctl" : "controlTransfersCall");
                attrs.put(tag, iControlTransfers.get(typeOfControlTransfer));
            }
        } else {
            JsonList controlTransfers = new JsonList();
            attrs.put("controlTransfers", controlTransfers);
            for (String typeOfControlTransfer : iControlTransfers.keySet()) {
                for (String target : iControlTransfers.get(typeOfControlTransfer)) {
                    JsonMap<String, String> controlTransfer = new JsonMap<String, String>();
                    controlTransfer.put("type", typeOfControlTransfer);
                    controlTransfer.put("target", target);
                    controlTransfers.add(controlTransfer);
                }
            }
        }
    }

    private void generateInclsForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<Integer, Map<String, Integer>> inclList) {
        if (inclList == null || inclList.size() == 0) {
            return;
        }
        if (jsonResponseFormat.equals("ADI")) {
            JsonMap references = new JsonMap();
            attributes.put("referencesIncl", references);
            for (Integer inclTypeId : inclList.keySet()) {
                IncludedFileMetaData includedFileMetaData = Dmh5210.decodeInclData(inclTypeId, " DD=x");
                JsonList<String> includeNames = (JsonList<String>)references.get(includedFileMetaData.getType());
                if (includeNames == null) {
                    includeNames = new JsonList<String>();
                    references.put(includedFileMetaData.getType(), includeNames);
                }
                for (String inclName : inclList.get(inclTypeId).keySet()) {
                    includedFileMetaData = Dmh5210.decodeInclData(inclTypeId, inclName);
                    String ddName = includedFileMetaData.getDdName();
                    if (ddName == null) {
                        includeNames.add(includedFileMetaData.getInclName());
                        continue;
                    }
                    includeNames.add(String.valueOf(includedFileMetaData.getInclName()) + " DD=" + ddName);
                }
            }
        } else if (jsonResponseFormat.equals("GBS")) {
            JsonMap references = new JsonMap();
            attributes.put("referencesIncl", references);
            for (Integer inclTypeId : inclList.keySet()) {
                JsonList includeNames = new JsonList();
                IncludedFileMetaData includedFileMetaData = Dmh5210.decodeInclData(inclTypeId, " DD=x");
                references.put(includedFileMetaData.getType(), includeNames);
                Map<String, Integer> inclNameMap = inclList.get(inclTypeId);
                for (String inclName : inclNameMap.keySet()) {
                    JsonMap<String, Integer> includeName = new JsonMap<String, Integer>();
                    Integer inclCount = inclNameMap.get(inclName);
                    includedFileMetaData = Dmh5210.decodeInclData(inclTypeId, inclName);
                    String ddName = includedFileMetaData.getDdName();
                    if (ddName == null) {
                        includeName.put(includedFileMetaData.getInclName(), inclCount);
                    } else {
                        includeName.put(String.valueOf(includedFileMetaData.getInclName()) + " DD=" + ddName, inclCount);
                    }
                    includeNames.add(includeName);
                }
            }
        } else {
            JsonList references = new JsonList();
            attributes.put("references", references);
            for (Integer inclTypeId : inclList.keySet()) {
                for (String inclName : inclList.get(inclTypeId).keySet()) {
                    IncludedFileMetaData includedFileMetaData = Dmh5210.decodeInclData(inclTypeId, inclName);
                    JsonMap<String, String> dependencyData = new JsonMap<String, String>();
                    dependencyData.put("type", includedFileMetaData.getType());
                    dependencyData.put("name", includedFileMetaData.getInclName());
                    String ddName = includedFileMetaData.getDdName();
                    if (ddName != null) {
                        dependencyData.put("ddName", ddName);
                    }
                    dependencyData.put("fileTypeCd", includedFileMetaData.getFileTypeCd());
                    references.add(dependencyData);
                }
            }
        }
    }

    private void generateCommentsForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<String, Integer> comments) {
        if (comments == null) {
            return;
        }
        if (jsonResponseFormat.equals("GBS")) {
            JsonList commentInstances = new JsonList();
            for (String comment : comments.keySet()) {
                JsonMap<String, Object> commentInstance = new JsonMap<String, Object>();
                commentInstance.put("comment", comment);
                commentInstance.put("instances", comments.get(comment));
                commentInstances.add(commentInstance);
            }
            attributes.put("comments", commentInstances);
        } else {
            Set<String> keys = comments.keySet();
            JsonList<String> jsonList = new JsonList<String>((Collection<String>)keys);
            attributes.put("comments", jsonList);
        }
    }

    private void generateEntryPointsForImportFile(String jsonResponseFormat, Map<String, Object> attributes, List<String> entryPoints) {
        if (entryPoints == null) {
            return;
        }
        attributes.put("entryPoints", new JsonList<String>((Collection<String>)entryPoints));
    }

    private void generateExecStatementsForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<String, Integer> execStatements) {
        if (execStatements == null) {
            return;
        }
        if (jsonResponseFormat.equals("GBS")) {
            JsonList execStatementInstances = new JsonList();
            for (String execStatement : execStatements.keySet()) {
                JsonMap<String, Object> execStatementInstance = new JsonMap<String, Object>();
                execStatementInstance.put("execStatement", execStatement);
                execStatementInstance.put("instances", execStatements.get(execStatement));
                execStatementInstances.add(execStatementInstance);
            }
            attributes.put("execStatements", execStatementInstances);
        } else {
            attributes.put("execStatements", new JsonList<String>((Collection<String>)execStatements.keySet()));
        }
    }

    private void generateLiteralsForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<String, Integer> literals) {
        if (literals == null) {
            return;
        }
        if (jsonResponseFormat.equals("GBS")) {
            JsonList literalInstances = new JsonList();
            for (String literal : literals.keySet()) {
                JsonMap<String, Object> literalInstance = new JsonMap<String, Object>();
                literalInstance.put("literal", literal);
                literalInstance.put("instances", literals.get(literal));
                literalInstances.add(literalInstance);
            }
            attributes.put("literals", literalInstances);
        } else {
            attributes.put("literals", new JsonList<String>((Collection<String>)literals.keySet()));
        }
    }

    private void generatePicturesForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<String, Integer> pictures) {
        if (pictures == null) {
            return;
        }
        if (jsonResponseFormat.equals("GBS")) {
            JsonList pictureInstances = new JsonList();
            for (String picture : pictures.keySet()) {
                JsonMap<String, Object> pictureInstance = new JsonMap<String, Object>();
                pictureInstance.put("picture", picture);
                pictureInstance.put("instances", pictures.get(picture));
                pictureInstances.add(pictureInstance);
            }
            attributes.put("pictures", pictureInstances);
        } else {
            attributes.put("pictures", new JsonList<String>((Collection<String>)pictures.keySet()));
        }
    }

    private void generateProcedureLabelsForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<String, Integer> procedureLabels) {
        if (procedureLabels == null) {
            return;
        }
        if (jsonResponseFormat.equals("ADI")) {
            attributes.put("procedureLabels", new JsonList<String>((Collection<String>)procedureLabels.keySet()));
        }
    }

    private void generateSymbolsForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<String, Integer> symbolsReserved, Map<String, Integer> symbolsUserDefined) {
        if (symbolsReserved != null) {
            if (jsonResponseFormat.equals("GBS")) {
                JsonList symbolsReservedInstances = new JsonList();
                for (String symbolReserved : symbolsReserved.keySet()) {
                    JsonMap<String, Object> symbolReservedInstance = new JsonMap<String, Object>();
                    symbolReservedInstance.put("symbolReserved", symbolReserved);
                    symbolReservedInstance.put("instances", symbolsReserved.get(symbolReserved));
                    symbolsReservedInstances.add(symbolReservedInstance);
                }
                attributes.put("symbolsReserved", symbolsReservedInstances);
            } else {
                attributes.put("symbolsReserved", new JsonList<String>((Collection<String>)symbolsReserved.keySet()));
            }
        }
        if (symbolsUserDefined != null) {
            if (jsonResponseFormat.equals("GBS")) {
                JsonList symbolsUserDefinedInstances = new JsonList();
                for (String symbolUserDefined : symbolsUserDefined.keySet()) {
                    JsonMap<String, Object> symbolUserDefinedInstance = new JsonMap<String, Object>();
                    symbolUserDefinedInstance.put("symbolUserDefined", symbolUserDefined);
                    symbolUserDefinedInstance.put("instances", symbolsUserDefined.get(symbolUserDefined));
                    symbolsUserDefinedInstances.add(symbolUserDefinedInstance);
                }
                attributes.put("symbolsUserDefined", symbolsUserDefinedInstances);
            } else {
                attributes.put("symbolsUserDefined", new JsonList<String>((Collection<String>)symbolsUserDefined.keySet()));
            }
        }
    }

    private void generateTableOrViewNamesForImportFile(String jsonResponseFormat, Map<String, Object> attributes, Map<String, Integer> tableOrViewNames) {
        if (tableOrViewNames == null) {
            return;
        }
        if (jsonResponseFormat.equals("GBS")) {
            JsonList tableOrViewNameInstances = new JsonList();
            for (String tableOrViewName : tableOrViewNames.keySet()) {
                JsonMap<String, Object> tableOrViewNameInstance = new JsonMap<String, Object>();
                tableOrViewNameInstance.put("tableName", tableOrViewName);
                tableOrViewNameInstance.put("instances", tableOrViewNames.get(tableOrViewName));
                tableOrViewNameInstances.add(tableOrViewNameInstance);
            }
            attributes.put("tableNames", tableOrViewNameInstances);
        } else {
            attributes.put("tableNames", new JsonList<String>((Collection<String>)tableOrViewNames.keySet()));
        }
    }

    private void createINCLrecord(List<String> records, Map<Integer, Map<String, Integer>> inclList) {
        if (inclList == null || inclList.size() == 0) {
            return;
        }
        for (Integer inclTypeId : inclList.keySet()) {
            for (String inclName : inclList.get(inclTypeId).keySet()) {
                records.add("INCL " + inclTypeId + " " + inclName);
            }
        }
    }

    private void createCicsMapRecord(List<String> records, Map<String, Set<String>> mapSetList) {
        if (mapSetList == null || mapSetList.size() == 0) {
            return;
        }
        for (String mapSetName : mapSetList.keySet()) {
            for (String mapName : mapSetList.get(mapSetName)) {
                if (mapSetName.length() != 0) continue;
                mapSetName = mapName;
            }
        }
    }

    private void createControlTransferRecords(List<String> records, Map<String, Set<String>> controlTransfers) {
    }

    private void createSITErecord(List<String> records, String siteName) {
        if (siteName == null || siteName.length() == 0) {
            return;
        }
        records.add("SITE " + this.quote(siteName));
    }

    private void createLITrecords(List<String> records, ClassifierMetaData metadata) {
        Map<String, Integer> literals = metadata.getLiterals();
        if (literals == null) {
            return;
        }
        for (String literal : literals.keySet()) {
            records.add("LIT " + literal);
        }
    }

    private void createPICrecords(List<String> records, ClassifierMetaData metadata) {
        Map<String, Integer> pictures = metadata.getPictures();
        if (pictures == null) {
            return;
        }
        for (String picture : pictures.keySet()) {
            records.add("PIC " + picture);
        }
    }

    private void createSYMrecords(List<String> records, ClassifierMetaData metadata) {
        Map<String, Integer> symbolsUserDefined = metadata.getSymbolsUserDefined();
        if (symbolsUserDefined == null) {
            return;
        }
        for (String symbolUserDefined : symbolsUserDefined.keySet()) {
            records.add("SYM " + symbolUserDefined);
        }
    }

    public static IncludedFileMetaData decodeInclData(Integer inclTypeId, String inclName) {
        IncludedFileMetaData includedFileMetaData;
        switch (inclTypeId) {
            case 10: {
                includedFileMetaData = new IncludedFileMetaData("#include", inclName, null, "INCL");
                break;
            }
            case 12: {
                includedFileMetaData = new IncludedFileMetaData("import", inclName, null, "INCL");
                break;
            }
            case 1: {
                includedFileMetaData = new IncludedFileMetaData("JCL INCLUDE", inclName, null, "INCL");
                break;
            }
            case 62: {
                includedFileMetaData = new IncludedFileMetaData("MACRO_DEF", inclName, null, "MAC");
                break;
            }
            case 8: {
                includedFileMetaData = new IncludedFileMetaData("MACRO", inclName, null, "MAC");
                break;
            }
            case 6: {
                includedFileMetaData = new IncludedFileMetaData("-INC", inclName, null, "INCL");
                break;
            }
            case 5: {
                includedFileMetaData = new IncludedFileMetaData("++INCLUDE", inclName, null, "INCL");
                break;
            }
            case 9: {
                includedFileMetaData = new IncludedFileMetaData("PROC", inclName, null, "PROC");
                break;
            }
            case 3: {
                includedFileMetaData = new IncludedFileMetaData("COPY", inclName, null, "INCL");
                break;
            }
            case 4: {
                String[] tokens = inclName.split(" DD=");
                includedFileMetaData = new IncludedFileMetaData("COPY", tokens[0], tokens[1], "INCL");
                break;
            }
            case 7: {
                includedFileMetaData = new IncludedFileMetaData("SQL INCLUDE", inclName, null, "INCL");
                break;
            }
            case 11: {
                includedFileMetaData = new IncludedFileMetaData("system #include", inclName, null, "INCL");
                break;
            }
            default: {
                includedFileMetaData = new IncludedFileMetaData("unknown", inclName, null, "INCL");
            }
        }
        return includedFileMetaData;
    }

    public static String getNumericAttrName(Integer attrTypeId, String languageCd) {
        String attrName;
        switch (attrTypeId) {
            case 25: {
                attrName = "idmsControlSection";
                break;
            }
            case 27: {
                attrName = "commentLines";
                break;
            }
            case 28: {
                attrName = "nonCommentLines";
                break;
            }
            case 29: {
                attrName = "blankLines";
                break;
            }
            case 30: {
                attrName = "execCICS";
                break;
            }
            case 31: {
                attrName = "execDLI";
                break;
            }
            case 32: {
                attrName = "execIDMS";
                break;
            }
            case 33: {
                attrName = "execSQL";
                break;
            }
            case 34: {
                attrName = "identificationDivision";
                break;
            }
            case 35: {
                attrName = "environmentDivision";
                break;
            }
            case 36: {
                attrName = "dataDivision";
                break;
            }
            case 37: {
                if (languageCd.equals("COB")) {
                    attrName = "procedureDivision";
                    break;
                }
                attrName = "procedure";
                break;
            }
            case 38: {
                attrName = "callCBLTDLI";
                break;
            }
            case 39: {
                attrName = "nonCommentBefore1st";
                break;
            }
            case 40: {
                attrName = "nonCommentAfter1st";
                break;
            }
            case 41: {
                attrName = "callPLITDLI";
                break;
            }
            case 42: {
                attrName = "callASMTDLI";
                break;
            }
            case 43: {
                attrName = "callAIBTDLI";
                break;
            }
            case 44: {
                attrName = "OPSYN";
                break;
            }
            case 45: {
                attrName = "ICTL";
                break;
            }
            case 46: {
                attrName = "CSECT";
                break;
            }
            case 47: {
                attrName = "START";
                break;
            }
            case 48: {
                attrName = "PSB";
                break;
            }
            case 49: {
                attrName = "PCB";
                break;
            }
            case 50: {
                attrName = "FCT";
                break;
            }
            case 51: {
                attrName = "PCT";
                break;
            }
            case 52: {
                attrName = "jobCard";
                break;
            }
            case 53: {
                attrName = "execStmt";
                break;
            }
            case 54: {
                attrName = "execPgm";
                break;
            }
            case 55: {
                attrName = "PPT";
                break;
            }
            case 56: {
                attrName = "OPTIONS";
                break;
            }
            case 57: {
                attrName = "ENTRY";
                break;
            }
            case 59: {
                attrName = "callAERTDLI";
                break;
            }
            case 60: {
                attrName = "function";
                break;
            }
            case 62: {
                attrName = "macroDef";
                break;
            }
            case 63: {
                attrName = "procDef";
                break;
            }
            case 64: {
                attrName = "copyReplacing";
                break;
            }
            case 65: {
                attrName = "DFHMSD";
                break;
            }
            case 81: {
                attrName = "DBD";
                break;
            }
            case 82: {
                attrName = "CEEENTRY";
                break;
            }
            case 83: {
                attrName = "splittingNodes";
                break;
            }
            case 84: {
                attrName = "CEEXAHD";
                break;
            }
            case 85: {
                attrName = "CEEXART";
                break;
            }
            case 86: {
                attrName = "CEEXAST";
                break;
            }
            case 87: {
                attrName = "MFS";
                break;
            }
            case 106: {
                attrName = "recordCount";
                break;
            }
            case 160: {
                attrName = "jclExtension";
                break;
            }
            case 810: {
                attrName = "DFHCSDUP";
                break;
            }
            default: {
                attrName = "unknown";
            }
        }
        return attrName;
    }

    public static String getCharacterAttrName(Integer attrTypeId) {
        String attrName;
        switch (attrTypeId) {
            case 56: {
                attrName = "OPTIONS";
                break;
            }
            default: {
                attrName = "unknown";
            }
        }
        return attrName;
    }

    public List<String> generateImportFileRecords(boolean includeSymbols) {
        Map<Integer, String> attcList;
        LinkedList<String> records = new LinkedList<String>();
        records.add("FMT MEMIDENT 1");
        records.add("TOOL 1000217");
        String currentContainerNameNoQuotes = null;
        String currentRmType = null;
        String currentSiteName = null;
        String siteName = this.dmh5211.getSiteName();
        if (currentSiteName == null || !currentSiteName.equals(siteName)) {
            this.createSITErecord(records, siteName);
            currentSiteName = siteName;
        }
        String containerName = this.dmh5211.getContainerName();
        String rmType = this.dmh5211.getRmType();
        if (currentContainerNameNoQuotes == null || !currentContainerNameNoQuotes.equals(containerName) || currentRmType == null || !currentRmType.equals(rmType)) {
            records.add("LIBR " + this.quote(containerName) + " " + rmType);
            currentContainerNameNoQuotes = containerName;
            currentRmType = rmType;
        }
        ClassifierMetaData metadata = this.dmh5211.getMetaData();
        String memberName = this.dmh5211.getMemberName();
        String languageCd = this.dmh5211.getLanguageCd();
        String hash = metadata.hasFileHash() ? " " + metadata.getFileHash() : "";
        records.add("MEMB " + this.quote(memberName) + " " + languageCd + hash);
        Map<Integer, Integer> attnList = metadata.getAttnList();
        if (attnList != null) {
            for (Integer key : attnList.keySet()) {
                records.add("ATTN " + key + " " + attnList.get(key));
            }
        }
        if ((attcList = metadata.getAttcList()) != null) {
            this.reportATTCForPLIoptions(attcList);
        }
        this.createControlTransferRecords(records, metadata.getControlTransfers());
        this.createINCLrecord(records, metadata.getInclList());
        this.createCicsMapRecord(records, metadata.getMapSetList());
        if (includeSymbols) {
            this.createLITrecords(records, metadata);
            this.createPICrecords(records, metadata);
            this.createSYMrecords(records, metadata);
        }
        return records;
    }

    public String generateJsonOutput(String jsonResponseFormat, Map<String, Object> attributes) {
        if (jsonResponseFormat.equals("ADI")) {
            return JsonSerializer.DEFAULT_STRICT_CONDENSED.serialize(attributes);
        }
        if (jsonResponseFormat.equals("GBS")) {
            throw new RuntimeException("IBM Services must not call the generateJsonOutput method");
        }
        JsonMap<String, Map<String, Object>> classify = new JsonMap<String, Map<String, Object>>();
        classify.put("classify", attributes);
        if (jsonResponseFormat.equals("PRETTY")) {
            return JsonSerializer.DEFAULT.serialize(classify);
        }
        return JsonSerializer.DEFAULT_STRICT_CONDENSED.serialize(classify);
    }

    public Map<String, Object> gatherAllAttributes(String jsonResponseFormat) {
        JsonMap<String, Object> attributes = new JsonMap<String, Object>();
        String memberName = this.dmh5211.getMemberName();
        if (!jsonResponseFormat.equals("GBS")) {
            attributes.put("name", memberName);
        }
        attributes.put("languageCd", this.dmh5211.getLanguageCd());
        ClassifierMetaData metaData = this.dmh5211.getMetaData();
        if (metaData.hasFileHash()) {
            attributes.put("fileHash", metaData.getFileHash());
        }
        this.generateNumericAttributesForImportFile(jsonResponseFormat, attributes, metaData.getAttnList());
        this.generateCharacterAttributesForImportFile(attributes, metaData.getAttcList());
        this.generateControlTransfersForImportFile(jsonResponseFormat, attributes, metaData.getControlTransfers());
        this.generateInclsForImportFile(jsonResponseFormat, attributes, metaData.getInclList());
        this.generateCicsMapsForImportFile(attributes, metaData.getMapSetList());
        this.generateCommentsForImportFile(jsonResponseFormat, attributes, metaData.getComments());
        this.generateEntryPointsForImportFile(jsonResponseFormat, attributes, metaData.getEntryPoints());
        this.generateExecStatementsForImportFile(jsonResponseFormat, attributes, metaData.getExecStatements());
        this.generateLiteralsForImportFile(jsonResponseFormat, attributes, metaData.getLiterals());
        this.generatePicturesForImportFile(jsonResponseFormat, attributes, metaData.getPictures());
        this.generateProcedureLabelsForImportFile(jsonResponseFormat, attributes, metaData.getProcedureLabels());
        this.generateSymbolsForImportFile(jsonResponseFormat, attributes, metaData.getSymbolsReserved(), metaData.getSymbolsUserDefined());
        this.generateTableOrViewNamesForImportFile(jsonResponseFormat, attributes, metaData.getTableOrViewNames());
        this.generateAssignmentsForImportFile(jsonResponseFormat, attributes, metaData.getAssignments());
        String fileTypeCd = this.dmh5211.getFileTypeCd();
        attributes.put("fileTypeCd", fileTypeCd);
        if (fileTypeCd.equals("INCL") || fileTypeCd.equals("PROC")) {
            attributes.put("logicalName", this.getLogicalName(memberName));
        }
        return attributes;
    }

    private void reportATTCForPLIoptions(Map<Integer, String> options) {
    }

    private String quote(String s) {
        return s.indexOf(32) == -1 ? s : String.valueOf('\"') + s + '\"';
    }

    private String getLogicalName(String iFilename) {
        int pChar = iFilename.lastIndexOf(46);
        if (pChar == -1) {
            return iFilename.toUpperCase();
        }
        return iFilename.substring(0, pChar).toUpperCase();
    }

    public static void updateAssemblerFileTypeUsingMetadata(SingleFilesMetadata asmFile, Collection<SingleFilesMetadata> allMetaData) {
        Map<Integer, Map<String, Integer>> refs;
        if (asmFile.getLanguageCd().equals("ASM") && asmFile.getFileTypeCd().equals("INCL") && (refs = asmFile.getMetaData().getInclList()) != null) {
            Set<String> macros = refs.get(8).keySet();
            block0: for (String macroName : macros) {
                for (SingleFilesMetadata checkFile : allMetaData) {
                    Map<Integer, Map<String, Integer>> inclList;
                    Map<Integer, Integer> attnList;
                    if (!checkFile.getLanguageCd().equals("ASM") || !macroName.equals(checkFile.getMemberName()) || !FileTypeClassification.fileContainsEntry(attnList = checkFile.getMetaData().getAttnList(), inclList = checkFile.getMetaData().getInclList())) continue;
                    asmFile.setFileTypeCd("MAIN");
                    continue block0;
                }
            }
        }
    }
}

