/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.rest;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.rest.RestCall;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.rest.RestCallException;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RestCmdLine {
    public static int handleRequest(List<String> args) throws RestCallException, IOException {
        if (!(args instanceof LinkedList)) {
            args = new LinkedList<String>(args);
        }
        if (args.size() < 2) {
            return 2;
        }
        String o = null;
        RestCall r = new RestCall(args.remove(0), args.remove(0));
        if (args.size() > 0 && !args.get(0).startsWith("-")) {
            r.setInput(args.remove(0));
        }
        Iterator<String> i2 = args.iterator();
        while (i2.hasNext()) {
            if (!i2.hasNext()) {
                return 2;
            }
            String s1 = i2.next();
            String s2 = i2.next();
            if (!s1.startsWith("-")) {
                return 2;
            }
            switch (s1.charAt(1)) {
                case 'i': {
                    r.setInput(new FileReader(s2));
                    break;
                }
                case 'o': {
                    o = s2;
                    break;
                }
                case 'c': {
                    r.setContentType(s2);
                    break;
                }
                case 'u': {
                    r.setUser(s2);
                    break;
                }
                case 'p': {
                    r.setPw(s2);
                    break;
                }
                case 'e': {
                    r.setCharset(s2);
                    break;
                }
                case 'h': {
                    r.setHeader(s1.substring(2), s2);
                    break;
                }
                default: {
                    return 2;
                }
            }
        }
        Writer out = o == null ? new OutputStreamWriter(System.out) : new BufferedWriter(new FileWriter(o));
        r.pipeToWriter(out);
        out.close();
        return r.rc;
    }

    public static void main(String[] args) {
        try {
            System.exit(RestCmdLine.handleRequest(Arrays.asList(args)));
        }
        catch (RestCallException e) {
            e.printStackTrace(System.err);
            System.exit(e.responseCode);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

