/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.rest;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonSerializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Parser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Serializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.UrlParamSerializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.XmlParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.rest.RestCallException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class RestCall {
    protected static final String DELETE = "DELETE";
    public static final String GET = "GET";
    public static final String OPTIONS = "OPTIONS";
    protected static final String POST = "POST";
    protected static final String PUT = "PUT";
    int bufferSize = 1024;
    HttpURLConnection c;
    String method;
    String url;
    String user;
    String pw;
    String contentType = "text/json";
    String charset = "UTF-8";
    Map<String, String> headers = new LinkedHashMap<String, String>();
    Map<String, Object> params = new LinkedHashMap<String, Object>();
    Object input;
    Serializer serializer;
    Parser parser = JsonParser.DEFAULT;
    Exception e;
    int rc;
    int redirectCount;
    int connectTimeout;
    boolean connectionMade;
    boolean connectionTimedOut;

    public RestCall(String method, String url) {
        this.method = method.toUpperCase();
        this.url = url;
    }

    public RestCall(String method, String url, String user, String pw) {
        this(method, url);
        this.setUser(user).setPw(pw);
    }

    public RestCall setInput(Object input) {
        this.input = input;
        return this;
    }

    public RestCall setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public RestCall setParser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public RestCall setUser(String user) {
        this.user = user;
        return this;
    }

    public RestCall setPw(String pw) {
        this.pw = pw;
        return this;
    }

    public RestCall setUserPw(String user, String pw) {
        return this.setUser(user).setPw(pw);
    }

    public RestCall setAccept(String contentType) {
        if (contentType != null) {
            this.setHeader("Accept", contentType);
        }
        return this;
    }

    public RestCall setAcceptCharset(String charset) {
        if (charset != null) {
            this.setHeader("Accept-Charset", charset);
        }
        return this;
    }

    public RestCall setAcceptLanguage(String language) {
        if (language != null) {
            this.setHeader("Accept-Language", language);
        }
        return this;
    }

    public RestCall setAccept(String contentType, String charset, String language) {
        return this.setAccept(contentType).setAcceptCharset(charset).setAcceptLanguage(language);
    }

    public RestCall setHeader(String propertyName, String propertyValue) {
        this.headers.put(propertyName, propertyValue);
        return this;
    }

    public RestCall setContentType(String contentType) {
        if (contentType != null) {
            if (contentType.indexOf("charset=") != -1) {
                String[] s = contentType.split(";\\s*charset=");
                return this.setContentType(s[0].trim(), s[1].trim());
            }
            this.contentType = contentType;
        }
        return this;
    }

    public RestCall setCharset(String charset) {
        if (charset != null) {
            this.charset = charset;
        }
        return this;
    }

    public RestCall setContentType(String contentType, String charset) {
        return this.setContentType(contentType).setCharset(charset);
    }

    public RestCall setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public void setParam(String param, Object val) {
        this.params.put(param, val);
    }

    public RestCall setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public void connect() throws RestCallException {
        try {
            String url2;
            this.c = (HttpURLConnection)new URL(this.getUrl()).openConnection();
            if (this.connectTimeout > 0) {
                this.c.setConnectTimeout(this.connectTimeout);
            }
            this.c.setRequestMethod(this.method.toString());
            this.c.setDoOutput(this.method.equals(POST) || this.method.equals(PUT));
            this.c.setDoInput(true);
            this.c.setUseCaches(false);
            this.c.setAllowUserInteraction(false);
            this.c.setInstanceFollowRedirects(false);
            this.c.setRequestProperty("Content-Type", String.valueOf(this.contentType) + ";charset=" + this.charset);
            for (Map.Entry<String, String> rp : this.headers.entrySet()) {
                this.c.setRequestProperty(rp.getKey(), rp.getValue());
            }
            Timer t = null;
            if (this.connectTimeout > 0) {
                t = new Timer();
                t.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (!RestCall.this.connectionMade) {
                            RestCall.this.c.disconnect();
                            RestCall.this.connectionTimedOut = true;
                        }
                    }
                }, new Date(System.currentTimeMillis() + (long)this.connectTimeout));
            }
            this.connectionMade = false;
            this.connectionTimedOut = false;
            if (this.c instanceof HttpsURLConnection) {
                HttpsURLConnection c1 = (HttpsURLConnection)this.c;
                c1.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
            }
            this.c.connect();
            if (t != null) {
                t.cancel();
            }
            this.connectionMade = true;
            if (this.method.equals(POST) || this.method.equals(PUT)) {
                if (this.input instanceof InputStream) {
                    OutputStream os = this.c.getOutputStream();
                    this.pipe((InputStream)this.input, this.c.getOutputStream());
                    os.close();
                } else {
                    OutputStreamWriter writer = new OutputStreamWriter(this.c.getOutputStream(), "UTF-8");
                    Reader r = null;
                    r = this.input instanceof Reader ? (Reader)this.input : (this.serializer == null ? new StringReader(this.input == null ? "" : this.input.toString()) : new StringReader(this.serializer.serialize(this.input)));
                    this.pipe(r, writer);
                    ((Writer)writer).close();
                }
            }
            this.rc = this.c.getResponseCode();
            if (this.rc >= 300 && this.rc < 400 && (url2 = this.c.getHeaderField("location")) != null) {
                ++this.redirectCount;
                if (this.redirectCount > 5) {
                    throw new RestCallException(this.rc, "Redirect too many times", this.method, this.url, "");
                }
                this.url = url2;
                this.method = GET;
                this.connect();
                return;
            }
            if (this.parser == null) {
                Parser parser = this.parser = this.c.getContentType().indexOf("xml") == -1 ? JsonParser.DEFAULT : XmlParser.DEFAULT;
            }
            if (this.rc != 200) {
                throw new RestCallException(this.rc, this.c.getResponseMessage(), this.method, this.url, this.rc == 202 ? "" : this.getString());
            }
        }
        catch (IOException e) {
            if (this.connectionTimedOut) {
                throw new RestCallException(new IOException("Connection timed out."));
            }
            this.rc = 500;
            throw e instanceof RestCallException ? (RestCallException)e : new RestCallException(this.rc, e.getLocalizedMessage(), this.method, this.url, "");
        }
    }

    public Reader getReader() throws IOException {
        if (this.c == null) {
            this.connect();
        }
        String cs = null;
        String ct = this.c.getContentType();
        if (ct != null && ct.indexOf("charset=") != -1) {
            cs = ct.substring(ct.indexOf("charset=") + 8).trim();
        }
        if (cs == null) {
            cs = this.headers.get("Accept-Charset");
        }
        if (cs == null) {
            cs = this.charset;
        }
        return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(this.rc == 200 ? this.c.getInputStream() : this.c.getErrorStream(), this.bufferSize), cs), this.bufferSize);
    }

    public String getString() throws IOException {
        StringBuilder out;
        block8: {
            if (this.c == null) {
                this.connect();
            }
            char[] buf = new char[this.bufferSize];
            out = new StringBuilder();
            int read = 0;
            Reader r = this.getReader();
            try {
                try {
                    while ((read = r.read(buf, 0, buf.length)) >= 0) {
                        out.append(buf, 0, read);
                    }
                }
                catch (IOException iOException) {
                    r.close();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                r.close();
                throw throwable;
            }
            r.close();
        }
        if (out.length() > 2 && (out.charAt(0) == '\'' || out.charAt(0) == '\"')) {
            return out.substring(1, out.length() - 1);
        }
        return out.toString();
    }

    public Integer getInt() throws IOException {
        return JsonUtils.toInt(this.getObject(), null);
    }

    public Long getLong() throws IOException {
        return JsonUtils.toLong(this.getObject(), null);
    }

    public Boolean getBoolean() throws IOException {
        return JsonUtils.toBoolean(this.getObject(), null);
    }

    public JsonMap getJsonMap() throws IOException {
        return JsonUtils.toJsonMap(this.getObject(), null);
    }

    public JsonList getJsonList() throws IOException {
        return JsonUtils.toJsonList(this.getObject(), null);
    }

    public Object getObject() throws IOException {
        if (this.c == null) {
            this.connect();
        }
        Reader r = this.getReader();
        Object o = this.parser.parse(r);
        r.close();
        return o;
    }

    public RestCall pipeToWriter(Writer w) throws IOException {
        if (this.c == null) {
            this.connect();
        }
        Reader r = this.getReader();
        this.pipe(r, w);
        r.close();
        return this;
    }

    private void pipe(Reader reader, Writer writer) throws IOException {
        char[] buf = new char[this.bufferSize];
        int read = 0;
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }

    private void pipe(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[this.bufferSize];
        int read = 0;
        while ((read = is.read(buf)) >= 0) {
            os.write(buf, 0, read);
        }
        os.flush();
    }

    public String getUrl() {
        try {
            StringBuilder sb = new StringBuilder();
            boolean needsEncoding = false;
            int i = 0;
            while (i < this.url.length() && !needsEncoding) {
                if (this.url.charAt(i) > '\u007f' || this.url.charAt(i) == ' ') {
                    needsEncoding = true;
                }
                ++i;
            }
            if (needsEncoding) {
                i = 0;
                while (i < this.url.length()) {
                    char c = this.url.charAt(i);
                    if (c == ' ') {
                        sb.append('+');
                    } else if (c > '\u007f') {
                        sb.append(URLEncoder.encode("" + c, "UTF-8"));
                    } else {
                        sb.append(c);
                    }
                    ++i;
                }
            } else {
                sb.append(this.url);
            }
            if (!this.params.isEmpty()) {
                int d = this.url.indexOf(63) == -1 ? 63 : 38;
                for (Map.Entry<String, Object> e : this.params.entrySet()) {
                    sb.append((char)d);
                    d = 38;
                    sb.append(UrlParamSerializer.encodeParamPart(e.getKey().toString()));
                    Object val = e.getValue();
                    if (val == null) continue;
                    sb.append("=");
                    if (val instanceof Map || val instanceof Collection) {
                        sb.append(UrlParamSerializer.encodeParamPart(JsonSerializer.DEFAULT_CONDENSED.serialize(val)));
                        continue;
                    }
                    sb.append(UrlParamSerializer.encodeParamPart(val.toString()));
                }
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public int getResponseCode() {
        return this.rc;
    }

    public Map<String, List<String>> getHeaderFields() throws IOException {
        if (this.c == null) {
            this.connect();
        }
        return this.c.getHeaderFields();
    }

    public String getHeaderField(String fieldName) throws IOException {
        if (this.c == null) {
            this.connect();
        }
        String value = null;
        List<String> values = this.getHeaderFields().get(fieldName);
        if (values != null && values.size() > 0) {
            value = values.get(0);
        }
        return value;
    }
}

