/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.proto;

import java.io.IOException;
import java.io.Reader;

public class PeekableReader
extends Reader {
    public static final int BUFFER_SIZE = 65535;
    private final int blockSize;
    private int[] buffer;
    private final PositionedReader in;
    private final RollingInt iNext;
    private final RollingInt iPeek;
    private final RollingInt iRead;

    public PeekableReader(Reader in, int initBufferSize) {
        this.in = new PositionedReader(in);
        this.blockSize = initBufferSize / 2;
        this.buffer = new int[initBufferSize];
        this.iNext = new RollingInt(0);
        this.iPeek = new RollingInt(0);
        this.iRead = new RollingInt(0);
    }

    public int peek() throws IOException {
        if (this.iPeek.value == this.iNext.value) {
            if (this.iNext.minus(this.iRead) == this.buffer.length - 1) {
                this.expandBuffer();
            }
            this.buffer[((RollingInt)this.iNext).postIncrement()] = this.in.read();
        }
        return this.buffer[this.iPeek.postIncrement()];
    }

    public void unread(int c) {
        if (this.iNext.minus(this.iRead) == this.buffer.length - 1) {
            this.expandBuffer();
        }
        this.iRead.postDecrement();
        this.buffer[((RollingInt)this.iRead).value] = c;
    }

    public void unpeek() throws IOException {
        if (this.iPeek.value == this.iRead.value) {
            throw new IOException("Cannot unpeek past last read point.");
        }
        this.iPeek.postDecrement();
    }

    public void peekReset() {
        this.iPeek.value = this.iRead.value;
    }

    private void fillBuffer() {
        int n3;
        RollingInt n1 = new RollingInt(this.iNext.value);
        int n2 = this.iNext.value + this.blockSize;
        if (n2 >= this.buffer.length) {
            n2 -= this.buffer.length;
        }
        if ((n3 = n2 + this.blockSize) >= this.buffer.length) {
            n3 -= this.buffer.length;
        }
    }

    private void expandBuffer() {
        System.err.println("EXPAND!");
        int blen = this.buffer.length;
        int[] x = new int[blen * 2];
        System.arraycopy(this.buffer, 0, x, 0, this.iRead.value);
        System.arraycopy(this.buffer, this.iRead.value, x, this.iRead.value + blen, blen - this.iRead.value);
        this.buffer = x;
        RollingInt rollingInt = this.iRead;
        rollingInt.value = rollingInt.value + blen;
        if (this.iRead.value <= this.iPeek.value) {
            RollingInt rollingInt2 = this.iPeek;
            rollingInt2.value = rollingInt2.value + blen;
        }
    }

    public String readPeeked() throws IOException {
        return this.read(this.iPeek.minus(this.iRead));
    }

    public String read(int count) throws IOException {
        if (count < 0) {
            count = this.iPeek.minus(this.iRead) + count;
        }
        char[] c = new char[count];
        this.read(c, 0, count);
        return new String(c);
    }

    public void reset(int count) throws IOException {
        count = this.iPeek.minus(this.iRead) + count;
        int i = 0;
        while (i < count) {
            this.read();
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public String readString(int n) throws IOException {
        char[] c = new char[n];
        int i = 0;
        while (i < c.length) {
            c[i] = (char)this.read();
            ++i;
        }
        return new String(c);
    }

    @Override
    public int read() throws IOException {
        int c = this.iRead.value == this.iNext.value ? this.in.read() : this.buffer[this.iRead.postIncrement()];
        this.peekReset();
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int rv = 0;
        if (this.iNext.value != this.iRead.value) {
            while (this.iNext.value != this.iRead.value && len > 0) {
                cbuf[off++] = (char)this.buffer[this.iRead.postIncrement()];
                --len;
                ++rv;
            }
            rv += this.in.read(cbuf, off, len);
        } else {
            rv = this.in.read(cbuf, off, len);
        }
        this.peekReset();
        return rv;
    }

    public int getLineNo() {
        return this.in.getLineNo();
    }

    public int getColumnNo() {
        return this.in.getColumnNo();
    }

    public class PositionedReader
    extends Reader {
        private int lineNo;
        private int columnNo;
        private final Reader in;

        public PositionedReader(Reader in) {
            this.in = in;
            this.columnNo = 0;
            this.lineNo = 1;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public int getColumnNo() {
            return this.columnNo;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        private void incrementPositions(char c) {
            if (c == '\n') {
                ++this.lineNo;
                this.columnNo = 0;
            } else {
                ++this.columnNo;
            }
        }

        @Override
        public int read() throws IOException {
            int c = this.in.read();
            this.incrementPositions((char)c);
            return c;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int rv = this.in.read(cbuf, off, len);
            int i = 0;
            while (i < rv) {
                this.incrementPositions(cbuf[i + off]);
                ++i;
            }
            return rv;
        }

        public String toString() {
            return "lineNo[" + this.lineNo + "] columnNo[" + this.columnNo + "]";
        }
    }

    class RollingInt {
        private int value = 0;

        public RollingInt(int value) {
            this.add(value);
        }

        private void add(int i) {
            if (i == 0) {
                return;
            }
            this.value += i;
            if (this.value >= PeekableReader.this.buffer.length) {
                this.value -= PeekableReader.this.buffer.length;
            }
        }

        private int minus(RollingInt i2) {
            if (this.value >= i2.value) {
                return this.value - i2.value;
            }
            return this.value + PeekableReader.this.buffer.length - i2.value;
        }

        private int postDecrement() {
            int v = this.value--;
            if (this.value == -1) {
                this.value = PeekableReader.this.buffer.length - 1;
            }
            return v;
        }

        private int postIncrement() {
            int v = this.value++;
            if (this.value == PeekableReader.this.buffer.length) {
                this.value = 0;
            }
            return v;
        }

        public String toString() {
            return "value[" + this.value + "]";
        }
    }
}

