/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.proto;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.ParseException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.proto.PeekableReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class JsonParser2 {
    private static final int ARRAY_S0 = 0;
    private static final int ARRAY_S1 = 1;
    private static final int ARRAY_S2 = 2;
    private static final int BUFFER_SIZE = 65535;
    private static final int MAP_S0 = 0;
    private static final int MAP_S1 = 1;
    private static final int MAP_S2 = 2;
    private static final int MAP_S3 = 3;
    private static final int MAP_S4 = 4;

    private JsonParser2() {
    }

    public static Object parse(CharSequence s) throws ParseException {
        try {
            return JsonParser2.parse(new StringReader(s.toString()));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static Object parse(Reader r) throws ParseException, IOException {
        PeekableReader pr = r instanceof PeekableReader ? (PeekableReader)r : new PeekableReader(r, 65535);
        Object o = JsonParser2.parseAnything(pr);
        JsonParser2.skipCommentsAndSpace(pr);
        JsonParser2.validateEnd(pr);
        return o;
    }

    public static boolean parseInto(PeekableReader r, Object o) throws ParseException, IOException {
        JsonParser2.skipCommentsAndSpace(r);
        r.peekReset();
        if (o instanceof JsonMap) {
            JsonParser2.parseMap((JsonMap)o, r);
        } else if (o instanceof JsonList) {
            JsonParser2.parseArray((JsonList)o, r);
        }
        JsonParser2.skipCommentsAndSpace(r);
        int c = r.peek();
        r.peekReset();
        return c != -1;
    }

    private static void validateEnd(PeekableReader r) throws ParseException, IOException {
        if (r.read() != -1) {
            throw new ParseException(r.getLineNo(), r.getColumnNo(), "Remainder after parse.");
        }
    }

    private static Object parseAnything(PeekableReader r) throws ParseException, IOException {
        r.peekReset();
        int c = r.peek();
        r.peekReset();
        if (c == -1) {
            return null;
        }
        if (c == 123) {
            return JsonParser2.parseObject(r);
        }
        if (c == 91) {
            return JsonParser2.parseArray(new JsonList(), r);
        }
        if (c == 39 || c == 34) {
            return JsonParser2.parseString(r);
        }
        if (c >= 48 && c <= 57 || c == 45) {
            return JsonParser2.parseNumber(r);
        }
        if (c == 102 || c == 110 || c == 116) {
            return JsonParser2.parseKeyword(r);
        }
        if (c == 47 || Character.isWhitespace(c)) {
            JsonParser2.skipCommentsAndSpace(r);
            return JsonParser2.parseAnything(r);
        }
        throw new ParseException(r.getLineNo(), r.getColumnNo(), "Unrecognized syntax");
    }

    private static Object parseKeyword(PeekableReader r) throws ParseException, IOException {
        int c = r.peek();
        int count = c == 102 ? 5 : 4;
        String s = r.readString(count);
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        if (s.equals("false")) {
            return Boolean.FALSE;
        }
        if (s.equals("null")) {
            return null;
        }
        throw new ParseException(r.getLineNo(), r.getColumnNo(), "Unrecognized syntax.");
    }

    private static void skipCommentsAndSpace(PeekableReader r) throws IOException {
        int c;
        while ((c = r.peek()) != -1) {
            if (Character.isWhitespace(c)) continue;
            if (c == 47) {
                r.reset(-1);
                JsonParser2.skipComments(r);
                continue;
            }
            r.reset(-1);
            return;
        }
        r.reset(0);
    }

    private static void skipComments(PeekableReader r) throws IOException {
        block3: {
            int c;
            block2: {
                r.read();
                c = r.read();
                if (c != 42) break block2;
                while ((c = r.read()) != -1) {
                    if (c != 42 || r.read() != 47) continue;
                    return;
                }
                break block3;
            }
            if (c != 47) break block3;
            while ((c = r.read()) != -1) {
                if (r.read() != 10) continue;
                return;
            }
        }
        throw new ParseException(r.getLineNo(), r.getColumnNo(), "Unrecognized syntax");
    }

    private static Number parseNumber(PeekableReader r) throws IOException {
        boolean isDouble = false;
        boolean isHex = false;
        boolean isInt = false;
        int c = r.peek();
        if (c == 45) {
            c = r.peek();
        }
        if (c != 48) {
            isInt = true;
        }
        while ((c = r.peek()) != -1) {
            if (c == 120 || c == 88) {
                isHex = true;
                continue;
            }
            if (c == 46) {
                isDouble = true;
                continue;
            }
            if (!(c >= 48 && c <= 57 || isHex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) && (!isDouble || c != 101 && c != 69 && c != 43 && c != 45)) break;
        }
        String s = r.read(-1);
        Number o = null;
        if (isDouble) {
            o = Double.valueOf(s);
        } else if (isHex) {
            s = s.charAt(0) == '-' ? String.valueOf('-') + s.substring(3) : s.substring(2);
            o = s.length() > 7 ? (Number)Long.valueOf(s, 16) : (Number)Integer.valueOf(s, 16);
        } else {
            o = isInt ? (Number)(s.length() > 8 ? (Number)Long.valueOf(s, 10) : (Number)Integer.valueOf(s, 10)) : (Number)(s.length() > 9 ? (Number)Long.valueOf(s, 8) : (Number)Integer.valueOf(s, 8));
        }
        return o;
    }

    private static String parseString(PeekableReader r) throws ParseException, IOException {
        int c;
        int qc = r.read();
        String s = null;
        boolean isInEscape = false;
        boolean hasEscapes = false;
        while ((c = r.peek()) != -1 && s == null) {
            if (c == 92) {
                isInEscape = !isInEscape;
                hasEscapes = true;
                continue;
            }
            if (!isInEscape && c == qc) {
                s = r.read(-1);
                continue;
            }
            isInEscape = false;
        }
        if (s == null) {
            throw new ParseException(r.getLineNo(), r.getColumnNo(), "Could not find expected end character [" + qc + "].");
        }
        r.read();
        if (hasEscapes) {
            s = JsonUtils.unEscapeChars(s, new char[]{'\'', '\"'});
        }
        while ((c = r.peek()) != -1) {
            if (c == 43) {
                r.readPeeked();
                while ((c = r.peek()) != -1) {
                    if (c == 34 || c == 39) {
                        r.reset(-1);
                        return String.valueOf(s) + JsonParser2.parseString(r);
                    }
                    if (c == 47) {
                        r.reset(-1);
                        JsonParser2.skipCommentsAndSpace(r);
                        continue;
                    }
                    if (Character.isWhitespace(c)) continue;
                    throw new ParseException(r.getLineNo(), r.getColumnNo(), "Expected [\"] or ['] following [+].  c=[" + c + "]");
                }
                continue;
            }
            if (c == 47) {
                r.reset(-1);
                JsonParser2.skipCommentsAndSpace(r);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            r.peekReset();
            break;
        }
        return s;
    }

    private static JsonList parseArray(JsonList jsonList, PeekableReader r) throws IOException {
        int c;
        int state = 0;
        block8: while ((c = r.peek()) != -1) {
            switch (state) {
                case 0: {
                    if (c != 91) continue block8;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 93) {
                        return jsonList;
                    }
                    if (c == 47) {
                        r.reset(-1);
                        JsonParser2.skipCommentsAndSpace(r);
                        break;
                    }
                    if (Character.isWhitespace(c)) continue block8;
                    r.reset(-1);
                    jsonList.add(JsonParser2.parseAnything(r));
                    state = 2;
                    break;
                }
                default: {
                    if (c == 44) {
                        state = 1;
                        break;
                    }
                    if (c == 47) {
                        r.reset(-1);
                        JsonParser2.skipCommentsAndSpace(r);
                        break;
                    }
                    if (c != 93) continue block8;
                    r.reset(0);
                    return jsonList;
                }
            }
        }
        switch (state) {
            case 0: {
                throw new ParseException(r.getLineNo(), r.getColumnNo(), "Expected '[' at beginning of JSON array.");
            }
            case 1: {
                throw new ParseException(r.getLineNo(), r.getColumnNo(), "Expected one of the following characters: {,[,',\",LITERAL.");
            }
        }
        throw new ParseException(r.getLineNo(), r.getColumnNo(), "Expected ',' or ']'.");
    }

    private static String parseFieldName(PeekableReader r) throws IOException {
        int quoteChar;
        r.peekReset();
        int c = r.peek();
        int n = quoteChar = c == 39 || c == 34 ? c : 0;
        if (quoteChar == 0) {
            while ((c = r.peek()) != -1) {
                if (c != 58 && !Character.isWhitespace(c) && c != 47) continue;
                return r.read(-1).intern();
            }
        } else {
            boolean isInEscape = false;
            r.read();
            while ((c = r.peek()) != -1) {
                if (c == 92) {
                    isInEscape = !isInEscape;
                    continue;
                }
                if (c != quoteChar || isInEscape) continue;
                String s = r.read(-1).intern();
                r.read();
                return s;
            }
        }
        throw new ParseException(r.getLineNo(), r.getColumnNo(), "Couldn't find the end of the field name.");
    }

    private static Object parseObject(PeekableReader r) throws IOException {
        JsonMap m = JsonParser2.parseMap(new JsonMap(), r);
        if (m.containsKey("_class")) {
            try {
                return BeanMapFactory.DEFAULT.newInstance(Class.forName((String)m.get("_class")), m).getBean();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return m;
    }

    private static JsonMap parseMap(JsonMap jsonMap, PeekableReader r) throws IOException {
        int c;
        int state = 0;
        String currAttr = null;
        block12: while ((c = r.peek()) != -1) {
            switch (state) {
                case 0: {
                    if (c != 123) continue block12;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 125) {
                        return jsonMap;
                    }
                    if (c == 47) {
                        r.reset(-1);
                        JsonParser2.skipCommentsAndSpace(r);
                        break;
                    }
                    if (Character.isWhitespace(c)) continue block12;
                    r.reset(-1);
                    currAttr = JsonParser2.parseFieldName(r);
                    state = 2;
                    break;
                }
                case 2: {
                    if (c != 58) continue block12;
                    state = 3;
                    break;
                }
                case 3: {
                    if (c == 47) {
                        r.reset(-1);
                        JsonParser2.skipCommentsAndSpace(r);
                        break;
                    }
                    if (Character.isWhitespace(c)) continue block12;
                    r.reset(-1);
                    jsonMap.put(currAttr, JsonParser2.parseAnything(r));
                    state = 4;
                    break;
                }
                default: {
                    if (c == 44) {
                        state = 1;
                        break;
                    }
                    if (c == 47) {
                        r.reset(-1);
                        JsonParser2.skipCommentsAndSpace(r);
                        break;
                    }
                    if (c != 125) continue block12;
                    r.reset(0);
                    return jsonMap;
                }
            }
        }
        switch (state) {
            case 0: {
                throw new ParseException(r.getLineNo(), r.getColumnNo(), "Expected '{' at beginning of JSON object.");
            }
            case 1: {
                throw new ParseException(r.getLineNo(), r.getColumnNo(), "Could not find attribute name on JSON object.");
            }
            case 2: {
                throw new ParseException(r.getLineNo(), r.getColumnNo(), "Could not find ':' following attribute name on JSON object.");
            }
            case 3: {
                throw new ParseException(r.getLineNo(), r.getColumnNo(), "Expected one of the following characters: {,[,',\",LITERAL.");
            }
        }
        throw new ParseException(r.getLineNo(), r.getColumnNo(), "Could not find '}' marking end of JSON object.");
    }
}

