/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMeta;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.NotABeanException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class BeanMapFactory
implements Cloneable {
    private static String[] DEFAULT_CLASS_EXCLUDES = new String[]{"java.lang.*", "java.io.*"};
    public static final BeanMapFactory DEFAULT = new BeanMapFactory();
    public static final BeanMapFactory DEFAULT_SAFE = DEFAULT.clone().setThrowNotABeanExceptions(true);
    public static final BeanMapFactory DEFAULT_RECONSTRUCTIBLE = DEFAULT.clone().setAddClassProperty(true);
    boolean requireDefaultConstructor = false;
    boolean requireSerializable = false;
    boolean requireSettersForGetters = false;
    boolean requireSomeProperties = true;
    boolean addClassProperty = false;
    boolean putReturnsOldValue = false;
    boolean throwNotABeanExceptions = false;
    boolean includePublicFieldProperties = true;
    boolean includeGetterProperties = true;
    List<Pattern> excludeClassPatterns = new LinkedList<Pattern>();
    Set<Package> ignorePackages = new HashSet<Package>();
    Set<Class<?>> ignoreClasses = new HashSet<Class<?>>(){
        private static final long serialVersionUID = -9181109227420630395L;
        {
            this.add(Throwable.class);
        }
    };
    private SoftReference<Map<Class<?>, BeanMeta>> metaCache = null;

    public BeanMapFactory() {
        this.setExcludeClassPatterns(DEFAULT_CLASS_EXCLUDES);
    }

    public BeanMapFactory clone() {
        try {
            return (BeanMapFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BeanMapFactory setRequireDefaultConstructor(boolean requireDefaultConstructor) {
        this.requireDefaultConstructor = requireDefaultConstructor;
        return this;
    }

    public BeanMapFactory setRequireSerializable(boolean requireSerializable) {
        this.requireSerializable = requireSerializable;
        return this;
    }

    public BeanMapFactory setRequireSettersForGetters(boolean requireSettersForGetters) {
        this.requireSettersForGetters = requireSettersForGetters;
        return this;
    }

    public BeanMapFactory setRequireSomeProperties(boolean requireSomeProperties) {
        this.requireSomeProperties = requireSomeProperties;
        return this;
    }

    public BeanMapFactory setAddClassProperty(boolean addClassProperty) {
        this.addClassProperty = addClassProperty;
        return this;
    }

    public BeanMapFactory setPutReturnsOldValue(boolean putReturnsOldValue) {
        this.putReturnsOldValue = putReturnsOldValue;
        return this;
    }

    public BeanMapFactory setThrowNotABeanExceptions(boolean throwNotABeanExceptions) {
        this.throwNotABeanExceptions = throwNotABeanExceptions;
        return this;
    }

    public BeanMapFactory setIncludePublicFieldProperties(boolean includePublicFieldProperties) {
        this.includePublicFieldProperties = includePublicFieldProperties;
        return this;
    }

    public BeanMapFactory setIncludeGetterProperties(boolean includeGetterProperties) {
        this.includeGetterProperties = includeGetterProperties;
        return this;
    }

    public BeanMapFactory addExcludeClassPatterns(String ... excludeClassPatterns) {
        String[] stringArray = excludeClassPatterns;
        int n = excludeClassPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.excludeClassPatterns.add(Pattern.compile(s.toString().replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*")));
            ++n2;
        }
        return this;
    }

    public BeanMapFactory setExcludeClassPatterns(String ... excludeClassPatterns) {
        this.excludeClassPatterns.clear();
        return this.addExcludeClassPatterns(excludeClassPatterns);
    }

    public BeanMapFactory addIgnorePackages(String ... packages) {
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            Package p2 = Package.getPackage(p);
            if (p2 != null) {
                this.ignorePackages.add(p2);
            }
            ++n2;
        }
        return this;
    }

    public BeanMapFactory addIgnoreClasses(String ... classes) {
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            try {
                this.addIgnoreClasses(Class.forName(c));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return this;
    }

    public BeanMapFactory addIgnoreClasses(Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c != null) {
                this.ignoreClasses.add(c);
            }
            ++n2;
        }
        return this;
    }

    protected boolean isIgnoredClass(Class<?> c) {
        String className = c.getName();
        for (Pattern p : this.excludeClassPatterns) {
            if (!p.matcher(className).matches()) continue;
            return true;
        }
        Class<?> c2 = c;
        do {
            Package p;
            if (this.ignorePackages.contains(p = c2.getPackage())) {
                return true;
            }
            if (!this.ignoreClasses.contains(c2)) continue;
            return true;
        } while ((c2 = c2.getSuperclass()) != null);
        return false;
    }

    public BeanMap forBean(Object o) {
        return this.forBean(o, o.getClass());
    }

    public boolean isBean(Object o) {
        return this.forBean(o, o.getClass()) != null;
    }

    public BeanMap forBean(Object o, Class<?> c) {
        if (o == null || c == null) {
            throw new NullPointerException("Neither the specified object nor class may be null.  class=[ " + c + " ], object=[ " + o + " ]");
        }
        if (!c.isInstance(o)) {
            throw new IllegalArgumentException("The specified object is not an instance of the specified class.  class=[ " + c.getName() + " ], objectClass=[ " + o.getClass().getName() + " ], object=[ " + o + " ]");
        }
        BeanMeta m = this.getBeanMeta(c);
        if (m == null) {
            return null;
        }
        return new BeanMap(o, m);
    }

    public BeanMap newInstance(Class<?> c) throws Exception {
        return this.newInstance(c, (Map)null);
    }

    public BeanMap newInstance(Class<?> c, String initProperties) throws Exception {
        return this.newInstance(c, new JsonMap(initProperties));
    }

    public BeanMap newInstance(Class<?> c, Map initProperties) throws Exception {
        BeanMeta m = this.getBeanMeta(c);
        if (m == null) {
            return null;
        }
        Object o = null;
        if (c.isInterface()) {
            o = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{c, Serializable.class}, (InvocationHandler)new BeanHandler(m));
        } else {
            if (m.defaultConstructor == null) {
                if (this.throwNotABeanExceptions) {
                    throw new NotABeanException("Class does not have a no-arg constructor.");
                }
                return null;
            }
            o = m.defaultConstructor.newInstance(null);
        }
        BeanMap b = new BeanMap(o, m);
        if (initProperties != null) {
            b.putAll(initProperties);
        }
        return b;
    }

    private synchronized BeanMeta getBeanMeta(Class<?> c) {
        Map<Class<?>, BeanMeta> cacheMap;
        if (this.metaCache == null || this.metaCache.get() == null) {
            this.metaCache = new SoftReference(new HashMap());
        }
        if (!(cacheMap = this.metaCache.get()).containsKey(c)) {
            try {
                cacheMap.put(c, new BeanMeta(c, this));
            }
            catch (NotABeanException e) {
                if (this.throwNotABeanExceptions) {
                    throw e;
                }
                cacheMap.put(c, null);
            }
        }
        return cacheMap.get(c);
    }

    private static class BeanHandler
    implements InvocationHandler {
        private final BeanMeta meta;
        private final Map<String, Object> beanProps;

        public BeanHandler(BeanMeta meta) {
            this.meta = meta;
            this.beanProps = new HashMap<String, Object>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (method.getName().equals("equals") && paramTypes.length == 1 && paramTypes[0] == Object.class) {
                InvocationHandler ih;
                Object arg = args[0];
                if (arg == null) {
                    return Boolean.FALSE;
                }
                if (proxy == arg) {
                    return Boolean.TRUE;
                }
                if (proxy.getClass() == arg.getClass() && (ih = Proxy.getInvocationHandler(arg)) instanceof BeanHandler) {
                    return this.beanProps.equals(((BeanHandler)ih).beanProps) ? Boolean.TRUE : Boolean.FALSE;
                }
                BeanMap bean = this.meta.factory.forBean(arg);
                return this.beanProps.equals(bean) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode") && paramTypes.length == 0) {
                return new Integer(this.beanProps.hashCode());
            }
            if (method.getName().equals("toString") && paramTypes.length == 0) {
                return this.beanProps.toString();
            }
            String prop = this.meta.getterProps.get(method);
            if (prop != null) {
                return this.beanProps.get(prop);
            }
            prop = this.meta.setterProps.get(method);
            if (prop != null) {
                this.beanProps.put(prop, args[0]);
                return null;
            }
            throw new UnsupportedOperationException("Unsupported bean method.  method=[ " + method + " ]");
        }
    }
}

