/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.PojoRest;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Serializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class XmlSerializer
extends Serializer {
    public static final XmlSerializer DEFAULT = new XmlSerializer();
    private boolean useIndentation = true;
    private boolean renderTypeAttrs = true;
    private boolean enumsAsStrings = true;
    private boolean trimNulls = false;
    private char quoteChar = (char)39;
    private String namespace = "";
    private String rootElementName;
    private DateFormat dateFormat;
    private final BeanMapFactory beanMapFactory = BeanMapFactory.DEFAULT;

    public XmlSerializer clone() {
        try {
            return (XmlSerializer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public XmlSerializer setQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public XmlSerializer setUseIndentation(boolean useIndentation) {
        this.useIndentation = useIndentation;
        return this;
    }

    public XmlSerializer setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public XmlSerializer setRenderTypeAttrs(boolean renderTypeAttrs) {
        this.renderTypeAttrs = renderTypeAttrs;
        return this;
    }

    public XmlSerializer setEnumsAsStrings(boolean enumsAsStrings) {
        this.enumsAsStrings = enumsAsStrings;
        return this;
    }

    public XmlSerializer setTrimNulls(boolean trimNulls) {
        this.trimNulls = trimNulls;
        return this;
    }

    public XmlSerializer setNamespace(String namespace) {
        this.namespace = namespace == null ? "" : String.valueOf(namespace) + ":";
        return this;
    }

    @Override
    public Writer serialize(Writer w, Object o, int depth) throws IOException {
        return this.serialize(w, o, this.rootElementName, depth);
    }

    public Writer serialize(Writer out, Object o, String elementName, int depth) throws IOException {
        if (o instanceof PojoRest) {
            return this.serialize(out, ((PojoRest)o).getRootObject(), elementName, depth);
        }
        elementName = XmlSerializer.encodeName(elementName);
        String type = null;
        if (o == null) {
            type = "null";
        } else if (o instanceof String || this.enumsAsStrings && o instanceof Enum) {
            type = "string";
        } else if (o instanceof Number) {
            type = "number";
        } else if (o instanceof Boolean) {
            type = "boolean";
        } else if (o instanceof Map) {
            type = "object";
        } else if (o instanceof Collection) {
            type = "array";
        } else if (o instanceof Date || o instanceof Calendar) {
            if (o instanceof Calendar) {
                o = ((Calendar)o).getTime();
            }
            String string = type = this.dateFormat == null ? "number" : "string";
            o = this.dateFormat == null ? new Long(((Date)o).getTime()) : this.dateFormat.format((Date)o);
        } else if (o.getClass().isArray()) {
            type = "array";
            o = Arrays.asList((Object[])o);
        } else {
            BeanMap bean = this.beanMapFactory.forBean(o);
            if (bean != null) {
                type = bean.getName() != null ? bean.getName() : "object";
                o = bean;
            } else {
                type = "string";
            }
        }
        if (this.useIndentation && depth > 0) {
            XmlSerializer.cr(out, depth);
        }
        out.write(elementName == null ? "<" + this.namespace + type + ">" : "<" + this.namespace + elementName + (this.renderTypeAttrs ? " type=" + this.quoteChar + type + this.quoteChar : "") + ">");
        if (o != null) {
            if (o instanceof String) {
                out.write(XmlSerializer.toValidXml(o.toString()));
            } else if (o instanceof Number || o instanceof Boolean) {
                out.write(o.toString());
            } else if (o instanceof Map) {
                Map m = (Map)o;
                for (Map.Entry e : m.entrySet()) {
                    if (this.trimNulls && e.getValue() == null) continue;
                    String attr = e.getKey() == null ? "null" : e.getKey().toString();
                    this.serialize(out, e.getValue(), attr, depth + 1);
                }
            } else if (o instanceof Collection) {
                Collection c = (Collection)o;
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    this.serialize(out, i.next(), null, depth + 1);
                }
            } else {
                out.write(XmlSerializer.toValidXml(o.toString()));
            }
        }
        if ((o instanceof Map || o instanceof Collection) && this.useIndentation) {
            XmlSerializer.cr(out, depth);
        }
        out.write(elementName == null ? "</" + this.namespace + type + ">" : "</" + this.namespace + elementName + ">");
        return out;
    }

    private static String encodeName(String s) {
        if (s == null) {
            return null;
        }
        boolean needsConvert = false;
        int i = 0;
        while (i < s.length() && !needsConvert) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '\t' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                needsConvert = true;
            }
            ++i;
        }
        if (needsConvert) {
            StringBuffer sb = new StringBuffer(s.length() + 12);
            int i2 = 0;
            while (i2 < s.length()) {
                char c = s.charAt(i2);
                if (c >= '0' && c <= '\t' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                    sb.append(c);
                } else {
                    sb.append("_x" + XmlSerializer.toPaddedHex(c) + "_");
                }
                ++i2;
            }
            s = sb.toString();
        }
        return s;
    }

    private static String toValidXml(String s) {
        if (s == null) {
            return "null";
        }
        boolean needsConvert = false;
        int i = 0;
        while (i < s.length() && !needsConvert) {
            char c = s.charAt(i);
            needsConvert |= c == '&' || c == '<' || c == '>' || !XmlSerializer.isValidXmlCharacter(c);
            ++i;
        }
        if (!needsConvert) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        int i2 = 0;
        while (i2 < s.length()) {
            char test = s.charAt(i2);
            if (test == '&') {
                sb.append("&amp;");
            } else if (test == '<') {
                sb.append("&lt;");
            } else if (test == '>') {
                sb.append("&gt;");
            } else if (XmlSerializer.isValidXmlCharacter(test)) {
                sb.append(test);
            } else {
                sb.append("?x" + XmlSerializer.toPaddedHex(test));
            }
            ++i2;
        }
        return sb.toString();
    }

    private static boolean isValidXmlCharacter(char c) {
        return c >= ' ' && c <= '\ud7ff' || c == '\n' || c == '\r' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }

    private static String toPaddedHex(int num) {
        char[] n = new char[4];
        int a = num % 16;
        n[3] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        int base = 16;
        int i = 1;
        while (i < 4) {
            a = num / base % 16;
            base <<= 4;
            n[3 - i] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
            ++i;
        }
        return new String(n);
    }
}

