/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.ParseException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Parser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlParser
extends Parser {
    public static final XmlParser DEFAULT = new XmlParser();
    private static final int OBJECT = 1;
    private static final int ARRAY = 2;
    private static final int STRING = 3;
    private static final int NUMBER = 4;
    private static final int BOOLEAN = 5;
    private static final Map<String, Integer> types = new HashMap<String, Integer>();

    static {
        types.put("object", 1);
        types.put("array", 2);
        types.put("string", 3);
        types.put("number", 4);
        types.put("boolean", 5);
        types.put("null", 6);
    }

    public XmlParser clone() {
        try {
            return (XmlParser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object parse(Reader r, long length) throws ParseException, IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource(r);
            return this.parseElement(builder.parse(is).getDocumentElement());
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    protected void parseInto(Reader r, long length, Object o) throws ParseException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource(r);
            Element root = builder.parse(is).getDocumentElement();
            if (o instanceof Map) {
                ((Map)o).putAll((Map)this.parseElement(root));
            } else if (o instanceof List) {
                ((List)o).addAll((List)this.parseElement(root));
            }
        }
        catch (ClassCastException e) {
            throw new ParseException("", 0, "Parsed XML did not conform to the data type [" + o.getClass().getName() + "]");
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException("", 0, "Document was not valid XML.");
        }
    }

    public Object parseElement(Element e) {
        int type = this.getJsonType(e);
        if (type == 1) {
            JsonMap<String, Object> m = new JsonMap<String, Object>();
            NodeList nl = e.getChildNodes();
            int i22 = 0;
            while (i22 < nl.getLength()) {
                Node n = nl.item(i22);
                if (n.getNodeType() == 1) {
                    m.put(this.getJsonAttrName((Element)n), this.parseElement((Element)n));
                }
                ++i22;
            }
            try {
                if (m.containsKey("_class")) {
                    return BeanMapFactory.DEFAULT.newInstance(Class.forName((String)m.get("_class")), m).getBean();
                }
            }
            catch (Exception i22) {
                // empty catch block
            }
            return m;
        }
        if (type == 2) {
            JsonList<Object> l = new JsonList<Object>();
            NodeList nl = e.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n.getNodeType() == 1) {
                    l.add(this.parseElement((Element)n));
                }
                ++i;
            }
            return l;
        }
        if (type == 3) {
            return this.getTextContent(e);
        }
        if (type == 4) {
            return JsonParser.parseNumber(this.getTextContent(e), new JsonParser.MutableInt(0));
        }
        if (type == 5) {
            return new Boolean(this.getTextContent(e).charAt(0) == 't');
        }
        return null;
    }

    private String getTextContent(Element e) {
        NodeList nl = e.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 3) {
                return ((Text)n).getNodeValue();
            }
            ++i;
        }
        return "";
    }

    private int getJsonType(Element e) {
        return e.hasAttribute("type") ? types.get(e.getAttribute("type")).intValue() : types.get(e.getNodeName()).intValue();
    }

    private String getJsonAttrName(Element e) {
        String n = e.getNodeName();
        return types.get(n) == null ? this.decodeName(n) : null;
    }

    private String decodeName(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(95) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '_' && i < s.length() - 1 && s.charAt(i + 1) == 'x') {
                sb.append((char)Integer.parseInt(s.substring(i + 2, i + 6), 16));
                i += 6;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

