/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonSerializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Serializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Map;

public class UrlParamSerializer
extends Serializer {
    public static final UrlParamSerializer DEFAULT = new UrlParamSerializer();
    public static final UrlParamSerializer DEFAULT_LAX = new UrlParamSerializer();
    private boolean trimNulls = false;
    private Serializer valueSerializer = new JsonSerializer().setUseWhitespace(false).setUseIndentation(false).setQuoteChar('\'');
    private BeanMapFactory beanMapFactory = BeanMapFactory.DEFAULT;

    public UrlParamSerializer clone() {
        try {
            return (UrlParamSerializer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public UrlParamSerializer setTrimNulls(boolean trimNulls) {
        this.trimNulls = trimNulls;
        return this;
    }

    public UrlParamSerializer setValueSerializer(Serializer valueSerializer) {
        this.valueSerializer = valueSerializer;
        return this;
    }

    public UrlParamSerializer setBeanMapFactory(BeanMapFactory beanMapFactory) {
        this.beanMapFactory = beanMapFactory;
        return this;
    }

    @Override
    public Writer serialize(Writer w, Object o, int depth) throws IOException {
        if (o == null) {
            return w;
        }
        Map m = o instanceof Map ? (Map)o : this.beanMapFactory.forBean(o);
        int d = 63;
        for (Map.Entry e : m.entrySet()) {
            Object val = e.getValue();
            if (val == null && this.trimNulls) continue;
            w.write(d);
            d = 38;
            w.write(UrlParamSerializer.encodeParamPart(e.getKey().toString()));
            w.write("=");
            w.write(UrlParamSerializer.encodeParamPart(this.valueSerializer.serialize(val)));
        }
        return w;
    }

    public static String encodeParamPart(String s) {
        block11: {
            if (s != null) break block11;
            return null;
        }
        try {
            boolean needsReplace = false;
            int i = 0;
            while (i < s.length() && !needsReplace) {
                char c = s.charAt(i);
                if (c == ' ' || c == '&' || c == '?' || c == '=' || c > '\u007f') {
                    needsReplace = true;
                }
                ++i;
            }
            if (!needsReplace) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < s.length()) {
                char c = s.charAt(i2);
                if (c == ' ') {
                    sb.append("+");
                } else if (c == '&' || c == '?' || c == '=' || c > '\u007f') {
                    sb.append(URLEncoder.encode("" + c, "UTF-8"));
                } else {
                    sb.append(c);
                }
                ++i2;
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s;
        }
    }
}

