/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.ParseException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Parser;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;

public class UrlParamParser
extends Parser {
    public static UrlParamParser DEFAULT = new UrlParamParser();
    private int bufferSize = 8096;

    public UrlParamParser clone() {
        try {
            return (UrlParamParser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public UrlParamParser setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    @Override
    public JsonMap parse(CharSequence cs) throws ParseException {
        return this.parseInto(cs, new JsonMap());
    }

    @Override
    public Object parse(Reader r, long length) throws ParseException, IOException {
        return this.parseInto(JsonUtils.read(r, 0L, this.bufferSize), new JsonMap());
    }

    protected JsonMap parseInto(CharSequence cs, JsonMap m) throws ParseException {
        try {
            String s;
            if (cs == null || cs.length() == 0) {
                return m;
            }
            String string = s = cs instanceof String ? (String)cs : cs.toString();
            if (s.indexOf(63) != -1) {
                s = s.substring(s.indexOf(63) + 1);
            }
            int S1 = 1;
            int S2 = 2;
            int i1 = 0;
            int state = S1;
            String paramName = null;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (state == S1) {
                    if (c == '=') {
                        paramName = URLDecoder.decode(s.substring(i1, i), "UTF-8");
                        i1 = i + 1;
                        state = S2;
                    } else if (c == '&') {
                        paramName = URLDecoder.decode(s.substring(i1, i), "UTF-8");
                        i1 = i + 1;
                        m.put(paramName, null);
                        state = S1;
                    }
                } else if (state == S2 && c == '&') {
                    String val = URLDecoder.decode(s.substring(i1, i), "UTF-8");
                    m.put(paramName, this.interpretValue(val));
                    state = S1;
                    i1 = i + 1;
                }
                ++i;
            }
            if (state == S1 && i1 < s.length()) {
                m.put(URLDecoder.decode(s.substring(i1, s.length()), "UTF-8"), null);
            } else if (state == S2) {
                String val = URLDecoder.decode(s.substring(i1, s.length()), "UTF-8");
                m.put(paramName, this.interpretValue(val));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return m;
    }

    private Object interpretValue(String s) {
        char c2;
        char c = c2 = s.length() == 0 ? (char)'\u0000' : s.charAt(0);
        if (c2 == '{' || c2 == '[' || c2 == '\'') {
            return JsonParser.DEFAULT.parse(s);
        }
        if (s.equals("true") || s.equals("false")) {
            return Boolean.valueOf(s);
        }
        if (s.equals("null")) {
            return null;
        }
        if (this.isNumeric(s)) {
            BigInteger bigInt = BigInteger.valueOf(Long.valueOf(s));
            return bigInt;
        }
        return s;
    }

    private boolean isNumeric(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        int i = c[0] == '-' ? 1 : 0;
        while (i < c.length) {
            if (c[i] < '0' || c[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void parseInto(CharSequence s, Object o) throws ParseException {
        this.parseInto(s, (JsonMap)o);
    }

    @Override
    protected void parseInto(Reader r, long length, Object o) throws ParseException, IOException {
        this.parseInto(JsonUtils.read(r, length, this.bufferSize), (JsonMap)o);
    }
}

