/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.DataType;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PojoRest {
    private static final int GET = 1;
    private static final int PUT = 2;
    private static final int POST = 3;
    private static final int DELETE = 4;
    private final BeanMapFactory beanMapFactory;
    private JsonNode root;

    public PojoRest(Object o) {
        this(o, BeanMapFactory.DEFAULT);
    }

    public PojoRest(Object o, BeanMapFactory beanMapFactory) {
        this.beanMapFactory = beanMapFactory;
        this.root = JsonNode.newInstance(o, this.beanMapFactory);
    }

    public Object getRootObject() {
        return this.root == null ? null : this.root.innerObject;
    }

    public Object get(String url) {
        return this.service(1, url, null);
    }

    public String getString(String url) {
        return JsonUtils.toString(this.get(url), null);
    }

    public String getString(String url, String defVal) {
        return JsonUtils.toString(this.get(url), defVal);
    }

    public Integer getInt(String url) {
        return JsonUtils.toInt(this.get(url), null);
    }

    public Integer getInt(String url, Integer defVal) {
        return JsonUtils.toInt(this.get(url), defVal);
    }

    public Long getLong(String url) {
        return JsonUtils.toLong(this.get(url), null);
    }

    public Long getLong(String url, Long defVal) {
        return JsonUtils.toLong(this.get(url), defVal);
    }

    public Boolean getBoolean(String url) {
        return JsonUtils.toBoolean(this.get(url), null);
    }

    public Boolean getBoolean(String url, Boolean defVal) {
        return JsonUtils.toBoolean(this.get(url), defVal);
    }

    public Map<?, ?> getMap(String url) {
        return JsonUtils.toMap(this.get(url), null);
    }

    public Map<?, ?> getMap(String url, Map<?, ?> def) {
        return JsonUtils.toMap(this.get(url), def);
    }

    public List<?> getList(String url) {
        return JsonUtils.toList(this.get(url), null);
    }

    public List<?> getList(String url, List<?> def) {
        return JsonUtils.toList(this.get(url), def);
    }

    public JsonMap<?, ?> getJsonMap(String url) {
        return JsonUtils.toJsonMap(this.get(url), null);
    }

    public JsonMap<?, ?> getJsonMap(String url, JsonMap<?, ?> def) {
        return JsonUtils.toJsonMap(this.get(url), def);
    }

    public JsonList<?> getJsonList(String url) {
        return JsonUtils.toJsonList(this.get(url), null);
    }

    public JsonList<?> getJsonList(String url, JsonList<?> def) {
        return JsonUtils.toJsonList(this.get(url), def);
    }

    public DataType getDataType(String url) {
        return JsonUtils.getDataType(this.get(url));
    }

    public Object put(String url, Object val) {
        return this.service(2, url, val);
    }

    public String post(String url, Object val) {
        return (String)this.service(3, url, val);
    }

    public Object delete(String url) {
        return this.service(4, url, null);
    }

    public String toString() {
        return this.root == null ? null : this.root.innerObject.toString();
    }

    private Object service(int method, String url, Object val) {
        String childKey;
        if (this.root == null) {
            return null;
        }
        if (url == null) {
            url = "";
        }
        if (url.length() > 0 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        if (method == 1) {
            if (url.length() == 0) {
                return this.root.innerObject;
            }
            JsonNode p = this.root.find(url, false);
            return p == null ? null : p.innerObject;
        }
        int i = url.lastIndexOf(47);
        String parentUrl = i == -1 ? null : url.substring(0, i);
        String string = childKey = i == -1 ? url : url.substring(i + 1);
        if (method == 2) {
            if (url.length() == 0) {
                Object o = this.root.innerObject;
                this.root = JsonNode.newInstance(val, this.beanMapFactory);
                return o;
            }
            if (parentUrl == null) {
                return this.root.put(url, val);
            }
            return this.root.find(parentUrl, true).put(childKey, val);
        }
        if (method == 3) {
            if (url.length() == 0) {
                this.root.post(val);
            } else {
                if (parentUrl == null) {
                    return String.valueOf(url) + "/" + this.root.get(url, true).post(val);
                }
                JsonNode p = this.root.find(parentUrl, true);
                if (p.get(childKey, false) == null) {
                    p.put(childKey, new JsonList());
                }
                return String.valueOf(url) + "/" + p.get(childKey, false).post(val);
            }
        }
        if (method == 4) {
            if (url.length() == 0) {
                Object o = this.root.innerObject;
                this.root = JsonNode.newInstance(null, this.beanMapFactory);
                return o;
            }
            if (parentUrl == null) {
                return this.root.delete(url);
            }
            JsonNode p = this.root.find(parentUrl, false);
            return p == null ? null : p.delete(childKey);
        }
        return null;
    }

    private static class JsonArrayNode
    extends JsonNode {
        private Object[] a;

        public JsonArrayNode(Object[] innerObject) {
            this.a = innerObject;
        }

        @Override
        public JsonNode get(String key, boolean doFill) {
            if (key.length() > 0 && key.charAt(0) == '@') {
                String attr = key.substring(1, key.indexOf(61));
                String val = key.substring(key.indexOf(61) + 1);
                Object[] objectArray = this.a;
                int n = this.a.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    Map m = JsonUtils.toMap(o, null);
                    if (m.get(attr).equals(val)) {
                        return JsonNode.newInstance(this, key, m);
                    }
                    ++n2;
                }
                return null;
            }
            int i = this.parseInt(key);
            if (this.a.length <= i && doFill) {
                Object[] a2 = (Object[])Array.newInstance(this.a.getClass().getComponentType(), i);
                System.arraycopy(this.a, 0, a2, 0, this.a.length);
                this.a = a2;
                this.parent.put(this.propertyName.toString(), this.a);
            }
            if (this.a.length <= i) {
                return null;
            }
            return JsonNode.newInstance(this, key, this.a[i]);
        }

        @Override
        public Object put(String key, Object val) {
            int i = this.parseInt(key);
            if (this.a.length <= i) {
                Object[] a2 = (Object[])Array.newInstance(this.a.getClass().getComponentType(), i + 1);
                System.arraycopy(this.a, 0, a2, 0, this.a.length);
                this.a = a2;
            }
            Object old = this.a[i];
            this.a[i] = this.convert(val);
            this.parent.put(this.propertyName.toString(), this.a);
            return old;
        }

        @Override
        public int post(Object val) {
            Object[] a2 = (Object[])Array.newInstance(this.a.getClass().getComponentType(), this.a.length + 1);
            System.arraycopy(this.a, 0, a2, 0, this.a.length);
            this.a = a2;
            this.a[this.a.length - 1] = this.convert(val);
            this.parent.put(this.propertyName.toString(), this.a);
            return this.a.length - 1;
        }

        @Override
        public Object delete(String key) {
            int i = this.parseInt(key);
            Object old = this.a[i];
            Object[] a2 = (Object[])Array.newInstance(this.a.getClass().getComponentType(), this.a.length - 1);
            System.arraycopy(this.a, 0, a2, 0, i);
            System.arraycopy(this.a, i + 1, a2, i, this.a.length - i - 1);
            this.a = a2;
            this.parent.put(this.propertyName.toString(), this.a);
            return old;
        }

        private Object convert(Object o) {
            try {
                Class<?> c = this.a.getClass().getComponentType();
                if (o instanceof Map && !Map.class.isAssignableFrom(c)) {
                    return this.beanMapFactory.newInstance(c, (Map)o).getBean();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            return o;
        }

        private int parseInt(String key) {
            try {
                return Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Cannot address an item in an array with a non-integer key [" + key + "]");
            }
        }
    }

    private static class JsonBeanNode
    extends JsonMapNode {
        public JsonBeanNode(BeanMap innerObject) {
            super(innerObject);
            this.innerObject = innerObject.getBean();
        }
    }

    private static class JsonCollectionNode
    extends JsonNode {
        private final Collection c;

        public JsonCollectionNode(Collection innerObject) {
            this.c = innerObject;
        }

        @Override
        public JsonNode get(String key, boolean doFill) {
            if (key.length() > 0 && key.charAt(0) == '@') {
                String attr = key.substring(1, key.indexOf(61));
                String val = key.substring(key.indexOf(61) + 1);
                for (Object o : this.c) {
                    Map m = JsonUtils.toMap(o, null);
                    if (!m.get(attr).equals(val)) continue;
                    return JsonNode.newInstance(this, key, m);
                }
                return null;
            }
            throw new RuntimeException("Cannot perform GET operation on a Collection that's not a List, since entries are not accessible by index.");
        }

        @Override
        public Object put(String key, Object val) {
            throw new RuntimeException("Cannot perform PUT operation on a Collection that's not a List, since entries are not accessible by index.");
        }

        @Override
        public int post(Object val) {
            this.c.add(val);
            return this.c.size() - 1;
        }

        @Override
        public Object delete(String key) {
            throw new RuntimeException("Cannot perform DELETE operation on a Collection that's not a List, since entries are not accessible by index.");
        }
    }

    private static class JsonListNode
    extends JsonNode {
        private final List l;

        public JsonListNode(List innerObject) {
            this.l = innerObject;
        }

        @Override
        public JsonNode get(String key, boolean doFill) {
            if (key.length() > 0 && key.charAt(0) == '@') {
                String attr = key.substring(1, key.indexOf(61));
                String val = key.substring(key.indexOf(61) + 1);
                for (Object o : this.l) {
                    Map m = JsonUtils.toMap(o, null);
                    if (!m.get(attr).equals(val)) continue;
                    return JsonNode.newInstance(this, key, m);
                }
                return null;
            }
            int i = this.parseInt(key);
            while (this.l.size() <= i && doFill) {
                this.l.add(null);
            }
            if (this.l.size() <= i) {
                return null;
            }
            return JsonNode.newInstance(this, key, this.l.get(i));
        }

        @Override
        public Object put(String key, Object val) {
            int i = this.parseInt(key);
            while (this.l.size() <= i) {
                this.l.add(null);
            }
            return this.l.set(i, val);
        }

        @Override
        public int post(Object val) {
            this.l.add(val);
            return this.l.size() - 1;
        }

        @Override
        public Object delete(String key) {
            int i = this.parseInt(key);
            return this.l.size() <= i ? null : this.l.remove(i);
        }

        private int parseInt(String key) {
            try {
                return Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Cannot address an item in a List with a non-integer key [" + key + "]");
            }
        }
    }

    private static class JsonMapNode
    extends JsonNode {
        private final Map m;

        public JsonMapNode(Map innerObject) {
            this.m = innerObject;
        }

        @Override
        public JsonNode get(String key, boolean doFill) {
            if (doFill && !this.m.containsKey(key)) {
                this.m.put(key, new JsonMap());
            }
            return JsonNode.newInstance(this, key, this.m.get(key));
        }

        @Override
        public Object put(String key, Object val) {
            return this.m.put(key, val);
        }

        @Override
        public int post(Object val) {
            try {
                int i = 0;
                Iterator j = this.m.keySet().iterator();
                while (j.hasNext()) {
                    i = Math.max(i, Integer.parseInt(j.next().toString()));
                }
                this.m.put("" + ++i, val);
                return i;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Cannot perform PUT operation on a Map that doesn't have number keys.");
            }
        }

        @Override
        public Object delete(String key) {
            return this.m.remove(key);
        }
    }

    private static abstract class JsonNode {
        public BeanMapFactory beanMapFactory;
        public JsonNode parent;
        public String propertyName;
        public Object innerObject;

        private JsonNode() {
        }

        public static JsonNode newInstance(Object o, BeanMapFactory beanMapFactory) {
            BeanMap b;
            if (o == null) {
                return null;
            }
            JsonNode n = null;
            n = o instanceof Map ? new JsonMapNode((Map)o) : (o instanceof List ? new JsonListNode((List)o) : (o instanceof Collection ? new JsonCollectionNode((Collection)o) : (o.getClass().isArray() ? new JsonArrayNode((Object[])o) : ((b = beanMapFactory.forBean(o)) != null ? new JsonBeanNode(b) : new JsonOtherNode(o)))));
            n.beanMapFactory = beanMapFactory;
            n.innerObject = o;
            return n;
        }

        public static JsonNode newInstance(JsonNode parent, String propertyName, Object o) {
            if (o == null) {
                return null;
            }
            JsonNode n = JsonNode.newInstance(o, parent.beanMapFactory);
            n.parent = parent;
            n.propertyName = propertyName;
            return n;
        }

        public JsonNode find(String url, boolean doFill) {
            int i;
            int n = i = url == null ? -1 : url.indexOf(47);
            if (i == -1) {
                return this.get(url, doFill);
            }
            String parentKey = url.substring(0, i);
            String childUrl = url.substring(i + 1);
            JsonNode p = this.get(parentKey, doFill);
            return p == null ? null : p.find(childUrl, doFill);
        }

        public abstract JsonNode get(String var1, boolean var2);

        public abstract Object put(String var1, Object var2);

        public abstract int post(Object var1);

        public abstract Object delete(String var1);
    }

    private static class JsonOtherNode
    extends JsonNode {
        public JsonOtherNode(Object innerObject) {
        }

        @Override
        public JsonNode get(String key, boolean doFill) {
            throw new RuntimeException("Cannot perform GET operation on an object of type [" + this.innerObject.getClass().getName() + "].");
        }

        @Override
        public Object put(String key, Object val) {
            throw new RuntimeException("Cannot perform PUT operation on an object of type [" + this.innerObject.getClass().getName() + "].");
        }

        @Override
        public int post(Object val) {
            throw new RuntimeException("Cannot perform POST operation on an object of type [" + this.innerObject.getClass().getName() + "].");
        }

        @Override
        public Object delete(String key) {
            throw new RuntimeException("Cannot perform DELETE operation on an object of type [" + this.innerObject.getClass().getName() + "].");
        }
    }
}

