/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

public class ParseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public ParseException(Exception e) {
        super(e.getLocalizedMessage());
    }

    public ParseException(CharSequence input, int startPos, String errorMsg) {
        this(input, startPos, startPos, errorMsg);
    }

    public ParseException(int lineNumber, int colNumber, String errorMsg) {
        super("Syntax error at line=[" + lineNumber + "], column=[" + colNumber + "], [" + errorMsg + "], ");
    }

    public ParseException(CharSequence input, int startPos, int errorPos, String errorMsg) {
        super("Syntax error at line [" + ParseException.getLineNum(input, errorPos) + "], " + errorMsg + ".\n\tfragment=[" + ParseException.getFragment(input, startPos, errorPos) + "]");
    }

    private static int getLineNum(CharSequence input, int startPos) {
        int lineNum = 1;
        int i = 0;
        while (i < startPos) {
            if (input.charAt(i) == '\n') {
                ++lineNum;
            }
            ++i;
        }
        return lineNum;
    }

    private static CharSequence getFragment(CharSequence input, int startPos, int errorPos) {
        if (input.length() == 0) {
            return "";
        }
        int sp = Math.min(startPos, input.length() - 1);
        int ep = Math.min(startPos == errorPos ? 100 + startPos : errorPos, input.length() - 1);
        return input.subSequence(sp, ep);
    }
}

