/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.DataType;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.InvalidDataConversionException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonSerializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    public static String reformat(String json, JsonSerializer serializer) {
        return serializer.serialize(JsonParser.DEFAULT.parse(json));
    }

    public static Object deepClone(Object o) {
        if (o instanceof Map) {
            JsonMap m = new JsonMap((Map)o);
            for (Map.Entry entry : m.entrySet()) {
                entry.setValue(JsonUtils.deepClone(entry.getValue()));
            }
            return m;
        }
        if (o instanceof List) {
            JsonList<Object> l = new JsonList<Object>();
            Iterator i = ((List)o).iterator();
            while (i.hasNext()) {
                l.add(JsonUtils.deepClone(i.next()));
            }
            return l;
        }
        return o;
    }

    public static String toJsonString(String s, char quoteChar) {
        boolean doConvert = false;
        int i = 0;
        while (i < s.length() && !doConvert) {
            char c = s.charAt(i);
            doConvert |= c == '\n' || c == '\t' || c == '\b' || c == '\f' || c == '\r' || c == '\'' && c == quoteChar || c == '\"' && c == quoteChar || c == '\\';
            ++i;
        }
        if (!doConvert) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        int i2 = 0;
        while (i2 < s.length()) {
            char c = s.charAt(i2);
            if (c == '\n') {
                sb.append('\\').append('n');
            } else if (c == '\t') {
                sb.append('\\').append('t');
            } else if (c == '\b') {
                sb.append('\\').append('b');
            } else if (c == '\f') {
                sb.append('\\').append('f');
            } else if (c == '\'' && c == quoteChar) {
                sb.append('\\').append('\'');
            } else if (c == '\"' && c == quoteChar) {
                sb.append('\\').append('\"');
            } else if (c == '\\') {
                sb.append('\\').append('\\');
            } else if (c != '\r') {
                sb.append(c);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static String toString(Object o, String d) {
        if (o == null) {
            return d;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Number || o instanceof Boolean || o instanceof Enum || o instanceof Date || o instanceof Calendar) {
            return o.toString();
        }
        if (o instanceof Map || o instanceof Collection || o.getClass().isArray() || BeanMapFactory.DEFAULT.isBean(o)) {
            return JsonSerializer.DEFAULT_CONDENSED.serialize(o);
        }
        return o.toString();
    }

    public static Integer toInt(Object o, Integer d) {
        try {
            if (o == null) {
                return d;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o instanceof String) {
                return Integer.parseInt((String)o);
            }
            if (o instanceof Date) {
                return (int)(((Date)o).getTime() / 1000L);
            }
            if (o instanceof Calendar) {
                return (int)(((Calendar)o).getTime().getTime() / 1000L);
            }
            if (o instanceof Map) {
                return ((Map)o).size();
            }
            if (o instanceof Collection) {
                return ((Collection)o).size();
            }
            if (o.getClass().isArray()) {
                return ((Object[])o).length;
            }
            if (o instanceof Enum) {
                return ((Enum)o).ordinal();
            }
            if (BeanMapFactory.DEFAULT.isBean(o)) {
                return BeanMapFactory.DEFAULT.forBean(o).size();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new InvalidDataConversionException(o.getClass(), Integer.class);
    }

    public static Long toLong(Object o, Long d) {
        try {
            if (o == null) {
                return d;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1L : 0L;
            }
            if (o instanceof String) {
                return Long.parseLong((String)o);
            }
            if (o instanceof Date) {
                return ((Date)o).getTime();
            }
            if (o instanceof Calendar) {
                return ((Calendar)o).getTimeInMillis();
            }
            if (o instanceof Map) {
                return ((Map)o).size();
            }
            if (o instanceof Collection) {
                return ((Collection)o).size();
            }
            if (o.getClass().isArray()) {
                return ((Object[])o).length;
            }
            if (o instanceof Enum) {
                return ((Enum)o).ordinal();
            }
            if (BeanMapFactory.DEFAULT.isBean(o)) {
                return BeanMapFactory.DEFAULT.forBean(o).size();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new InvalidDataConversionException(o.getClass(), Long.class);
    }

    public static Boolean toBoolean(Object o, Boolean d) {
        if (o == null) {
            return d;
        }
        if (o instanceof Boolean) {
            return (boolean)((Boolean)o);
        }
        if (o instanceof String) {
            String s = o.toString();
            if (s == null || s.length() == 0) {
                return false;
            }
            char c = s.charAt(0);
            if (c != 'T' && c != 't' && c != 'Y' && c != 'y' && c != '1') {
                return false;
            }
            return true;
        }
        if (o instanceof Number) {
            if (((Number)o).intValue() != 0) {
                return true;
            }
            return false;
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            if (((Object[])o).length != 0) {
                return true;
            }
            return false;
        }
        if (o instanceof Enum) {
            throw new InvalidDataConversionException(o.getClass(), Boolean.class);
        }
        if (BeanMapFactory.DEFAULT.isBean(o)) {
            return !BeanMapFactory.DEFAULT.forBean(o).isEmpty();
        }
        throw new InvalidDataConversionException(o.getClass(), Boolean.class);
    }

    public static Map toMap(Object o, Map d) {
        if (o == null) {
            return d;
        }
        if (o instanceof Map) {
            return (Map)o;
        }
        return JsonUtils.toJsonMap(o, null);
    }

    public static JsonMap toJsonMap(Object o, JsonMap def) {
        if (o == null) {
            return def;
        }
        if (o instanceof JsonMap) {
            return (JsonMap)o;
        }
        if (o instanceof Map) {
            return new JsonMap((Map)o);
        }
        if (o instanceof Collection) {
            JsonMap m = new JsonMap();
            int i = 0;
            for (Object o2 : (Collection)o) {
                m.put(i++, o2);
            }
            return m;
        }
        if (o.getClass().isArray()) {
            JsonMap<Integer, Object> m = new JsonMap<Integer, Object>();
            int i = 0;
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o2 = objectArray[n2];
                m.put(i++, o2);
                ++n2;
            }
            return m;
        }
        if (o instanceof Date) {
            JsonMap<String, Integer> m = new JsonMap<String, Integer>();
            Calendar c = Calendar.getInstance();
            c.setTime((Date)o);
            m.put("y", c.get(1));
            m.put("M", c.get(2));
            m.put("d", c.get(5));
            m.put("H", c.get(11));
            m.put("m", c.get(12));
            m.put("s", c.get(13));
            m.put("S", c.get(14));
            return m;
        }
        if (o instanceof Calendar) {
            JsonMap<String, Integer> m = new JsonMap<String, Integer>();
            Calendar c = (Calendar)o;
            m.put("y", c.get(1));
            m.put("M", c.get(2));
            m.put("d", c.get(5));
            m.put("H", c.get(11));
            m.put("m", c.get(12));
            m.put("s", c.get(13));
            m.put("S", c.get(14));
            return m;
        }
        if (o instanceof Enum) {
            throw new InvalidDataConversionException(o.getClass(), JsonMap.class);
        }
        if (BeanMapFactory.DEFAULT.isBean(o)) {
            return new JsonMap<String, Object>(BeanMapFactory.DEFAULT.forBean(o));
        }
        throw new InvalidDataConversionException(o.getClass(), JsonMap.class);
    }

    public static List toList(Object o, List d) {
        if (o == null) {
            return d;
        }
        if (o instanceof List) {
            return (List)o;
        }
        return JsonUtils.toJsonList(o, null);
    }

    public static JsonList toJsonList(Object o, JsonList d) {
        if (o == null) {
            return d;
        }
        if (o instanceof JsonList) {
            return (JsonList)o;
        }
        if (o instanceof Collection) {
            return new JsonList((Collection)o);
        }
        if (o.getClass().isArray()) {
            return new JsonList<Object>((Object[])o);
        }
        JsonList<Object> l = new JsonList<Object>();
        l.add(o);
        return l;
    }

    public static List[] toListArray(Object[] l) {
        if (l == null) {
            return null;
        }
        if (l instanceof List[]) {
            return (List[])l;
        }
        return JsonUtils.toJsonListArray(l);
    }

    public static JsonList[] toJsonListArray(Object[] l) {
        if (l == null) {
            return null;
        }
        if (l instanceof JsonList[]) {
            return (JsonList[])l;
        }
        JsonList[] l2 = new JsonList[l.length];
        int i = 0;
        while (i < l.length) {
            l2[i] = JsonUtils.toJsonList(l[i], null);
            ++i;
        }
        return l2;
    }

    public static JsonMap[] toJsonMapArray(Object[] l) {
        if (l == null) {
            return null;
        }
        if (l instanceof JsonMap[]) {
            return (JsonMap[])l;
        }
        JsonMap[] l2 = new JsonMap[l.length];
        int i = 0;
        while (i < l.length) {
            l2[i] = JsonUtils.toJsonMap(l[i], null);
            ++i;
        }
        return l2;
    }

    public static Map[] toMapArray(Object[] l) {
        if (l == null) {
            return null;
        }
        if (l instanceof Map[]) {
            return (Map[])l;
        }
        return JsonUtils.toJsonMapArray(l);
    }

    public static Boolean[] toBooleanArray(Object[] o) {
        if (o == null) {
            return null;
        }
        Boolean[] b = new Boolean[o.length];
        int i = 0;
        while (i < o.length) {
            b[i] = JsonUtils.toBoolean(o[i], null);
            ++i;
        }
        return b;
    }

    public static Integer[] toIntArray(Object[] o) {
        if (o == null) {
            return null;
        }
        Integer[] x = new Integer[o.length];
        int i = 0;
        while (i < o.length) {
            x[i] = JsonUtils.toInt(o[i], null);
            ++i;
        }
        return x;
    }

    public static Long[] toLongArray(Object[] o) {
        if (o == null) {
            return null;
        }
        Long[] x = new Long[o.length];
        int i = 0;
        while (i < o.length) {
            x[i] = JsonUtils.toLong(o[i], null);
            ++i;
        }
        return x;
    }

    public static String[] toStringArray(Object[] o) {
        String[] s = new String[o.length];
        int i = 0;
        while (i < o.length) {
            s[i] = JsonUtils.toString(o[i], null);
            ++i;
        }
        return s;
    }

    public static String unEscapeChars(String s, char[] toEscape) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0 || s.indexOf(92) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\' && i + 1 != s.length()) {
                char c2 = s.charAt(i + 1);
                boolean isOneOf = false;
                int j = 0;
                while (j < toEscape.length && !isOneOf) {
                    isOneOf = c2 == toEscape[j];
                    ++j;
                }
                if (isOneOf) {
                    ++i;
                } else if (c2 == '\\') {
                    sb.append('\\');
                    ++i;
                }
            }
            sb.append(s.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    protected static DataType getDataType(Object o) {
        if (o == null) {
            return DataType.NULL;
        }
        if (o instanceof String || o instanceof Enum) {
            return DataType.STRING;
        }
        if (o instanceof Number || o instanceof Date || o instanceof Calendar) {
            return DataType.NUMBER;
        }
        if (o instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (o instanceof Collection || o.getClass().isArray()) {
            return DataType.LIST;
        }
        if (o instanceof Map || BeanMapFactory.DEFAULT.forBean(o) != null) {
            return DataType.MAP;
        }
        return DataType.STRING;
    }

    public static int getInt(String s, int defaultVal) {
        if (!JsonUtils.isNumeric(s)) {
            return defaultVal;
        }
        return Integer.parseInt(s);
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        int i = c[0] == '-' ? 1 : 0;
        while (i < c.length) {
            if (c[i] < '0' || c[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static CharSequence read(Reader r, long length, int bufferSize) throws IOException {
        length = length <= 0L ? (long)bufferSize : length;
        StringBuilder sb = new StringBuilder((int)length);
        if (!(r instanceof BufferedReader)) {
            r = new BufferedReader(r, length <= 0L || length > (long)bufferSize ? bufferSize : (int)length);
        }
        char[] buf = new char[Math.min(bufferSize, (int)length)];
        int i = 0;
        while ((i = r.read(buf)) != -1) {
            sb.append(buf, 0, i);
        }
        return sb;
    }
}

