/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.ParseException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.PojoRest;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Serializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.XmlParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class JsonSerializer
extends Serializer {
    public static final JsonSerializer DEFAULT = new JsonSerializer();
    public static final JsonSerializer DEFAULT_CONDENSED = new JsonSerializer().setUseWhitespace(false).setUseIndentation(false);
    public static final JsonSerializer DEFAULT_STRICT = new JsonSerializer().setStrictMode(true);
    public static final JsonSerializer DEFAULT_STRICT_CONDENSED = new JsonSerializer().setStrictMode(true).setUseWhitespace(false).setUseIndentation(false);
    public static final JsonSerializer DEFAULT_RECONSTRUCTIBLE = new JsonSerializer().setBeanMapFactory(BeanMapFactory.DEFAULT_RECONSTRUCTIBLE);
    private boolean strictMode = false;
    private boolean useWhitespace = true;
    private boolean useIndentation = true;
    private boolean trimNulls = false;
    private boolean enumsAsStrings = true;
    private char quoteChar = (char)34;
    private int maxDepth = 100;
    private DateFormat dateFormat;
    private BeanMapFactory beanMapFactory = BeanMapFactory.DEFAULT;

    public JsonSerializer clone() {
        try {
            return (JsonSerializer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JsonSerializer setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
        return this;
    }

    public JsonSerializer setUseWhitespace(boolean useWhitespace) {
        this.useWhitespace = useWhitespace;
        return this;
    }

    public JsonSerializer setUseIndentation(boolean useIndentation) {
        this.useIndentation = useIndentation;
        return this;
    }

    public JsonSerializer setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public JsonSerializer setTrimNulls(boolean trimNulls) {
        this.trimNulls = trimNulls;
        return this;
    }

    public JsonSerializer setEnumsAsStrings(boolean enumsAsStrings) {
        this.enumsAsStrings = enumsAsStrings;
        return this;
    }

    public JsonSerializer setQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public JsonSerializer setBeanMapFactory(BeanMapFactory beanMapFactory) {
        this.beanMapFactory = beanMapFactory;
        return this;
    }

    public JsonSerializer setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @Override
    public Writer serialize(Writer w, Object o, int indentation) throws IOException {
        this.serializeAnything(w, o, indentation);
        return w;
    }

    public String serializeFromXml(String xml) throws ParseException, ParserConfigurationException, SAXException, IOException {
        return this.serialize(XmlParser.DEFAULT.parse(xml));
    }

    private Writer serializeAnything(Writer w, Object o, int depth) throws IOException {
        if (depth > this.maxDepth) {
            throw new SerializeException("Depth too deep.  Possible recursion.", o);
        }
        try {
            if (o instanceof PojoRest) {
                return this.serializeAnything(w, ((PojoRest)o).getRootObject(), depth);
            }
            if (o == null) {
                w.write("null");
            } else if (o instanceof String || this.enumsAsStrings && o instanceof Enum) {
                w.write(String.valueOf(this.quoteChar) + JsonUtils.toJsonString(o.toString(), this.quoteChar) + this.quoteChar);
            } else if (o instanceof Number || o instanceof Boolean) {
                w.write(o.toString());
            } else if (o instanceof Map) {
                this.serializeMap((Map)o, w, depth);
            } else if (o instanceof Date || o instanceof Calendar) {
                if (o instanceof Calendar) {
                    o = ((Calendar)o).getTime();
                }
                w.write(this.dateFormat == null ? "" + ((Date)o).getTime() : String.valueOf(this.quoteChar) + this.dateFormat.format((Date)o) + this.quoteChar);
            } else if (o instanceof Collection) {
                this.serializeCollection((Collection)o, w, depth);
            } else if (o.getClass().isArray()) {
                this.serializeCollection(Arrays.asList((Object[])o), w, depth);
            } else if (this.beanMapFactory != null) {
                BeanMap bean = this.beanMapFactory.forBean(o);
                if (bean != null) {
                    this.serializeMap(bean, w, depth);
                } else {
                    w.write(String.valueOf(this.quoteChar) + JsonUtils.toJsonString(o.toString(), this.quoteChar) + this.quoteChar);
                }
            } else {
                w.write(String.valueOf(this.quoteChar) + JsonUtils.toJsonString(o.toString(), this.quoteChar) + this.quoteChar);
            }
            return w;
        }
        catch (SerializeException e) {
            e.objectStack.addFirst(o);
            throw e;
        }
        catch (StackOverflowError e) {
            throw new SerializeException("Stack overflow error", o);
        }
        catch (Throwable e) {
            throw new SerializeException(e, o);
        }
    }

    private Writer serializeMap(Map m, Writer out, int depth) throws IOException {
        out.write(123);
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object value = e.getValue();
            if (this.trimNulls && value == null) continue;
            if (this.useIndentation) {
                JsonSerializer.cr(out, depth + 1);
            }
            String attr = e.getKey() == null ? "null" : e.getKey().toString();
            out.write(this.toJsonAttr(attr));
            out.write(58);
            if (this.useWhitespace) {
                out.write(32);
            }
            this.serializeAnything(out, e.getValue(), depth + 1);
            if (!i.hasNext()) continue;
            out.write(44);
            if (!this.useWhitespace) continue;
            out.write(32);
        }
        if (this.useIndentation) {
            JsonSerializer.cr(out, depth);
        }
        out.write(125);
        return out;
    }

    private Writer serializeCollection(Collection c, Writer out, int depth) throws IOException {
        out.write(91);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.useIndentation) {
                JsonSerializer.cr(out, depth + 1);
            }
            this.serializeAnything(out, i.next(), depth + 1);
            if (!i.hasNext()) continue;
            out.write(44);
            if (!this.useWhitespace) continue;
            out.write(32);
        }
        if (this.useIndentation) {
            JsonSerializer.cr(out, depth);
        }
        out.write(93);
        return out;
    }

    private String toJsonAttr(String s) {
        boolean doConvert = this.strictMode;
        int i = 0;
        while (i < s.length() && !doConvert) {
            char c = s.charAt(i);
            doConvert |= !(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_');
            ++i;
        }
        if (!doConvert) {
            return s;
        }
        boolean useQuotes = this.strictMode;
        StringBuffer sb = new StringBuffer(s.length() + 2);
        sb.append(this.quoteChar);
        int i2 = 0;
        while (i2 < s.length()) {
            char c = s.charAt(i2);
            if (c == '\n') {
                sb.append('\\').append('n');
            } else if (c == '\t') {
                sb.append('\\').append('t');
            } else if (c == '\'') {
                sb.append('\\').append('\'');
            } else if (c == '\"') {
                sb.append('\\').append('\"');
            } else if (c != '\r') {
                sb.append(c);
            }
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) {
                useQuotes = true;
            }
            ++i2;
        }
        sb.append(this.quoteChar);
        return useQuotes ? sb.toString() : sb.substring(1, sb.length() - 1);
    }

    private static class SerializeException
    extends RuntimeException {
        protected LinkedList<Object> objectStack = new LinkedList();
        private final String msg;

        public SerializeException(String msg, Object o) {
            this.msg = msg;
            this.objectStack.add(o);
        }

        public SerializeException(Throwable cause, Object o) {
            super(cause);
            this.msg = cause.getMessage();
            this.objectStack.add(o);
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder("Exception in JsonSerializer: [" + this.msg + "].");
            sb.append("\nObject stack:");
            for (Object e : this.objectStack) {
                sb.append("\n\t->" + e.getClass().getName());
            }
            return sb.toString();
        }
    }
}

