/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.ParseException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Parser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import java.io.IOException;
import java.io.Reader;

public class JsonParser
extends Parser {
    public static final JsonParser DEFAULT = new JsonParser();
    private static final int STATE_0 = 0;
    private static final int STATE_1 = 1;
    private static final int STATE_2 = 2;
    private static final int STATE_3 = 3;
    private static final int STATE_4 = 4;
    private static final int STATE_5 = 5;
    private static final int STATE_6 = 6;
    private static final int STATE_7 = 7;
    private int bufferSize = 8096;

    public JsonParser clone() {
        try {
            return (JsonParser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JsonParser setBufferSize(int iSetting) {
        this.bufferSize = iSetting;
        return this;
    }

    @Override
    public Object parse(CharSequence s) throws ParseException {
        MutableInt pos = new MutableInt(0);
        Object o = this.parseAnything(s, pos);
        if (o == null) {
            return null;
        }
        this.validateEnd(s, pos);
        return o;
    }

    @Override
    public Object parse(Reader r, long length) throws ParseException, IOException {
        return this.parse(JsonUtils.read(r, length, this.bufferSize));
    }

    @Override
    protected void parseInto(CharSequence s, Object o) throws ParseException {
        MutableInt pos = new MutableInt(0);
        if (o instanceof JsonMap) {
            this.parseMap((JsonMap)o, s, pos);
        } else if (o instanceof JsonList) {
            this.parseArray((JsonList)o, s, pos);
        }
        this.validateEnd(s, pos);
    }

    @Override
    protected void parseInto(Reader r, long length, Object o) throws ParseException, IOException {
        this.parseInto(JsonUtils.read(r, length, this.bufferSize), o);
    }

    private void validateEnd(CharSequence cs, MutableInt pos) throws ParseException {
        int length = cs.length();
        if (pos.val == length) {
            return;
        }
        this.skipCommentsAndSpace(cs, pos, true);
        if (pos.val < length) {
            throw new ParseException(cs, pos.val, "Remainder after parse.");
        }
    }

    private Object parseAnything(CharSequence cs, MutableInt pos) throws ParseException {
        if (cs == null) {
            return null;
        }
        this.skipCommentsAndSpace(cs, pos, true);
        int length = cs.length();
        if (length == 0 || pos.val >= length) {
            return null;
        }
        char c = cs.charAt(pos.val);
        if (c == '{') {
            return this.parseObject(cs, pos);
        }
        if (c == '[') {
            JsonList list = new JsonList();
            return this.parseArray(list, cs, pos);
        }
        if (c == '\'' || c == '\"') {
            return this.parseString(cs, pos);
        }
        if (c >= '0' && c <= '9' || c == '-') {
            return JsonParser.parseNumber(cs, pos);
        }
        if (c == 't' || c == 'f' || c == 'n') {
            return this.parseKeyword(cs, pos);
        }
        if (c == '/' || Character.isWhitespace(c)) {
            this.skipCommentsAndSpace(cs, pos, true);
            return this.parseAnything(cs, pos);
        }
        throw new ParseException(cs, pos.val, "Unrecognized syntax");
    }

    private Object parseKeyword(CharSequence cs, MutableInt pos) throws ParseException {
        Boolean o;
        try {
            int count = cs.charAt(pos.val) == 'f' ? 5 : 4;
            String s = cs.subSequence(pos.val, pos.val + count).toString();
            if (s.equals("true")) {
                o = Boolean.TRUE;
            } else if (s.equals("false")) {
                o = Boolean.FALSE;
            } else if (s.equals("null")) {
                o = null;
            } else {
                throw new ParseException(cs, pos.val, "Unrecognized syntax.");
            }
            pos.val += count;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException(cs, pos.val, "Unrecognized syntax.");
        }
        return o;
    }

    private void skipCommentsAndSpace(CharSequence cs, MutableInt pos, boolean positionOnNext) {
        int length = cs.length();
        while (pos.val < length) {
            char c = cs.charAt(pos.val);
            if (!Character.isWhitespace(c)) {
                if (c == '/') {
                    this.skipComments(cs, pos);
                } else {
                    if (!positionOnNext) {
                        --pos.val;
                    }
                    return;
                }
            }
            ++pos.val;
        }
    }

    private void skipComments(CharSequence cs, MutableInt pos) {
        block4: {
            int length;
            char c;
            block3: {
                c = cs.charAt(++pos.val);
                length = cs.length();
                if (c != '*') break block3;
                while (pos.val < length) {
                    if (cs.charAt(++pos.val) != '*' || cs.charAt(++pos.val) != '/') continue;
                    return;
                }
                break block4;
            }
            if (c != '/') break block4;
            while (pos.val < length) {
                ++pos.val;
                if (pos.val == length) {
                    return;
                }
                if (cs.charAt(pos.val) != '\n') continue;
                return;
            }
        }
        throw new ParseException(cs, pos.val, "Unrecognized syntax");
    }

    protected static Number parseNumber(CharSequence cs, MutableInt pos) {
        int i = pos.val;
        boolean isInt = false;
        boolean isHex = false;
        boolean isDouble = false;
        if (cs.charAt(i) == '-') {
            ++i;
        }
        if (cs.charAt(i) != '0') {
            isInt = true;
        }
        int length = cs.length();
        while (i < length) {
            char c = cs.charAt(i);
            if (c == 'x' || c == 'X') {
                isHex = true;
            } else if (c == '.') {
                isDouble = true;
            } else if (!(c >= '0' && c <= '9' || isHex && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') || isDouble && (c == 'e' || c == 'E' || c == '+' || c == '-'))) break;
            ++i;
        }
        String s = cs.subSequence(pos.val, i).toString();
        Number o = null;
        if (isDouble) {
            Double d = Double.valueOf(s);
            Float f = Float.valueOf(s);
            o = d.toString().equals(f.toString()) ? (Number)f : (Number)d;
        } else if (isHex) {
            s = cs.charAt(pos.val) == '-' ? String.valueOf('-') + s.substring(3) : s.substring(2);
            o = i - pos.val > 7 ? (Number)Long.valueOf(s, 16) : (Number)Integer.valueOf(s, 16);
        } else {
            Long l;
            o = isInt ? (Number)((l = Long.valueOf(s, 10)) < Integer.MIN_VALUE || l > Integer.MAX_VALUE ? (Number)l : (Number)l.intValue()) : (Number)(i - pos.val > 9 ? (Number)Long.valueOf(s, 8) : (Number)Integer.valueOf(s, 8));
        }
        pos.val = i;
        return o;
    }

    private String parseString(CharSequence cs, MutableInt pos) throws ParseException {
        char c;
        char qc = cs.charAt(pos.val++);
        int i = pos.val;
        String s = null;
        StringBuilder sb = new StringBuilder();
        boolean isInEscape = false;
        int length = cs.length();
        while (pos.val < length && s == null) {
            c = cs.charAt(pos.val);
            if (isInEscape) {
                switch (c) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '/': {
                        sb.append('/');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case 'u': {
                        sb.append((char)Integer.parseInt(cs.subSequence(pos.val + 1, pos.val + 5).toString(), 16));
                        pos.val += 4;
                        break;
                    }
                    default: {
                        throw new ParseException(cs, i, "Invalid escape sequence in string.");
                    }
                }
                isInEscape = false;
            } else if (c == '\\') {
                isInEscape = true;
            } else if (c == qc) {
                s = sb.toString();
            } else {
                sb.append(c);
            }
            ++pos.val;
        }
        if (s == null) {
            throw new ParseException(cs, i, "Could not find expected end character [" + qc + "].");
        }
        i = pos.val;
        while (pos.val < length) {
            c = cs.charAt(pos.val);
            if (c == '+') {
                while (pos.val < length) {
                    char c2;
                    if ((c2 = cs.charAt(++pos.val)) == '\"' || c2 == '\'') {
                        return String.valueOf(s) + this.parseString(cs, pos);
                    }
                    if (c2 == '/') {
                        this.skipCommentsAndSpace(cs, pos, false);
                        continue;
                    }
                    if (Character.isWhitespace(c2)) continue;
                    throw new ParseException(cs, i, "Expected [\"] or ['] following [+].  c2=[" + c2 + "]");
                }
            } else if (c == '/') {
                this.skipCommentsAndSpace(cs, pos, false);
            } else if (!Character.isWhitespace(c)) break;
            ++pos.val;
        }
        pos.val = i;
        return s;
    }

    protected JsonList parseArray(JsonList jsonList, CharSequence cs, MutableInt pos) {
        int length = cs.length();
        int state = 1;
        while (pos.val < length) {
            char c = cs.charAt(pos.val);
            switch (state) {
                case 1: {
                    if (c == '[') {
                        state = 5;
                        break;
                    }
                    return this.parseArray(jsonList, "[" + cs + "]", pos);
                }
                case 5: {
                    if (c == ']') {
                        ++pos.val;
                        return jsonList;
                    }
                    if (c == '/') {
                        this.skipCommentsAndSpace(cs, pos, false);
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    jsonList.add(this.parseAnything(cs, pos));
                    --pos.val;
                    state = 6;
                    break;
                }
                case 6: {
                    if (c == ',') {
                        state = 5;
                        break;
                    }
                    if (c == '/') {
                        this.skipCommentsAndSpace(cs, pos, false);
                        break;
                    }
                    if (c != ']') break;
                    ++pos.val;
                    return jsonList;
                }
            }
            ++pos.val;
        }
        switch (state) {
            case 1: {
                throw new ParseException(cs, pos.val, "Expected '[' at beginning of JSON array.");
            }
            case 5: {
                throw new ParseException(cs, pos.val, "Expected one of the following characters: {,[,',\",LITERAL.");
            }
            case 6: {
                throw new ParseException(cs, pos.val, "Expected ',' or ']'.");
            }
        }
        return null;
    }

    private String parseFieldName(CharSequence cs, MutableInt pos) {
        int i = pos.val;
        char c = cs.charAt(i);
        char quoteChar = c == '\'' || c == '\"' ? c : (char)'\u0000';
        int length = cs.length();
        if (quoteChar == '\u0000') {
            while (pos.val < length) {
                c = cs.charAt(pos.val);
                if (c == ':' || Character.isWhitespace(c) || c == '/') {
                    return cs.subSequence(i, pos.val).toString().intern();
                }
                ++pos.val;
            }
        } else {
            boolean isInEscape = false;
            ++i;
            ++pos.val;
            StringBuilder str = new StringBuilder();
            while (pos.val < length) {
                c = cs.charAt(pos.val);
                if (c == '\\' && !isInEscape) {
                    isInEscape = true;
                } else {
                    if (c == quoteChar && !isInEscape) {
                        ++pos.val;
                        return str.toString().intern();
                    }
                    isInEscape = false;
                    str.append(c);
                }
                ++pos.val;
            }
        }
        throw new ParseException(cs, pos.val, "Couldn't find the end of the field name.");
    }

    protected Object parseObject(CharSequence cs, MutableInt pos) {
        JsonMap map = new JsonMap();
        JsonMap m = this.parseMap(map, cs, pos);
        if (m.containsKey("_class")) {
            try {
                return BeanMapFactory.DEFAULT_SAFE.newInstance(Class.forName((String)m.get("_class")), m).getBean();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return m;
    }

    protected JsonMap parseMap(JsonMap jsonMap, CharSequence cs, MutableInt pos) {
        int length = cs.length();
        int state = 0;
        String currAttr = null;
        while (pos.val < length) {
            char c = cs.charAt(pos.val);
            switch (state) {
                case 0: {
                    if (c != '{') break;
                    state = 2;
                    break;
                }
                case 2: {
                    if (c == '}') {
                        ++pos.val;
                        return jsonMap;
                    }
                    if (c == '/') {
                        this.skipCommentsAndSpace(cs, pos, false);
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    currAttr = this.parseFieldName(cs, pos);
                    --pos.val;
                    state = 3;
                    break;
                }
                case 3: {
                    if (c != ':') break;
                    state = 4;
                    break;
                }
                case 4: {
                    if (c == '/') {
                        this.skipCommentsAndSpace(cs, pos, false);
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    jsonMap.put(currAttr, this.parseAnything(cs, pos));
                    --pos.val;
                    state = 7;
                    break;
                }
                case 7: {
                    if (c == ',') {
                        state = 2;
                        break;
                    }
                    if (c == '/') {
                        this.skipCommentsAndSpace(cs, pos, false);
                        break;
                    }
                    if (c != '}') break;
                    ++pos.val;
                    return jsonMap;
                }
            }
            ++pos.val;
        }
        switch (state) {
            case 0: {
                throw new ParseException(cs, pos.val, "Expected '{' at beginning of JSON object.");
            }
            case 2: {
                throw new ParseException(cs, pos.val, "Could not find attribute name on JSON object.");
            }
            case 3: {
                throw new ParseException(cs, pos.val, "Could not find ':' following attribute name on JSON object.");
            }
            case 4: {
                throw new ParseException(cs, pos.val, "Expected one of the following characters: {,[,',\",LITERAL.");
            }
            case 7: {
                throw new ParseException(cs, pos.val, "Could not find '}' marking end of JSON object.");
            }
        }
        return null;
    }

    static class MutableInt {
        int val = 0;

        public MutableInt(int iVal) {
            this.val = iVal;
        }
    }
}

