/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.DataFormat;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.DataType;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.HtmlParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonList;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonSerializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.ParseException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.UrlParamParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.XmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;

    public JsonMap(CharSequence s, DataFormat df) throws ParseException {
        switch (df) {
            case HTML: {
                HtmlParser.DEFAULT.parseInto(s, this);
                break;
            }
            case JSON: {
                JsonParser.DEFAULT.parseInto(s, this);
                break;
            }
            case URLPARAM: {
                UrlParamParser.DEFAULT.parseInto(s, this);
                break;
            }
            case XML: {
                XmlParser.DEFAULT.parseInto(s, this);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data format specified: [" + (Object)((Object)df) + "]");
            }
        }
    }

    public JsonMap(CharSequence s) throws ParseException {
        this(s, DataFormat.JSON);
    }

    public JsonMap(Reader r, DataFormat df) throws ParseException, IOException {
        this.parseReader(r, -1L, df);
    }

    public JsonMap(Reader r) throws ParseException, IOException {
        this.parseReader(r, -1L, DataFormat.JSON);
    }

    public JsonMap(Reader r, long length, DataFormat df) throws ParseException, IOException {
        this.parseReader(r, length, df);
    }

    public JsonMap(File f, DataFormat df) throws ParseException, FileNotFoundException, IOException {
        try (FileReader r = new FileReader(f);){
            this.parseReader(r, f.length(), df);
        }
    }

    public JsonMap(File f) throws ParseException, FileNotFoundException, IOException {
        this(f, DataFormat.JSON);
    }

    private void parseReader(Reader r, long length, DataFormat df) throws IOException {
        switch (df) {
            case HTML: {
                HtmlParser.DEFAULT.parseInto(r, length, this);
                break;
            }
            case JSON: {
                JsonParser.DEFAULT.parseInto(r, length, this);
                break;
            }
            case URLPARAM: {
                UrlParamParser.DEFAULT.parseInto(r, length, this);
                break;
            }
            case XML: {
                XmlParser.DEFAULT.parseInto(r, length, this);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data format specified: [" + (Object)((Object)df) + "]");
            }
        }
    }

    public JsonMap() {
    }

    public JsonMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    public V get(K key, V def) {
        Object o = this.get(key);
        return o == null ? def : o;
    }

    public V find(K ... keys) {
        K[] KArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            K key = KArray[n2];
            if (this.containsKey((Object)key)) {
                return this.get(key);
            }
            ++n2;
        }
        return null;
    }

    public void putJson(K key, String json) {
        this.put(key, JsonParser.DEFAULT.parse(json));
    }

    public void putAll(Object ... o) {
        if (o.length % 2 != 0) {
            throw new RuntimeException("Invalid set of arguments passed to JsonMap.putAll().  Must be an even number of arguments.");
        }
        int i = 0;
        while (i < o.length) {
            this.put(o[i], o[i + 1]);
            i += 2;
        }
    }

    public String getString(K key) {
        return JsonUtils.toString(this.get(key), null);
    }

    public String getString(K key, String defVal) {
        return JsonUtils.toString(this.get(key), defVal);
    }

    public String findString(K ... keys) {
        return JsonUtils.toString(this.find(keys), null);
    }

    public Integer getInt(K key) {
        return JsonUtils.toInt(this.get(key), null);
    }

    public Integer getInt(K key, Integer defVal) {
        return JsonUtils.toInt(this.get(key), defVal);
    }

    public Integer findInt(K ... keys) {
        return JsonUtils.toInt(this.find(keys), null);
    }

    public Long getLong(K key) {
        return JsonUtils.toLong(this.get(key), null);
    }

    public Long getLong(K key, Long defVal) {
        return JsonUtils.toLong(this.get(key), defVal);
    }

    public Long findLong(K ... keys) {
        return JsonUtils.toLong(this.find(keys), null);
    }

    public Boolean getBoolean(K key) {
        return JsonUtils.toBoolean(this.get(key), null);
    }

    public Boolean getBoolean(K key, Boolean defVal) {
        return JsonUtils.toBoolean(this.get(key), defVal);
    }

    public Boolean findBoolean(K ... keys) {
        return JsonUtils.toBoolean(this.find(keys), null);
    }

    public Map<?, ?> getMap(K key) {
        return JsonUtils.toMap(this.get(key), null);
    }

    public Map<?, ?> getMap(K key, Map<?, ?> def) {
        return JsonUtils.toMap(this.get(key), def);
    }

    public Map<?, ?> findMap(K ... keys) {
        return JsonUtils.toMap(this.find(keys), null);
    }

    public List<?> getList(K key) {
        return JsonUtils.toList(this.get(key), null);
    }

    public List<?> getList(K key, List<?> def) {
        return JsonUtils.toList(this.get(key), def);
    }

    public List<?> findList(K ... keys) {
        return JsonUtils.toList(this.find(keys), null);
    }

    public JsonMap<?, ?> getJsonMap(K key) {
        return JsonUtils.toJsonMap(this.get(key), null);
    }

    public JsonMap<?, ?> getJsonMap(K key, JsonMap<?, ?> def) {
        return JsonUtils.toJsonMap(this.get(key), def);
    }

    public JsonMap<?, ?> findJsonMap(K ... keys) {
        return JsonUtils.toJsonMap(this.find(keys), null);
    }

    public JsonList<?> getJsonList(K key) {
        return JsonUtils.toJsonList(this.get(key), null);
    }

    public JsonList<?> getJsonList(K key, JsonList<?> def) {
        return JsonUtils.toJsonList(this.get(key), def);
    }

    public JsonList<?> findJsonList(K ... keys) {
        return JsonUtils.toJsonList(this.find(keys), null);
    }

    public K getFirstKey() {
        return this.isEmpty() ? null : (K)this.keySet().iterator().next();
    }

    public DataType getDataType(K attr) {
        return JsonUtils.getDataType(this.get(attr));
    }

    public void removeAll(Collection<K> c) {
        for (K k : c) {
            this.remove(k);
        }
    }

    public void removeAll(K ... c) {
        K[] KArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            K k = KArray[n2];
            this.remove(k);
            ++n2;
        }
    }

    public String toString(JsonSerializer serializer) {
        return serializer.serialize(this);
    }

    @Override
    public String toString() {
        return this.toString(JsonSerializer.DEFAULT_CONDENSED);
    }

    public boolean containsKey(K ... keys) {
        K[] KArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            K k = KArray[n2];
            if (super.containsKey(k)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

