/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.DataFormat;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.DataType;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.HtmlParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonParser;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonSerializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.JsonUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.ParseException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.XmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 1L;

    public JsonList(CharSequence s, DataFormat df) throws ParseException {
        switch (df) {
            case JSON: {
                JsonParser.DEFAULT.parseInto(s, this);
                break;
            }
            case XML: {
                XmlParser.DEFAULT.parseInto(s, this);
                break;
            }
            case HTML: {
                HtmlParser.DEFAULT.parseInto(s, this);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data format specified: [" + (Object)((Object)df) + "]");
            }
        }
    }

    public JsonList(CharSequence s) throws ParseException {
        this(s, DataFormat.JSON);
    }

    public JsonList(Reader r, DataFormat df) throws ParseException, IOException {
        this.parseReader(r, -1L, df);
    }

    public JsonList(Reader r, long length, DataFormat df) throws ParseException, IOException {
        this.parseReader(r, length, df);
    }

    public JsonList(File f, DataFormat df) throws ParseException, FileNotFoundException, IOException {
        try (FileReader r = new FileReader(f);){
            this.parseReader(r, f.length(), df);
        }
    }

    public JsonList(File f) throws ParseException, FileNotFoundException, IOException {
        this(f, DataFormat.JSON);
    }

    private void parseReader(Reader r, long length, DataFormat df) throws IOException {
        switch (df) {
            case JSON: {
                JsonParser.DEFAULT.parseInto(r, length, this);
                break;
            }
            case XML: {
                XmlParser.DEFAULT.parseInto(r, length, this);
                break;
            }
            case HTML: {
                HtmlParser.DEFAULT.parseInto(r, length, this);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data format specified: [" + (Object)((Object)df) + "]");
            }
        }
    }

    public JsonList() {
    }

    public JsonList(E ... o) {
        super(Arrays.asList(o));
    }

    public JsonList(Collection<? extends E> o) {
        super(o);
    }

    public String getString(int index) {
        return this.get(index).toString();
    }

    public String getString(int index, String defVal) {
        return JsonUtils.toString(this.get(index), defVal);
    }

    public Boolean getBoolean(int index) {
        return JsonUtils.toBoolean(this.get(index), null);
    }

    public Boolean getBoolean(int index, Boolean defVal) {
        return JsonUtils.toBoolean(this.get(index), defVal);
    }

    public Integer getInt(int index) {
        return JsonUtils.toInt(this.get(index), null);
    }

    public Integer getInt(int index, Integer defVal) {
        return JsonUtils.toInt(this.get(index), defVal);
    }

    public Long getLong(int index) {
        return JsonUtils.toLong(this.get(index), null);
    }

    public Long getLong(int index, Long defVal) {
        return JsonUtils.toLong(this.get(index), defVal);
    }

    public Map<?, ?> getMap(int index) {
        return JsonUtils.toMap(this.get(index), null);
    }

    public List<?> getList(int index) {
        return JsonUtils.toList(this.get(index), null);
    }

    public JsonMap<?, ?> getJsonMap(int index) {
        return JsonUtils.toJsonMap(this.get(index), null);
    }

    public JsonList<?> getJsonList(int index) {
        return JsonUtils.toJsonList(this.get(index), null);
    }

    public String[] toStringArray() {
        return JsonUtils.toStringArray(this.toArray());
    }

    public Boolean[] toBooleanArray() {
        return JsonUtils.toBooleanArray(this.toArray());
    }

    public Integer[] toIntArray() {
        return JsonUtils.toIntArray(this.toArray());
    }

    public Long[] toLongArray() {
        return JsonUtils.toLongArray(this.toArray());
    }

    public Map<?, ?>[] toMapArray() {
        return JsonUtils.toMapArray(this.toArray());
    }

    public JsonMap<?, ?>[] toJsonMapArray() {
        return JsonUtils.toJsonMapArray(this.toArray());
    }

    public List<?>[] toListArray() {
        return JsonUtils.toListArray(this.toArray());
    }

    public JsonList<?>[] toJsonListArray() {
        return JsonUtils.toJsonListArray(this.toArray());
    }

    public DataType getDataType(int index) {
        return JsonUtils.getDataType(this.get(index));
    }

    public String toString(JsonSerializer serializer) {
        return serializer.serialize(this);
    }

    @Override
    public String toString() {
        return this.toString(JsonSerializer.DEFAULT_CONDENSED);
    }
}

