/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.DateFormats;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.Serializer;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMap;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.BeanMapFactory;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.jjson.beans.annotation.HtmlLink;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;

public class HtmlSerializer
extends Serializer {
    public static HtmlSerializer DEFAULT = new HtmlSerializer();
    private final Class<HtmlLink> hyperlinkAnnotation = HtmlLink.class;
    private boolean useIndentation = true;
    private DateFormat dateFormat = DateFormats.DEFAULT;

    public HtmlSerializer clone() {
        try {
            return (HtmlSerializer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public HtmlSerializer setUseIndentation(boolean useIndentation) {
        this.useIndentation = useIndentation;
        return this;
    }

    public HtmlSerializer setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @Override
    public Writer serialize(Writer w, Object o, int depth) throws IOException {
        this.serialize(null, o, w, depth);
        return w;
    }

    private void serialize(String name, Object o, Writer w, int depth) throws IOException {
        if (o == null) {
            w.write("");
        } else if (o instanceof Calendar || o instanceof Date) {
            if (o instanceof Calendar) {
                o = ((Calendar)o).getTime();
            }
            Date d = (Date)o;
            if (this.dateFormat == null) {
                w.write("" + d.getTime());
            } else {
                w.write(HtmlSerializer.toValidHtml(this.dateFormat.format(d)));
            }
        } else if (o instanceof String) {
            String string = (String)o;
            if (string.startsWith("<center>") && string.endsWith("</center>")) {
                w.write(string);
            } else {
                w.write(HtmlSerializer.toValidHtml(o.toString()));
            }
        } else if (o instanceof Number || o instanceof Boolean || o instanceof Enum) {
            w.write(HtmlSerializer.toValidHtml(o.toString()));
        } else if (o.getClass().isAnnotationPresent(this.hyperlinkAnnotation)) {
            BeanMap m = BeanMapFactory.DEFAULT.forBean(o);
            HtmlLink h = o.getClass().getAnnotation(this.hyperlinkAnnotation);
            Object urlProp = m.get(h.urlProperty());
            Object nameProp = m.get(h.nameProperty());
            w.write("<a href='" + urlProp + "'>" + HtmlSerializer.toValidHtml(nameProp == null ? null : nameProp.toString()) + "</a>");
        } else if (o instanceof Map) {
            this.serializeMap(name, (Map)o, w, depth);
        } else if (o instanceof Collection) {
            this.serializeCollection(name, (Collection)o, w, depth);
        } else if (o.getClass().isArray()) {
            this.serializeCollection(name, Arrays.asList((Object[])o), w, depth);
        } else {
            BeanMap m = BeanMapFactory.DEFAULT.forBean(o);
            if (m != null) {
                this.serializeMap(name, m, w, depth);
            } else {
                w.write(HtmlSerializer.toValidHtml(o.toString()));
            }
        }
    }

    private void serializeMap(String name, Map m, Writer w, int depth) throws IOException {
        if (this.useIndentation) {
            HtmlSerializer.cr(w, depth);
        }
        w.write("<table>");
        if (this.useIndentation) {
            HtmlSerializer.cr(w, depth + 1);
        }
        w.write("<tr><th>key</th><th>value</th></tr>");
        for (Map.Entry e : m.entrySet()) {
            if (this.useIndentation) {
                HtmlSerializer.cr(w, depth + 1);
            }
            w.write("<tr><td>" + e.getKey() + "</td><td>");
            try {
                this.serialize(e.getKey().toString(), e.getValue(), w, depth + 2);
            }
            catch (Exception e2) {
                e2.printStackTrace(System.err);
                System.err.println("Couldn't serialize field [" + e.getKey() + "]");
            }
            w.write("</td></tr>");
        }
        if (this.useIndentation) {
            HtmlSerializer.cr(w, depth);
        }
        w.write("</table>\n");
    }

    private void serializeCollection(String name, Collection c, Writer w, int depth) throws IOException {
        if (this.useIndentation) {
            HtmlSerializer.cr(w, depth);
        }
        if (c.isEmpty()) {
            w.write(name == null ? "No results" : "&nbsp;");
            return;
        }
        Object oc = c.iterator().next();
        if (oc instanceof String || oc instanceof Number || oc instanceof Boolean || oc instanceof Date || oc instanceof Enum || oc == null || oc.getClass().isAnnotationPresent(HtmlLink.class)) {
            w.write("<ol>");
            for (Object o : c) {
                if (this.useIndentation) {
                    HtmlSerializer.cr(w, depth + 1);
                }
                w.write("<li>");
                this.serialize(name, o, w, depth + 2);
            }
            if (this.useIndentation) {
                HtmlSerializer.cr(w, depth);
            }
            w.write("</ol>");
        } else {
            if (!(oc instanceof Map)) {
                BeanMap oc2 = BeanMapFactory.DEFAULT.forBean(oc);
                if (oc2 == null) {
                    w.write(oc.toString());
                    return;
                }
                oc = oc2;
            }
            LinkedList keys = new LinkedList(((Map)oc).keySet());
            w.write("<table><tr>");
            for (Object key : keys) {
                w.write("<th>" + key + "</th>");
            }
            w.write("</tr>");
            for (Object m : c) {
                Map m2;
                w.write("<tr>");
                Map map = m2 = m instanceof Map ? (Map)m : BeanMapFactory.DEFAULT.forBean(m);
                if (m2 == null) {
                    this.serialize(w, m, depth + 1);
                } else {
                    for (Object key : keys) {
                        w.write("<td>");
                        this.serialize(key.toString(), m2.get(key), w, depth + 1);
                        w.write("</td>");
                    }
                }
                w.write("</tr>");
            }
            w.write("</table>");
        }
    }

    protected static String toValidHtml(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            char test = s.charAt(i);
            if (test == '&') {
                sb.append("&amp;");
            } else if (test == '<') {
                sb.append("&lt;");
            } else if (test == '>') {
                sb.append("&gt;");
            } else if (test == '\n') {
                sb.append("<br>");
            } else if (test == '\t') {
                sb.append("&nbsp;&nbsp;&nbsp;");
            } else if (Character.isISOControl(test)) {
                sb.append("&#" + test + ";");
            } else {
                sb.append(test);
            }
            ++i;
        }
        return sb.toString();
    }
}

