/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.PasswordCipherUtil;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.SecurityException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.CryptUtils;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import javax.crypto.spec.SecretKeySpec;

public class PasswordUtil {
    public static final String STRING_CONVERSION_CODE = "UTF-8";
    public static final String DEFAULT_CRYPTO_ALGORITHM;
    private static final String CRYPTO_ALGORITHM_STARTED = "{";
    private static final String CRYPTO_ALGORITHM_STOPPED = "}";
    public static final String DEFAULT_CRYPTO_EYECATCHER;
    public static final String CRYPTO_XOR_EYECATCHER = "{xor}";
    public static final String CRYPTO_AES_EYECATCHER = "{aes}";
    private static final String EMPTY_STRING;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final String[] SUPPORTED_CRYPTO_ALGORITHMS;
    private static final byte[] BASE64_ENCODE_MAP;
    private static final byte[] BASE64_DECODE_MAP;

    static {
        EMPTY_STRING = new String("");
        EMPTY_BYTE_ARRAY = new byte[0];
        SUPPORTED_CRYPTO_ALGORITHMS = PasswordCipherUtil.getSupportedCryptoAlgorithms();
        DEFAULT_CRYPTO_ALGORITHM = "aes";
        DEFAULT_CRYPTO_EYECATCHER = CRYPTO_ALGORITHM_STARTED + DEFAULT_CRYPTO_ALGORITHM + CRYPTO_ALGORITHM_STOPPED;
        byte[] map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        BASE64_ENCODE_MAP = map;
        BASE64_DECODE_MAP = new byte[128];
        int idx = 0;
        while (idx < BASE64_DECODE_MAP.length) {
            PasswordUtil.BASE64_DECODE_MAP[idx] = -1;
            ++idx;
        }
        idx = 0;
        while (idx < BASE64_ENCODE_MAP.length) {
            PasswordUtil.BASE64_DECODE_MAP[PasswordUtil.BASE64_ENCODE_MAP[idx]] = (byte)idx;
            ++idx;
        }
    }

    public static String decode(String encoded_string, String iSecret) throws SecurityException {
        if (encoded_string == null) {
            throw new SecurityException(2);
        }
        String crypto_algorithm = PasswordUtil.getCryptoAlgorithm(encoded_string);
        if (crypto_algorithm == null) {
            throw new SecurityException(2);
        }
        if (!PasswordUtil.isValidCryptoAlgorithm(crypto_algorithm)) {
            throw new SecurityException(4);
        }
        String decoded_string = PasswordUtil.decode_password(PasswordUtil.removeCryptoAlgorithmTag(encoded_string), iSecret, crypto_algorithm);
        if (decoded_string == null) {
            throw new SecurityException(2);
        }
        return decoded_string;
    }

    public static String encode(String decoded_string, String iSecret, String crypto_algorithm) throws SecurityException {
        if (!PasswordUtil.isValidCryptoAlgorithm(crypto_algorithm)) {
            throw new SecurityException(4);
        }
        if (decoded_string == null) {
            throw new SecurityException(3);
        }
        if (PasswordUtil.getCryptoAlgorithm(decoded_string) != null) {
            throw new SecurityException(3);
        }
        String encoded_string = PasswordUtil.encode_password(decoded_string.trim(), iSecret, crypto_algorithm.trim());
        if (encoded_string == null) {
            throw new SecurityException(3);
        }
        return encoded_string;
    }

    public static String getCryptoAlgorithm(String encoded_string) {
        int algorithm_stopped;
        int algorithm_started;
        String crypto_algorithm = null;
        if (encoded_string != null && (encoded_string = encoded_string.trim()).length() >= 2 && (algorithm_started = encoded_string.indexOf(CRYPTO_ALGORITHM_STARTED)) == 0 && (algorithm_stopped = encoded_string.indexOf(CRYPTO_ALGORITHM_STOPPED, ++algorithm_started)) > 0) {
            crypto_algorithm = algorithm_started < algorithm_stopped ? encoded_string.substring(algorithm_started, algorithm_stopped).trim() : EMPTY_STRING;
        }
        return crypto_algorithm;
    }

    public static String getCryptoAlgorithmTag(String encoded_string) {
        String crypto_algorithm_tag = null;
        String crypto_algorithm = PasswordUtil.getCryptoAlgorithm(encoded_string);
        if (crypto_algorithm != null) {
            StringBuffer buffer = new StringBuffer(CRYPTO_ALGORITHM_STARTED);
            if (crypto_algorithm.length() > 0) {
                buffer.append(crypto_algorithm);
            }
            buffer.append(CRYPTO_ALGORITHM_STOPPED);
            crypto_algorithm_tag = buffer.toString();
        }
        return crypto_algorithm_tag;
    }

    public static boolean isValidCryptoAlgorithm(String crypto_algorithm) {
        if (crypto_algorithm != null) {
            if ((crypto_algorithm = crypto_algorithm.trim()).length() == 0) {
                return true;
            }
            int i = 0;
            while (i < SUPPORTED_CRYPTO_ALGORITHMS.length) {
                if (crypto_algorithm.equalsIgnoreCase(SUPPORTED_CRYPTO_ALGORITHMS[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isValidCryptoAlgorithmTag(String crypto_algorithm_tag) {
        return PasswordUtil.isValidCryptoAlgorithm(PasswordUtil.getCryptoAlgorithm(crypto_algorithm_tag));
    }

    public static String removeCryptoAlgorithmTag(String encoded_string) {
        int algorithm_stopped;
        int algorithm_started;
        String encoded_password = null;
        if (encoded_string != null && (encoded_string = encoded_string.trim()).length() >= 2 && (algorithm_started = encoded_string.indexOf(CRYPTO_ALGORITHM_STARTED)) == 0 && (algorithm_stopped = encoded_string.indexOf(CRYPTO_ALGORITHM_STOPPED, ++algorithm_started)) > 0) {
            encoded_password = ++algorithm_stopped < encoded_string.length() ? encoded_string.substring(algorithm_stopped).trim() : EMPTY_STRING;
        }
        return encoded_password;
    }

    private static byte[] convert_to_bytes(String string) {
        byte[] bytes = null;
        if (string != null) {
            if (string.length() == 0) {
                bytes = EMPTY_BYTE_ARRAY;
            } else {
                try {
                    bytes = string.getBytes(STRING_CONVERSION_CODE);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        return bytes;
    }

    private static String convert_to_string(byte[] bytes) {
        String string = null;
        if (bytes != null) {
            if (bytes.length == 0) {
                string = EMPTY_STRING;
            } else {
                try {
                    string = new String(bytes, STRING_CONVERSION_CODE);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        return string;
    }

    private static byte[] convert_viewable_to_bytes(String string) {
        byte[] bytes = null;
        if (string != null) {
            if (string.length() == 0) {
                bytes = EMPTY_BYTE_ARRAY;
            } else {
                try {
                    bytes = PasswordUtil.base64Decode(PasswordUtil.convert_to_bytes(string));
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        return bytes;
    }

    private static byte[] base64Decode(byte[] bytes) {
        int tail = bytes.length;
        while (bytes[--tail] == 61) {
        }
        byte[] dest = new byte[tail + 1 - bytes.length / 4];
        int idx = 0;
        while (idx < bytes.length) {
            bytes[idx] = BASE64_DECODE_MAP[bytes[idx]];
            ++idx;
        }
        int destx = dest.length - 2;
        int didx = 0;
        int sidx = 0;
        while (didx < destx) {
            dest[didx] = (byte)(bytes[sidx] << 2 & 0xFF | bytes[sidx + 1] >>> 4 & 3);
            dest[didx + 1] = (byte)(bytes[sidx + 1] << 4 & 0xFF | bytes[sidx + 2] >>> 2 & 0xF);
            dest[didx + 2] = (byte)(bytes[sidx + 2] << 6 & 0xFF | bytes[sidx + 3] & 0x3F);
            didx += 3;
            sidx += 4;
        }
        if (didx < dest.length) {
            dest[didx++] = (byte)(bytes[sidx] << 2 & 0xFF | bytes[sidx + 1] >>> 4 & 3);
            if (didx < dest.length) {
                dest[didx] = (byte)(bytes[sidx + 1] << 4 & 0xFF | bytes[sidx + 2] >>> 2 & 0xF);
            }
        }
        return dest;
    }

    private static String convert_viewable_to_string(byte[] bytes) {
        String string = null;
        if (bytes != null) {
            if (bytes.length == 0) {
                string = EMPTY_STRING;
            } else {
                try {
                    string = PasswordUtil.convert_to_string(PasswordUtil.base64Encode(bytes));
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        return string;
    }

    private static byte[] base64Encode(byte[] bytes) {
        byte[] dest = new byte[(bytes.length + 2) / 3 * 4];
        int sidx = 0;
        int didx = 0;
        while (sidx < bytes.length - 2) {
            dest[didx++] = BASE64_ENCODE_MAP[bytes[sidx] >>> 2 & 0x3F];
            dest[didx++] = BASE64_ENCODE_MAP[bytes[sidx + 1] >>> 4 & 0xF | bytes[sidx] << 4 & 0x3F];
            dest[didx++] = BASE64_ENCODE_MAP[bytes[sidx + 2] >>> 6 & 3 | bytes[sidx + 1] << 2 & 0x3F];
            dest[didx++] = BASE64_ENCODE_MAP[bytes[sidx + 2] & 0x3F];
            sidx += 3;
        }
        if (sidx < bytes.length) {
            dest[didx++] = BASE64_ENCODE_MAP[bytes[sidx] >>> 2 & 0x3F];
            if (sidx < bytes.length - 1) {
                dest[didx++] = BASE64_ENCODE_MAP[bytes[sidx + 1] >>> 4 & 0xF | bytes[sidx] << 4 & 0x3F];
                dest[didx++] = BASE64_ENCODE_MAP[bytes[sidx + 1] << 2 & 0x3F];
            } else {
                dest[didx++] = BASE64_ENCODE_MAP[bytes[sidx] << 4 & 0x3F];
            }
        }
        while (didx < dest.length) {
            dest[didx] = 61;
            ++didx;
        }
        return dest;
    }

    private static String decode_password(String encoded_string, String iSecret, String crypto_algorithm) {
        StringBuffer buffer = new StringBuffer();
        if (crypto_algorithm.length() == 0) {
            buffer.append(encoded_string);
        } else {
            String decoded_string = null;
            if (encoded_string.length() > 0) {
                byte[] encrypted_bytes = PasswordUtil.convert_viewable_to_bytes(encoded_string);
                if (encrypted_bytes == null) {
                    return null;
                }
                if (encrypted_bytes.length > 0) {
                    byte[] decrypted_bytes = null;
                    try {
                        decrypted_bytes = PasswordCipherUtil.decipher(encrypted_bytes, iSecret, crypto_algorithm);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace(System.err);
                        return null;
                    }
                    if (decrypted_bytes != null && decrypted_bytes.length > 0) {
                        decoded_string = PasswordUtil.convert_to_string(decrypted_bytes);
                    }
                }
            }
            if (decoded_string != null && decoded_string.length() > 0) {
                buffer.append(decoded_string);
            }
        }
        return buffer.toString();
    }

    private static String encode_password(String decoded_string, String iSecret, String crypto_algorithm) {
        StringBuffer buffer = new StringBuffer(CRYPTO_ALGORITHM_STARTED);
        if (crypto_algorithm.length() == 0) {
            buffer.append(CRYPTO_ALGORITHM_STOPPED).append(decoded_string);
        } else {
            byte[] decrypted_bytes;
            buffer.append(crypto_algorithm).append(CRYPTO_ALGORITHM_STOPPED);
            String encoded_string = null;
            if (decoded_string.length() > 0 && (decrypted_bytes = PasswordUtil.convert_to_bytes(decoded_string)).length > 0) {
                byte[] encrypted_bytes = null;
                try {
                    encrypted_bytes = PasswordCipherUtil.encipher(decrypted_bytes, iSecret, crypto_algorithm);
                }
                catch (SecurityException e) {
                    e.printStackTrace(System.err);
                    return null;
                }
                if (encrypted_bytes != null && encrypted_bytes.length > 0 && (encoded_string = PasswordUtil.convert_viewable_to_string(encrypted_bytes)) == null) {
                    return null;
                }
            }
            if (encoded_string != null && encoded_string.length() > 0) {
                buffer.append(encoded_string);
            }
        }
        return buffer.toString();
    }

    public static String getSecretKeyFromKeyStore(String path, String password) {
        String secretKey = null;
        try {
            String keystorePassword = PasswordUtil.decode(CRYPTO_XOR_EYECATCHER + password, null);
            File keystoreFile = new File(path, "dmh.keystore");
            KeyStore ks = KeyStore.getInstance("JCEKS");
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(keystorePassword.toCharArray());
            FileInputStream is = keystoreFile.exists() ? new FileInputStream(keystoreFile) : null;
            ks.load(is, keystorePassword.toCharArray());
            if (is != null) {
                ((InputStream)is).close();
                KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)ks.getEntry("secretKeyAlias", protParam);
                secretKey = new String(skEntry.getSecretKey().getEncoded(), STRING_CONVERSION_CODE);
            } else {
                secretKey = CryptUtils.generateSecretKey();
                SecretKeySpec mySecretKey = new SecretKeySpec(secretKey.getBytes(STRING_CONVERSION_CODE), "AES");
                KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(mySecretKey);
                ks.setEntry("secretKeyAlias", skEntry, protParam);
                FileOutputStream os = new FileOutputStream(keystoreFile);
                ks.store(os, keystorePassword.toCharArray());
                ((OutputStream)os).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return secretKey;
    }

    public static String getSecretKeyFromKeyStore(StringBuffer buffer, String password) {
        String secretKey = null;
        try {
            String keystorePassword = PasswordUtil.decode(CRYPTO_XOR_EYECATCHER + password, null);
            KeyStore ks = KeyStore.getInstance("JCEKS");
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(keystorePassword.toCharArray());
            ByteArrayInputStream is = buffer.length() > 0 ? new ByteArrayInputStream(StringUtils.hexToBytes(buffer.toString())) : null;
            ks.load(is, keystorePassword.toCharArray());
            if (is != null) {
                ((InputStream)is).close();
                KeyStore.SecretKeyEntry skEntry = (KeyStore.SecretKeyEntry)ks.getEntry("secretKeyAlias", protParam);
                secretKey = new String(skEntry.getSecretKey().getEncoded(), STRING_CONVERSION_CODE);
            } else {
                secretKey = CryptUtils.generateSecretKey();
                SecretKeySpec mySecretKey = new SecretKeySpec(secretKey.getBytes(STRING_CONVERSION_CODE), "AES");
                KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(mySecretKey);
                ks.setEntry("secretKeyAlias", skEntry, protParam);
                ByteArrayOutputStream os = new ByteArrayOutputStream(500);
                ks.store(os, keystorePassword.toCharArray());
                buffer.append(StringUtils.bytesToHex(os.toByteArray()));
                os.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return secretKey;
    }
}

