/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.PasswordUtil;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.SecurityException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.CryptUtils;

public class PasswordCipherUtil {
    private static final byte XOR_MASK = 95;
    public static final String CRYPTO_ALGORITHM_AES = "aes";
    public static final String CRYPTO_ALGORITHM_XOR = "xor";
    private static final String[] SUPPORTED_CRYPTO_ALGORITHMS = new String[]{"xor", "aes"};
    private static String secretPrefix = "aGlvZx4abW0dZh4eaRwdZw==";

    public static byte[] decipher(byte[] encrypted_bytes, String iSecret, String crypto_algorithm) throws SecurityException {
        if (crypto_algorithm == null) {
            throw new SecurityException(4);
        }
        byte[] decrypted_bytes = null;
        if (crypto_algorithm.equalsIgnoreCase(CRYPTO_ALGORITHM_XOR)) {
            decrypted_bytes = PasswordCipherUtil.xor(encrypted_bytes);
        } else if (crypto_algorithm.equalsIgnoreCase(CRYPTO_ALGORITHM_AES)) {
            try {
                String secret = String.valueOf(PasswordUtil.decode("{xor}" + secretPrefix, null)) + iSecret.substring(16);
                String decryptedString = CryptUtils.decrypt(new String(encrypted_bytes, "UTF-8"), secret);
                decrypted_bytes = decryptedString.getBytes("UTF-8");
            }
            catch (Throwable t) {
                throw new java.lang.SecurityException(t);
            }
        } else {
            throw new SecurityException(4);
        }
        if (decrypted_bytes == null) {
            throw new SecurityException(1);
        }
        return decrypted_bytes;
    }

    public static byte[] encipher(byte[] decrypted_bytes, String iSecret, String crypto_algorithm) throws SecurityException {
        if (crypto_algorithm == null) {
            throw new SecurityException(4);
        }
        byte[] encrypted_bytes = null;
        if (crypto_algorithm.equalsIgnoreCase(CRYPTO_ALGORITHM_XOR)) {
            encrypted_bytes = PasswordCipherUtil.xor(decrypted_bytes);
        } else if (crypto_algorithm.equalsIgnoreCase(CRYPTO_ALGORITHM_AES)) {
            try {
                String secret = String.valueOf(PasswordUtil.decode("{xor}" + secretPrefix, null)) + iSecret.substring(16);
                String encryptedString = CryptUtils.encrypt(new String(decrypted_bytes, "UTF-8"), secret);
                encrypted_bytes = encryptedString.getBytes("UTF-8");
            }
            catch (Throwable t) {
                throw new java.lang.SecurityException(t);
            }
        } else {
            throw new SecurityException(4);
        }
        if (encrypted_bytes == null) {
            throw new SecurityException(1);
        }
        return encrypted_bytes;
    }

    public static String[] getSupportedCryptoAlgorithms() {
        return SUPPORTED_CRYPTO_ALGORITHMS;
    }

    private static byte[] xor(byte[] bytes) {
        byte[] xor_bytes = null;
        if (bytes != null) {
            xor_bytes = new byte[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                xor_bytes[i] = (byte)(0x5F ^ bytes[i]);
                ++i;
            }
        }
        return xor_bytes;
    }
}

