/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;

public class ExpressionSolver {
    public static boolean solveBoolean(String s) throws Exception {
        return ExpressionSolver.solveMath(s) > 0;
    }

    public static int solveMath(String s) throws Exception {
        if (StringUtils.isEmpty(s)) {
            throw new RuntimeException("Blank expression passed to ExpressionSolver.");
        }
        s = ExpressionSolver.fixUp(s);
        s = ExpressionSolver.methodizeOperator(s, '*', "mul");
        s = ExpressionSolver.methodizeOperator(s, '/', "div");
        s = ExpressionSolver.methodizeOperator(s, '+', "add");
        s = ExpressionSolver.methodizeOperator(s, '-', "sub");
        s = ExpressionSolver.methodizeOperator(s, '=', "equ");
        s = ExpressionSolver.methodizeOperator(s, '!', "neq");
        s = ExpressionSolver.methodizeOperator(s, '&', "and");
        s = ExpressionSolver.methodizeOperator(s, '|', "orr");
        s = ExpressionSolver.methodizeOperator(s, '>', "grt");
        s = ExpressionSolver.methodizeOperator(s, '<', "les");
        try {
            return ExpressionSolver.solve(s.toCharArray(), 0, s.length());
        }
        catch (ArithmeticException e) {
            return 0;
        }
    }

    public static float solveFloatMath(String s) throws Exception {
        s = ExpressionSolver.fixUp(s);
        s = ExpressionSolver.methodizeOperator(s, '*', "mul");
        s = ExpressionSolver.methodizeOperator(s, '/', "div");
        s = ExpressionSolver.methodizeOperator(s, '+', "add");
        s = ExpressionSolver.methodizeOperator(s, '-', "sub");
        s = ExpressionSolver.methodizeOperator(s, '=', "equ");
        s = ExpressionSolver.methodizeOperator(s, '!', "neq");
        s = ExpressionSolver.methodizeOperator(s, '&', "and");
        float f = ExpressionSolver.solveFloat((s = ExpressionSolver.methodizeOperator(s, '|', "orr")).toCharArray(), 0, s.length());
        return Float.isNaN(f) ? 0.0f : f;
    }

    private static String methodizeOperator(String s, char op, String meth) {
        int i;
        while ((i = s.indexOf(op)) != -1) {
            char[] x = s.toCharArray();
            String op1 = ExpressionSolver.op1(x, i);
            String op2 = ExpressionSolver.op2(x, i);
            s = String.valueOf(op1.length() < i ? s.substring(0, i - op1.length()) : "") + meth + "(" + op1 + "," + op2 + ")" + (i + op2.length() < s.length() ? s.substring(i + op2.length() + 1) : "");
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private static String op1(char[] s, int p) {
        block11: {
            if (p == 0) {
                return "";
            }
            if (s[p - 1] == ')') {
                parCount = 1;
                j = 2;
                while (parCount != 0) {
                    if (s[p - j] == ')') {
                        ++parCount;
                    } else if (s[p - j] == '(') {
                        --parCount;
                    }
                    ++j;
                }
                return new String(s, p - j - 2, j + 2);
            }
            j = 1;
            if (s[p - 1] != '\'' && s[p - 1] != '\"') ** GOTO lbl25
            ++j;
            while (p - j >= 0 && s[p - j] != s[p - 1]) {
                ++j;
            }
            if (p - j < 0) break block11;
            ++j;
            break block11;
lbl-1000:
            // 1 sources

            {
                ++j;
lbl25:
                // 2 sources

                ** while (p - j >= 0 && (Character.isJavaIdentifierPart((char)s[p - j]) || s[p - j] == '#' || s[p - j] == '\'' || s[p - j] == '\"'))
            }
        }
        return new String(s, p - j + 1, j - 1);
    }

    /*
     * Unable to fully structure code
     */
    private static String op2(char[] s, int p) {
        block10: {
            if (s.length > p + 4 && Character.isLetter(s[p + 1]) && Character.isLetter(s[p + 2]) && Character.isLetter(s[p + 3]) && s[p + 4] == '(') {
                parCount = 1;
                j = 5;
                while (parCount != 0) {
                    if (s[p + j] == '(') {
                        ++parCount;
                    } else if (s[p + j] == ')') {
                        --parCount;
                    }
                    ++j;
                }
                return new String(s, p + 1, j - 1);
            }
            j = 1;
            if (p + 2 > s.length || s[p + 1] != '\'' && s[p + 1] != '\"') ** GOTO lbl23
            ++j;
            while (p + j < s.length && s[p + j] != s[p + 1]) {
                ++j;
            }
            if (p + j >= s.length) break block10;
            ++j;
            break block10;
lbl-1000:
            // 1 sources

            {
                ++j;
lbl23:
                // 2 sources

                ** while (p + j < s.length && (Character.isJavaIdentifierPart((char)s[p + j]) || s[p + j] == '#' || s[p + j] == '\'' || s[p + j] == '\"'))
            }
        }
        return new String(s, p + 1, j - 1);
    }

    private static String fixUp(String s) throws Exception {
        char c;
        if (s.indexOf(" >= ") != -1 || s.indexOf(" <= ") != -1) {
            throw new Exception("Unsupported operator used.");
        }
        int i = 0;
        while ((i = s.indexOf("true")) != -1) {
            s = String.valueOf(s.substring(0, i)) + "1" + s.substring(i + 4);
        }
        i = 0;
        while ((i = s.indexOf("false")) != -1) {
            s = String.valueOf(s.substring(0, i)) + "0" + s.substring(i + 5);
        }
        i = 0;
        while ((i = s.indexOf("null")) != -1) {
            s = String.valueOf(s.substring(0, i)) + "0" + s.substring(i + 4);
        }
        i = 0;
        while ((i = s.indexOf(" AND ")) != -1) {
            s = String.valueOf(s.substring(0, i)) + " && " + s.substring(i + 5);
        }
        i = 0;
        while ((i = s.indexOf(" OR ")) != -1) {
            s = String.valueOf(s.substring(0, i)) + " || " + s.substring(i + 4);
        }
        i = 0;
        while ((i = s.indexOf("!", i)) != -1) {
            if (s.charAt(i + 1) != '=') {
                s = String.valueOf(s.substring(0, i)) + "1 !=" + s.substring(i + 1);
                i += 4;
                continue;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        char quoteChar = ' ';
        boolean inQuotes = false;
        i = 0;
        while (i < s.length()) {
            c = s.charAt(i);
            if (inQuotes) {
                if (c == quoteChar) {
                    inQuotes = false;
                    quoteChar = ' ';
                }
            } else if (c == '\'' || c == '\"') {
                inQuotes = true;
                quoteChar = c;
            }
            if (inQuotes || !Character.isSpaceChar(c)) {
                if (!(inQuotes || c != '&' && c != '|' && c != '!' && c != '=')) {
                    ++i;
                }
                sb.append(c);
            }
            ++i;
        }
        s = sb.toString();
        sb.setLength(0);
        i = 0;
        while (i < s.length()) {
            c = s.charAt(i);
            if (!(c != '(' || i != 0 && Character.isLetter(s.charAt(i - 1)))) {
                sb.append("par(");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static int solve(char[] exp, int start, int end) throws Exception {
        if (Character.isDigit(exp[start])) {
            try {
                return Integer.parseInt(new String(exp, start, end - start));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (start + 3 >= exp.length || exp[start + 3] != '(') {
            return Integer.MAX_VALUE;
        }
        String opcode = new String(exp, start, 3);
        int parCount = 0;
        int argCount = 1;
        int i = start + 4;
        while (i < end - 1) {
            if (exp[i] == ',') {
                if (parCount == 0) {
                    exp[i] = 4096;
                    ++argCount;
                }
            } else if (exp[i] == '(') {
                ++parCount;
            } else if (exp[i] == ')') {
                --parCount;
            }
            ++i;
        }
        int[] args = new int[argCount];
        int j = start + 4;
        int i2 = 0;
        while (i2 < argCount - 1) {
            int k = j;
            while (exp[k] != '\u1000') {
                ++k;
            }
            args[i2] = ExpressionSolver.solve(exp, j, k);
            j = k + 1;
            ++i2;
        }
        args[argCount - 1] = ExpressionSolver.solve(exp, j, end - 1);
        if (args.length > 1 && args[0] == Integer.MAX_VALUE && args[1] == Integer.MAX_VALUE) {
            String x = new String(exp, start + 4, end - start - 5);
            String arg1 = x.substring(0, x.indexOf(4096));
            String arg2 = x.substring(x.indexOf(4096) + 1);
            if (arg1.length() > 0 && (arg1.charAt(0) == '\'' || arg1.charAt(0) == '\"')) {
                arg1 = arg1.substring(1, arg1.length() - 1);
            }
            if (arg2.length() > 0 && (arg2.charAt(0) == '\'' || arg2.charAt(0) == '\"')) {
                arg2 = arg2.substring(1, arg2.length() - 1);
            }
            if (opcode.equals("equ")) {
                return arg1.equals(arg2) ? 1 : 0;
            }
            if (opcode.equals("neq")) {
                return arg1.equals(arg2) ? 0 : 1;
            }
        }
        if (opcode.equals("add")) {
            return args[0] + args[1];
        }
        if (opcode.equals("sub")) {
            return args[0] - args[1];
        }
        if (opcode.equals("mul")) {
            return args[0] * args[1];
        }
        if (opcode.equals("div")) {
            return args[0] / args[1];
        }
        if (opcode.equals("max")) {
            return Math.max(args[0], args[1]);
        }
        if (opcode.equals("min")) {
            return Math.min(args[0], args[1]);
        }
        if (opcode.equals("par")) {
            return args[0];
        }
        if (opcode.equals("abs")) {
            return Math.abs(args[0]);
        }
        if (opcode.equals("equ")) {
            return args[0] == args[1] ? 1 : 0;
        }
        if (opcode.equals("neq")) {
            return args[0] != args[1] ? 1 : 0;
        }
        if (opcode.equals("and")) {
            return args[0] > 0 && args[1] > 0 ? 1 : 0;
        }
        if (opcode.equals("orr")) {
            return args[0] > 0 || args[1] > 0 ? 1 : 0;
        }
        if (opcode.equals("grt")) {
            return args[0] > args[1] ? 1 : 0;
        }
        if (opcode.equals("les")) {
            return args[0] < args[1] ? 1 : 0;
        }
        return Integer.MAX_VALUE;
    }

    private static float solveFloat(char[] exp, int start, int end) throws Exception {
        if (Character.isDigit(exp[start])) {
            try {
                return Float.parseFloat(new String(exp, start, end - start));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (start + 3 >= exp.length || exp[start + 3] != '(') {
            return Float.MAX_VALUE;
        }
        String opcode = new String(exp, start, 3);
        int parCount = 0;
        int argCount = 1;
        int i = start + 4;
        while (i < end - 1) {
            if (exp[i] == ',') {
                if (parCount == 0) {
                    exp[i] = 4096;
                    ++argCount;
                }
            } else if (exp[i] == '(') {
                ++parCount;
            } else if (exp[i] == ')') {
                --parCount;
            }
            ++i;
        }
        float[] args = new float[argCount];
        int j = start + 4;
        int i2 = 0;
        while (i2 < argCount - 1) {
            int k = j;
            while (exp[k] != '\u1000') {
                ++k;
            }
            args[i2] = ExpressionSolver.solveFloat(exp, j, k);
            j = k + 1;
            ++i2;
        }
        args[argCount - 1] = ExpressionSolver.solveFloat(exp, j, end - 1);
        if (args.length > 1 && args[0] == Float.MAX_VALUE && args[1] == Float.MAX_VALUE) {
            String x = new String(exp, start + 4, end - start - 5);
            String arg1 = x.substring(0, x.indexOf(4096));
            String arg2 = x.substring(x.indexOf(4096) + 1);
            if (arg1.charAt(0) == '\'' || arg1.charAt(0) == '\"') {
                arg1 = arg1.substring(1, arg1.length() - 2);
            }
            if (arg2.charAt(0) == '\'' || arg2.charAt(0) == '\"') {
                arg2 = arg2.substring(1, arg2.length() - 2);
            }
            if (opcode.equals("equ")) {
                return arg1.equals(arg2) ? 1 : 0;
            }
            if (opcode.equals("neq")) {
                return !arg1.equals(arg2) ? 1 : 0;
            }
        }
        if (opcode.equals("add")) {
            return args[0] + args[1];
        }
        if (opcode.equals("sub")) {
            return args[0] - args[1];
        }
        if (opcode.equals("mul")) {
            return args[0] * args[1];
        }
        if (opcode.equals("div")) {
            return args[0] / args[1];
        }
        if (opcode.equals("max")) {
            return Math.max(args[0], args[1]);
        }
        if (opcode.equals("min")) {
            return Math.min(args[0], args[1]);
        }
        if (opcode.equals("par")) {
            return args[0];
        }
        if (opcode.equals("abs")) {
            return Math.abs(args[0]);
        }
        if (opcode.equals("equ")) {
            return args[0] == args[1] ? 1 : 0;
        }
        if (opcode.equals("neq")) {
            return args[0] != args[1] ? 1 : 0;
        }
        if (opcode.equals("and")) {
            return args[0] > 0.0f && args[1] > 0.0f ? 1 : 0;
        }
        if (opcode.equals("orr")) {
            return args[0] > 0.0f || args[1] > 0.0f ? 1 : 0;
        }
        return Float.MAX_VALUE;
    }
}

