/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigEntry;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigFile;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigRuntimeException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.PasswordUtil;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class ConfigMgr {
    private static Hashtable<String, ConfigFile> configFileTable = new Hashtable();
    private static ArrayList<String> configSearchPaths = new ArrayList();
    public static ConfigRuntimeException loadErrorsException = null;
    public static boolean autoSave = true;

    public static String[] getConfigSearchPaths() {
        return configSearchPaths.toArray(new String[configSearchPaths.size()]);
    }

    public static boolean isAutoSave() {
        return autoSave;
    }

    public static void setAutoSave(boolean b) {
        autoSave = b;
    }

    public static void load(String searchPath) throws ConfigRuntimeException {
        ArrayList<String> newSearchPaths = new ArrayList<String>();
        LinkedList<String> loadErrors = new LinkedList<String>();
        loadErrors.clear();
        if (searchPath == null || searchPath.equals("")) {
            loadErrors.add("Search path passed to ConfigMgr.load() was empty:  searchPath=[" + searchPath + "]");
        } else {
            StringTokenizer st = new StringTokenizer(searchPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                try {
                    String s;
                    File f = new File(token);
                    if (!f.exists() || newSearchPaths.contains(s = f.getCanonicalPath())) continue;
                    newSearchPaths.add(s);
                }
                catch (Exception e) {
                    throw new ConfigRuntimeException("Could not get canonical path for token [" + token + "].", e);
                }
            }
            boolean isSamePath = configSearchPaths.size() == newSearchPaths.size();
            int i = 0;
            while (i < configSearchPaths.size() && isSamePath) {
                if (!configSearchPaths.get(i).equalsIgnoreCase((String)newSearchPaths.get(i))) {
                    isSamePath = false;
                }
                ++i;
            }
            if (isSamePath) {
                return;
            }
            configSearchPaths = newSearchPaths;
            File configDir = null;
            for (String configDirPath : configSearchPaths) {
                configDir = new File(configDirPath);
                if (!configDir.exists()) continue;
                if (!configDir.canRead()) {
                    loadErrors.add("Search path passed to ConfigMgr.load() is not readable:  searchPath=[" + searchPath + "]");
                    continue;
                }
                File[] children = configDir.listFiles();
                int j = 0;
                while (j < children.length) {
                    File f = children[j];
                    if (f.isFile() && f.getAbsolutePath().toLowerCase().endsWith(".cfg")) {
                        ConfigFile cf = null;
                        try {
                            cf = new ConfigFile(f.getAbsolutePath());
                            cf.setAutoSave(ConfigMgr.isAutoSave());
                            if (!configFileTable.containsKey(cf.name)) {
                                configFileTable.put(cf.name, cf);
                            }
                        }
                        catch (ConfigRuntimeException e) {
                            loadErrors.addAll(e.getErrors());
                        }
                    }
                    ++j;
                }
            }
            for (ConfigFile cf : configFileTable.values()) {
                try {
                    cf.resolveAllValues();
                    if (!cf.isAutoSave()) continue;
                    cf.save();
                }
                catch (ConfigRuntimeException e) {
                    loadErrors.addAll(e.getErrors());
                }
            }
        }
        if (!loadErrors.isEmpty()) {
            loadErrorsException = new ConfigRuntimeException("Problems occurred while trying to load configuration files into memory. ", loadErrors);
        }
        if (loadErrorsException != null) {
            throw loadErrorsException;
        }
    }

    public static void reload() throws ConfigRuntimeException {
        String searchPath = StringUtils.join(configSearchPaths.toArray(), File.pathSeparator);
        configSearchPaths.clear();
        configFileTable.clear();
        ConfigMgr.load(searchPath);
    }

    public static void addPath(String searchPath) throws ConfigRuntimeException {
        ConfigMgr.load(String.valueOf(StringUtils.join(configSearchPaths.toArray(), File.pathSeparator)) + File.pathSeparator + searchPath);
    }

    public static void set(String key, String value, boolean createIfNotThere) throws ConfigRuntimeException {
        ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(key)).set(ConfigMgr.getLastTokens(key), value, createIfNotThere);
    }

    public static void set(String fileName, String key, String value, boolean createIfNotThere) throws ConfigRuntimeException {
        ConfigMgr.getConfigFile(fileName).set(key, value, createIfNotThere);
    }

    public static String getRawValue(String key) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(key)).getRawValue(ConfigMgr.getLastTokens(key));
    }

    public static String get(String key) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(key)).get(ConfigMgr.getLastTokens(key));
    }

    public static HashSet<String> getStringSet(String key) throws ConfigRuntimeException {
        return new HashSet<String>(Arrays.asList(StringUtils.split(ConfigMgr.get(key), ',')));
    }

    public static String get(String key, String defaultValue) {
        String rv = defaultValue;
        try {
            rv = ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(key)).get(ConfigMgr.getLastTokens(key), defaultValue);
            if (StringUtils.isEmpty(rv)) {
                rv = defaultValue;
            }
        }
        catch (ConfigRuntimeException e) {
            rv = defaultValue;
        }
        return rv;
    }

    public static String get(String key, Object[] args) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(key)).get(ConfigMgr.getLastTokens(key), args);
    }

    public static String get(String key, Object[] args, String defaultValue) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(key)).get(ConfigMgr.getLastTokens(key), args, defaultValue);
    }

    public static boolean getBoolean(String key) throws ConfigRuntimeException {
        String value = ConfigMgr.get(key);
        return ConfigMgr.testBooleanValue(value);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = ConfigMgr.get(key, String.valueOf(defaultValue));
        return ConfigMgr.testBooleanValue(value);
    }

    private static boolean testBooleanValue(String iValue) {
        boolean rc;
        if (iValue.length() == 0) {
            return false;
        }
        switch (iValue.charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                rc = true;
                break;
            }
            default: {
                rc = false;
            }
        }
        return rc;
    }

    public static long getTime(String key) throws ConfigRuntimeException {
        String s = ConfigMgr.get(key).toUpperCase();
        try {
            return StringUtils.parseTime(s);
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Invalid value for key [" + key + "].  " + e.getMessage());
        }
    }

    public static long getTime(String key, long defaultValue) {
        String value = ConfigMgr.get(key, null);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return StringUtils.parseTime(value);
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Invalid value for key [" + key + "].  " + e.getMessage());
        }
    }

    public static int getInt(String key) throws ConfigRuntimeException {
        String value = ConfigMgr.get(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ConfigRuntimeException("Can not return int value for key [" + key + "].  Value was [" + value + "].");
        }
    }

    public static int getInt(String key, int defaultValue) {
        String value = ConfigMgr.get(key, null);
        return StringUtils.getInt(value, defaultValue);
    }

    public static int[] getInts(String key) throws ConfigRuntimeException {
        try {
            return StringUtils.getInts(ConfigMgr.get(key));
        }
        catch (NumberFormatException e) {
            throw new ConfigRuntimeException("Cannot return value as int for key [" + key + "].  Value was [" + ConfigMgr.get(key) + "].");
        }
    }

    public static Set<String> getKeyNames(String key) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(key)).getKeyNamesInSection(ConfigMgr.getLastTokens(key));
    }

    public static boolean isEncoded(String fileName, String key) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(fileName).isEncoded(key);
    }

    public static boolean isEncoded(String key) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(key)).isEncoded(ConfigMgr.getLastTokens(key));
    }

    public static Hashtable<String, String> getSection(String key) throws ConfigRuntimeException {
        try {
            Map<String, ConfigEntry> m = ConfigMgr.getConfigFile((String)ConfigMgr.getFirstToken((String)key)).sectionValuesMap.get(ConfigMgr.getLastTokens(key));
            if (m == null) {
                throw new ConfigRuntimeException("Section not found for key [" + key + "].");
            }
            Hashtable<String, String> ht = new Hashtable<String, String>();
            for (ConfigEntry x : m.values()) {
                ht.put(x.propName, x.getValue());
            }
            return ht;
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Exception of type [" + e.getClass().getName() + "] " + "caught in method ConfigMgr.getSection() for key [" + key + "]", e);
        }
    }

    public static Map<String, String> getConfigMap(String config) throws ConfigRuntimeException {
        TreeMap<String, String> m = new TreeMap<String, String>();
        Map<String, ConfigEntry> valueMap = ConfigMgr.getConfigFile((String)config).allValuesMap;
        for (Map.Entry<String, ConfigEntry> e : valueMap.entrySet()) {
            m.put(e.getKey(), e.getValue().getValue());
        }
        return m;
    }

    public static void save() throws ConfigRuntimeException {
        for (ConfigFile f : configFileTable.values()) {
            f.save();
        }
    }

    public static void createBatchEnvFile(String configFileName, String batchFilePath, boolean includeConfigName, boolean verbose) throws ConfigRuntimeException {
        try {
            ConfigFile c = ConfigMgr.getConfigFile(configFileName);
            StringBuffer sb = new StringBuffer("echo off\r\n\r\n");
            sb.append("rem This file was automatically generated from the contents in the " + configFileName + ".cfg file\r\n\r\n");
            sb.append("rem version 2\r\n\r\n");
            if (configFileName.indexOf(46) > -1) {
                configFileName = configFileName.substring(0, configFileName.lastIndexOf(46));
            }
            Pattern p = Pattern.compile("(<|>|\\^|\\||&)");
            for (String sectionName : c.sectionList) {
                for (String line : c.sectionContents.get(sectionName)) {
                    if (line.length() > 0 && line.charAt(0) == '=') {
                        ConfigEntry ce = c.allValuesMap.get(line.substring(1));
                        String value = ce.getValue();
                        value = value.replace("%", "%%");
                        value = p.matcher(value).replaceAll("^$1");
                        if (ce.isEncoded) {
                            value = ce.getRawValue();
                        }
                        sb.append("set " + ce.configKey.replace('.', '_') + "=" + value + "\r\n");
                        continue;
                    }
                    sb.append("rem " + line + "\r\n");
                }
            }
            FileWriter fw = new FileWriter(batchFilePath);
            fw.write(sb.toString());
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Exception of type [" + e.getClass().getName() + "] " + "caught while trying to generate batch file [" + batchFilePath + "].");
        }
    }

    public static void createShellEnvFile(String configFileName, String batchFilePath, boolean includeConfigName, boolean verbose) throws ConfigRuntimeException {
        try {
            ConfigFile c = ConfigMgr.getConfigFile(configFileName);
            StringBuffer sb = new StringBuffer("#!/bin/sh\n\n");
            sb.append("# This file was automatically generated from the contents in the " + configFileName + ".cfg file\n\n");
            sb.append("# version 2\n\n");
            if (configFileName.indexOf(46) > -1) {
                configFileName = configFileName.substring(0, configFileName.lastIndexOf(46));
            }
            Pattern p = Pattern.compile("(`|\\\\)");
            for (String sectionName : c.sectionList) {
                for (String line : c.sectionContents.get(sectionName)) {
                    if (line.length() > 0 && line.charAt(0) == '=') {
                        ConfigEntry ce = c.allValuesMap.get(line.substring(1));
                        String value = ce.getValue();
                        value = p.matcher(value).replaceAll("\\\\$1");
                        if (ce.isEncoded) {
                            value = ce.getRawValue();
                        }
                        sb.append("export " + ce.configKey.replace('.', '_') + "=\"" + value + "\"\n");
                        continue;
                    }
                    sb.append(String.valueOf(line.startsWith("#") ? "" : "# ") + line + "\n");
                }
            }
            FileWriter fw = new FileWriter(batchFilePath);
            fw.write(sb.toString().toCharArray());
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Exception of type [" + e.getClass().getName() + "] " + "caught while trying to generate batch file [" + batchFilePath + "].");
        }
    }

    private static String replace(String s, String replace, String with) {
        int i = -1;
        while ((i = s.indexOf(replace, i + 1)) != -1) {
            s = String.valueOf(s.substring(0, i)) + with + s.substring(i += replace.length());
        }
        return s;
    }

    public static ConfigFile getConfigFile(String filename) throws ConfigRuntimeException {
        ConfigFile c;
        if (filename.indexOf(46) == -1) {
            filename = String.valueOf(filename) + ".cfg";
        }
        if (!configFileTable.containsKey(filename)) {
            boolean foundIt = false;
            Iterator<String> i = configSearchPaths.iterator();
            while (i.hasNext() && !foundIt) {
                String searchPath = i.next();
                File f = new File(String.valueOf(searchPath) + File.separator + filename);
                try {
                    if (!f.exists() || !f.getCanonicalFile().getName().equals(filename)) continue;
                    ConfigFile cf = new ConfigFile(f.getAbsolutePath());
                    cf.setAutoSave(ConfigMgr.isAutoSave());
                    configFileTable.put(filename, cf);
                    foundIt = true;
                }
                catch (Exception e) {
                    throw new ConfigRuntimeException("Unexpected exception caught in ConfigMgr.getConfigFile(" + filename + "):  msg=[" + e.getLocalizedMessage() + "]", e);
                }
            }
        }
        if ((c = configFileTable.get(filename)) == null) {
            throw new ConfigRuntimeException("Could not find configuration file [" + filename + "] " + "in search path [" + ConfigMgr.getSearchPath() + "]");
        }
        if (c.hasBeenModified && c.isAutoSave()) {
            try {
                c.save();
            }
            catch (ConfigRuntimeException e) {
                System.err.println("WARNING:  Could not save configuration file [" + filename + "].  File is read-only.  File may now contain unencoded passwords.");
                c.hasBeenModified = false;
            }
        }
        return c;
    }

    private static String getSearchPath() {
        String searchPath = "";
        int i = 0;
        while (i < configSearchPaths.size()) {
            searchPath = String.valueOf(searchPath) + configSearchPaths.get(i) + File.pathSeparator;
            ++i;
        }
        return searchPath;
    }

    public static Hashtable<String, String> getAllValues(boolean resolveValues) throws Exception {
        Hashtable<String, String> m = new Hashtable<String, String>();
        for (String f : configSearchPaths) {
            File dir = new File(f);
            if (!dir.exists() || !dir.isDirectory()) continue;
            String[] files = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith("cfg");
                }
            });
            int j = 0;
            while (j < files.length) {
                ConfigFile c = ConfigMgr.getConfigFile(files[j]);
                String configName = files[j].substring(0, files[j].indexOf(46));
                String secretKey = null;
                for (Map.Entry<String, ConfigEntry> e : c.allValuesMap.entrySet()) {
                    ConfigEntry ce = e.getValue();
                    String value = null;
                    if (resolveValues) {
                        value = ce.getValue();
                    } else {
                        if (ce.isEncoded && secretKey == null) {
                            secretKey = PasswordUtil.getSecretKeyFromKeyStore(new File(c.configFilePath).getParent(), "aGwdHmobGmdnaB4bZxxqaG1oGmgZaG0ebx1pbGYcHGs=");
                        }
                        value = ce.isEncoded ? PasswordUtil.decode(ce.rawValue, secretKey) : ce.rawValue;
                    }
                    m.put(String.valueOf(configName) + "." + e.getKey(), value);
                }
                ++j;
            }
        }
        return m;
    }

    public static Hashtable<String, String> getAllValues() throws Exception {
        return ConfigMgr.getAllValues(true);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ConfigMgr.printUsageAndExit();
        }
        if (args[0].equals("setVals")) {
            String searchPath = null;
            LinkedList<String> commands = new LinkedList<String>();
            boolean verbose = false;
            int i = 1;
            while (i < args.length) {
                System.out.println("looking at arg [" + args[i] + "]");
                if (args[i].equals("-searchPath") && args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    searchPath = args[++i];
                } else if (args[i].equals("-vals")) {
                    StringBuffer sb = new StringBuffer();
                    while (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                        sb.append(String.valueOf(args[++i]) + " ");
                    }
                    String[] tokens = StringUtils.split(sb.toString());
                    int j = 0;
                    while (j < tokens.length) {
                        if (j % 2 == 1) {
                            commands.add(String.valueOf(tokens[j - 1]) + "=" + tokens[j]);
                        }
                        ++j;
                    }
                } else if (args[i].equals("-verbose")) {
                    verbose = true;
                }
                ++i;
            }
            if (searchPath == null || commands.size() == 0) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (verbose) {
                    System.out.println("Setting search path to [" + searchPath + "]");
                }
                ConfigMgr.load(searchPath);
                for (String s : commands) {
                    System.out.println("Command=[" + s + "]");
                    int eq = s.indexOf(61);
                    if (eq == -1) {
                        ConfigMgr.printUsageAndExit();
                    }
                    String var = s.substring(0, eq);
                    String val = s.substring(eq + 1);
                    if (verbose) {
                        System.out.println("Setting [" + var + "] to [" + val + "]");
                    }
                    ConfigMgr.set(var, val, false);
                }
                if (verbose) {
                    System.out.println("Saving...");
                }
                if (ConfigMgr.isAutoSave()) {
                    ConfigMgr.save();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (verbose) {
                System.out.println("Done.");
            }
        } else if (args[0].equals("createShellEnvFile") && args.length >= 3) {
            String searchPath = null;
            String configFile = null;
            String batchPathname = null;
            boolean verbose = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equals("-searchPath") && args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    searchPath = args[++i];
                } else if (args[i].equals("-configFile") && args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    configFile = args[++i];
                } else if (args[i].equals("-batchPathname") && args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    batchPathname = args[++i];
                } else if (args[i].equals("-verbose")) {
                    verbose = true;
                }
                ++i;
            }
            if (searchPath == null || configFile == null || batchPathname == null) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (verbose) {
                    System.out.println("creating shell script [" + batchPathname + "]...");
                }
                ConfigMgr.load(searchPath);
                ConfigMgr.createShellEnvFile(configFile, batchPathname, false, verbose);
                if (verbose) {
                    System.out.println("Done.");
                }
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else if (args[0].equals("createBatchEnvFile") && args.length >= 3) {
            String searchPath = null;
            String configFile = null;
            String batchPathname = null;
            boolean verbose = false;
            int i = 1;
            while (i < args.length) {
                if (args[i].equals("-searchPath") && args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    searchPath = args[++i];
                } else if (args[i].equals("-configFile") && args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    configFile = args[++i];
                } else if (args[i].equals("-batchPathname") && args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    batchPathname = args[++i];
                } else if (args[i].equals("-verbose")) {
                    verbose = true;
                }
                ++i;
            }
            if (searchPath == null || configFile == null || batchPathname == null) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (verbose) {
                    System.out.println("creating batch file [" + batchPathname + "]...");
                }
                ConfigMgr.load(searchPath);
                ConfigMgr.createBatchEnvFile(configFile, batchPathname, false, verbose);
                if (verbose) {
                    System.out.println("Done.");
                }
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            ConfigMgr.printUsageAndExit();
        }
    }

    public static void printUsageAndExit() {
        System.err.println("---Usage---");
        System.err.println("java -jar ConfigMgr.jar createBatchEnvFile -searchPath <searchPath> -configFile <configFile> -batchPathname <batchFilePath> [-verbose]");
        System.err.println("java -jar ConfigMgr.jar createShellEnvFile -searchPath <searchPath> -configFile <configFile> -batchPathname <batchFilePath> [-verbose]");
        System.err.println("java -jar ConfigMgr.jar setVals -searchPath <searchPath> -vals [var1 val1 [var2 val2...]] [-verbose]");
        System.exit(2);
    }

    private static String getFirstToken(String s) throws ConfigRuntimeException {
        if (s.indexOf(46) == -1) {
            throw new ConfigRuntimeException("Invalid config key [" + s + "].  " + "Must be of the format [config.key] or [config.section.key]");
        }
        return s.substring(0, s.indexOf(46));
    }

    private static String getLastTokens(String s) throws ConfigRuntimeException {
        if (s.indexOf(46) == -1) {
            throw new ConfigRuntimeException("Invalid config key [" + s + "].  " + "Must be of the format [config.key] or [config.section.key]");
        }
        return s.substring(s.indexOf(46) + 1);
    }

    private static String checkConfigPath(String iPath) {
        if (StringUtils.isEmpty(iPath)) {
            return null;
        }
        File f = new File(String.valueOf(iPath) + "\\Common.cfg");
        if (!f.exists() || !f.canRead()) {
            return null;
        }
        return f.getParent();
    }

    public static String getConfigPath() throws FileNotFoundException {
        String configPath = ConfigMgr.checkConfigPath(System.getProperty("wsaaConfig"));
        if (configPath != null) {
            return configPath;
        }
        configPath = ConfigMgr.checkConfigPath(System.getenv("WSAA_CONFIG"));
        if (configPath != null) {
            return configPath;
        }
        configPath = ConfigMgr.checkConfigPath(String.valueOf(System.getenv("WSAA_HOME")) + "\\config");
        if (configPath == null) {
            throw new FileNotFoundException("Common.cfg");
        }
        return configPath;
    }
}

