/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr;

import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigFile;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigMgr;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ConfigRuntimeException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.ExpressionSolver;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.PasswordUtil;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.cfgmgr.SecurityException;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.util.StringUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public class ConfigEntry {
    ConfigFile configFile;
    String rawValue;
    String resolvedValue;
    String sectionName;
    String propName;
    String configKey;
    boolean isEncoded;
    MessageFormat messageFormat;
    private static String secretKey;

    public ConfigEntry(ConfigFile configFile, String sectionName, String propName, String rawValue, boolean isEncoded, int lineNum) throws ConfigRuntimeException {
        this.configFile = configFile;
        this.sectionName = sectionName;
        this.propName = propName;
        this.configKey = String.valueOf(sectionName == null ? "" : String.valueOf(sectionName) + ".") + propName;
        this.rawValue = rawValue;
        this.isEncoded = isEncoded;
        if (isEncoded && !rawValue.startsWith(PasswordUtil.DEFAULT_CRYPTO_EYECATCHER)) {
            try {
                this.initializeSecurity();
                if (PasswordUtil.getCryptoAlgorithm(rawValue) != null) {
                    rawValue = PasswordUtil.decode(rawValue, this.getSecretKey());
                }
                this.rawValue = PasswordUtil.encode(rawValue, this.getSecretKey(), PasswordUtil.DEFAULT_CRYPTO_ALGORITHM);
            }
            catch (Exception e) {
                throw new ConfigRuntimeException("Could not encode value for prop [" + propName + "] at line [" + lineNum + "] of [" + configFile.name + "].  Msg=[" + e.getLocalizedMessage() + "]");
            }
            configFile.hasBeenModified = true;
        }
    }

    public String getRawValue() throws ConfigRuntimeException {
        return this.rawValue;
    }

    public String getValue() throws ConfigRuntimeException {
        if (this.resolvedValue == null) {
            this.resolveValue();
        }
        return this.resolvedValue;
    }

    public String getValue(Object[] args) throws ConfigRuntimeException {
        if (this.resolvedValue == null) {
            this.resolveValue();
        }
        if (this.messageFormat != null) {
            return this.messageFormat.format(args);
        }
        return this.resolvedValue;
    }

    private void resolveValue() throws ConfigRuntimeException {
        int i;
        String expr;
        int i1;
        String s = this.rawValue;
        if (this.isEncoded) {
            try {
                this.initializeSecurity();
                s = PasswordUtil.decode(s, this.getSecretKey());
            }
            catch (Throwable e) {
                throw new ConfigRuntimeException("Could not decode property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + e.getLocalizedMessage() + "]", e);
            }
        }
        int i2 = 0;
        while ((i1 = s.indexOf("$C{", i2)) != -1) {
            String x2;
            i2 = s.indexOf(125, i1);
            String varName = s.substring(i1 + 3, s.indexOf(125, i1));
            String string = x2 = varName.startsWith("this.") ? this.configFile.get(varName.substring(5)) : ConfigMgr.get(varName, null);
            if (x2 != null) {
                s = String.valueOf(s.substring(0, i1)) + x2 + s.substring(i2 + 1);
            }
            i2 = i1 + 1;
        }
        i2 = 0;
        while ((i1 = s.indexOf("$L{", i2)) != -1 && this.configFile.resourceBundle != null) {
            i2 = s.indexOf(125, i1);
            String x = null;
            try {
                x = this.configFile.resourceBundle.getString(s.substring(i1 + 3, s.indexOf(125, i1)));
            }
            catch (MissingResourceException x2) {
                // empty catch block
            }
            if (x != null) {
                s = String.valueOf(s.substring(0, i1)) + x + s.substring(i2 + 1);
            }
            i2 = i1 + 1;
        }
        if (s.startsWith("math(")) {
            try {
                s = "" + ExpressionSolver.solveMath(s.substring(5, s.lastIndexOf(41)));
            }
            catch (Exception e) {
                throw new ConfigRuntimeException("Math error encountered trying to solve property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + e.getLocalizedMessage() + "]", e);
            }
        }
        if (s.startsWith("mathf(")) {
            try {
                expr = s.substring(6, s.lastIndexOf(41));
                float f = ExpressionSolver.solveFloatMath(expr);
                String fs = Float.toString(f);
                s = fs.indexOf(69) != -1 ? fs : ((i = fs.indexOf(46)) == -1 ? fs : fs.substring(0, i));
            }
            catch (Exception e) {
                throw new ConfigRuntimeException("Math error encountered trying to solve property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + e.getLocalizedMessage() + "]", e);
            }
        }
        if (s.startsWith("case(")) {
            try {
                expr = s.substring(5, s.lastIndexOf(41));
                String[] parts = StringUtils.split(expr, ',');
                boolean foundMatch = false;
                i = 0;
                while (i < parts.length - 1 && !foundMatch) {
                    String p = parts[i];
                    int x = p.indexOf(61);
                    String boolExpr = p.substring(0, x - 1).trim();
                    String valExpr = p.substring(x + 1).trim();
                    if (ExpressionSolver.solveBoolean(boolExpr)) {
                        foundMatch = true;
                        s = "" + ExpressionSolver.solveMath(valExpr);
                    }
                    ++i;
                }
                if (!foundMatch) {
                    s = "" + ExpressionSolver.solveMath(parts[parts.length - 1]);
                }
            }
            catch (Exception e) {
                throw new ConfigRuntimeException("Math error encountered trying to solve property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + e.getLocalizedMessage() + "]", e);
            }
        }
        this.resolvedValue = s;
        if (s.indexOf("{0") != -1) {
            this.messageFormat = new MessageFormat(s);
        }
    }

    public void setValue(String value) throws ConfigRuntimeException {
        if (this.isEncoded && !value.startsWith(PasswordUtil.DEFAULT_CRYPTO_EYECATCHER)) {
            try {
                this.initializeSecurity();
                if (PasswordUtil.getCryptoAlgorithm(value) != null) {
                    value = PasswordUtil.decode(value, this.getSecretKey());
                }
                value = PasswordUtil.encode(value, this.getSecretKey(), PasswordUtil.DEFAULT_CRYPTO_ALGORITHM);
            }
            catch (Exception e) {
                throw new ConfigRuntimeException("Could not encode value for property [" + this.configKey + "] in file [" + this.configFile.name + "].  msg=[" + e.getMessage() + "]", e);
            }
        }
        if (!value.equals(this.rawValue)) {
            this.rawValue = value;
            this.configFile.hasBeenModified = true;
        }
        this.resolvedValue = null;
    }

    private String getSecretKey() {
        return secretKey;
    }

    private void setSecretKey(String iSecretKey) {
        secretKey = iSecretKey;
    }

    private void initializeSecurity() throws SecurityException {
        if (secretKey == null) {
            this.setSecretKey(PasswordUtil.getSecretKeyFromKeyStore(new File(this.configFile.configFilePath).getParent(), "aGwdHmobGmdnaB4bZxxqaG1oGmgZaG0ebx1pbGYcHGs="));
        }
    }
}

