/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.dmh;

import com.ibm.team.enterprise.metadata.common.scanner.IMetadataScanner;
import com.ibm.team.enterprise.metadata.common.scanner.IMetadataValueType;
import com.ibm.team.enterprise.metadata.common.scanner.IScannerData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.metadata.ScannerData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ClassifierMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.Dmh5210;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.IncludedFileMetaData;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.ScanProperties;
import com.ibm.team.enterprise.zos.metadata.common.classify.dmh.scan.classify.SingleFilesMetadata;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClassifyFileContent
implements IMetadataScanner {
    public static final String[] versionTokens = new String[]{"V6.1.0.23", "100425"};
    HashMap<String, IMetadataValueType> generalMetadataTypes = null;
    int debug = 0;
    String containerName = "";
    String fileContent = "";
    String fileName = "";

    public String getFilesMetadata(String containerName, String fileName, String fileContent, InputStream inputStream, ScanProperties scanProperties) {
        if (this.debug == 1 || this.debug == 2) {
            System.out.println("\nAsset: " + containerName + "(" + fileName + ")");
        }
        Dmh5210 dmh52102 = new Dmh5210();
        dmh52102.init(scanProperties);
        dmh52102.setDebug(this.debug);
        dmh52102.ProcessSingleFile(null, null, null, containerName, fileName, null, fileContent, inputStream);
        String jsonResponseFormat = scanProperties == null ? "" : scanProperties.getJsonResponseFormat();
        Map<String, Object> attributes = dmh52102.gatherAllAttributes(jsonResponseFormat);
        String metaData = dmh52102.generateJsonOutput(jsonResponseFormat, attributes);
        if (this.debug == 1 || this.debug == 2) {
            System.out.println(metaData);
        }
        return metaData;
    }

    public String getFilesMetadata(String containerName, String fileName, String fileContent) {
        return this.getFilesMetadata(containerName, fileName, fileContent, null, null);
    }

    public String getFilesMetadata(String containerName, String fileName) {
        return this.getFilesMetadata(containerName, fileName, null, null, null);
    }

    public String getFilesMetadata(String fileContent) {
        return this.getFilesMetadata(null, null, fileContent, null, null);
    }

    public String getFilesMetadata(InputStream inputStream) {
        return this.getFilesMetadata(null, null, null, inputStream, null);
    }

    private String getFileTypeCd(String containerName, String fileName, String fileContent, InputStream inputStream, ScanProperties scanProperties) {
        Dmh5210 dmh52102 = new Dmh5210();
        dmh52102.init(scanProperties);
        dmh52102.setDebug(this.debug);
        dmh52102.ProcessSingleFile(null, null, null, containerName, fileName, null, fileContent, inputStream);
        return dmh52102.getFileTypeCd();
    }

    public String getFileTypeCd(String containerName, String fileName) {
        return this.getFileTypeCd(containerName, fileName, null, null, null);
    }

    public String getFileTypeCd(String containerName, String fileName, ScanProperties scanProperties) {
        return this.getFileTypeCd(containerName, fileName, null, null, scanProperties);
    }

    public String getFileTypeCd(String fileContent) {
        return this.getFileTypeCd(null, null, fileContent, null, null);
    }

    public String getFileTypeCd(String fileContent, ScanProperties scanProperties) {
        return this.getFileTypeCd(null, null, fileContent, null, scanProperties);
    }

    public String getFileTypeCd(InputStream inputStream) {
        return this.getFileTypeCd(null, null, null, inputStream, null);
    }

    public String getFileTypeCd(InputStream inputStream, ScanProperties scanProperties) {
        return this.getFileTypeCd(null, null, null, inputStream, scanProperties);
    }

    @Override
    public Map<String, IMetadataValueType> getGeneralMetadataTypes() {
        if (this.generalMetadataTypes != null) {
            return this.generalMetadataTypes;
        }
        this.generalMetadataTypes = new HashMap();
        this.generalMetadataTypes.put("blankLines", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("callAERTDLI", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("callCBLTDLI", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("commentLines", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("copyReplacing", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("CSECT", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("dataDivision", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("DFHMSD", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("ENTRY", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("environmentDivision", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("execCICS", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("execPgm", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("execStmt", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("execSQL", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("identificationDivision", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("jobCard", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("nonCommentAfter1st", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("nonCommentBefore1st", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("nonCommentLines", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("OPTIONS", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("procedureDivision", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("recordCount", IMetadataValueType.NUMBER);
        this.generalMetadataTypes.put("splittingNodes", IMetadataValueType.NUMBER);
        return this.generalMetadataTypes;
    }

    private String getLanguageCd(String containerName, String fileName, String fileContent, InputStream inputStream, ScanProperties scanProperties) {
        Dmh5210 dmh52102 = new Dmh5210();
        dmh52102.init(scanProperties);
        dmh52102.setDebug(this.debug);
        dmh52102.ProcessSingleFile(null, null, null, containerName, fileName, null, fileContent, inputStream);
        return dmh52102.getLanguageCd();
    }

    public String getLanguageCd(String containerName, String fileName) {
        return this.getLanguageCd(containerName, fileName, null, null, null);
    }

    public String getLanguageCd(String containerName, String fileName, ScanProperties scanProperties) {
        return this.getLanguageCd(containerName, fileName, null, null, scanProperties);
    }

    public String getLanguageCd(String fileContent) {
        return this.getLanguageCd(null, null, fileContent, null, null);
    }

    public String getLanguageCd(String fileContent, ScanProperties scanProperties) {
        return this.getLanguageCd(null, null, fileContent, null, scanProperties);
    }

    public String getLanguageCd(InputStream inputStream) {
        return this.getLanguageCd(null, null, null, inputStream, null);
    }

    public String getLanguageCd(InputStream inputStream, ScanProperties scanProperties) {
        return this.getLanguageCd(null, null, null, inputStream, scanProperties);
    }

    @Override
    public IScannerData scan(InputStream inputStream, Map<String, String> properties) {
        ScanProperties scanProperties = new ScanProperties();
        if (properties != null) {
            String scannedFileAllowIncludeInAnyColumn = properties.get("scanned.file.allowIncludeInAnyColumn");
            scanProperties.setAllowIncludeInAnyColumn(scannedFileAllowIncludeInAnyColumn);
            String scannedFileCaptureComments = properties.get("scanned.file.capture.comments");
            scanProperties.setCaptureComments(scannedFileCaptureComments);
            String scannedFileCaptureEntryPoints = properties.get("scanned.file.capture.entry.points");
            scanProperties.setCaptureEntryPoints(scannedFileCaptureEntryPoints);
            String scannedFileCaptureExecStatements = properties.get("scanned.file.capture.exec.statements");
            scanProperties.setCaptureExecStatements(scannedFileCaptureExecStatements);
            String scannedFileCaptureLiterals = properties.get("scanned.file.capture.literals");
            scanProperties.setCaptureLiterals(scannedFileCaptureLiterals);
            String scannedFileCapturePictures = properties.get("scanned.file.capture.pictures");
            scanProperties.setCapturePictures(scannedFileCapturePictures);
            String scannedFileCaptureSymbolsReserved = properties.get("scanned.file.capture.symbols.reserved");
            scanProperties.setCaptureSymbolsReserved(scannedFileCaptureSymbolsReserved);
            String scannedFileCaptureSymbolsUserDefined = properties.get("scanned.file.capture.symbols.user.defined");
            scanProperties.setCaptureSymbolsUserDefined(scannedFileCaptureSymbolsUserDefined);
            String scannedFileCodePage = properties.get("scanned.file.code.page");
            scanProperties.setCodePage(scannedFileCodePage);
            String scannedFileExpandIncludeInComment = properties.get("scanned.file.expandIncludeInComment");
            scanProperties.setExpandIncludeInComment(scannedFileExpandIncludeInComment);
            String scannedFileFreeFormatCobol = properties.get("scanned.file.freeFormatCobol");
            scanProperties.setFreeFormatCobol(scannedFileFreeFormatCobol);
            String scannedFileLanguageHint = properties.get("scanned.file.language.hint");
            scanProperties.setLanguageHint(scannedFileLanguageHint);
            String scannedFileNLSCharacters = properties.get("scanned.file.mvs.codepage.nls.characters");
            scanProperties.setMvsCodePage(scannedFileNLSCharacters);
            String scannedFileReportNetViewMacros = properties.get("scanned.file.report.net.view.macros");
            scanProperties.setReportNetViewMacros(scannedFileReportNetViewMacros);
            String scannedFileTruncateFilenames = properties.get("scanned.file.truncate.filenames");
            scanProperties.setTruncateFilenames(scannedFileTruncateFilenames);
        }
        Dmh5210 dmh52102 = new Dmh5210();
        dmh52102.init(scanProperties);
        dmh52102.setDebug(this.debug);
        SingleFilesMetadata file = dmh52102.processSingleFile(inputStream);
        return this.generateScannerData(file);
    }

    private ScannerData generateScannerData(SingleFilesMetadata file) {
        ScannerData scannerData = new ScannerData();
        ClassifierMetaData metaData = file.getMetaData();
        scannerData.setLanguage(file.getLanguageCd());
        scannerData.setFileType(file.getFileTypeCd());
        this.gatherNumericAttributes(metaData, scannerData);
        this.gatherCharacterAttributes(metaData, scannerData);
        this.gatherControlTransfers(metaData, scannerData);
        this.gatherIncludeFileReferences(metaData, scannerData);
        this.gatherCicsMapsetReferences(metaData, scannerData);
        return scannerData;
    }

    private void gatherCharacterAttributes(ClassifierMetaData metaData, ScannerData scannerData) {
        Map<Integer, String> attcList = metaData.getAttcList();
        if (attcList == null) {
            return;
        }
        Set<Integer> keys = attcList.keySet();
        for (Integer key : keys) {
            String attrName = Dmh5210.getCharacterAttrName(key);
            scannerData.addGeneralProperty(attrName, attcList.get(key));
        }
    }

    private void gatherCicsMapsetReferences(ClassifierMetaData metaData, ScannerData scannerData) {
        Map<String, Set<String>> mapSetList = metaData.getMapSetList();
        if (mapSetList == null) {
            return;
        }
        boolean firstMapSet = true;
        String currentMapSetName = "";
        Set<String> mapSetNames = mapSetList.keySet();
        for (String mapSetName : mapSetNames) {
            Set<String> mapNames = mapSetList.get(mapSetName);
            for (String mapName : mapNames) {
                if (mapSetName.length() == 0) {
                    mapSetName = mapName;
                }
                if (firstMapSet) {
                    firstMapSet = false;
                    currentMapSetName = mapSetName;
                    continue;
                }
                if (mapSetName.equals(currentMapSetName)) continue;
                currentMapSetName = mapSetName;
            }
        }
    }

    private void gatherControlTransfers(ClassifierMetaData metaData, ScannerData scannerData) {
        Map<String, Set<String>> controlTransfers = metaData.getControlTransfers();
        if (controlTransfers == null) {
            return;
        }
        Set<String> types = controlTransfers.keySet();
        for (String type : types) {
            Set<String> targets = controlTransfers.get(type);
            for (String target : targets) {
                scannerData.addDependencyData(target, type, "MAIN", null, true);
            }
        }
    }

    private void gatherIncludeFileReferences(ClassifierMetaData metaData, ScannerData scannerData) {
        Map<Integer, Map<String, Integer>> inclList = metaData.getInclList();
        if (inclList == null) {
            return;
        }
        Set<Integer> inclTypeIds = inclList.keySet();
        for (Integer inclTypeId : inclTypeIds) {
            Set<String> inclNames = inclList.get(inclTypeId).keySet();
            for (String inclName : inclNames) {
                IncludedFileMetaData includedFileMetaData = Dmh5210.decodeInclData(inclTypeId, inclName);
                String mdInclName = includedFileMetaData.getInclName();
                String mdType = includedFileMetaData.getType();
                String mdFileTypeCd = includedFileMetaData.getFileTypeCd();
                String mdDdName = includedFileMetaData.getDdName();
                scannerData.addDependencyData(mdInclName, mdType, mdFileTypeCd, mdDdName);
            }
        }
    }

    private void gatherNumericAttributes(ClassifierMetaData metaData, ScannerData scannerData) {
        Map<Integer, Integer> attnList = metaData.getAttnList();
        if (attnList == null) {
            return;
        }
        Set<Integer> keys = attnList.keySet();
        for (Integer key : keys) {
            String attrName = Dmh5210.getNumericAttrName(key, metaData.getLanguageCd());
            scannerData.addGeneralProperty(attrName, attnList.get(key));
        }
    }

    public void setDebug(int setting) {
        this.debug = setting;
    }
}

