/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.metadata.common.classify.cfgmgr;

import com.ibm.team.enterprise.zos.metadata.common.classify.cfgmgr.ConfigEntry;
import com.ibm.team.enterprise.zos.metadata.common.classify.cfgmgr.ConfigRuntimeException;
import com.ibm.team.enterprise.zos.metadata.common.classify.utils.LocaleMgr;
import com.ibm.team.enterprise.zos.metadata.common.classify.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ConfigFile {
    protected Map<String, List<String>> sectionContents = new LinkedHashMap<String, List<String>>();
    protected LinkedList<String> sectionList = new LinkedList();
    public LinkedList<String> loadErrors = new LinkedList();
    private final String configFilePath;
    public String name;
    protected boolean hasBeenModified = false;
    protected ResourceBundle resourceBundle;
    protected Map<String, ConfigEntry> allValuesMap = new LinkedHashMap<String, ConfigEntry>();
    protected Map<String, Map<String, ConfigEntry>> sectionValuesMap = new LinkedHashMap<String, Map<String, ConfigEntry>>();

    public ConfigFile(String configFilePath) throws ConfigRuntimeException {
        this.configFilePath = configFilePath;
        this.name = ConfigFile.getFileName(configFilePath);
        this.readFile(configFilePath);
        if (!this.loadErrors.isEmpty()) {
            throw new ConfigRuntimeException("Errors occurred while trying to load config file [" + this.name + "].", this.loadErrors);
        }
    }

    public ConfigFile(String configFilePath, boolean createIfNotExists) throws ConfigRuntimeException {
        this.configFilePath = configFilePath;
        this.name = ConfigFile.getFileName(configFilePath);
        File f = new File(configFilePath);
        if (!f.exists() && createIfNotExists) {
            this.readReader(new BufferedReader(new StringReader("")), configFilePath);
        } else {
            this.readFile(configFilePath);
        }
        if (!this.loadErrors.isEmpty()) {
            throw new ConfigRuntimeException("Errors occurred while trying to load config file [" + this.name + "].", this.loadErrors);
        }
    }

    public ConfigFile(DataInputStream in) throws ConfigRuntimeException {
        this.configFilePath = null;
        this.name = null;
        this.readReader(new BufferedReader(new InputStreamReader(in)), null);
        if (!this.loadErrors.isEmpty()) {
            throw new ConfigRuntimeException("Errors occurred while trying to load config file [" + this.name + "].", this.loadErrors);
        }
    }

    public ConfigFile() {
        this.configFilePath = null;
        this.name = null;
    }

    public void resolveAllValues() throws ConfigRuntimeException {
        LinkedList<String> errors = new LinkedList<String>();
        for (String key : this.allValuesMap.keySet()) {
            ConfigEntry ce = this.allValuesMap.get(key);
            try {
                ce.getValue();
            }
            catch (ConfigRuntimeException e) {
                errors.add(e.getLocalizedMessage());
            }
        }
        if (!errors.isEmpty()) {
            throw new ConfigRuntimeException("Errors occurred while trying to resolve all values in config file [" + this.name + "].", errors);
        }
    }

    private void readFile(String configFilePath) {
        BufferedReader br = null;
        File f = new File(configFilePath);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (IOException e) {
            this.loadErrors.add("Could not create config file on filesystem:  [" + configFilePath + "], msg=[" + e.getLocalizedMessage() + "]");
            return;
        }
        try {
            this.resourceBundle = LocaleMgr.getResourceBundle(f.getAbsolutePath(), null);
        }
        catch (IOException e) {
            this.loadErrors.add("Could not load resource bundle for config file.  configFilePath=[" + configFilePath + "], msg=[" + e.getLocalizedMessage() + "]");
        }
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), LocaleMgr.getExternalDefaultEncoding()));
            this.readReader(br, configFilePath);
            br.close();
        }
        catch (UnsupportedEncodingException e) {
            this.loadErrors.add("Unsupported encoding exception caught trying to load config file.  configFilePath=[" + configFilePath + "], encoding=[" + LocaleMgr.getExternalDefaultEncoding() + "], msg=[" + e.getLocalizedMessage() + "]");
        }
        catch (FileNotFoundException e) {
            this.loadErrors.add("Could not find config file.  configFilePath=[" + configFilePath + "], msg=[" + e.getLocalizedMessage() + "]");
        }
        catch (IOException e) {
            this.loadErrors.add("Error occurred while trying to close reader.  configFilePath=[" + configFilePath + "], msg=[" + e.getLocalizedMessage() + "]");
        }
    }

    private void readReader(BufferedReader brin, String fileName) {
        LinkedList<String> linesInSection = new LinkedList<String>();
        String currentSection = null;
        LinkedHashMap<String, ConfigEntry> currentSectionMap = new LinkedHashMap<String, ConfigEntry>();
        this.sectionValuesMap.put(currentSection, currentSectionMap);
        this.sectionList.add(null);
        this.sectionContents.put(null, linesInSection);
        String line = null;
        int lineNum = 0;
        try {
            while ((line = brin.readLine()) != null) {
                ++lineNum;
                if (!(line = line.trim()).startsWith("#")) {
                    int index;
                    if (line.startsWith("[")) {
                        index = line.indexOf("]");
                        if (index == -1) {
                            this.loadErrors.add("Missing ']' at line " + lineNum + " of config file [" + this.configFilePath + "]");
                            continue;
                        }
                        currentSection = line.substring(1, index).trim();
                        if (this.sectionValuesMap.containsKey(currentSection)) {
                            this.loadErrors.add("Duplicate sections [" + currentSection + "] defined in config file [" + this.configFilePath + "]");
                            continue;
                        }
                        currentSectionMap = new LinkedHashMap();
                        this.sectionValuesMap.put(currentSection, currentSectionMap);
                        this.sectionList.add(currentSection);
                        linesInSection = new LinkedList();
                        this.sectionContents.put(currentSection, linesInSection);
                    } else if (line.indexOf(61) != -1) {
                        boolean isEncoded;
                        index = line.indexOf(61);
                        String key = line.substring(0, index).trim();
                        String value = line.substring(index + 1).trim();
                        String nextLine = null;
                        while (value.endsWith("\\") && !value.endsWith("\\\\") && (nextLine = brin.readLine()) != null) {
                            value = String.valueOf(value.substring(0, value.length() - 1)) + nextLine.trim();
                        }
                        if (value.indexOf(92) != -1) {
                            value = StringUtils.unEscapeChars(value, new char[]{'\\'});
                        }
                        boolean bl = isEncoded = key.charAt(key.length() - 1) == '*';
                        if (isEncoded) {
                            key = key.substring(0, key.length() - 1);
                        }
                        ConfigEntry c = null;
                        try {
                            c = new ConfigEntry(this, currentSection, key, value, isEncoded, lineNum);
                            currentSectionMap.put(key, c);
                            this.allValuesMap.put(c.configKey, c);
                            line = "=" + c.configKey;
                        }
                        catch (ConfigRuntimeException e) {
                            this.loadErrors.add(e.getMessage());
                        }
                    }
                }
                linesInSection.addLast(line);
            }
        }
        catch (IOException e) {
            this.loadErrors.add("IOException [" + e.getLocalizedMessage() + "] caught at line [" + lineNum + "] while trying to read config file [" + this.configFilePath + "] at line [" + lineNum + "]");
        }
    }

    public synchronized String get(String key) throws ConfigRuntimeException {
        String value = this.get(key, null, null);
        if (value == null) {
            throw new ConfigRuntimeException("Key '" + key + "' not found in file '" + this.configFilePath + "'");
        }
        return value;
    }

    public synchronized String get(String key, Object[] args) throws ConfigRuntimeException {
        String value = this.get(key, args, null);
        if (value == null) {
            throw new ConfigRuntimeException("Key '" + key + "' not found in file '" + this.configFilePath + "'");
        }
        return value;
    }

    public synchronized String get(String key, String defaultValue) throws ConfigRuntimeException {
        return this.get(key, null, defaultValue);
    }

    public synchronized String get(String key, Object[] args, String defaultValue) throws ConfigRuntimeException {
        ConfigEntry c = this.allValuesMap.get(key);
        if (c == null) {
            return defaultValue;
        }
        try {
            if (args == null) {
                return c.getValue();
            }
            return c.getValue(args);
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Exception of type [" + e.getClass().getName() + "] " + "caught trying to retrieve value for [" + key + "] in config file [" + this.configFilePath + "]", e);
        }
    }

    public synchronized boolean isEncoded(String key) {
        ConfigEntry c = this.allValuesMap.get(key);
        return c == null ? false : c.isEncoded;
    }

    public synchronized void set(String key, String value, boolean createIfNotThere) throws ConfigRuntimeException {
        try {
            ConfigEntry c = this.allValuesMap.get(key);
            if (c == null && !createIfNotThere) {
                throw new ConfigRuntimeException("Key [" + key + "] not found in file [" + this.configFilePath + "]");
            }
            if (c == null) {
                String section = null;
                int index = key.indexOf(".");
                if (index != -1) {
                    section = key.substring(0, index);
                    key = key.substring(index + 1);
                }
                c = new ConfigEntry(this, section, key, value, false, 0);
                Map<String, ConfigEntry> m = this.sectionValuesMap.get(section);
                if (m == null) {
                    String lastLine;
                    m = new LinkedHashMap<String, ConfigEntry>();
                    this.sectionValuesMap.put(section, m);
                    String lastSection = this.sectionList.getLast();
                    LinkedList lastSectionContents = (LinkedList)this.sectionContents.get(lastSection);
                    String string = lastLine = lastSectionContents.isEmpty() ? "" : (String)lastSectionContents.getLast();
                    if (lastLine == null || !lastLine.trim().equals("")) {
                        lastSectionContents.addLast("");
                    }
                    this.sectionList.addLast(c.sectionName);
                    LinkedList<String> l = new LinkedList<String>();
                    l.addLast("[" + c.sectionName + "]");
                    this.sectionContents.put(c.sectionName, l);
                }
                m.put(c.propName, c);
                this.allValuesMap.put(c.configKey, c);
                LinkedList l = (LinkedList)this.sectionContents.get(c.sectionName);
                if (l.isEmpty()) {
                    l.add("");
                }
                if (((String)l.getLast()).equals("")) {
                    l.removeLast();
                }
                l.addLast("=" + c.configKey);
                l.addLast("");
            } else {
                c.setValue(value);
            }
            this.hasBeenModified = true;
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Exception of type [" + e.getClass().getName() + "] " + "caught trying to set value for [" + key + "] in config file [" + this.configFilePath + "]", e);
        }
    }

    public synchronized void remove(String key) throws ConfigRuntimeException {
        try {
            Map<String, ConfigEntry> m;
            ConfigEntry c = this.allValuesMap.get(key);
            if (c == null) {
                return;
            }
            this.allValuesMap.remove(key);
            String sectionName = null;
            String sectionKey = null;
            int index = key.indexOf(".");
            if (index != -1) {
                sectionName = key.substring(0, index);
                sectionKey = key.substring(index + 1);
            }
            if ((m = this.sectionValuesMap.get(sectionName)) != null) {
                m.remove(sectionKey);
                LinkedList l = (LinkedList)this.sectionContents.get(sectionName);
                int x = -1;
                int i = 0;
                while (i < l.size()) {
                    if (l.get(i).toString().equals("=" + key)) {
                        x = i;
                    }
                    ++i;
                }
                if (x != -1) {
                    l.remove(x);
                }
            }
            this.hasBeenModified = true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new ConfigRuntimeException("Exception of type [" + e.getClass().getName() + "] " + "caught trying to remove value for [" + key + "] in config file [" + this.configFilePath + "]", e);
        }
    }

    public synchronized Map<String, String> getSectionMap(String section) throws ConfigRuntimeException {
        Map<String, ConfigEntry> m;
        if (section.equals("")) {
            section = null;
        }
        if ((m = this.sectionValuesMap.get(section)) == null) {
            throw new ConfigRuntimeException("Section '" + section + "' not found in file '" + this.configFilePath + "'");
        }
        LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
        for (String key : m.keySet()) {
            ConfigEntry ce = m.get(key);
            newMap.put(key, ce.getValue());
        }
        return newMap;
    }

    public synchronized Set<String> getKeyNamesInSection(String section) throws ConfigRuntimeException {
        Map<String, ConfigEntry> m;
        if (section.equals("")) {
            section = null;
        }
        if ((m = this.sectionValuesMap.get(section)) == null) {
            throw new ConfigRuntimeException("Section '" + section + "' not found in file '" + this.configFilePath + "'");
        }
        return m.keySet();
    }

    public Map<String, ConfigEntry> getAllValuesMap() {
        return this.allValuesMap;
    }

    public synchronized Set<String> getKeyNames() {
        return this.allValuesMap.keySet();
    }

    public synchronized Set<String> getSectionNames() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        s.addAll(this.sectionValuesMap.keySet());
        s.remove(null);
        return s;
    }

    public synchronized void printOn(PrintWriter out) {
        for (String sectionName : this.sectionList) {
            List<String> sectionList = this.sectionContents.get(sectionName);
            for (String line : sectionList) {
                if (line.length() > 0 && line.charAt(0) == '=') {
                    ConfigEntry c = this.allValuesMap.get(line.substring(1));
                    if (c == null) {
                        System.err.println("ERROR: No config file entry for [" + line.substring(1) + "]");
                        continue;
                    }
                    String val = c.rawValue;
                    if (val.endsWith("\\")) {
                        val = String.valueOf(val) + "\\";
                    }
                    out.println(String.valueOf(c.propName) + (c.isEncoded ? "*" : "") + " = " + val);
                    continue;
                }
                out.println(line);
            }
        }
        out.flush();
    }

    public synchronized void save() throws ConfigRuntimeException {
        this.save(this.configFilePath);
    }

    public synchronized void save(String path) throws ConfigRuntimeException {
        if (!this.hasBeenModified) {
            return;
        }
        try (PrintWriter out = null;){
            try {
                File configFile = new File(path);
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), LocaleMgr.getExternalDefaultEncoding())));
                this.printOn(out);
                this.hasBeenModified = false;
            }
            catch (IOException ie) {
                throw new ConfigRuntimeException("Trouble saving configuration to file \"" + path + "\"", ie);
            }
        }
    }

    public synchronized String getContents() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printOn(pw);
        pw.flush();
        return sw.getBuffer().toString();
    }

    public synchronized String getLocation() {
        return this.configFilePath;
    }

    private static String getFileName(String path) {
        int i;
        if (path == null) {
            path = "";
        }
        if ((i = (path = path.replace('\\', '/')).lastIndexOf(47)) == -1) {
            return path;
        }
        return path.substring(i + 1);
    }

    public static void main(String[] args) {
    }
}

