/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.ISPARQLQuery;
import com.ibm.team.enterprise.metadata.query.common.Messages;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;

public class Term
implements ISPARQLQuery {
    private Statement parent;
    private Operator operator;
    private List<Expression> expressions;

    public Term(Statement parent, Operator operator) {
        this.parent = parent;
        this.operator = operator;
        this.expressions = new ArrayList<Expression>();
    }

    public void setParent(Statement statement) {
        this.parent = statement;
    }

    public Statement getParent() {
        return this.parent;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
        Expression expression = null;
        if (!this.expressions.isEmpty()) {
            expression = this.expressions.get(0);
        }
        this.parent.notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.TERM_OPERATOR_CHANGED, expression);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
        this.parent.notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.TERM_CONDITION_ADDED, expression);
    }

    public void removeExpression(Expression expression) {
        this.expressions.remove(expression);
        this.parent.notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.TERM_CONDITION_REMOVED, expression);
    }

    public void removeAllExpressions() {
        this.expressions.clear();
        this.parent.notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.TERM_CLEARED, null);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public String getSPARQLString() {
        StringBuffer buffer = new StringBuffer();
        if (this.operator == Operator.ALTERNATIVE && this.expressions.size() > 1) {
            int count = 0;
            for (Expression expression : this.expressions) {
                if (count == 0) {
                    buffer.append('{');
                } else {
                    buffer.append("UNION").append("    ").append('{');
                }
                buffer.append(expression.getSPARQLString());
                buffer.append("}\n");
                ++count;
            }
        } else {
            for (Expression expression : this.expressions) {
                buffer.append(expression.getSPARQLString()).append('\n');
            }
        }
        return buffer.toString();
    }

    public boolean hasExpression(UUID uuid) {
        for (Expression expression : this.expressions) {
            if (!(expression instanceof AttributeExpression) || !((AttributeExpression)expression).getAttribute().getAttributeId().equals((Object)uuid)) continue;
            return true;
        }
        return false;
    }

    public static enum Operator {
        GROUP("group", "Term_GROUP_LABEL", "Term_GROUP_DESCRIPTION"),
        OPTIONAL("optional", "Term_OPTIONAL_LABEL", "Term_OPTIONAL_DESCRIPTION"),
        ALTERNATIVE("alternative", "Term_ALTERNATIVE_LABEL", "Term_ALTERNATIVE_DESCRIPTION");

        private final String operatorName;
        private final String labelKey;
        private final String descriptionKey;

        private Operator(String operatorName, String labelKey, String descriptionKey) {
            this.operatorName = operatorName;
            this.labelKey = labelKey;
            this.descriptionKey = descriptionKey;
        }

        public String getLabel() {
            return Messages.getString(this.labelKey);
        }

        public String getDescription() {
            return Messages.getString(this.descriptionKey);
        }

        public String getOperatorName() {
            return this.operatorName;
        }
    }
}

