/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.team.enterprise.metadata.common.query.util.Util;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.AttributeSortColumn;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQueryChangeListener;
import com.ibm.team.enterprise.metadata.query.common.ISPARQLQuery;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Prefix;
import com.ibm.team.enterprise.metadata.query.common.SelectClause;
import com.ibm.team.enterprise.metadata.query.common.StreamScope;
import com.ibm.team.enterprise.metadata.query.common.Term;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Statement
implements ISPARQLQuery {
    private static Prefix scm = new Prefix("prefixScm", "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/");
    private static Prefix dep = new Prefix("prefixDep", "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/");
    private static Prefix def = new Prefix("prefixDef", "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scanner/default/");
    private static Prefix fn = new Prefix("fn", "http://www.w3.org/2005/xpath-functions#");
    private static Prefix xsd = new Prefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    private Term term;
    private SelectClause selectClause;
    private List<IMetadataQueryChangeListener> listeners;
    private List<Prefix> prefixes;
    private StreamScope streamScope;

    public Statement() {
        this.term = new Term(this, Term.Operator.GROUP);
        this.selectClause = new SelectClause(this, true);
        this.prefixes = new ArrayList<Prefix>();
        this.prefixes.add(scm);
        this.prefixes.add(dep);
        this.prefixes.add(def);
        this.prefixes.add(fn);
        this.prefixes.add(xsd);
        this.streamScope = new StreamScope(this);
    }

    public Statement(Term term) {
        this.term = term;
        this.term.setParent(this);
        this.selectClause = new SelectClause(this, true);
        this.streamScope = new StreamScope(this);
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public List<Prefix> getPrefixes() {
        return this.prefixes;
    }

    public void addPrefix(Prefix prefix) {
        for (Prefix next : this.prefixes) {
            if (!next.getName().equals(prefix.getName())) continue;
            return;
        }
        this.prefixes.add(prefix);
    }

    public String getPrefix(String namespace) {
        for (Prefix next : this.prefixes) {
            if (!next.getUri().equals(namespace)) continue;
            return next.getName();
        }
        return null;
    }

    public String getSPARQLStringFromBasicMode() {
        StringBuffer buffer = new StringBuffer();
        for (Prefix prefix : this.prefixes) {
            buffer.append(prefix.getSPARQLString()).append('\n');
        }
        boolean foundFilePathAttribute = false;
        boolean foundComponentIdAttribute = false;
        boolean foundStreamIdAttribute = false;
        boolean foundFileItemIdAttribute = false;
        StreamScope scope = this.getStreamScope();
        buffer.append("SELECT").append("    ").append('?').append("index").append("    ");
        buffer.append('?').append("streamResource").append("    ");
        List<AttributeColumn> columns = this.selectClause.getColumns();
        Iterator<AttributeColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String attributeIdentifier = iterator.next().getAttribute().getDisplayName();
            if (attributeIdentifier.equals("streamId")) {
                foundStreamIdAttribute = true;
                if (scope.isAllStreams()) {
                    buffer.append('?').append("streamId").append("    ");
                    continue;
                }
                buffer.append("(\"").append(scope.getStreamUUID()).append("\" AS ?").append("streamId").append(')').append("    ");
                continue;
            }
            buffer.append('?').append(attributeIdentifier).append("    ");
            if (attributeIdentifier.equals("filePath")) {
                foundFilePathAttribute = true;
                continue;
            }
            if (attributeIdentifier.equals("componentId")) {
                foundComponentIdAttribute = true;
                continue;
            }
            if (!attributeIdentifier.equals("fileItemId")) continue;
            foundFileItemIdAttribute = true;
        }
        if (!foundFilePathAttribute) {
            buffer.append('?').append("filePath").append("    ");
        }
        if (!foundComponentIdAttribute) {
            buffer.append('?').append("componentId").append("    ");
        }
        if (!foundStreamIdAttribute) {
            if (scope.isAllStreams()) {
                buffer.append('?').append("streamId").append("    ");
            } else {
                buffer.append("(\"").append(scope.getStreamUUID()).append("\" AS ?").append("streamId").append(')').append("    ");
            }
        }
        if (!foundFileItemIdAttribute) {
            buffer.append('?').append("fileItemId").append("    ");
        }
        buffer.append('\n');
        buffer.append("WHERE\n{\n");
        if (scope.isAllStreams()) {
            buffer.append("?streamResource prefixScm:fragment ?fragment.\n");
            buffer.append("?streamResource prefixScm:streamId ?streamId.\n");
        }
        buffer.append("GRAPH ?fragment \n");
        buffer.append(" {\n");
        if (this.term != null) {
            buffer.append(this.term.getSPARQLString());
        }
        List<Expression> expressions = this.term.getExpressions();
        for (Expression expression : expressions) {
            if (!(expression instanceof AttributeExpression)) continue;
            if (((AttributeExpression)expression).getAttribute().getDisplayName().equals("filePath")) {
                foundFilePathAttribute = true;
                continue;
            }
            if (((AttributeExpression)expression).getAttribute().getDisplayName().equals("componentId")) {
                foundComponentIdAttribute = true;
                continue;
            }
            if (((AttributeExpression)expression).getAttribute().getDisplayName().equals("streamId")) {
                foundStreamIdAttribute = true;
                continue;
            }
            if (!((AttributeExpression)expression).getAttribute().getDisplayName().equals("fileItemId")) continue;
            foundFileItemIdAttribute = true;
        }
        if (!foundFilePathAttribute) {
            this.addAttributeToWhereClause(buffer, "filePath");
        }
        if (!foundComponentIdAttribute) {
            this.addAttributeToWhereClause(buffer, "componentId");
        }
        if (!foundFileItemIdAttribute) {
            this.addAttributeToWhereClause(buffer, "fileItemId");
        }
        for (AttributeColumn col : columns) {
            if (col.getAttribute().getParent() == null) {
                buffer.append("OPTIONAL").append(" { ?").append("index").append("    ");
                String prefix = Util.getPredefinedPrefix(col.getAttribute().getNamespace(), this);
                if (prefix != null) {
                    buffer.append(prefix).append(':').append(col.getAttribute().getDisplayName());
                } else {
                    buffer.append('<').append(col.getAttribute().getNamespace());
                    if (!col.getAttribute().getNamespace().endsWith("/")) {
                        buffer.append('/');
                    }
                    buffer.append(col.getAttribute().getDisplayName()).append('>');
                }
                buffer.append("    ").append('?').append(col.getAttribute().getDisplayName()).append("    ").append(". }\n");
                continue;
            }
            buffer.append("OPTIONAL").append(" { ?").append("index").append("    ").append(col.getAttribute().getParent().getNamespace()).append(':');
            buffer.append(col.getAttribute().getParent().getDisplayName()).append("    ").append('?').append("index2").append("    ").append(".\n");
            buffer.append('?').append("index2").append("    ").append(col.getAttribute().getNamespace()).append(':');
            buffer.append(col.getAttribute().getDisplayName()).append("    ").append("    ").append('?');
            buffer.append(col.getAttribute().getDisplayName()).append("    ").append(". }\n");
        }
        buffer.append(" }\n");
        buffer.append("}\n");
        List<AttributeSortColumn> sortCols = this.selectClause.getSortColumns();
        if (sortCols.size() > 0) {
            buffer.append("ORDER BY ");
        }
        for (AttributeSortColumn sortCol : sortCols) {
            if (sortCol.getDirection() == AttributeSortColumn.Direction.ASCENDING) {
                buffer.append("ASC");
            } else {
                buffer.append("DESC");
            }
            buffer.append("(?").append(sortCol.getAttribute().getDisplayName()).append(") ");
        }
        buffer.append('\n');
        return buffer.toString();
    }

    private void addAttributeToWhereClause(StringBuffer buffer, String attributeName) {
        buffer.append("OPTIONAL").append(" { ?").append("index").append("    ");
        buffer.append("prefixScm").append(':').append(attributeName).append("    ");
        buffer.append('?').append(attributeName).append("    ").append(".}\n");
    }

    @Override
    public String getSPARQLString() {
        return this.getSPARQLStringFromBasicMode();
    }

    public void addListener(IMetadataQueryChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IMetadataQueryChangeListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IMetadataQueryChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyExpressionChanged(MetadataQueryChangeEvent.Type type, MetadataQueryChangeEvent.SubType subType, Expression expression) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<IMetadataQueryChangeListener> copyListeners = new ArrayList<IMetadataQueryChangeListener>(this.listeners);
        MetadataQueryChangeEvent event = new MetadataQueryChangeEvent(type, subType, expression);
        for (IMetadataQueryChangeListener listener : copyListeners) {
            listener.queryChanged(event);
        }
    }

    public void notifyStatementChange(MetadataQueryChangeEvent.Type type, MetadataQueryChangeEvent.SubType subType) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<IMetadataQueryChangeListener> copyListeners = new ArrayList<IMetadataQueryChangeListener>(this.listeners);
        MetadataQueryChangeEvent event = new MetadataQueryChangeEvent(type, subType, this);
        for (IMetadataQueryChangeListener listener : copyListeners) {
            listener.queryChanged(event);
        }
    }

    public void notifySortColumnChange(MetadataQueryChangeEvent.SubType subType, List<AttributeSortColumn> sortColumns) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<IMetadataQueryChangeListener> copyListeners = new ArrayList<IMetadataQueryChangeListener>(this.listeners);
        MetadataQueryChangeEvent event = new MetadataQueryChangeEvent(MetadataQueryChangeEvent.Type.SELECT_SORT_COLUMN_CHANGED, subType, this, sortColumns);
        for (IMetadataQueryChangeListener listener : copyListeners) {
            listener.queryChanged(event);
        }
    }

    public void notifyColumnChange(MetadataQueryChangeEvent.SubType subType, List<AttributeColumn> columns) {
        if (this.listeners == null) {
            return;
        }
        ArrayList<IMetadataQueryChangeListener> copyListeners = new ArrayList<IMetadataQueryChangeListener>(this.listeners);
        MetadataQueryChangeEvent event = new MetadataQueryChangeEvent(MetadataQueryChangeEvent.Type.SELECT_COLUMN_CHANGED, subType, this, columns);
        for (IMetadataQueryChangeListener listener : copyListeners) {
            listener.queryChanged(event);
        }
    }

    public void setStreamScope(StreamScope scope) {
        this.streamScope = scope;
        this.notifyStatementChange(MetadataQueryChangeEvent.Type.STREAM_SCOPE_CHANGED, null);
    }

    public StreamScope getStreamScope() {
        return this.streamScope;
    }

    public Statement newStatement() {
        try {
            return (Statement)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        Statement newStatement = new Statement();
        Term newTerm = new Term(newStatement, this.term.getOperator());
        for (Expression expression : this.term.getExpressions()) {
            AttributeExpression attrExpression = (AttributeExpression)expression;
            AttributeExpression newExpression = new AttributeExpression(newTerm, attrExpression.getAttribute().newAttribute(), attrExpression.getOperator());
            newExpression.setValue(attrExpression.getValue());
            newTerm.addExpression(newExpression);
        }
        newStatement.setTerm(newTerm);
        newStatement.setStreamScope(this.getStreamScope());
        return newStatement;
    }
}

