/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.team.enterprise.metadata.common.query.util.AttributeProviderFactory;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.AttributeSortColumn;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SelectClause {
    List<AttributeColumn> columns = new ArrayList<AttributeColumn>();
    List<AttributeSortColumn> sortColumns = new ArrayList<AttributeSortColumn>();
    private Statement statement;

    public SelectClause(Statement statement, boolean newSelect) {
        this.statement = statement;
        if (newSelect) {
            this.columns.addAll(AttributeProviderFactory.getInstance().getDefaultAttributeColumns());
            this.sortColumns.addAll(AttributeProviderFactory.getInstance().getDefaultAttributeSortColumns());
        }
    }

    public List<AttributeColumn> getColumns() {
        return this.columns;
    }

    public List<AttributeSortColumn> getSortColumns() {
        return this.sortColumns;
    }

    public void addColumn(AttributeColumn col) {
        ArrayList<AttributeColumn> cols = new ArrayList<AttributeColumn>(1);
        if (!this.columns.contains(col)) {
            col.setSelectClause(this);
            this.columns.add(col);
            this.statement.notifyColumnChange(MetadataQueryChangeEvent.SubType.COLUMN_ADDED, cols);
        }
    }

    public void addSortColumn(AttributeSortColumn col) {
        ArrayList<AttributeSortColumn> cols = new ArrayList<AttributeSortColumn>(1);
        if (!this.sortColumns.contains(col)) {
            col.setSelectClause(this);
            this.sortColumns.add(col);
            this.statement.notifySortColumnChange(MetadataQueryChangeEvent.SubType.SORT_COLUMN_ADDED, cols);
        }
    }

    public void addColumns(List<AttributeColumn> cols) {
        ArrayList<AttributeColumn> addedCols = new ArrayList<AttributeColumn>(cols.size());
        for (AttributeColumn col : cols) {
            if (this.columns.contains(col)) continue;
            col.setSelectClause(this);
            this.columns.add(col);
            addedCols.add(col);
        }
        if (addedCols.size() > 0) {
            this.statement.notifyColumnChange(MetadataQueryChangeEvent.SubType.COLUMN_ADDED, addedCols);
        }
    }

    public void addSortColumns(List<AttributeSortColumn> cols) {
        ArrayList<AttributeSortColumn> sortCols = new ArrayList<AttributeSortColumn>(cols.size());
        for (AttributeSortColumn col : cols) {
            if (this.sortColumns.contains(col)) continue;
            col.setSelectClause(this);
            this.sortColumns.add(col);
            sortCols.add(col);
        }
        if (sortCols.size() > 0) {
            this.statement.notifySortColumnChange(MetadataQueryChangeEvent.SubType.SORT_COLUMN_ADDED, sortCols);
        }
    }

    public void removeColumn(AttributeColumn col) {
        this.columns.remove(col);
        col.setSelectClause(null);
        ArrayList<AttributeColumn> removedCols = new ArrayList<AttributeColumn>(1);
        removedCols.add(col);
        this.statement.notifyColumnChange(MetadataQueryChangeEvent.SubType.COLUMN_REMOVED, removedCols);
    }

    public void removeSortColumn(AttributeSortColumn col) {
        this.sortColumns.remove(col);
        col.setSelectClause(null);
        ArrayList<AttributeSortColumn> sortCols = new ArrayList<AttributeSortColumn>(1);
        sortCols.add(col);
        this.statement.notifySortColumnChange(MetadataQueryChangeEvent.SubType.SORT_COLUMN_REMOVED, sortCols);
    }

    public void removeColumns(List<AttributeColumn> cols) {
        this.columns.removeAll(cols);
        for (AttributeColumn col : cols) {
            col.setSelectClause(null);
        }
        this.statement.notifyColumnChange(MetadataQueryChangeEvent.SubType.COLUMN_REMOVED, cols);
    }

    public void removeSortColumns(List<AttributeSortColumn> cols) {
        this.sortColumns.removeAll(cols);
        for (AttributeSortColumn col : cols) {
            col.setSelectClause(null);
        }
        this.statement.notifySortColumnChange(MetadataQueryChangeEvent.SubType.SORT_COLUMN_REMOVED, cols);
    }

    public void removeAllColumns() {
        ArrayList<AttributeColumn> removedCols = new ArrayList<AttributeColumn>(this.columns.size());
        removedCols.addAll(this.columns);
        this.columns.clear();
        for (AttributeColumn col : removedCols) {
            col.setSelectClause(null);
        }
        this.statement.notifyColumnChange(MetadataQueryChangeEvent.SubType.COLUMN_REMOVED, removedCols);
    }

    public void removeAllSortColumns() {
        ArrayList<AttributeSortColumn> cols = new ArrayList<AttributeSortColumn>(this.sortColumns.size());
        cols.addAll(this.sortColumns);
        this.sortColumns.clear();
        for (AttributeSortColumn col : cols) {
            col.setSelectClause(null);
        }
        this.statement.notifySortColumnChange(MetadataQueryChangeEvent.SubType.SORT_COLUMN_REMOVED, cols);
    }

    public void moveColumns(List<AttributeColumn> cols, int offset) {
        ArrayList<AttributeColumn> toBeMoved = new ArrayList<AttributeColumn>(cols);
        if (offset > 0) {
            Collections.reverse(toBeMoved);
        }
        for (AttributeColumn col : toBeMoved) {
            int index = this.columns.indexOf(col);
            int newIndex = index + offset;
            if (newIndex <= -1 || newIndex >= this.columns.size()) continue;
            this.columns.remove(index);
            this.columns.add(newIndex, col);
        }
        this.statement.notifyColumnChange(MetadataQueryChangeEvent.SubType.COLUMN_CHANGED, cols);
    }

    public void moveSortColumns(List<AttributeSortColumn> cols, int offset) {
        ArrayList<AttributeSortColumn> toBeMoved = new ArrayList<AttributeSortColumn>(cols);
        if (offset > 0) {
            Collections.reverse(toBeMoved);
        }
        for (AttributeSortColumn col : toBeMoved) {
            int index = this.sortColumns.indexOf(col);
            int newIndex = index + offset;
            if (newIndex <= -1 || newIndex >= this.sortColumns.size()) continue;
            this.sortColumns.remove(index);
            this.sortColumns.add(newIndex, col);
        }
        this.statement.notifySortColumnChange(MetadataQueryChangeEvent.SubType.SORT_COLUMN_REORDERED, cols);
    }

    public void setColumns(List<AttributeColumn> cols) {
        this.columns.clear();
        this.columns.addAll(cols);
        for (AttributeColumn col : cols) {
            col.setSelectClause(this);
        }
        this.statement.notifyColumnChange(MetadataQueryChangeEvent.SubType.COLUMN_CHANGED, null);
    }

    public void setSortColumns(List<AttributeSortColumn> cols) {
        this.sortColumns.clear();
        this.sortColumns.addAll(cols);
        for (AttributeSortColumn col : cols) {
            col.setSelectClause(this);
        }
        this.statement.notifySortColumnChange(MetadataQueryChangeEvent.SubType.SORT_COLUMN_CHANGED, null);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public AttributeColumn getColumnByName(String name) {
        for (AttributeColumn column : this.columns) {
            if (!column.getAttribute().getDisplayName().equals(name)) continue;
            return column;
        }
        return null;
    }
}

