/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.AttributeSortColumn;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MetadataQueryChangeEvent {
    private String name;
    private Statement statement;
    private Expression expression;
    private Type type;
    private SubType subType;
    private List<AttributeSortColumn> sortColumns;
    private List<AttributeColumn> columns;

    public MetadataQueryChangeEvent(Type type, String name) {
        this.type = type;
        this.name = name;
        this.subType = SubType.NA;
    }

    public MetadataQueryChangeEvent(Type type, SubType subType, Statement statement) {
        this.type = type;
        this.statement = statement;
        this.subType = subType == null ? SubType.NA : subType;
    }

    public MetadataQueryChangeEvent(Type type, SubType subType, Statement statement, List<?> list) {
        block2: {
            block3: {
                this(type, subType, statement);
                if (list == null || list.size() <= 0) break block2;
                if (!(list.get(0) instanceof AttributeSortColumn)) break block3;
                this.sortColumns = new ArrayList<AttributeSortColumn>();
                Iterator<?> iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.sortColumns.add((AttributeSortColumn)iterator.next());
                }
                break block2;
            }
            if (!(list.get(0) instanceof AttributeColumn)) break block2;
            this.columns = new ArrayList<AttributeColumn>();
            Iterator<?> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.columns.add((AttributeColumn)iterator.next());
            }
        }
    }

    public MetadataQueryChangeEvent(Type type, SubType subType, Expression expression) {
        this.type = type;
        this.expression = expression;
        this.subType = subType == null ? SubType.NA : subType;
    }

    public Type getType() {
        return this.type;
    }

    public SubType getSubType() {
        return this.subType;
    }

    public String getName() {
        return this.name;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<AttributeSortColumn> getSortColumns() {
        return this.sortColumns;
    }

    public List<AttributeColumn> getColumns() {
        return this.columns;
    }

    public static enum SubType {
        NA,
        TERM_CONDITION_ADDED,
        TERM_CONDITION_REMOVED,
        TERM_OPERATOR_CHANGED,
        TERM_CONDITION_VALUE_CHANGED,
        TERM_CLEARED,
        EXPRESSION_OPERATOR_CHANGED,
        SORT_COLUMN_ADDED,
        SORT_COLUMN_REMOVED,
        SORT_COLUMN_CHANGED,
        SORT_COLUMN_REORDERED,
        COLUMN_ADDED,
        COLUMN_REMOVED,
        COLUMN_CHANGED,
        COLUMN_REORDERED;

    }

    public static enum Type {
        NAME_CHANGED,
        STREAM_SCOPE_CHANGED,
        MODE_CHANGED,
        FREE_FORM_PATTERN_CHANGED,
        TERM_CHANGED,
        SELECT_COLUMN_CHANGED,
        SELECT_SORT_COLUMN_CHANGED;

    }
}

