/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import java.util.ArrayList;

public class AttributeSortColumn
extends AttributeColumn {
    private Direction direction;

    public AttributeSortColumn(AttributeColumn column) {
        super(column.getAttribute());
        this.direction = Direction.ASCENDING;
    }

    public AttributeSortColumn(AttributeColumn column, Direction direction) {
        super(column.getAttribute());
        this.direction = direction;
    }

    public AttributeSortColumn(IAttribute attribute) {
        super(attribute);
        this.direction = Direction.ASCENDING;
    }

    public AttributeSortColumn(IAttribute attribute, Direction direction) {
        super(attribute);
        this.direction = direction;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
        if (this.getSelectClause() != null) {
            ArrayList<AttributeSortColumn> sortCols = new ArrayList<AttributeSortColumn>(1);
            sortCols.add(this);
            this.getSelectClause().getStatement().notifySortColumnChange(MetadataQueryChangeEvent.SubType.SORT_COLUMN_CHANGED, sortCols);
        }
    }

    public static enum Direction {
        ASCENDING(true),
        DESCENDING(false);

        private boolean ascending;

        private Direction(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }
}

