/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.IFilterRestriction;
import com.ibm.team.enterprise.metadata.query.common.Messages;
import java.util.ArrayList;
import java.util.List;

public abstract class AttributeOperator
implements IFilterRestriction {
    public static final String OPERATOR_IS = "is";
    public static final String OPERATOR_IS_NOT = "is_not";
    public static final String OPERATOR_CONTAINS = "contains";
    public static final String OPERATOR_DOES_NOT_CONTAIN = "does_not_contain";
    public static final String OPERATOR_GREATER_OR_EQUALS = "greater_or_equal";
    public static final String OPERATOR_LESS_OR_EQUALS = "less_or_equal";
    public static final AttributeOperator IS = new AttributeOperator("is", Messages.getString("OPERATOR_IS")){

        @Override
        public String generateSPARQL(AttributeExpression expression) {
            StringBuffer buffer = new StringBuffer();
            if (expression.getAttribute().getType() == IAttribute.AttributeType.BOOLEAN) {
                buffer.append(expression.getValue());
            } else if (expression.getAttribute().getType() == IAttribute.AttributeType.NUMBER) {
                buffer.append('\"').append(expression.getValue()).append("\"^^xsd:double");
            } else if (expression.getAttribute().getType() == IAttribute.AttributeType.COMPONENT_TREE) {
                Object values = expression.getValue();
                if (values != null) {
                    buffer.append("    ").append("?").append(expression.getAttribute().getDisplayName()).append("    ").append('.');
                    buffer.append("FILTER (?").append(expression.getAttribute().getDisplayName()).append("    ");
                    if (values instanceof String && values.toString().isEmpty()) {
                        buffer.append("NOT IN ()");
                    } else if (values instanceof List && ((List)values).size() > 0) {
                        List<Object> valueList = (List<Object>)values;
                        boolean needAll = false;
                        if (valueList.size() == 2) {
                            boolean isCurrentProjectArea = Boolean.valueOf(valueList.get(1).toString());
                            if (isCurrentProjectArea) {
                                valueList = expression.getAttribute().getPredefinedValues();
                            } else {
                                needAll = true;
                            }
                        }
                        if (needAll) {
                            buffer.append("NOT IN ()");
                        } else {
                            buffer.append("IN (");
                            int i = 2;
                            while (i < valueList.size()) {
                                Object valueObj = valueList.get(i);
                                buffer.append("\"").append(valueObj).append("\"").append(",");
                                ++i;
                            }
                            buffer.deleteCharAt(buffer.length() - 1);
                            buffer.append(")");
                        }
                    }
                    buffer.append(")");
                }
            } else {
                buffer.append('\"').append(expression.getValue()).append('\"');
            }
            buffer.append("    ").append('.');
            return buffer.toString();
        }
    };
    public static final AttributeOperator IS_NOT = new AttributeOperator("is_not", Messages.getString("OPERATOR_IS_NOT")){

        @Override
        public String generateSPARQL(AttributeExpression expression) {
            StringBuffer buffer = new StringBuffer("FILTER");
            buffer.append("    ").append("(?").append(expression.getAttribute().getDisplayName()).append("    ");
            if (expression.getAttribute().getType() == IAttribute.AttributeType.NUMBER) {
                buffer.append("!=").append("    ");
                buffer.append(expression.getValue());
            } else if (expression.getAttribute().getType() == IAttribute.AttributeType.COMPONENT_TREE) {
                Object values = expression.getValue();
                if (values != null && values instanceof List) {
                    boolean isCurrentProjectArea;
                    List<Object> valueList = (List<Object>)values;
                    buffer.append("NOT IN (");
                    if (valueList.size() == 2 && (isCurrentProjectArea = Boolean.valueOf(valueList.get(1).toString()).booleanValue())) {
                        valueList = expression.getAttribute().getPredefinedValues();
                    }
                    if (valueList.size() > 2) {
                        int i = 2;
                        while (i < valueList.size()) {
                            Object valueObj = valueList.get(i);
                            buffer.append("\"").append(valueObj).append("\"").append(",");
                            ++i;
                        }
                        buffer.deleteCharAt(buffer.length() - 1);
                    }
                    buffer.append(")");
                }
            } else {
                buffer.append("!=").append("    ");
                buffer.append('\"').append(expression.getValue()).append('\"');
            }
            buffer.append(')');
            return buffer.toString();
        }
    };
    public static final AttributeOperator CONTAINS = new AttributeOperator("contains", Messages.getString("OPERATOR_CONTAINS")){

        @Override
        public String generateSPARQL(AttributeExpression expression) {
            StringBuffer buffer = new StringBuffer("FILTER");
            buffer.append("    ").append("(fn:contains").append("(?").append(expression.getAttribute().getDisplayName()).append(", ");
            if (expression.getAttribute().getType() == IAttribute.AttributeType.NUMBER) {
                buffer.append(expression.getValue());
            } else {
                buffer.append('\"').append(expression.getValue()).append('\"');
            }
            buffer.append("))");
            return buffer.toString();
        }
    };
    public static final AttributeOperator DOES_NOT_CONTAIN = new AttributeOperator("does_not_contain", Messages.getString("OPERATOR_DOES_NOT_CONTAIN")){

        @Override
        public String generateSPARQL(AttributeExpression expression) {
            StringBuffer buffer = new StringBuffer("FILTER");
            buffer.append("    ").append("(!fn:contains").append("(?").append(expression.getAttribute().getDisplayName()).append(", ");
            if (expression.getAttribute().getType() == IAttribute.AttributeType.NUMBER) {
                buffer.append(expression.getValue());
            } else {
                buffer.append('\"').append(expression.getValue()).append('\"');
            }
            buffer.append("))");
            return buffer.toString();
        }
    };
    public static final AttributeOperator GREATER_OR_EQUALS = new AttributeOperator("greater_or_equal", Messages.getString("OPERATOR_GREATER_OR_EQUALS")){

        @Override
        public String generateSPARQL(AttributeExpression expression) {
            StringBuffer buffer = new StringBuffer("FILTER");
            buffer.append("    ").append("(?").append(expression.getAttribute().getDisplayName()).append("    ");
            buffer.append(">=").append("    ");
            if (expression.getAttribute().getType() == IAttribute.AttributeType.NUMBER) {
                buffer.append(expression.getValue());
            } else {
                buffer.append('\"').append(expression.getValue()).append('\"');
            }
            buffer.append(')');
            return buffer.toString();
        }
    };
    public static final AttributeOperator LESS_OR_EQUALS = new AttributeOperator("less_or_equal", Messages.getString("OPERATOR_LESS_OR_EQUALS")){

        @Override
        public String generateSPARQL(AttributeExpression expression) {
            StringBuffer buffer = new StringBuffer("FILTER");
            buffer.append("    ").append("(?").append(expression.getAttribute().getDisplayName()).append("    ");
            buffer.append("<=").append("    ");
            if (expression.getAttribute().getType() == IAttribute.AttributeType.NUMBER) {
                buffer.append(expression.getValue());
            } else {
                buffer.append('\"').append(expression.getValue()).append('\"');
            }
            buffer.append(')');
            return buffer.toString();
        }
    };
    public static AttributeOperator[] availableOperators = new AttributeOperator[]{IS, IS_NOT, CONTAINS, DOES_NOT_CONTAIN, GREATER_OR_EQUALS, LESS_OR_EQUALS};
    private String identifier;
    private String displayName;

    public AttributeOperator(String identifier, String displayName) {
        this.identifier = identifier;
        this.displayName = displayName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public List<String> getPrefixes() {
        return new ArrayList<String>(0);
    }

    @Override
    public boolean isFilterRequired() {
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof AttributeOperator) {
            return ((AttributeOperator)o).getIdentifier().equals(this.identifier);
        }
        return false;
    }

    public static AttributeOperator getAttributeOperator(String id) {
        AttributeOperator[] attributeOperatorArray = availableOperators;
        int n = availableOperators.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeOperator operator = attributeOperatorArray[n2];
            if (operator.getIdentifier().equals(id)) {
                return operator;
            }
            ++n2;
        }
        return null;
    }
}

