/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.team.enterprise.metadata.common.query.util.Util;
import com.ibm.team.enterprise.metadata.query.common.AttributeOperator;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Term;

public class AttributeExpression
extends Expression {
    private final IAttribute attribute;
    private AttributeOperator operator;

    public AttributeExpression(Term parent, IAttribute attribute, AttributeOperator operator) {
        super(parent);
        this.attribute = attribute;
        if (attribute.getValue() != null) {
            this.value = attribute.getValue();
        }
        this.operator = operator != null ? operator : attribute.getOperators().get(0);
    }

    @Override
    public String getSPARQLString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        if (this.attribute.getParent() != null) {
            IAttribute parentAttribute = this.attribute.getParent();
            buffer.append('?').append("index").append("    ");
            String prefix = Util.getPredefinedPrefix(parentAttribute.getNamespace(), this.parent.getParent());
            if (prefix != null) {
                buffer.append(prefix).append(':').append(parentAttribute.getDisplayName());
            } else {
                buffer.append('<').append(parentAttribute.getNamespace());
                if (!parentAttribute.getNamespace().endsWith("/")) {
                    buffer.append('/');
                }
                buffer.append(parentAttribute.getDisplayName()).append('>');
            }
            buffer.append("    ").append('?').append("index2").append("    ").append('.').append("    ");
            buffer.append('?').append("index2").append("    ");
            if (prefix != null) {
                buffer.append(prefix).append(':').append(this.attribute.getDisplayName());
            } else {
                buffer.append('<').append(this.attribute.getNamespace());
                if (!this.attribute.getNamespace().endsWith("/")) {
                    buffer.append('/');
                }
                buffer.append(this.attribute.getDisplayName()).append('>');
            }
        } else {
            buffer.append('?').append("index").append("    ");
            String prefix = Util.getPredefinedPrefix(this.attribute.getNamespace(), this.parent.getParent());
            if (prefix != null) {
                buffer.append(prefix).append(':').append(this.attribute.getDisplayName());
            } else {
                buffer.append('<').append(this.attribute.getNamespace());
                if (!this.attribute.getNamespace().endsWith("/")) {
                    buffer.append('/');
                }
                buffer.append(this.attribute.getDisplayName()).append('>');
            }
        }
        buffer.append("    ");
        if (this.operator != AttributeOperator.IS) {
            buffer.append('?').append(this.attribute.getDisplayName()).append("    ");
            buffer.append("    ").append('.').append("    ");
        }
        buffer.append(this.operator.generateSPARQL(this)).append('}');
        return buffer.toString();
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof AttributeExpression) {
            AttributeExpression ae = (AttributeExpression)o;
            return ae.getAttribute().getAttributeId().equals((Object)this.attribute.getAttributeId()) && ae.getSPARQLString().equals(this.getSPARQLString());
        }
        return super.equals(o);
    }

    public AttributeOperator getOperator() {
        return this.operator;
    }

    public void setOperator(AttributeOperator operator) {
        this.operator = operator;
        this.parent.getParent().notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.EXPRESSION_OPERATOR_CHANGED, this);
    }
}

