/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.icu.text.Collator;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.SelectClause;
import java.util.Comparator;
import java.util.Locale;

public class AttributeColumn {
    private IAttribute attribute;
    private SelectClause selectClause;

    public AttributeColumn(IAttribute attribute) {
        this.attribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    public boolean equals(Object o) {
        if (o instanceof AttributeColumn) {
            AttributeColumn aCol = (AttributeColumn)o;
            return aCol.getAttribute().getAttributeId().equals((Object)this.attribute.getAttributeId());
        }
        return false;
    }

    public static Comparator<AttributeColumn> createComparator() {
        return AttributeColumn.createComparator(Locale.getDefault());
    }

    public static Comparator createComparator(Locale locale) {
        return new Comparator<AttributeColumn>(locale){
            private Collator collator;
            {
                this.collator = Collator.getInstance((Locale)locale);
            }

            @Override
            public int compare(AttributeColumn a1, AttributeColumn a2) {
                return this.collator.compare(a1.getAttribute().getFullDisplayName(), a2.getAttribute().getFullDisplayName());
            }
        };
    }

    public void setSelectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }
}

