/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.query.common;

import com.ibm.team.enterprise.metadata.common.query.util.RdfXmlConverter2;
import com.ibm.team.enterprise.metadata.query.common.AttributeOperator;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.Messages;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;

public class Attribute
implements IAttribute {
    private UUID attributeId;
    private String displayName;
    private String fDisplayConditionName;
    private Object value;
    private IAttribute.AttributeType type;
    private IAttribute parent;
    private List<IAttribute> childAttributes;
    private List<Object> predefinedValues;
    private List<AttributeOperator> operators;
    private String namespace;
    private String repositoryUrl;

    public Attribute(UUID attributeId, String namespace, String displayName) {
        this(attributeId, namespace, displayName, null, IAttribute.AttributeType.STRING, null);
    }

    public Attribute(UUID attributeId, String namespace, String displayName, Object value, IAttribute.AttributeType type, List<AttributeOperator> operators) {
        this(attributeId, namespace, displayName, value, type, null, operators);
    }

    public Attribute(UUID attributeId, String namespace, String displayName, Object value, IAttribute.AttributeType type, List<Object> predefinedValues, List<AttributeOperator> operators) {
        this(attributeId, namespace, displayName, value, type, predefinedValues, operators, null);
    }

    public Attribute(UUID attributeId, String namespace, String displayName, Object value, IAttribute.AttributeType type, List<Object> predefinedValues, List<AttributeOperator> operators, String repositoryUrl) {
        this.attributeId = attributeId == null ? UUID.generate() : attributeId;
        this.displayName = displayName;
        this.value = value;
        this.namespace = namespace;
        this.type = type;
        this.childAttributes = new ArrayList<IAttribute>();
        this.predefinedValues = new ArrayList<Object>();
        if (type == IAttribute.AttributeType.BOOLEAN) {
            this.predefinedValues.add(Boolean.TRUE);
            this.predefinedValues.add(Boolean.FALSE);
        } else if (predefinedValues != null) {
            this.predefinedValues.addAll(predefinedValues);
        }
        this.operators = new ArrayList<AttributeOperator>();
        if (operators == null) {
            this.operators.add(AttributeOperator.IS);
        } else {
            this.operators.addAll(operators);
        }
        this.repositoryUrl = repositoryUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFullDisplayName() {
        if (this.parent == null) {
            return this.getDisplayName();
        }
        return String.valueOf(this.parent.getDisplayName()) + " > " + this.getDisplayName();
    }

    @Override
    public String getFullDisplayConditionName() {
        if (this.parent == null) {
            return this.getDisplayConditionName();
        }
        return String.valueOf(this.parent.getDisplayConditionName()) + " > " + this.getDisplayConditionName();
    }

    @Override
    public void setDisplayConditionName(String fDisplayConditionName) {
        this.fDisplayConditionName = fDisplayConditionName;
    }

    @Override
    public String getDisplayConditionName() {
        String result = null;
        result = this.fDisplayConditionName == null || this.fDisplayConditionName.length() == 0 ? this.displayName : this.fDisplayConditionName;
        return result;
    }

    @Override
    public void setAttributeId(UUID uuid) {
        this.attributeId = uuid;
    }

    @Override
    public UUID getAttributeId() {
        return this.attributeId;
    }

    @Override
    public IAttribute.AttributeType getType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public List<IAttribute> getChildAttributes() {
        return this.childAttributes;
    }

    @Override
    public List<Object> getPredefinedValues() {
        return this.predefinedValues;
    }

    @Override
    public List<AttributeOperator> getOperators() {
        return this.operators;
    }

    @Override
    public void addOperator(AttributeOperator operator) {
        if (!this.operators.contains(operator)) {
            this.operators.add(operator);
        }
    }

    @Override
    public void addChildAttribute(IAttribute attribute) {
        this.childAttributes.add(attribute);
        if (attribute.getParent() == null) {
            attribute.setParent(this);
        }
    }

    @Override
    public IAttribute getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IAttribute parent) {
        this.parent = parent;
    }

    @Override
    public IAttribute newAttribute() {
        try {
            return (IAttribute)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        Attribute newAttribute = new Attribute(this.attributeId, this.namespace, this.displayName, this.value, this.type, this.predefinedValues, this.operators, this.repositoryUrl);
        newAttribute.setParent(this.parent);
        return newAttribute;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean hasChildAttributes() {
        return this.childAttributes.size() > 0;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public static String generateSlug(String id) {
        StringBuffer slugBuffer = new StringBuffer("_attributeId=").append(id);
        return slugBuffer.toString();
    }

    @Override
    public String getSlug() {
        return Attribute.generateSlug(this.attributeId.getUuidValue());
    }

    @Override
    public String getStoragePresentation() {
        try {
            return RdfXmlConverter2.toRdfXml(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTypeLabel(IAttribute.AttributeType type) {
        if (type == IAttribute.AttributeType.STRING) {
            return Messages.getString("ATTRIBUTE_TYPE_STRING");
        }
        if (type == IAttribute.AttributeType.NUMBER) {
            return Messages.getString("ATTRIBUTE_TYPE_INT");
        }
        if (type == IAttribute.AttributeType.BOOLEAN) {
            return Messages.getString("ATTRIBUTE_TYPE_BOOLEAN");
        }
        if (type == IAttribute.AttributeType.LIST) {
            return Messages.getString("ATTRIBUTE_TYPE_LIST");
        }
        if (type == IAttribute.AttributeType.COMPLEX) {
            return Messages.getString("ATTRIBUTE_TYPE_COMPLEX");
        }
        if (type == IAttribute.AttributeType.COMPONENT_TREE) {
            return Messages.getString("ATTRIBUTE_TYPE_COMPONENT_TREE");
        }
        return Messages.getString("ATTRIBUTE_TYPE_UNKNOWN");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Name: ");
        buffer.append(this.attributeId.getUuidValue()).append('\n');
        buffer.append("Namespace: ").append(this.namespace).append('\n');
        buffer.append("Type: ").append(this.type.name()).append('\n');
        buffer.append("Operators: ");
        for (AttributeOperator operator : this.operators) {
            buffer.append(operator.getIdentifier()).append(',');
        }
        buffer.append('\n');
        buffer.append("Available Values: ");
        for (Object value : this.predefinedValues) {
            buffer.append(value).append(',');
        }
        buffer.append('\n');
        buffer.append("Initial Value: ").append(this.value).append('\n');
        buffer.append("RepositoryURL: ").append(this.repositoryUrl).append('\n');
        for (IAttribute attribute : this.getChildAttributes()) {
            buffer.append("*******");
            buffer.append(attribute);
        }
        return buffer.toString();
    }
}

