/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.common.scanner;

import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.filesystem.common.IFileItem;
import java.io.File;
import java.io.InputStream;

public class ScanFileDesc {
    private static String ITEM_ID_DELIMITER = "_itemId=";
    private static final String FILE_SCD_BASE_URI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/";
    private IFileItem fileItem;
    private String filePath;
    private boolean delete;
    private ILanguageDefinition languageDefinition;
    private InputStream fileContents;
    private boolean warningIssued;
    private boolean skipped;

    public ScanFileDesc() {
    }

    public ScanFileDesc(IFileItem fileItem, String filePath, boolean delete) {
        this.fileItem = fileItem;
        this.filePath = filePath;
        this.delete = delete;
    }

    public String getFileName() {
        if (this.fileItem != null) {
            return this.fileItem.getName();
        }
        if (this.filePath != null) {
            int index = this.filePath.lastIndexOf(File.separator);
            if (index > -1 && index < this.filePath.length() - 1) {
                return this.filePath.substring(index + 1);
            }
            return this.filePath;
        }
        return null;
    }

    public IFileItem getFileItem() {
        return this.fileItem;
    }

    public void setFileItem(IFileItem fileItem) {
        this.fileItem = fileItem;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public ILanguageDefinition getLanguageDefinition() {
        return this.languageDefinition;
    }

    public void setLanguageDefinition(ILanguageDefinition languageDefinition) {
        this.languageDefinition = languageDefinition;
    }

    public InputStream getFileContents() {
        return this.fileContents;
    }

    public void setFileContents(InputStream fileContents) {
        this.fileContents = fileContents;
    }

    public boolean isWarningIssued() {
        return this.warningIssued;
    }

    public void setWarningIssued(boolean warningIssued) {
        this.warningIssued = warningIssued;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public String getResourceUri() {
        if (this.fileItem != null) {
            StringBuffer buffer = new StringBuffer(FILE_SCD_BASE_URI);
            buffer.append(ITEM_ID_DELIMITER);
            buffer.append(this.fileItem.getItemId().getUuidValue());
            return buffer.toString();
        }
        return null;
    }

    public String getCodePage() {
        return this.fileItem == null || this.fileItem.getContent() == null ? null : this.fileItem.getContent().getCharacterEncoding();
    }
}

