/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.common.query.util;

import com.ibm.team.enterprise.metadata.common.query.util.AttributeProviderFactory;
import com.ibm.team.enterprise.metadata.common.query.util.Messages;
import com.ibm.team.enterprise.metadata.query.common.Attribute;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Util {
    private static Util instance = new Util();

    public static IStatus verifyQueryName(String name) {
        if (name == null || name.trim().length() == 0) {
            return new Status(4, "com.ibm.team.enterprise.metadata.query.common", Messages.QueryNameValidation_NAME_NOT_EMPTY_MESSAGE);
        }
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch) && !Character.isSpaceChar(ch) && ch != '+' && ch != '-' && ch != '.' && ch != '(' && ch != ')') {
                return new Status(4, "com.ibm.team.enterprise.metadata.query.common", NLS.bind((String)Messages.QueryNameValidation_NAME_INVALID_CHARACTER, (Object)Character.valueOf(ch), (Object)name));
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public static String getPredefinedPrefix(String namespace, Statement statement) {
        if (namespace.equalsIgnoreCase("prefixScm")) {
            return "prefixScm";
        }
        if (namespace.equalsIgnoreCase("prefixDep")) {
            return "prefixDep";
        }
        if (namespace.equalsIgnoreCase("prefixDef")) {
            return "prefixDef";
        }
        if (statement == null) {
            return null;
        }
        return statement.getPrefix(namespace);
    }

    private static IAttribute getAttribute(List<IAttribute> attributes, String attributeId, String namespace) {
        for (IAttribute attribute : attributes) {
            if (!attribute.getAttributeId().getUuidValue().equals(attributeId) || !attribute.getNamespace().equals(namespace)) continue;
            return attribute;
        }
        return null;
    }

    public static String getQueryNameSparql(String projectAreaUUID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX ns1: <http://www.ibm.com/xmlns/prod/rational/rtc/metadata/query/1.0/> \n");
        buffer.append("SELECT ?queryName \n");
        buffer.append("WHERE\n");
        buffer.append("{\n");
        buffer.append("  ?zindex   ns1:queryName   ?queryName   .  \n");
        buffer.append("  ?zindex   ns1:projectAreaUUID   \"").append(projectAreaUUID).append("\"   .  \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getAttributeSparql() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX ns1: <http://www.ibm.com/xmlns/prod/rational/rtc/metadata/query/1.0/> \n");
        buffer.append("SELECT ?attributeId ?attributeName ?attributeNamespace ?attributeType ?attributeOperators ?attributeAvailableValues ?attributeInitialValue ?attributeParentId\n");
        buffer.append("WHERE\n");
        buffer.append("{\n");
        buffer.append("  ?zindex   ns1:attributeId     ?attributeId   .  \n");
        buffer.append("  ?zindex   ns1:attributeName   ?attributeName   .  \n");
        buffer.append("  ?zindex   ns1:attributeNamespace   ?attributeNamespace   .  \n");
        buffer.append("  ?zindex   ns1:attributeType   ?attributeType   .  \n");
        buffer.append("  ?zindex   ns1:attributeOperators   ?attributeOperators   .  \n");
        buffer.append("  ?zindex   ns1:attributeAvailableValues   ?attributeAvailableValues   .  \n");
        buffer.append("  ?zindex   ns1:attributeInitialValue   ?attributeInitialValue   .  \n");
        buffer.append("  ?zindex   ns1:attributeParentId   ?attributeParentId   .  \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getAttributeSparql2() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PREFIX ns1: <http://www.ibm.com/xmlns/prod/rational/rtc/metadata/query/1.0/> \n");
        buffer.append("SELECT ?attributeId ?attributeName ?attributeNamespace ?attributeType\n");
        buffer.append("WHERE\n");
        buffer.append("{\n");
        buffer.append("  ?zindex   ns1:attributeId     ?attributeId   .  \n");
        buffer.append("  ?zindex   ns1:attributeName   ?attributeName   .  \n");
        buffer.append("  ?zindex   ns1:attributeNamespace   ?attributeNamespace   .  \n");
        buffer.append("  ?zindex   ns1:attributeType   ?attributeType   .  \n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static List<IAttribute> parseAttributes(List<SelectResult> results, String repositoryUri) {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        HashMap<FullyQualifiedName, ArrayList<Attribute>> parentChildMap = new HashMap<FullyQualifiedName, ArrayList<Attribute>>();
        for (SelectResult result : results) {
            List bindings = result.getBindings();
            String attributeId = "";
            String attributeName = "";
            String attributeNamespace = "";
            String attributeType = "";
            String attributeOperators = "";
            String attributeAvailableValues = "";
            String attributeInitialValue = "";
            String attributeParentId = "";
            for (Binding binding : bindings) {
                if (binding.getName().equals("attributeId")) {
                    attributeId = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("attributeName")) {
                    attributeName = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("attributeNamespace")) {
                    attributeNamespace = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("attributeType")) {
                    attributeType = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("attributeOperators")) {
                    attributeOperators = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("attributeAvailableValues")) {
                    attributeAvailableValues = binding.getValue();
                    continue;
                }
                if (binding.getName().equals("attributeInitialValue")) {
                    attributeInitialValue = binding.getValue();
                    continue;
                }
                if (!binding.getName().equals("attributeParentId")) continue;
                attributeParentId = binding.getValue();
            }
            Attribute attribute = new Attribute(UUID.valueOf((String)attributeId), attributeNamespace, attributeName, attributeInitialValue, IAttribute.AttributeType.valueOf(attributeType), AttributeProviderFactory.stringToObjects(attributeAvailableValues), AttributeProviderFactory.stringToAttributeOperators(attributeOperators), repositoryUri);
            if (attributeParentId.trim().length() == 0) {
                attributes.add(attribute);
                continue;
            }
            Util util = instance;
            util.getClass();
            FullyQualifiedName fullyQualifiedName = util.new FullyQualifiedName(attribute.getNamespace(), attributeParentId);
            ArrayList<Attribute> children = (ArrayList<Attribute>)parentChildMap.get(fullyQualifiedName);
            if (children == null) {
                children = new ArrayList<Attribute>();
            }
            children.add(attribute);
            parentChildMap.put(fullyQualifiedName, children);
        }
        for (FullyQualifiedName fullyQualifiedName : parentChildMap.keySet()) {
            IAttribute parentAttribute = Util.getAttribute(attributes, fullyQualifiedName.getName(), fullyQualifiedName.getNamespace());
            if (parentAttribute == null) continue;
            List children = (List)parentChildMap.get(fullyQualifiedName);
            for (IAttribute child : children) {
                parentAttribute.addChildAttribute(child);
            }
        }
        return attributes;
    }

    private class FullyQualifiedName {
        private final String name;
        private final String namespace;

        public FullyQualifiedName(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String toString() {
            return new StringBuffer(this.namespace).append('/').append(this.name).toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            return this.toString().equals(o);
        }
    }
}

