/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.common.query.util;

import com.ibm.team.enterprise.metadata.common.query.util.AttributeProviderFactory;
import com.ibm.team.enterprise.metadata.common.query.util.KeyValue;
import com.ibm.team.enterprise.metadata.common.query.util.MetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.Attribute;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.AttributeOperator;
import com.ibm.team.enterprise.metadata.query.common.AttributeSortColumn;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.Prefix;
import com.ibm.team.enterprise.metadata.query.common.QueryJfsConstants;
import com.ibm.team.enterprise.metadata.query.common.SelectClause;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.query.common.StreamScope;
import com.ibm.team.enterprise.metadata.query.common.Term;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RdfXmlConverter2
implements QueryJfsConstants {
    public static final String XMLNS_RDF_VALUE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String XMLNS_NS1_VALUE = "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/query/1.0/";
    public static final String RDF_ABOUT_VALUE = "{0}storage/teamz_query/_projectAreaUUID={1}_queryId={2}";
    public static final String RDF_ABOUT_VALUE2 = "{0}storage/teamz_query/{1}";
    public static final String RDF_ABOUT_VALUE3 = "{0}storage/teamz_attribute/_attributeId={1}";
    public static final String RDF_ABOUT_VALUE4 = "{0}storage/teamz_attribute/{1}";
    private static final String ELEMENT_HAS_STATEMENT = "ns1:hasStatement";
    private static final String ELEMENT_HAS_WHERE = "ns1:hasWhere";
    private static final String ELEMENT_HAS_PREFIX = "ns1:hasPrefix";
    private static final String ELEMENT_HAS_COLUMN = "ns1:hasColumn";
    private static final String ELEMENT_HAS_SORT_COLUMN = "ns1:hasSortColumn";
    private static final String ELEMENT_HAS_TERM = "ns1:hasTerm";
    private static final String ELEMENT_HAS_EXPRESSION = "ns1:hasExpression";
    private static final String ELEMENT_HAS_PREDEFINED_VALUES = "ns1:hasPredefinedValues";
    private static final String ELEMENT_HAS_PARENT_ATTRIBUTE = "ns1:hasParentAttribute";
    private static final String ELEMENT_HAS_ATTRIBUTE_OPERATOR = "ns1:hasAttributeOperator";
    private static final String ELEMENT_RDF = "rdf:RDF";
    protected static final String ELEMENT_RDF_DESCRIPTION = "rdf:Description";
    protected static final String ELEMENT_QUERY_NAME = "ns1:queryName";
    protected static final String ELEMENT_PROJECT_AREA = "ns1:projectAreaUUID";
    private static final String ELEMENT_STATEMENT = "ns1:statement";
    private static final String ELEMENT_PREFIX = "ns1:prefix";
    protected static final String ELEMENT_STREAM_UUID = "ns1:streamUUID";
    private static final String ELEMENT_COLUMN = "ns1:column";
    private static final String ELEMENT_SORT_COLUMN = "ns1:sortColumn";
    private static final String ELEMENT_WHERE = "ns1:where";
    private static final String ELEMENT_TERM = "ns1:term";
    private static final String ELEMENT_EXPRESSION = "ns1:expression";
    private static final String ELEMENT_PREDEFINED_VALUES = "ns1:predefinedValues";
    private static final String ELEMENT_PREDEFINED_VALUE = "ns1:predefinedValue";
    private static final String ELEMENT_PARENT_ATTRIBUTE = "ns1:parentAttribute";
    private static final String ELEMENT_OPERATOR = "ns1:operator";
    private static final String ELEMENT_INDEX = "ns1:index";
    private static final String ELEMENT_PREDICATE = "ns1:predicate";
    private static final String ELEMENT_OBJECT = "ns1:object";
    private static final String ELEMENT_DISPLAY_NAME = "ns1:displayName";
    private static final String ELEMENT_TYPE = "ns1:type";
    private static final String ELEMENT_NAMESPACE = "ns1:namespace";
    private static final String ELEMENT_PREFIX_NAME = "ns1:prefixName";
    private static final String ELEMENT_PREFIX_URI = "ns1:prefixUri";
    private static final String ELEMENT_COL_ID = "ns1:colId";
    private static final String ELEMENT_COL_NAMESPACE = "ns1:colNamespace";
    private static final String ELEMENT_COL_DISPLAYNAME = "ns1:colDisplayName";
    private static final String ELEMENT_SORT_DIRECTION = "ns1:sortDirection";
    private static final String ELEMENT_ATTRIBUTE_OPERATOR = "ns1:attributeOperator";
    private static final String ELEMENT_ID = "ns1:id";
    private static final String ELEMENT_EXPRESSION_OPERATOR = "ns1:expressionOperator";
    private static final String ELEMENT_REPOSITORY_URL = "ns1:repositoryUrl";
    private static final String ELEMENT_ATTRIBUTE_ID = "ns1:attributeId";
    private static final String ELEMENT_ATTRIBUTE_NAME = "ns1:attributeName";
    private static final String ELEMENT_ATTRIBUTE_NAMESPACE = "ns1:attributeNamespace";
    private static final String ELEMENT_ATTRIBUTE_TYPE = "ns1:attributeType";
    private static final String ELEMENT_ATTRIBUTE_OPERATORS = "ns1:attributeOperators";
    private static final String ELEMENT_ATTRIBUTE_AVAILABLE_VALUES = "ns1:attributeAvailableValues";
    private static final String ELEMENT_ATTRIBUTE_INITIAL_VALUE = "ns1:attributeInitialValue";
    private static final String ELEMENT_ATTRIBUTE_PARENT_ID = "ns1:attributeParentId";
    private static final String ELEMENT_NESTED_ATTRIBUTE = "ns1:nestedAttribute";
    private static final String ELEMENT_HAS_NESTED_ATTRIBUTE = "ns1:hasNestedAttribute";
    private static final String ATTR_RDF_RESOURCE = "rdf:resource";
    private static final String ATTR_XMLNS_RDF = "xmlns:rdf";
    private static final String ATTR_XMLNS_NS1 = "xmlns:ns1";
    public static final String ATTR_RDF_ABOUT = "rdf:about";
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    protected static final String UTF_8 = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static IMetadataQuery toMetadataQuery(String rdfxml) throws TeamRepositoryException {
        try {
            Element termElement;
            Document doc = RdfXmlConverter2.newDocument(new ByteArrayInputStream(rdfxml.getBytes(UTF_8)));
            NodeList descriptionNodes = doc.getElementsByTagName(ELEMENT_RDF_DESCRIPTION);
            Element descriptionElement = (Element)descriptionNodes.item(0);
            NodeList queryNameNodes = doc.getElementsByTagName(ELEMENT_QUERY_NAME);
            Element queryName = (Element)queryNameNodes.item(0);
            NodeList projectAreaNodes = doc.getElementsByTagName(ELEMENT_PROJECT_AREA);
            Element projectAreaElement = (Element)projectAreaNodes.item(0);
            MetadataQuery metadataQuery = new MetadataQuery(queryName.getTextContent(), RdfXmlConverter2.extractRepositoryUrl(descriptionElement.getAttribute(ATTR_RDF_ABOUT), "teamz_query"), projectAreaElement.getTextContent(), new Statement());
            Statement statement = metadataQuery.getStatement();
            StreamScope scope = new StreamScope(statement);
            String streamUUID = RdfXmlConverter2.getElementValue(doc, ELEMENT_STREAM_UUID);
            if (streamUUID != null && streamUUID.length() > 0) {
                scope.setAllStreams(false);
                scope.setStreamUUID(streamUUID);
            } else {
                scope.setAllStreams(true);
            }
            statement.setStreamScope(scope);
            NodeList prefixElements = doc.getElementsByTagName(ELEMENT_PREFIX);
            int i = 0;
            while (i < prefixElements.getLength()) {
                Element next = (Element)prefixElements.item(i);
                String prefixName = RdfXmlConverter2.getElementValue(next, ELEMENT_PREFIX_NAME);
                String prefixUri = RdfXmlConverter2.getElementValue(next, ELEMENT_PREFIX_URI);
                statement.addPrefix(new Prefix(prefixName, prefixUri));
                ++i;
            }
            SelectClause select = new SelectClause(statement, false);
            NodeList colElements = doc.getElementsByTagName(ELEMENT_COLUMN);
            int i2 = 0;
            while (i2 < colElements.getLength()) {
                Element next = (Element)colElements.item(i2);
                String colName = RdfXmlConverter2.getElementValue(next, ELEMENT_COL_ID);
                String colNamespace = RdfXmlConverter2.getElementValue(next, ELEMENT_COL_NAMESPACE);
                String colDisplayName = RdfXmlConverter2.getElementValue(next, ELEMENT_COL_DISPLAYNAME);
                IAttribute.AttributeType colType = RdfXmlConverter2.getAttributeType(RdfXmlConverter2.getElementValue(next, ELEMENT_TYPE));
                Attribute attr = new Attribute(UUID.valueOf((String)colName), colNamespace, colDisplayName, null, colType != null ? colType : IAttribute.AttributeType.STRING, null);
                IAttribute parentAttribute = RdfXmlConverter2.getParentAttribute(doc, next);
                if (parentAttribute != null) {
                    attr.setParent(parentAttribute);
                }
                select.addColumn(new AttributeColumn(attr));
                ++i2;
            }
            NodeList sortColElements = doc.getElementsByTagName(ELEMENT_SORT_COLUMN);
            int i3 = 0;
            while (i3 < sortColElements.getLength()) {
                Element next = (Element)sortColElements.item(i3);
                String colName = RdfXmlConverter2.getElementValue(next, ELEMENT_COL_ID);
                String colNamespace = RdfXmlConverter2.getElementValue(next, ELEMENT_COL_NAMESPACE);
                String colDisplayName = RdfXmlConverter2.getElementValue(next, ELEMENT_COL_DISPLAYNAME);
                IAttribute.AttributeType colType = RdfXmlConverter2.getAttributeType(RdfXmlConverter2.getElementValue(next, ELEMENT_TYPE));
                Attribute attr = new Attribute(UUID.valueOf((String)colName), colNamespace, colDisplayName, null, colType != null ? colType : IAttribute.AttributeType.STRING, null);
                IAttribute parentAttribute = RdfXmlConverter2.getParentAttribute(doc, next);
                if (parentAttribute != null) {
                    attr.setParent(parentAttribute);
                }
                AttributeSortColumn.Direction direction = RdfXmlConverter2.getDirection(RdfXmlConverter2.getElementValue(next, ELEMENT_SORT_DIRECTION));
                select.addSortColumn(new AttributeSortColumn(attr, direction));
                ++i3;
            }
            statement.setSelectClause(select);
            NodeList termElements = doc.getElementsByTagName(ELEMENT_TERM);
            if (termElements.getLength() > 0 && (termElement = (Element)termElements.item(0)) != null) {
                Element operatorElement = (Element)termElement.getElementsByTagName(ELEMENT_OPERATOR).item(0);
                Term term = new Term(statement, RdfXmlConverter2.getOperatorByName(operatorElement.getTextContent()));
                NodeList expressionNodes = doc.getElementsByTagName(ELEMENT_EXPRESSION);
                int i4 = 0;
                while (i4 < expressionNodes.getLength()) {
                    String[] attributeOperatorRdfs;
                    Element expressionElement = (Element)expressionNodes.item(i4);
                    String predicate = RdfXmlConverter2.getElementValue(expressionElement, ELEMENT_PREDICATE);
                    String displayName = RdfXmlConverter2.getElementValue(expressionElement, ELEMENT_DISPLAY_NAME);
                    String object = RdfXmlConverter2.getElementValue(expressionElement, ELEMENT_OBJECT);
                    String repositoryUrl = RdfXmlConverter2.getElementValue(expressionElement, ELEMENT_REPOSITORY_URL);
                    String expressionOperatorId = RdfXmlConverter2.getElementValue(expressionElement, ELEMENT_EXPRESSION_OPERATOR);
                    AttributeOperator expressionOperator = AttributeOperator.getAttributeOperator(expressionOperatorId);
                    Element predefinedValuesElement = RdfXmlConverter2.findRdfResourceElement(doc, ELEMENT_PREDEFINED_VALUES, RdfXmlConverter2.getAttributeValue(expressionElement, ELEMENT_HAS_PREDEFINED_VALUES, ATTR_RDF_RESOURCE));
                    ArrayList<Object> predefinedValues = new ArrayList<Object>();
                    if (predefinedValuesElement != null) {
                        NodeList predefinedValueElements = predefinedValuesElement.getElementsByTagName(ELEMENT_PREDEFINED_VALUE);
                        int j = 0;
                        while (j < predefinedValueElements.getLength()) {
                            Element predefinedValueElement = (Element)predefinedValueElements.item(j);
                            predefinedValues.add(predefinedValueElement.getTextContent());
                            ++j;
                        }
                    }
                    IAttribute.AttributeType attributeType = RdfXmlConverter2.getAttributeType(RdfXmlConverter2.getElementValue(expressionElement, ELEMENT_TYPE));
                    String namespace = RdfXmlConverter2.getElementValue(expressionElement, ELEMENT_NAMESPACE);
                    Attribute attribute = new Attribute(UUID.valueOf((String)predicate), namespace, displayName, object, attributeType, predefinedValues, null, repositoryUrl);
                    AttributeExpression expression = new AttributeExpression(term, attribute, expressionOperator);
                    if (attributeType == IAttribute.AttributeType.COMPONENT_TREE && object != null && object.length() > 2) {
                        ArrayList<String> values = new ArrayList<String>();
                        String wholeStr = object.substring(1, object.length() - 1);
                        if (wholeStr.length() > 0) {
                            String[] uuidArray;
                            String[] stringArray = uuidArray = wholeStr.split(",");
                            int n = uuidArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String uuid = stringArray[n2];
                                if (uuid.length() > 0) {
                                    values.add(uuid.trim());
                                }
                                ++n2;
                            }
                        }
                        expression.setValue(values);
                    } else {
                        expression.setValue(object);
                    }
                    String[] stringArray = attributeOperatorRdfs = RdfXmlConverter2.getAttributeValues(expressionElement, ELEMENT_HAS_ATTRIBUTE_OPERATOR, ATTR_RDF_RESOURCE);
                    int n = attributeOperatorRdfs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String attributeOperatorRdf = stringArray[n3];
                        Element attributeOperatorElement = RdfXmlConverter2.findRdfResourceElement(doc, ELEMENT_ATTRIBUTE_OPERATOR, attributeOperatorRdf);
                        String attributeIdentifier = RdfXmlConverter2.getElementValue(attributeOperatorElement, ELEMENT_ID);
                        attribute.addOperator(AttributeOperator.getAttributeOperator(attributeIdentifier));
                        ++n3;
                    }
                    IAttribute parentAttribute = RdfXmlConverter2.getParentAttribute(doc, expressionElement);
                    if (parentAttribute != null) {
                        attribute.setParent(parentAttribute);
                    }
                    term.addExpression(expression);
                    ++i4;
                }
                statement.setTerm(term);
            }
            return metadataQuery;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static String toRdfXml(IMetadataQuery query) throws TeamRepositoryException {
        try {
            Document doc = RdfXmlConverter2.newDocument();
            Element rdfElement = doc.createElement(ELEMENT_RDF);
            doc.appendChild(rdfElement);
            rdfElement.setAttribute(ATTR_XMLNS_RDF, XMLNS_RDF_VALUE);
            rdfElement.setAttribute(ATTR_XMLNS_NS1, XMLNS_NS1_VALUE);
            Element descriptionElement = doc.createElement(ELEMENT_RDF_DESCRIPTION);
            rdfElement.appendChild(descriptionElement);
            descriptionElement.setAttribute(ATTR_RDF_ABOUT, RdfXmlConverter2.getRDFAbout(query));
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_PROJECT_AREA, query.getProjectAreaUUID());
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_QUERY_NAME, query.getName());
            Element statementElement = RdfXmlConverter2.createResourceXmlNode(doc, query, ELEMENT_STATEMENT, rdfElement, "statement", descriptionElement, ELEMENT_HAS_STATEMENT);
            Statement statement = query.getStatement();
            StreamScope scope = statement.getStreamScope();
            if (!scope.isAllStreams() && scope.getStreamUUID() != null) {
                RdfXmlConverter2.createPropertyNode(doc, statementElement, ELEMENT_STREAM_UUID, scope.getStreamUUID());
            } else {
                RdfXmlConverter2.createPropertyNode(doc, statementElement, ELEMENT_STREAM_UUID, null);
            }
            List<Prefix> prefixes = statement.getPrefixes();
            for (Prefix prefix : prefixes) {
                ArrayList<KeyValue> properties = new ArrayList<KeyValue>();
                properties.add(new KeyValue(ELEMENT_PREFIX_NAME, prefix.getName()));
                properties.add(new KeyValue(ELEMENT_PREFIX_URI, prefix.getUri()));
                RdfXmlConverter2.createResourceXmlAndPropertyElement(doc, query, ELEMENT_PREFIX, rdfElement, "prefix/" + prefix.getName(), statementElement, ELEMENT_HAS_PREFIX, properties);
            }
            SelectClause select = statement.getSelectClause();
            if (select != null) {
                List<AttributeColumn> cols = select.getColumns();
                for (AttributeColumn col : cols) {
                    ArrayList properties = new ArrayList();
                    properties.add(new KeyValue(ELEMENT_COL_ID, col.getAttribute().getAttributeId().getUuidValue()));
                    properties.add(new KeyValue(ELEMENT_COL_NAMESPACE, col.getAttribute().getNamespace()));
                    properties.add(new KeyValue(ELEMENT_COL_DISPLAYNAME, col.getAttribute().getDisplayName()));
                    properties.add(new KeyValue(ELEMENT_TYPE, col.getAttribute().getType().toString()));
                    Element colElement = RdfXmlConverter2.createResourceXmlAndPropertyElement(doc, query, ELEMENT_COLUMN, rdfElement, "column/" + col.getAttribute().getAttributeId().getUuidValue(), statementElement, ELEMENT_HAS_COLUMN, (List<KeyValue>)properties);
                    IAttribute parentAttribute = col.getAttribute().getParent();
                    if (parentAttribute == null) continue;
                    RdfXmlConverter2.createParentAttributeElement(doc, query, rdfElement, parentAttribute, colElement);
                }
                List<AttributeSortColumn> sortCols = select.getSortColumns();
                for (AttributeSortColumn sortCol : sortCols) {
                    ArrayList<KeyValue> properties = new ArrayList<KeyValue>();
                    properties.add(new KeyValue(ELEMENT_COL_ID, sortCol.getAttribute().getAttributeId().getUuidValue()));
                    properties.add(new KeyValue(ELEMENT_COL_NAMESPACE, sortCol.getAttribute().getNamespace()));
                    properties.add(new KeyValue(ELEMENT_COL_DISPLAYNAME, sortCol.getAttribute().getDisplayName()));
                    properties.add(new KeyValue(ELEMENT_SORT_DIRECTION, sortCol.getDirection().toString()));
                    properties.add(new KeyValue(ELEMENT_TYPE, sortCol.getAttribute().getType().toString()));
                    Element sortColElement = RdfXmlConverter2.createResourceXmlAndPropertyElement(doc, query, ELEMENT_SORT_COLUMN, rdfElement, "sortColumn/" + sortCol.getAttribute().getAttributeId().getUuidValue(), statementElement, ELEMENT_HAS_SORT_COLUMN, properties);
                    IAttribute parentAttribute = sortCol.getAttribute().getParent();
                    if (parentAttribute == null) continue;
                    RdfXmlConverter2.createParentAttributeElement(doc, query, rdfElement, parentAttribute, sortColElement);
                }
            }
            Element whereElement = RdfXmlConverter2.createResourceXmlNode(doc, query, ELEMENT_WHERE, rdfElement, "where", statementElement, ELEMENT_HAS_WHERE);
            Term term = statement.getTerm();
            if (term != null) {
                Element termElement = RdfXmlConverter2.createResourceXmlNode(doc, query, ELEMENT_TERM, rdfElement, "term", whereElement, ELEMENT_HAS_TERM);
                RdfXmlConverter2.createPropertyNode(doc, termElement, ELEMENT_OPERATOR, term.getOperator().getOperatorName());
                int count = 1;
                List<Expression> expressions = term.getExpressions();
                for (Expression expression : expressions) {
                    if (!(expression instanceof AttributeExpression)) continue;
                    Element expressionElement = RdfXmlConverter2.createResourceXmlNode(doc, query, ELEMENT_EXPRESSION, rdfElement, "expression/#" + count, termElement, ELEMENT_HAS_EXPRESSION);
                    AttributeExpression attrExpression = (AttributeExpression)expression;
                    IAttribute attribute = attrExpression.getAttribute();
                    RdfXmlConverter2.createPropertyNode(doc, expressionElement, ELEMENT_INDEX, "zindex");
                    RdfXmlConverter2.createPropertyNode(doc, expressionElement, ELEMENT_PREDICATE, attribute.getAttributeId().getUuidValue());
                    RdfXmlConverter2.createPropertyNode(doc, expressionElement, ELEMENT_OBJECT, attrExpression.getValue().toString());
                    RdfXmlConverter2.createPropertyNode(doc, expressionElement, ELEMENT_DISPLAY_NAME, attribute.getDisplayName());
                    RdfXmlConverter2.createPropertyNode(doc, expressionElement, ELEMENT_TYPE, attribute.getType().toString());
                    RdfXmlConverter2.createPropertyNode(doc, expressionElement, ELEMENT_NAMESPACE, attribute.getNamespace());
                    RdfXmlConverter2.createPropertyNode(doc, expressionElement, ELEMENT_REPOSITORY_URL, attribute.getRepositoryUrl());
                    RdfXmlConverter2.createPropertyNode(doc, expressionElement, ELEMENT_EXPRESSION_OPERATOR, attrExpression.getOperator().getIdentifier());
                    List<Object> predefinedValues = attribute.getPredefinedValues();
                    ArrayList<KeyValue> properties = new ArrayList<KeyValue>();
                    for (Object predefinedValue : predefinedValues) {
                        properties.add(new KeyValue(ELEMENT_PREDEFINED_VALUE, predefinedValue.toString()));
                    }
                    RdfXmlConverter2.createResourceXmlAndPropertyElement(doc, query, ELEMENT_PREDEFINED_VALUES, rdfElement, "predefinedValues/" + attribute.getAttributeId().getUuidValue(), expressionElement, ELEMENT_HAS_PREDEFINED_VALUES, properties);
                    List<AttributeOperator> operators = attribute.getOperators();
                    for (AttributeOperator operator : operators) {
                        properties.clear();
                        properties.add(new KeyValue(ELEMENT_ID, operator.getIdentifier()));
                        properties.add(new KeyValue(ELEMENT_DISPLAY_NAME, operator.getDisplayName()));
                        RdfXmlConverter2.createResourceXmlAndPropertyElement(doc, query, ELEMENT_ATTRIBUTE_OPERATOR, rdfElement, "attributeOperator/" + operator.getIdentifier(), expressionElement, ELEMENT_HAS_ATTRIBUTE_OPERATOR, properties);
                    }
                    IAttribute parent = attribute.getParent();
                    if (parent != null) {
                        RdfXmlConverter2.createParentAttributeElement(doc, query, rdfElement, parent, expressionElement);
                    }
                    ++count;
                }
            }
            return RdfXmlConverter2.transform(doc);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static String toRdfXml(IAttribute attribute) throws TeamRepositoryException {
        try {
            Document doc = RdfXmlConverter2.newDocument();
            Element rdfElement = doc.createElement(ELEMENT_RDF);
            doc.appendChild(rdfElement);
            rdfElement.setAttribute(ATTR_XMLNS_RDF, XMLNS_RDF_VALUE);
            rdfElement.setAttribute(ATTR_XMLNS_NS1, XMLNS_NS1_VALUE);
            Element descriptionElement = doc.createElement(ELEMENT_RDF_DESCRIPTION);
            rdfElement.appendChild(descriptionElement);
            descriptionElement.setAttribute(ATTR_RDF_ABOUT, RdfXmlConverter2.getRDFAbout(attribute));
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_ATTRIBUTE_ID, attribute.getAttributeId().getUuidValue());
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_ATTRIBUTE_NAME, attribute.getDisplayName());
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_ATTRIBUTE_NAMESPACE, attribute.getNamespace());
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_ATTRIBUTE_TYPE, attribute.getType().toString());
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_ATTRIBUTE_OPERATORS, AttributeProviderFactory.attributeOperatorsToString(attribute.getOperators()));
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_ATTRIBUTE_AVAILABLE_VALUES, AttributeProviderFactory.objectsToString(attribute.getPredefinedValues()));
            if (attribute.getValue() == null) {
                attribute.setValue("");
            }
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_ATTRIBUTE_INITIAL_VALUE, attribute.getValue().toString());
            RdfXmlConverter2.createPropertyNode(doc, descriptionElement, ELEMENT_ATTRIBUTE_PARENT_ID, "");
            List<IAttribute> childAttributes = attribute.getChildAttributes();
            for (IAttribute childAttribute : childAttributes) {
                ArrayList<KeyValue> properties = new ArrayList<KeyValue>();
                properties.add(new KeyValue(ELEMENT_ATTRIBUTE_ID, childAttribute.getAttributeId().getUuidValue()));
                properties.add(new KeyValue(ELEMENT_ATTRIBUTE_NAME, childAttribute.getDisplayName()));
                properties.add(new KeyValue(ELEMENT_ATTRIBUTE_NAMESPACE, childAttribute.getNamespace()));
                properties.add(new KeyValue(ELEMENT_ATTRIBUTE_TYPE, childAttribute.getType().toString()));
                properties.add(new KeyValue(ELEMENT_ATTRIBUTE_OPERATORS, AttributeProviderFactory.attributeOperatorsToString(childAttribute.getOperators())));
                properties.add(new KeyValue(ELEMENT_ATTRIBUTE_AVAILABLE_VALUES, AttributeProviderFactory.objectsToString(childAttribute.getPredefinedValues())));
                if (childAttribute.getValue() == null) {
                    childAttribute.setValue("");
                }
                properties.add(new KeyValue(ELEMENT_ATTRIBUTE_INITIAL_VALUE, childAttribute.getValue().toString()));
                properties.add(new KeyValue(ELEMENT_ATTRIBUTE_PARENT_ID, attribute.getAttributeId().getUuidValue()));
                RdfXmlConverter2.createResourceXmlAndPropertyElement(doc, childAttribute, ELEMENT_NESTED_ATTRIBUTE, rdfElement, "childAttribute/" + childAttribute.getAttributeId().getUuidValue(), descriptionElement, ELEMENT_HAS_NESTED_ATTRIBUTE, properties);
            }
            return RdfXmlConverter2.transform(doc);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static IAttribute toAttribute(String rdfxml) throws TeamRepositoryException {
        try {
            String[] nestedAttributeRdfs;
            Document doc = RdfXmlConverter2.newDocument(new ByteArrayInputStream(rdfxml.getBytes(UTF_8)));
            Element rdfDescriptionElement = (Element)doc.getElementsByTagName(ELEMENT_RDF_DESCRIPTION).item(0);
            String id = RdfXmlConverter2.getElementValue(rdfDescriptionElement, ELEMENT_ATTRIBUTE_ID);
            String name = RdfXmlConverter2.getElementValue(rdfDescriptionElement, ELEMENT_ATTRIBUTE_NAME);
            String namespace = RdfXmlConverter2.getElementValue(rdfDescriptionElement, ELEMENT_ATTRIBUTE_NAMESPACE);
            String type = RdfXmlConverter2.getElementValue(rdfDescriptionElement, ELEMENT_ATTRIBUTE_TYPE);
            String operatorString = RdfXmlConverter2.getElementValue(rdfDescriptionElement, ELEMENT_ATTRIBUTE_OPERATORS);
            String availableValueString = RdfXmlConverter2.getElementValue(rdfDescriptionElement, ELEMENT_ATTRIBUTE_AVAILABLE_VALUES);
            String initialValue = RdfXmlConverter2.getElementValue(rdfDescriptionElement, ELEMENT_ATTRIBUTE_INITIAL_VALUE);
            String repositoryUrl = RdfXmlConverter2.extractRepositoryUrl(RdfXmlConverter2.getAttributeValue(doc, ELEMENT_RDF_DESCRIPTION, ATTR_RDF_ABOUT), "teamz_attribute");
            Attribute attribute = new Attribute(UUID.valueOf((String)id), namespace, name, initialValue, IAttribute.AttributeType.valueOf(type), AttributeProviderFactory.stringToObjects(availableValueString), AttributeProviderFactory.stringToAttributeOperators(operatorString), repositoryUrl);
            String[] stringArray = nestedAttributeRdfs = RdfXmlConverter2.getAttributeValues(rdfDescriptionElement, ELEMENT_HAS_NESTED_ATTRIBUTE, ATTR_RDF_RESOURCE);
            int n = nestedAttributeRdfs.length;
            int n2 = 0;
            while (n2 < n) {
                String nestedAttributeRdf = stringArray[n2];
                Element nestedAttributeElement = RdfXmlConverter2.findRdfResourceElement(doc, ELEMENT_NESTED_ATTRIBUTE, nestedAttributeRdf);
                if (nestedAttributeElement != null) {
                    id = RdfXmlConverter2.getElementValue(nestedAttributeElement, ELEMENT_ATTRIBUTE_ID);
                    name = RdfXmlConverter2.getElementValue(nestedAttributeElement, ELEMENT_ATTRIBUTE_NAME);
                    namespace = RdfXmlConverter2.getElementValue(nestedAttributeElement, ELEMENT_ATTRIBUTE_NAMESPACE);
                    type = RdfXmlConverter2.getElementValue(nestedAttributeElement, ELEMENT_ATTRIBUTE_TYPE);
                    operatorString = RdfXmlConverter2.getElementValue(nestedAttributeElement, ELEMENT_ATTRIBUTE_OPERATORS);
                    availableValueString = RdfXmlConverter2.getElementValue(nestedAttributeElement, ELEMENT_ATTRIBUTE_AVAILABLE_VALUES);
                    initialValue = RdfXmlConverter2.getElementValue(nestedAttributeElement, ELEMENT_ATTRIBUTE_INITIAL_VALUE);
                    attribute.addChildAttribute(new Attribute(UUID.valueOf((String)id), namespace, name, initialValue, IAttribute.AttributeType.valueOf(type), AttributeProviderFactory.stringToObjects(availableValueString), AttributeProviderFactory.stringToAttributeOperators(operatorString), repositoryUrl));
                }
                ++n2;
            }
            return attribute;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static Element createResourceXmlNode(Document doc, IMetadataQuery query, String name, Element parent, String rdfAboutSuffix, Element includedElement, String aboutName) {
        boolean found;
        String rdfAbout = RdfXmlConverter2.getRDFAbout(query, rdfAboutSuffix);
        Element resourceXmlElement = RdfXmlConverter2.findRdfResourceElement(doc, name, rdfAbout);
        boolean bl = found = resourceXmlElement != null;
        if (!found) {
            resourceXmlElement = doc.createElement(name);
            resourceXmlElement.setAttribute(ATTR_RDF_ABOUT, rdfAbout);
        }
        if (includedElement != null && aboutName != null) {
            Element propertyElement = doc.createElement(aboutName);
            propertyElement.setAttribute(ATTR_RDF_RESOURCE, rdfAbout);
            includedElement.appendChild(propertyElement);
        }
        if (!found) {
            parent.appendChild(resourceXmlElement);
            return resourceXmlElement;
        }
        return null;
    }

    private static Element createResourceXmlNode(Document doc, IAttribute attribute, String name, Element parent, String rdfAboutSuffix, Element includedElement, String aboutName) {
        boolean found;
        String rdfAbout = RdfXmlConverter2.getRDFAbout(attribute, rdfAboutSuffix);
        Element resourceXmlElement = RdfXmlConverter2.findRdfResourceElement(doc, name, rdfAbout);
        boolean bl = found = resourceXmlElement != null;
        if (!found) {
            resourceXmlElement = doc.createElement(name);
            resourceXmlElement.setAttribute(ATTR_RDF_ABOUT, rdfAbout);
        }
        if (includedElement != null && aboutName != null) {
            Element propertyElement = doc.createElement(aboutName);
            propertyElement.setAttribute(ATTR_RDF_RESOURCE, rdfAbout);
            includedElement.appendChild(propertyElement);
        }
        if (!found) {
            parent.appendChild(resourceXmlElement);
            return resourceXmlElement;
        }
        return null;
    }

    private static Element createPropertyNode(Document doc, Element parent, String name, String value) {
        Element propertyElement = doc.createElement(name);
        parent.appendChild(propertyElement);
        if (value != null) {
            propertyElement.setTextContent(value);
        }
        return propertyElement;
    }

    private static String getRDFAbout(IMetadataQuery query) {
        return MessageFormat.format(RDF_ABOUT_VALUE, query.getRepositoryUrl(), query.getProjectAreaUUID(), query.getId());
    }

    private static String getRDFAbout(IMetadataQuery query, String suffix) {
        return MessageFormat.format(RDF_ABOUT_VALUE2, query.getRepositoryUrl(), suffix);
    }

    private static String getRDFAbout(IAttribute attribute) {
        return MessageFormat.format(RDF_ABOUT_VALUE3, attribute.getRepositoryUrl(), attribute.getAttributeId().getUuidValue());
    }

    private static String getRDFAbout(IAttribute attribute, String suffix) {
        return MessageFormat.format(RDF_ABOUT_VALUE4, attribute.getRepositoryUrl(), suffix);
    }

    private static String extractRepositoryUrl(String rdfAbout, String namespace) {
        int index = rdfAbout.indexOf("storage/" + namespace);
        return rdfAbout.substring(0, index);
    }

    private static Document newDocument() throws ParserConfigurationException, IOException, SAXException {
        return RdfXmlConverter2.newDocument(null);
    }

    protected static Document newDocument(InputStream xmlContent) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = xmlContent == null ? documentBuilderFactory.newDocumentBuilder().newDocument() : documentBuilderFactory.newDocumentBuilder().parse(xmlContent);
        return document;
    }

    private static String transform(Document doc) throws TeamRepositoryException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
            StreamResult result = new StreamResult(outputStream);
            DOMSource source = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", YES);
            transformer.setOutputProperty(INDENT_AMOUNT, THREE);
            transformer.transform(source, result);
            return outputStream.toString(UTF_8);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static Term.Operator getOperatorByName(String operatorName) {
        if (operatorName.equals(Term.Operator.GROUP.getOperatorName())) {
            return Term.Operator.GROUP;
        }
        if (operatorName.equals(Term.Operator.OPTIONAL.getOperatorName())) {
            return Term.Operator.OPTIONAL;
        }
        if (operatorName.equals(Term.Operator.ALTERNATIVE.getOperatorName())) {
            return Term.Operator.ALTERNATIVE;
        }
        return null;
    }

    private static IAttribute.AttributeType getAttributeType(String name) {
        try {
            return IAttribute.AttributeType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static AttributeSortColumn.Direction getDirection(String name) {
        try {
            return AttributeSortColumn.Direction.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return AttributeSortColumn.Direction.ASCENDING;
        }
    }

    private static Element findRdfResourceElement(Document doc, String name, String rdfAbout) {
        NodeList nodeList = doc.getElementsByTagName(name);
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            if (element.getAttribute(ATTR_RDF_ABOUT).equals(rdfAbout)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    protected static String getElementValue(Document doc, String name) {
        NodeList list = doc.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return "";
        }
        Element element = (Element)list.item(0);
        return element.getTextContent();
    }

    private static String getElementValue(Element parent, String name) {
        NodeList list = parent.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return "";
        }
        Element element = (Element)list.item(0);
        return element.getTextContent();
    }

    private static String getAttributeValue(Element parent, String name, String attrName) {
        NodeList list = parent.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return "";
        }
        Element element = (Element)list.item(0);
        return element.getAttribute(attrName);
    }

    private static String getAttributeValue(Document doc, String name, String attrName) {
        NodeList list = doc.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return "";
        }
        Element element = (Element)list.item(0);
        return element.getAttribute(attrName);
    }

    private static String[] getAttributeValues(Element parent, String name, String attrName) {
        NodeList list = parent.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return new String[0];
        }
        String[] values = new String[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            Element element = (Element)list.item(i);
            values[i] = element.getAttribute(attrName);
            ++i;
        }
        return values;
    }

    private static IAttribute getParentAttribute(Document doc, Element element) {
        Element parentAttributeElement = RdfXmlConverter2.findRdfResourceElement(doc, ELEMENT_PARENT_ATTRIBUTE, RdfXmlConverter2.getAttributeValue(element, ELEMENT_HAS_PARENT_ATTRIBUTE, ATTR_RDF_RESOURCE));
        if (parentAttributeElement != null) {
            String parentPredicate = RdfXmlConverter2.getElementValue(parentAttributeElement, ELEMENT_PREDICATE);
            String parentDisplayName = RdfXmlConverter2.getElementValue(parentAttributeElement, ELEMENT_DISPLAY_NAME);
            String parentNamespace = RdfXmlConverter2.getElementValue(parentAttributeElement, ELEMENT_NAMESPACE);
            String parentType = RdfXmlConverter2.getElementValue(parentAttributeElement, ELEMENT_TYPE);
            IAttribute.AttributeType parentAttributeType = RdfXmlConverter2.getAttributeType(parentType);
            return new Attribute(UUID.valueOf((String)parentPredicate), parentNamespace, parentDisplayName, "", parentAttributeType, null);
        }
        return null;
    }

    private static void createParentAttributeElement(Document doc, IMetadataQuery query, Element rdfElement, IAttribute parent, Element element) {
        ArrayList<KeyValue> properties = new ArrayList<KeyValue>();
        properties.add(new KeyValue(ELEMENT_INDEX, "zindex"));
        properties.add(new KeyValue(ELEMENT_PREDICATE, parent.getAttributeId().getUuidValue()));
        properties.add(new KeyValue(ELEMENT_DISPLAY_NAME, parent.getDisplayName()));
        properties.add(new KeyValue(ELEMENT_TYPE, parent.getType().toString()));
        properties.add(new KeyValue(ELEMENT_NAMESPACE, parent.getNamespace()));
        RdfXmlConverter2.createResourceXmlAndPropertyElement(doc, query, ELEMENT_PARENT_ATTRIBUTE, rdfElement, "parentAttribute/" + parent.getAttributeId().getUuidValue(), element, ELEMENT_HAS_PARENT_ATTRIBUTE, properties);
    }

    private static Element createResourceXmlAndPropertyElement(Document doc, IMetadataQuery query, String name, Element parent, String rdfAboutSuffix, Element includedElement, String aboutName, List<KeyValue> properties) {
        Element resourceXmlElement = RdfXmlConverter2.createResourceXmlNode(doc, query, name, parent, rdfAboutSuffix, includedElement, aboutName);
        if (resourceXmlElement != null) {
            for (KeyValue next : properties) {
                RdfXmlConverter2.createPropertyNode(doc, resourceXmlElement, next.key, next.value);
            }
        }
        return resourceXmlElement;
    }

    private static Element createResourceXmlAndPropertyElement(Document doc, IAttribute attribute, String name, Element parent, String rdfAboutSuffix, Element includedElement, String aboutName, List<KeyValue> properties) {
        Element resourceXmlElement = RdfXmlConverter2.createResourceXmlNode(doc, attribute, name, parent, rdfAboutSuffix, includedElement, aboutName);
        if (resourceXmlElement != null) {
            for (KeyValue next : properties) {
                RdfXmlConverter2.createPropertyNode(doc, resourceXmlElement, next.key, next.value);
            }
        }
        return resourceXmlElement;
    }
}

