/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.common.query.util;

import com.ibm.team.enterprise.metadata.common.query.util.RdfXmlConverter2;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQueryChangeListener;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Prefix;
import com.ibm.team.enterprise.metadata.query.common.SelectClause;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.query.common.StreamScope;
import com.ibm.team.enterprise.metadata.query.common.Term;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class MetadataQuery
implements IMetadataQuery {
    private String name;
    private Statement statement;
    private String repositoryUrl;
    private List<IMetadataQueryChangeListener> listeners;
    private String projectAreaUUID;

    public MetadataQuery(String name, String repositoryUrl, String projectAreaUUID, Statement statement) {
        this.name = name;
        this.statement = statement;
        this.repositoryUrl = repositoryUrl;
        this.projectAreaUUID = projectAreaUUID;
    }

    @Override
    public String getId() {
        return MetadataQuery.generateId(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.notify(new MetadataQueryChangeEvent(MetadataQueryChangeEvent.Type.NAME_CHANGED, name));
    }

    @Override
    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    @Override
    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    private static String generateId(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    public static String generateSlug(String projectAreaUUID, String queryName) {
        StringBuffer slugBuffer = new StringBuffer("_projectAreaUUID=");
        slugBuffer.append(projectAreaUUID).append("_queryId=").append(MetadataQuery.generateId(queryName));
        return slugBuffer.toString();
    }

    @Override
    public String getSlug() {
        return MetadataQuery.generateSlug(this.projectAreaUUID, this.name);
    }

    @Override
    public String getStoragePresentation() {
        try {
            return RdfXmlConverter2.toRdfXml(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void addListener(IMetadataQueryChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IMetadataQueryChangeListener>();
        }
        this.listeners.add(listener);
        if (this.statement != null) {
            this.statement.addListener(listener);
        }
    }

    @Override
    public void removeListener(IMetadataQueryChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void notify(MetadataQueryChangeEvent event) {
        if (this.listeners == null) {
            return;
        }
        for (IMetadataQueryChangeListener listener : this.listeners) {
            listener.queryChanged(event);
        }
    }

    @Override
    public String getProjectAreaUUID() {
        return this.projectAreaUUID;
    }

    @Override
    public void setProjectArea(String projectAreaUUID) {
        this.projectAreaUUID = projectAreaUUID;
    }

    @Override
    public IMetadataQuery newMetadataQuery() {
        try {
            return (IMetadataQuery)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return new MetadataQuery(this.name, this.repositoryUrl, this.projectAreaUUID, this.statement.newStatement());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer("Query Name: " + this.getName()).append(nl);
        buffer.append("Query Id: ").append(this.getId()).append(nl);
        Statement statement = this.getStatement();
        List<Prefix> prefixes = statement.getPrefixes();
        for (Prefix prefix : prefixes) {
            buffer.append("Prefix: ").append(prefix.getName()).append(',').append(prefix.getUri()).append(nl);
        }
        SelectClause select = statement.getSelectClause();
        List<AttributeColumn> cols = select.getColumns();
        for (AttributeColumn col : cols) {
            buffer.append("AttributeColumn: ").append(col.getAttribute().getAttributeId().getUuidValue()).append(',').append(col.getAttribute().getDisplayName());
            buffer.append(',').append(col.getAttribute().getNamespace()).append(nl);
        }
        StreamScope scope = statement.getStreamScope();
        buffer.append("Scope: ").append(scope.isAllStreams()).append(scope.getStreamUUID()).append(nl);
        Term term = statement.getTerm();
        List<Expression> expressions = term.getExpressions();
        for (Expression expression : expressions) {
            AttributeExpression attrExpression = (AttributeExpression)expression;
            IAttribute attr = attrExpression.getAttribute();
            buffer.append("Expression: ").append(attr.getAttributeId().getUuidValue()).append(',').append(attr.getDisplayName()).append(',');
            buffer.append(attr.getNamespace()).append(',').append((Object)attr.getType()).append(',').append(expression.getValue()).append(nl);
            if (attr.getParent() != null) {
                IAttribute parentAttr = attr.getParent();
                buffer.append("Parent: ").append(parentAttr.getAttributeId().getUuidValue()).append(',').append(parentAttr.getDisplayName());
                buffer.append(',').append(parentAttr.getNamespace()).append(nl);
            }
            List<Object> predefinedValues = attr.getPredefinedValues();
            buffer.append("PredefinedValues: {");
            for (Object obj : predefinedValues) {
                buffer.append(obj).append(',');
            }
            buffer.append('}').append(nl);
        }
        return buffer.toString();
    }
}

