/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.common.query.util;

import com.ibm.team.enterprise.metadata.common.query.IScdQueryDescriptor;
import com.ibm.team.enterprise.metadata.common.query.util.RdfXmlConverter2;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EMFRdfXmlConverter2
extends RdfXmlConverter2 {
    public static String toRdfXml(IScdQueryDescriptor scdQuerydescriptor) throws TeamRepositoryException {
        String zipEncodedXml = scdQuerydescriptor.getInternalExpression();
        byte[] zipBytes = DataValue.Base64.decode((String)zipEncodedXml);
        String outStr = "";
        try {
            String line;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(zipBytes));
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
            while ((line = bf.readLine()) != null) {
                outStr = String.valueOf(outStr) + line;
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return outStr;
    }

    public static IScdQueryDescriptor toIScdQueryDescriptor(String rdfxml) throws TeamRepositoryException {
        try {
            Document doc = EMFRdfXmlConverter2.newDocument(new ByteArrayInputStream(rdfxml.getBytes("UTF-8")));
            NodeList queryNameNodes = doc.getElementsByTagName("ns1:queryName");
            Element queryName = (Element)queryNameNodes.item(0);
            NodeList projectAreaNodes = doc.getElementsByTagName("ns1:projectAreaUUID");
            Element projectAreaElement = (Element)projectAreaNodes.item(0);
            IScdQueryDescriptor scdQueryDescriptor = (IScdQueryDescriptor)IScdQueryDescriptor.ITEM_TYPE.createItem();
            scdQueryDescriptor.setName(queryName.getTextContent());
            String projectAreaUUID = projectAreaElement.getTextContent();
            IProjectAreaHandle projectAreahandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)projectAreaUUID), null);
            scdQueryDescriptor.setProjectArea(projectAreahandle);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(rdfxml.getBytes());
            gzip.close();
            byte[] bytes = out.toByteArray();
            String zipEncodedXml = DataValue.Base64.encode((byte[])bytes);
            scdQueryDescriptor.setInternalExpression(zipEncodedXml);
            return scdQueryDescriptor;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }
}

