/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.common.query.util;

import com.ibm.team.enterprise.metadata.common.query.util.IAttributeConstants;
import com.ibm.team.enterprise.metadata.common.query.util.Messages;
import com.ibm.team.enterprise.metadata.query.common.Attribute;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.AttributeOperator;
import com.ibm.team.enterprise.metadata.query.common.AttributeSortColumn;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class AttributeProviderFactory
implements IAttributeConstants {
    private static final String LANGUAGE_CODE_ASSEMBLER = "ASM";
    private static final String LANGUAGE_CODE_BINARY = "BIN";
    private static final String LANGUAGE_CODE_BIND = "BND";
    private static final String LANGUAGE_CODE_C = "C";
    private static final String LANGUAGE_CODE_COBOL = "COB";
    private static final String LANGUAGE_CODE_CPP = "CPP";
    private static final String LANGUAGE_CODE_CAEASYTRIEVE = "EASY";
    private static final String LANGUAGE_CODE_EMPTY = "EMP";
    private static final String LANGUAGE_CODE_JCL = "JCL";
    private static final String LANGUAGE_CODE_LINKEDIT = "LNK";
    private static final String LANGUAGE_CODE_PLI = "PLI";
    private static final String LANGUAGE_CODE_OTHER = "OTH";
    private static final String LANGUAGE_CODE_UNKNOWN = "UNK";
    private static Object[] FILE_TYPES = new Object[]{"DBD", "INCL", "MAC", "MAIN", "MAP", "MFS", "PROC", "PSP", "UNKN"};
    private static final Object[] LANGUAGE_CODES = new Object[]{"ASM", "BIN", "BND", "C", "COB", "CPP", "EASY", "EMP", "JCL", "LNK", "PLI", "OTH", "UNK"};
    private static Object[] REFERENCE_TYPES = new Object[]{"++INCLUDE", "-INC", "COPY", "MACRO", "MACRO_DEF", "PROC", "SQL INCLUDE", "UNKN"};
    private static IAttribute FILE_NAME_ATTRIBUTE;
    private static IAttribute FILE_TYPE_ATTRIBUTE;
    private static IAttribute FILE_PATH_ATTRIBUTE;
    private static IAttribute LANGUAGE_ATTRIBUTE;
    private static IAttribute LOGICAL_NAME_ATTRIBUTE;
    private static IAttribute DEPENDENCY_ATTRIBUTE;
    private static IAttribute DEPENDENCY_LOGICAL_NAME_ATTRIBUTE;
    private static IAttribute DEPENDENCY_FILE_TYPE_ATTRIBUTE;
    private static IAttribute DEPENDENCY_REF_TYPE_ATTRIBUTE;
    private static IAttribute DEPENDENCY_PATH_ATTRIBUTE;
    private static IAttribute STREAM_ATTRIBUTE;
    private static IAttribute STREAM_NAME_ATTRIBUTE;
    private static IAttribute COMPONENT_NAME_ATTRIBUTE;
    private static IAttribute COMPONENT_ID_ATTRIBUTE;
    private static AttributeProviderFactory instance;

    static {
        ArrayList<AttributeOperator> operators = new ArrayList<AttributeOperator>();
        operators.add(AttributeOperator.IS);
        operators.add(AttributeOperator.IS_NOT);
        operators.add(AttributeOperator.CONTAINS);
        operators.add(AttributeOperator.DOES_NOT_CONTAIN);
        FILE_NAME_ATTRIBUTE = new Attribute(null, "prefixScm", "fileName", "", IAttribute.AttributeType.STRING, operators);
        FILE_PATH_ATTRIBUTE = new Attribute(null, "prefixScm", "filePath", "", IAttribute.AttributeType.STRING, operators);
        LOGICAL_NAME_ATTRIBUTE = new Attribute(null, "prefixDep", "logicalName", "", IAttribute.AttributeType.STRING, operators);
        DEPENDENCY_ATTRIBUTE = new Attribute(null, "prefixDep", "dependency", "", IAttribute.AttributeType.COMPLEX, null);
        DEPENDENCY_LOGICAL_NAME_ATTRIBUTE = new Attribute(null, "prefixDep", "dependencyLogicalName", "", IAttribute.AttributeType.STRING, operators);
        DEPENDENCY_ATTRIBUTE.addChildAttribute(DEPENDENCY_LOGICAL_NAME_ATTRIBUTE);
        DEPENDENCY_PATH_ATTRIBUTE = new Attribute(null, "prefixDep", "dependencyPath", "", IAttribute.AttributeType.STRING, operators);
        DEPENDENCY_ATTRIBUTE.addChildAttribute(DEPENDENCY_PATH_ATTRIBUTE);
        operators.clear();
        operators.add(AttributeOperator.IS);
        operators.add(AttributeOperator.IS_NOT);
        FILE_TYPE_ATTRIBUTE = new Attribute(null, "prefixDep", "fileType", "", IAttribute.AttributeType.LIST, AttributeProviderFactory.getDefaultFileTypes(), operators);
        LANGUAGE_ATTRIBUTE = new Attribute(null, "prefixDep", "language", "", IAttribute.AttributeType.LIST, AttributeProviderFactory.getDefaultLanguages(), operators);
        DEPENDENCY_FILE_TYPE_ATTRIBUTE = new Attribute(null, "prefixDep", "dependencyFileType", "", IAttribute.AttributeType.LIST, AttributeProviderFactory.getDefaultFileTypes(), operators);
        DEPENDENCY_ATTRIBUTE.addChildAttribute(DEPENDENCY_FILE_TYPE_ATTRIBUTE);
        DEPENDENCY_REF_TYPE_ATTRIBUTE = new Attribute(null, "prefixDep", "dependencyReferenceType", "", IAttribute.AttributeType.LIST, AttributeProviderFactory.getDefaultReferenceTypes(), operators);
        DEPENDENCY_ATTRIBUTE.addChildAttribute(DEPENDENCY_REF_TYPE_ATTRIBUTE);
        COMPONENT_NAME_ATTRIBUTE = new Attribute(null, "prefixScm", "componentName");
        COMPONENT_ID_ATTRIBUTE = new Attribute(null, "prefixScm", "componentId", null, IAttribute.AttributeType.COMPONENT_TREE, new ArrayList<Object>(), operators);
        COMPONENT_ID_ATTRIBUTE.setDisplayConditionName(Messages.AttributeLabel_COMPONENT);
        STREAM_ATTRIBUTE = new Attribute(null, "prefixScm", "streamId");
        STREAM_NAME_ATTRIBUTE = new Attribute(null, "prefixScm", "streamName");
    }

    private AttributeProviderFactory() {
    }

    public static AttributeProviderFactory getInstance() {
        if (instance == null) {
            instance = new AttributeProviderFactory();
        }
        return instance;
    }

    public List<IAttribute> getDefaultAttributes() {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        attributes.add(FILE_NAME_ATTRIBUTE);
        attributes.add(FILE_TYPE_ATTRIBUTE);
        attributes.add(FILE_PATH_ATTRIBUTE);
        attributes.add(LANGUAGE_ATTRIBUTE);
        attributes.add(LOGICAL_NAME_ATTRIBUTE);
        attributes.add(DEPENDENCY_ATTRIBUTE);
        attributes.add(COMPONENT_ID_ATTRIBUTE);
        return attributes;
    }

    public List<AttributeColumn> getDefaultAttributeColumns() {
        ArrayList<AttributeColumn> columns = new ArrayList<AttributeColumn>();
        columns.add(new AttributeColumn(FILE_NAME_ATTRIBUTE));
        columns.add(new AttributeColumn(FILE_TYPE_ATTRIBUTE));
        columns.add(new AttributeColumn(FILE_PATH_ATTRIBUTE));
        columns.add(new AttributeColumn(LANGUAGE_ATTRIBUTE));
        columns.add(new AttributeColumn(COMPONENT_NAME_ATTRIBUTE));
        return columns;
    }

    public List<AttributeSortColumn> getDefaultAttributeSortColumns() {
        ArrayList<AttributeSortColumn> columns = new ArrayList<AttributeSortColumn>();
        return columns;
    }

    public List<AttributeColumn> getAvailableAttributeColumns() {
        List<IAttribute> defaultAttributes = this.getDefaultAttributes();
        defaultAttributes.add(STREAM_ATTRIBUTE);
        defaultAttributes.add(STREAM_NAME_ATTRIBUTE);
        defaultAttributes.add(COMPONENT_NAME_ATTRIBUTE);
        return this.createAttributeColumn(defaultAttributes);
    }

    public List<AttributeColumn> createAttributeColumn(List<IAttribute> attributes) {
        ArrayList<AttributeColumn> columns = new ArrayList<AttributeColumn>(attributes.size());
        for (IAttribute attribute : attributes) {
            if (attribute.hasChildAttributes()) {
                List<IAttribute> childAttributes = attribute.getChildAttributes();
                for (IAttribute childAttribute : childAttributes) {
                    columns.add(new AttributeColumn(childAttribute));
                }
                continue;
            }
            columns.add(new AttributeColumn(attribute));
        }
        return columns;
    }

    public List<AttributeSortColumn> getAvailableAttributeSortColumns() {
        List<IAttribute> defaultAttributes = this.getDefaultAttributes();
        defaultAttributes.add(STREAM_ATTRIBUTE);
        List<AttributeColumn> defaultColumns = this.createAttributeColumn(defaultAttributes);
        return this.createAttributeSortColumn(defaultColumns);
    }

    public List<AttributeSortColumn> createAttributeSortColumn(List<AttributeColumn> attributeColumns) {
        ArrayList<AttributeSortColumn> sortColumns = new ArrayList<AttributeSortColumn>(attributeColumns.size());
        for (AttributeColumn column : attributeColumns) {
            sortColumns.add(new AttributeSortColumn(column));
        }
        return sortColumns;
    }

    public List<AttributeSortColumn> createAttributeSortColumn2(List<IAttribute> attributes) {
        ArrayList<AttributeSortColumn> columns = new ArrayList<AttributeSortColumn>(attributes.size());
        for (IAttribute attribute : attributes) {
            if (attribute.hasChildAttributes()) {
                List<IAttribute> childAttributes = attribute.getChildAttributes();
                for (IAttribute childAttribute : childAttributes) {
                    columns.add(new AttributeSortColumn(new AttributeColumn(childAttribute)));
                }
                continue;
            }
            columns.add(new AttributeSortColumn(new AttributeColumn(attribute)));
        }
        return columns;
    }

    private static List<Object> getDefaultFileTypes() {
        return Arrays.asList(FILE_TYPES);
    }

    private static List<Object> getDefaultLanguages() {
        return Arrays.asList(LANGUAGE_CODES);
    }

    private static List<Object> getDefaultReferenceTypes() {
        return Arrays.asList(REFERENCE_TYPES);
    }

    public boolean isParentComplexAttribute(String attributeName) {
        List<IAttribute> attributes = AttributeProviderFactory.getInstance().getDefaultAttributes();
        for (IAttribute attribute : attributes) {
            if (attribute.getType() != IAttribute.AttributeType.COMPLEX) continue;
            List<IAttribute> children = attribute.getChildAttributes();
            for (IAttribute child : children) {
                if (!child.getDisplayName().equals(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static String attributeOperatorsToString(List<AttributeOperator> operators) {
        StringBuffer buffer = new StringBuffer();
        Iterator<AttributeOperator> iterator = operators.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().getIdentifier());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    public static List<AttributeOperator> stringToAttributeOperators(String string) {
        StringTokenizer st = new StringTokenizer(string, ",");
        ArrayList<AttributeOperator> operators = new ArrayList<AttributeOperator>(st.countTokens());
        while (st.hasMoreTokens()) {
            operators.add(AttributeOperator.getAttributeOperator(st.nextToken()));
        }
        return operators;
    }

    public static String objectsToString(List<Object> objects) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Object> iterator = objects.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    public static List<Object> stringToObjects(String string) {
        StringTokenizer st = new StringTokenizer(string, ",");
        ArrayList<Object> objects = new ArrayList<Object>(st.countTokens());
        while (st.hasMoreTokens()) {
            objects.add(st.nextToken());
        }
        return objects;
    }
}

