/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.common.collection.transport;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import java.util.List;

public class TransportPropertyValue {
    public static final int VALUE_TYPE_NOT_SET = -1;
    public static final int VALUE_TYPE_STRING = 0;
    public static final int VALUE_TYPE_BOOLEAN = 1;
    public static final int VALUE_TYPE_NUMBER = 2;
    public static final int VALUE_TYPE_PROPERTY_LIST = 3;
    private Object value;

    public TransportPropertyValue(String value) {
        this.value = value;
    }

    public TransportPropertyValue(Boolean value) {
        this.value = value;
    }

    public TransportPropertyValue(Number value) {
        this.value = value;
    }

    public TransportPropertyValue(List<TransportProperty> value) {
        this.value = value;
    }

    public Boolean getBooleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return null;
    }

    public Number getNumberValue() {
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        return null;
    }

    public List<TransportProperty> getPropertyList() {
        if (this.value instanceof List) {
            return (List)this.value;
        }
        return null;
    }

    public String getStringValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public int getValueType() {
        if (this.value == null) {
            return -1;
        }
        if (this.value instanceof String) {
            return 0;
        }
        if (this.value instanceof Boolean) {
            return 1;
        }
        if (this.value instanceof Number) {
            return 2;
        }
        if (this.value instanceof List) {
            return 3;
        }
        return -1;
    }

    public boolean equals(TransportPropertyValue value2) {
        if (this.getValue() == null || value2.getValue() == null) {
            return false;
        }
        switch (this.getValueType()) {
            case 1: {
                return this.getBooleanValue().booleanValue() == value2.getBooleanValue().booleanValue();
            }
            case 0: {
                return this.getStringValue().equals(value2.getStringValue());
            }
            case 2: {
                Number number1 = this.getNumberValue();
                Number number2 = value2.getNumberValue();
                if (number1 instanceof Integer) {
                    return number1.intValue() == number2.intValue();
                }
                if (number1 instanceof Short) {
                    return number1.shortValue() == number2.shortValue();
                }
                if (number1 instanceof Long) {
                    return number1.longValue() == number2.longValue();
                }
                if (number1 instanceof Float) {
                    return Float.floatToIntBits(number1.floatValue()) == Float.floatToIntBits(number2.floatValue());
                }
                if (number1 instanceof Double) {
                    return Double.doubleToLongBits(number1.doubleValue()) == Double.doubleToLongBits(number2.doubleValue());
                }
                return false;
            }
            case 3: {
                List<TransportProperty> valueList1 = this.getPropertyList();
                List<TransportProperty> valueList2 = value2.getPropertyList();
                if (valueList1 == null || valueList2 == null || valueList1.size() != valueList2.size()) break;
                boolean foundIt = false;
                for (TransportProperty prop1 : valueList1) {
                    int j = 0;
                    while (j < valueList2.size() && !foundIt) {
                        if (prop1.equals(valueList2.get(j))) {
                            foundIt = true;
                        }
                        ++j;
                    }
                    if (!foundIt) {
                        return false;
                    }
                    foundIt = false;
                }
                return true;
            }
        }
        return false;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public void setValue(List<TransportProperty> value) {
        this.value = value;
    }
}

