/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    protected static Pattern applySubREPattern = Pattern.compile("^s/(.*[^/])/(.*)/(.*)$");
    private static Pattern timePattern;
    private static long SECOND;
    private static long MINUTE;
    private static long HOUR;
    private static long DAY;
    private static long WEEK;
    private static long MONTH;
    private static long YEAR;

    static {
        SECOND = 1000L;
        MINUTE = SECOND * 60L;
        HOUR = MINUTE * 60L;
        DAY = HOUR * 24L;
        WEEK = DAY * 7L;
        MONTH = DAY * 31L;
        YEAR = DAY * 365L;
    }

    public static String[] split(String s, char c) {
        return StringUtils.split(s, c, false);
    }

    public static String[] split(String s, char c, boolean removeEscapes) {
        return StringUtils.split(s, c, removeEscapes, false);
    }

    public static String[] split(String s, char c, boolean removeEscapes, boolean preserveBlankSingleEntry) {
        char[] unEscapeChars = new char[]{'\\', c};
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s) && !preserveBlankSingleEntry) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && escapeCount % 2 == 0) {
                String s2 = new String(sArray, x1, i - x1);
                l.add(StringUtils.strip(removeEscapes ? StringUtils.unEscapeChars(s2, unEscapeChars) : s2));
                x1 = i + 1;
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        String s2 = new String(sArray, x1, sArray.length - x1);
        l.add(StringUtils.strip(removeEscapes ? StringUtils.unEscapeChars(s2, unEscapeChars) : s2));
        return l.toArray(new String[l.size()]);
    }

    public static String[] split2(String s, char c, boolean removeEscapes) {
        return StringUtils.split(s, c, removeEscapes, false);
    }

    public static String[] splitQuoted(String s, char c) {
        return StringUtils.splitQuoted(s, c, false, false);
    }

    public static String[] splitQuoted(String s, char c, boolean removeEscapes, boolean removeQuotes) {
        return StringUtils.splitQuoted(s, c, removeEscapes, removeQuotes, false);
    }

    public static String[] splitQuoted(String s, char c, boolean removeEscapes, boolean removeQuotes, boolean ignoreEmptyTokens) {
        char[] unEscapeChars = new char[]{'\\', c};
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '\\') {
                ++escapeCount;
            } else if (escapeCount % 2 == 0) {
                if (sArray[i] == '\'' && !inDoubleQuote) {
                    inSingleQuote = !inSingleQuote;
                } else if (sArray[i] == '\"' && !inSingleQuote) {
                    inDoubleQuote = !inDoubleQuote;
                } else if (sArray[i] == c && !inSingleQuote && !inDoubleQuote) {
                    String s2 = StringUtils.strip(new String(sArray, x1, i - x1));
                    if (removeEscapes) {
                        s2 = StringUtils.unEscapeChars(s2, unEscapeChars);
                    }
                    if (removeQuotes && s2.length() > 1) {
                        char c1 = s2.charAt(0);
                        char c2 = s2.charAt(s2.length() - 1);
                        if (c1 == '\'' && c2 == '\'' || c1 == '\"' && c2 == '\"') {
                            s2 = s2.substring(1, s2.length() - 1);
                        }
                    }
                    if (!ignoreEmptyTokens || !StringUtils.isEmpty(s2)) {
                        l.add(s2);
                    }
                    x1 = i + 1;
                }
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        String s2 = StringUtils.strip(new String(sArray, x1, sArray.length - x1));
        if (removeEscapes) {
            s2 = StringUtils.unEscapeChars(s2, unEscapeChars);
        }
        if (removeQuotes && s2.length() > 1) {
            char c1 = s2.charAt(0);
            char c2 = s2.charAt(s2.length() - 1);
            if (c1 == '\'' && c2 == '\'' || c1 == '\"' && c2 == '\"') {
                s2 = s2.substring(1, s2.length() - 1);
            }
        }
        if (!ignoreEmptyTokens || !StringUtils.isEmpty(s2)) {
            l.add(s2);
        }
        return l.toArray(new String[l.size()]);
    }

    public static String[] splitBracketed(String s, char c, boolean removeEscapes) {
        char[] unEscapeChars = new char[]{'\\', c};
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int bracketCount = 0;
        int escapeCount = 0;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '{') {
                ++bracketCount;
            } else if (sArray[i] == '}') {
                --bracketCount;
            } else if (bracketCount == 0 && sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && bracketCount == 0 && escapeCount % 2 == 0) {
                String s2 = StringUtils.strip(new String(sArray, x1, i - x1));
                if (removeEscapes) {
                    s2 = StringUtils.unEscapeChars(s2, unEscapeChars);
                }
                l.add(s2);
                x1 = i + 1;
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        String s2 = StringUtils.strip(new String(sArray, x1, sArray.length - x1));
        l.add(s2);
        return l.toArray(new String[l.size()]);
    }

    public static String[] split(String s, String delim) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        LinkedList<String> l = new LinkedList<String>();
        int i1 = 0;
        int i2 = 0;
        while ((i2 = s.indexOf(delim, i1)) != -1) {
            l.add(StringUtils.strip(s.substring(i1, i2)));
            i1 = i2 + delim.length();
        }
        l.add(StringUtils.strip(s.substring(i1)));
        return l.toArray(new String[l.size()]);
    }

    public static String[] split(String s) {
        if (s == null) {
            return null;
        }
        LinkedList<String> l = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }

    public static int countChars(String s, char c, boolean ignoreEscapedChars) {
        if (s == null) {
            return 0;
        }
        int n = 0;
        char[] sArray = s.toCharArray();
        int escapeCount = 0;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && escapeCount % 2 == 0) {
                ++n;
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        return n;
    }

    public static String replace(String s, String from, String to) {
        if (s == null) {
            return null;
        }
        if (from == null || from.length() == 0) {
            return s;
        }
        if (to == null) {
            to = "";
        }
        StringBuffer sb = new StringBuffer(s.length());
        int i1 = 0;
        int i2 = 0;
        while ((i2 = s.indexOf(from, i1)) != -1) {
            sb.append(s.substring(i1, i2)).append(to);
            i1 = i2 + from.length();
        }
        return sb.append(s.substring(i1)).toString();
    }

    public static String replace(String s, char from, char to) {
        return StringUtils.replace(s, from, to, false, false);
    }

    public static String replace(String s, char from, char to, boolean ignoreEscapedChars, boolean ignoreQuoted) {
        if (s == null) {
            return null;
        }
        char[] sArray = s.toCharArray();
        int escapeCount = 0;
        int singleQuoteCount = 0;
        int doubleQuoteCount = 0;
        int i = 0;
        while (i < sArray.length) {
            char c = sArray[i];
            if (c == '\\' && ignoreEscapedChars) {
                ++escapeCount;
            } else if (escapeCount % 2 == 0) {
                if (c == '\'' && ignoreQuoted) {
                    ++singleQuoteCount;
                } else if (c == '\"' && ignoreQuoted) {
                    ++doubleQuoteCount;
                } else if (c == from && singleQuoteCount % 2 == 0 && doubleQuoteCount % 2 == 0) {
                    sArray[i] = to;
                }
            }
            if (sArray[i] != '\\') {
                escapeCount = 0;
            }
            ++i;
        }
        return new String(sArray);
    }

    public static String escapeChars(String s, char[] toEscape) {
        return StringUtils.escapeChars(s, toEscape, '\\');
    }

    public static String escapeDoubleQuotes(String s) {
        return StringUtils.escapeChars(s, new char[]{'\"'}, '\\');
    }

    public static String escapeChar(String s, char c) {
        return StringUtils.escapeChars(s, new char[]{c}, '\\');
    }

    public static String escapeChars(String s, char[] toEscape, char escapeChar) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] sArray = s.toCharArray();
        int i = 0;
        while (i < sArray.length) {
            boolean isOneOf = false;
            int j = 0;
            while (j < toEscape.length && !isOneOf) {
                isOneOf = sArray[i] == toEscape[j] || sArray[i] == escapeChar;
                ++j;
            }
            if (isOneOf) {
                sb.append(escapeChar);
            }
            sb.append(sArray[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String unEscapeChars(String s, char[] toEscape) {
        return StringUtils.unEscapeChars(s, toEscape, '\\');
    }

    public static String unEscapeChars(String s, char[] toEscape, char escapeChar) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] sArray = s.toCharArray();
        int i = 0;
        while (i < sArray.length) {
            char c = sArray[i];
            if (c == escapeChar && i + 1 != sArray.length) {
                char c2 = sArray[i + 1];
                boolean isOneOf = false;
                int j = 0;
                while (j < toEscape.length && !isOneOf) {
                    isOneOf = c2 == toEscape[j];
                    ++j;
                }
                if (isOneOf) {
                    ++i;
                } else if (c2 == escapeChar) {
                    sb.append(escapeChar);
                    ++i;
                }
            }
            sb.append(sArray[i]);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        int i = c[0] == '-' ? 1 : 0;
        while (i < c.length) {
            if (c[i] < '0' || c[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String join(Object[] o, String delim) {
        if (o == null) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuffer sb = new StringBuffer();
        if (o.length > 0) {
            sb.append(o[0]);
        }
        int i = 1;
        while (i < o.length) {
            sb.append(delim).append(o[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(Object[] o, char delim, boolean escapeExisting) {
        if (o == null) {
            return null;
        }
        char[] c = new char[]{delim};
        StringBuffer sb = new StringBuffer();
        if (o.length > 0) {
            sb.append(escapeExisting ? StringUtils.escapeChars(o[0] == null ? "null" : o[0].toString(), c) : o[0]);
        }
        int i = 1;
        while (i < o.length) {
            sb.append(delim).append(escapeExisting ? StringUtils.escapeChars(o[i] == null ? "null" : o[i].toString(), c) : o[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(Iterator i, String delim) {
        if (i == null) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuffer sb = new StringBuffer();
        if (i.hasNext()) {
            sb.append(i.next());
        }
        while (i.hasNext()) {
            sb.append(delim).append(i.next());
        }
        return sb.toString();
    }

    public static String quoteAndJoin(Iterator i, String delim) {
        return StringUtils.quoteAndJoin(i, '\'', delim);
    }

    public static String quoteAndJoin(Iterator i, char quoteChar, String delim) {
        return StringUtils.quoteAndJoin(i, String.valueOf(quoteChar), String.valueOf(quoteChar), delim);
    }

    public static String quoteAndJoin(Iterator i, String startQuote, String endQuote, String delim) {
        if (i == null) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuffer sb = new StringBuffer();
        if (i.hasNext()) {
            sb.append(startQuote).append(i.next()).append(endQuote);
        }
        while (i.hasNext()) {
            sb.append(delim).append(startQuote).append(i.next()).append(endQuote);
        }
        return sb.toString();
    }

    public static String join(Iterator i, char delim, boolean escapeExisting) {
        String s;
        Object o;
        if (i == null) {
            return null;
        }
        char[] c = new char[]{delim};
        StringBuffer sb = new StringBuffer();
        if (i.hasNext()) {
            o = i.next();
            s = o == null ? "null" : o.toString();
            sb.append(escapeExisting ? StringUtils.escapeChars(s, c) : s);
        }
        while (i.hasNext()) {
            o = i.next();
            s = o == null ? "null" : o.toString();
            sb.append(delim).append(escapeExisting ? StringUtils.escapeChars(s, c) : s);
        }
        return sb.toString();
    }

    public static String strip(String s, String stripChars) {
        if (s == null || s.length() == 0 || stripChars == null || stripChars.length() == 0) {
            return s;
        }
        char[] sc = stripChars.toCharArray();
        char[] sArray = s.toCharArray();
        int startPos = 0;
        int endPos = sArray.length - 1;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == ' ' || sArray[i] == '\t' || StringUtils.charIsOneOf(sArray[i], sc)) {
                ++startPos;
            } else {
                i = sArray.length;
            }
            ++i;
        }
        i = endPos;
        while (i > startPos) {
            if (sArray[i] == ' ' || sArray[i] == '\t' || StringUtils.charIsOneOf(sArray[i], sc)) {
                --endPos;
            } else {
                i = startPos;
            }
            --i;
        }
        return new String(sArray, startPos, endPos - startPos + 1);
    }

    public static String strip(String s) {
        return StringUtils.strip(s, " \t\r\n");
    }

    public static String[] strip(String[] s, boolean removeEmpty) {
        ArrayList<String> l = new ArrayList<String>(s.length);
        int i = 0;
        while (i < s.length) {
            if (!removeEmpty || !StringUtils.isEmpty(s[i])) {
                l.add(s[i]);
            }
            ++i;
        }
        return l.toArray(new String[l.size()]);
    }

    private static boolean charIsOneOf(char c, char[] cArray) {
        int i = 0;
        while (i < cArray.length) {
            if (c == cArray[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0 || StringUtils.strip(s).length() == 0;
    }

    public static boolean getBoolean(String s) {
        return StringUtils.getBoolean(s, false);
    }

    public static boolean getBoolean(String s, boolean defaultVal) {
        if (s == null || s.length() == 0) {
            return defaultVal;
        }
        char c = s.charAt(0);
        return c == 'T' || c == 't' || c == 'Y' || c == 'y' || c == '1';
    }

    public static int getInt(String s, int defaultVal) {
        if (!StringUtils.isNumeric(s)) {
            return defaultVal;
        }
        return Integer.parseInt(s);
    }

    public static char getChar(String s, char defaultVal) {
        if (s == null || s.length() == 0) {
            return defaultVal;
        }
        return s.charAt(0);
    }

    public static String[] getVars(String type, String s) {
        type = String.valueOf(type) + "{";
        int varLength = type.length();
        LinkedList<String> l = new LinkedList<String>();
        int x1 = s.indexOf(type);
        while (x1 != -1) {
            int x2 = s.indexOf(125, x1);
            if (x2 != -1) {
                l.add(s.substring(x1 + varLength, x2));
                x1 = s.indexOf(type, x2);
                continue;
            }
            x1 = -1;
        }
        return l.toArray(new String[l.size()]);
    }

    public static String getString(String s, String defaultVal) {
        return StringUtils.getString(s, defaultVal, false);
    }

    public static String getString(String s, String defaultVal, boolean trim) {
        if (s == null || s.length() == 0) {
            s = defaultVal;
        }
        if (s == null) {
            return null;
        }
        return trim ? s.trim() : s;
    }

    public static LinkedHashMap getMap(String s) throws ParseException {
        return StringUtils.getMap(s, ',', '=');
    }

    public static LinkedHashMap<String, String> getMap(String s, char delim, char equals) throws ParseException {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        String[] tokens = StringUtils.split(s, delim, true);
        int i = 0;
        while (i < tokens.length) {
            String[] s2 = StringUtils.split(tokens[i], equals, true);
            if (s2.length != 2) {
                throw new ParseException("Invalid map string: [" + s + "]", 0);
            }
            String o = m.put(s2[0], s2[1]);
            if (o != null) {
                throw new ParseException("Duplicate keys in map string: [" + s + "]", 0);
            }
            ++i;
        }
        return m;
    }

    public static String makeUnicodeReadable(String s) {
        StringBuffer sb = new StringBuffer(s.length() * 2);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < ' ' || c > '~') {
                sb.append("\\u" + StringUtils.toHex(c, 4));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String convertToCsv(String input) {
        StringBuffer buf = new StringBuffer();
        boolean specialCharExists = false;
        int i = 0;
        while (i < input.length()) {
            char curChar = input.charAt(i);
            switch (curChar) {
                case '\n': {
                    specialCharExists = true;
                    break;
                }
                case ',': {
                    specialCharExists = true;
                    break;
                }
                case '\"': {
                    buf.append('\"');
                    specialCharExists = true;
                    break;
                }
            }
            buf.append(curChar);
            ++i;
        }
        return specialCharExists ? "\"" + buf + "\"" : input;
    }

    public static String convertToHtml(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char test = chars[i];
            if (test == '&') {
                sb.append("&amp;");
            } else if (test == '<') {
                sb.append("&lt;");
            } else if (test == '>') {
                sb.append("&gt;");
            } else if (test == '\"') {
                sb.append("&quot;");
            } else if (Character.isISOControl(test)) {
                sb.append("&#" + test + ";");
            } else {
                sb.append(test);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toValidXmlString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char test = chars[i];
            if (Character.isWhitespace(test) && test != ' ') {
                sb.append("&#" + test + ";");
            } else {
                sb.append(test);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String htmlEscape(String s) {
        StringBuffer sb = new StringBuffer(s.length() * 2);
        char[] cArray = s.toCharArray();
        int i = 0;
        while (i < cArray.length) {
            char c = cArray[i];
            if (c >= '@' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '-' && c <= '9' || c == '*' || c == '+' || c == '_') {
                sb.append(c);
            } else if (c > '\u00ff') {
                sb.append("%u" + StringUtils.toHex(c, 4));
            } else {
                sb.append("%" + StringUtils.toHex(c, 2));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toHex(int num, int numDigits) {
        char[] c = new char[numDigits];
        int a = num % 16;
        c[numDigits - 1] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        int base = 16;
        int i = 1;
        while (i < numDigits) {
            a = num / base % 16;
            base <<= 4;
            c[numDigits - 1 - i] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
            ++i;
        }
        return new String(c);
    }

    public static boolean isValidIdentifier(String s) {
        if (s == null || s.equals("")) {
            return false;
        }
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (i == 0 && !Character.isLetter(c[i])) {
                return false;
            }
            if (!Character.isLetterOrDigit(c[i]) && c[i] != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String escapeApostrophes(String s) {
        char[] c = s.toCharArray();
        StringBuffer sb = new StringBuffer(s.length() + 1);
        int escapeCount = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int i = 0;
        while (i < c.length) {
            if (c[i] == '\\') {
                ++escapeCount;
            } else if (escapeCount % 2 == 0) {
                if (c[i] == '\'') {
                    if (inDoubleQuote || i > 0 && i < c.length - 1 && !Character.isWhitespace(c[i - 1]) && c[i - 1] != '+' && c[i - 1] != '-' && !Character.isWhitespace(c[i + 1])) {
                        sb.append('\\');
                    } else {
                        inSingleQuote = !inSingleQuote;
                    }
                } else if (c[i] == '\"') {
                    if (inSingleQuote || i > 0 && i < c.length - 1 && !Character.isWhitespace(c[i - 1]) && c[i - 1] != '+' && c[i - 1] != '-' && !Character.isWhitespace(c[i + 1])) {
                        sb.append('\\');
                    } else {
                        boolean bl = inDoubleQuote = !inDoubleQuote;
                    }
                }
            }
            if (c[i] != '\\') {
                escapeCount = 0;
            }
            sb.append(c[i]);
            ++i;
        }
        if (inSingleQuote || inDoubleQuote) {
            throw new RuntimeException("Single or double quote not properly closed in the following expression: [" + s + "]");
        }
        return sb.toString();
    }

    public static String[] fragment(String s, int length) {
        LinkedList<String> l = new LinkedList<String>();
        int i = 0;
        while (i < s.length()) {
            int j = Math.min(i + length, s.length());
            l.add(s.substring(i, j));
            i += length;
        }
        return l.toArray(new String[l.size()]);
    }

    public static String applySubRE(String re, String s) {
        Matcher m = applySubREPattern.matcher(re);
        if (m.find()) {
            boolean isGlobal = m.group(3).indexOf(103) != -1;
            boolean isMultiLine = m.group(3).indexOf(115) == -1;
            Pattern p = Pattern.compile(m.group(1), isMultiLine ? 8 : 32);
            Matcher m2 = p.matcher(s);
            if (isGlobal) {
                return m2.replaceAll(m.group(2));
            }
            return m2.replaceFirst(m.group(2));
        }
        return s;
    }

    public static boolean containsUnEscapedChars(String s, char[] chars) {
        char[] sArray = s.toCharArray();
        boolean inEscape = false;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '\\') {
                inEscape = !inEscape;
            } else {
                if (!inEscape) {
                    int j = 0;
                    while (j < chars.length) {
                        if (sArray[i] == chars[j]) {
                            return true;
                        }
                        ++j;
                    }
                }
                inEscape = false;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsEscapedChars(String s, char[] chars) {
        char[] sArray = s.toCharArray();
        boolean inEscape = false;
        int i = 0;
        while (i < sArray.length) {
            if (sArray[i] == '\\') {
                inEscape = !inEscape;
            } else {
                if (inEscape) {
                    int j = 0;
                    while (j < chars.length) {
                        if (sArray[i] == chars[j]) {
                            return true;
                        }
                        ++j;
                    }
                }
                inEscape = false;
            }
            ++i;
        }
        return false;
    }

    public static String chop(String s, int length) {
        if (s.length() < length) {
            return s;
        }
        return s.substring(0, length);
    }

    public static String[] addToArray(String[] array, String s) {
        String[] newArray;
        String[] stringArray = newArray = array == null ? new String[1] : new String[array.length + 1];
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                newArray[i] = array[i];
                ++i;
            }
        }
        newArray[newArray.length - 1] = s;
        return newArray;
    }

    public static String toValidHref(String s) {
        if (s == null) {
            s = "";
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char test = chars[i];
            if (test == '\"') {
                sb.append("&quot;");
            } else if (test == '\'') {
                sb.append("&#39;");
            } else {
                sb.append(test);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toValidXml(String s) {
        return StringUtils.convertToHtml(s);
    }

    public static String toValidXmlAttr(String s) {
        return StringUtils.toValidHref(s);
    }

    public static String toValidJavascriptParam(String s) {
        return StringUtils.escapeChars(s, new char[]{'\'', '\"'});
    }

    public static long parseTime(String s) {
        if (timePattern == null) {
            timePattern = Pattern.compile("(\\d+)\\s*(\\w*)");
        }
        if ((s = s.toUpperCase()).equals("NEVER")) {
            return Long.MAX_VALUE;
        }
        if (s.equals("")) {
            return 0L;
        }
        Matcher m = timePattern.matcher(s);
        if (!m.matches()) {
            throw new RuntimeException("Invalid time string format: [" + s + "]");
        }
        long n = Long.parseLong(m.group(1));
        String x = m.group(2);
        if (x.startsWith("S")) {
            n *= SECOND;
        } else if (x.startsWith("MIN")) {
            n *= MINUTE;
        } else if (x.startsWith("H")) {
            n *= HOUR;
        } else if (x.startsWith("D")) {
            n *= DAY;
        } else if (x.startsWith("W")) {
            n *= WEEK;
        } else if (x.startsWith("MO")) {
            n *= MONTH;
        } else if (x.startsWith("Y")) {
            n *= YEAR;
        }
        return n;
    }

    public static String getTimeString(long l) {
        long x;
        LinkedList<String> parts = new LinkedList<String>();
        if (l == Long.MAX_VALUE) {
            return "never";
        }
        if (l >= YEAR) {
            x = l / YEAR;
            l %= YEAR;
            parts.add(String.valueOf(x) + " year" + (x > 1L ? "s" : ""));
        }
        if (l >= MONTH) {
            x = l / MONTH;
            l %= MONTH;
            parts.add(String.valueOf(x) + " month" + (x > 1L ? "s" : ""));
        }
        if (l >= DAY) {
            x = l / DAY;
            l %= DAY;
            parts.add(String.valueOf(x) + " day" + (x > 1L ? "s" : ""));
        }
        if (l >= HOUR) {
            x = l / HOUR;
            l %= HOUR;
            parts.add(String.valueOf(x) + " hour" + (x > 1L ? "s" : ""));
        }
        if (l >= MINUTE) {
            x = l / MINUTE;
            l %= MINUTE;
            parts.add(String.valueOf(x) + " minute" + (x > 1L ? "s" : ""));
        }
        if (l >= SECOND) {
            x = l / SECOND;
            l %= SECOND;
            parts.add(String.valueOf(x) + " second" + (x > 1L ? "s" : ""));
        }
        return StringUtils.join(parts.iterator(), ",");
    }

    public static String getTimeStringShort(long l) {
        StringBuffer sb = new StringBuffer();
        long x = l / HOUR;
        sb.append(String.valueOf(x) + ":");
        x = (l %= HOUR) / MINUTE;
        sb.append(String.valueOf(x < 10L ? "0" : "") + x + ":");
        x = (l %= MINUTE) / SECOND;
        l %= SECOND;
        sb.append(String.valueOf(x < 10L ? "0" : "") + x);
        return sb.toString();
    }

    public static boolean needsTruncate(String s, int length, String charset) throws UnsupportedEncodingException {
        return s.getBytes(charset).length > length;
    }

    /*
     * Unable to fully structure code
     */
    public static String truncateBytes(String s, int length, String charset) throws UnsupportedEncodingException {
        cs = Charset.forName(charset);
        encoder = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(new byte[]{63});
        try {
            in = CharBuffer.wrap(s);
            out = ByteBuffer.allocate(length);
            result = encoder.encode(in, out, true);
            hadReplacement = false;
            buf = out.array();
            i = 0;
            while (i < buf.length && !hadReplacement) {
                if (buf[i] == 63) {
                    hadReplacement = true;
                }
                ++i;
            }
            s2 = null;
            if (result.isOverflow() || hadReplacement) {
                out.limit(out.position());
                decoder = cs.newDecoder();
                out.rewind();
                s2 = decoder.decode(out).toString();
            } else {
                s2 = s;
            }
            if (s2.getBytes(charset).length > length) {
                return s2.substring(0, s2.length() - 1);
            }
            return s2;
        }
        catch (Throwable t) {
            ** while (s.getBytes((String)charset).length > length)
        }
lbl-1000:
        // 1 sources

        {
            s = s.substring(0, s.length() - 1);
            continue;
        }
lbl32:
        // 1 sources

        return s;
    }

    public static String getReaderContents(Reader r) throws IOException {
        StringBuffer sb = new StringBuffer();
        char[] cbuf = new char[1024];
        int charsRead = 0;
        while ((charsRead = r.read(cbuf, 0, 1024)) != -1) {
            sb.append(cbuf, 0, charsRead);
        }
        return sb.toString();
    }

    public static boolean isHexChars(String iString) {
        if (iString == null || iString.length() == 0) {
            return false;
        }
        char[] c = iString.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!(c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'f' || c[i] >= 'A' && c[i] <= 'F')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLike(String pattern, String source) {
        char zeroOrMore = '*';
        char anyChar = '?';
        return StringUtils.isLike(pattern, source, zeroOrMore, anyChar);
    }

    public static boolean isLike(String pattern, String source, char zeroOrMore, char anyChar) {
        if (source == null || pattern == null) {
            return false;
        }
        if (source.equals(pattern)) {
            return true;
        }
        int patternLen = pattern.length();
        StringBuffer wildcard = new StringBuffer(pattern);
        StringBuffer receiver = new StringBuffer(source);
        int iText = 0;
        int iPattern = 0;
        int lastStar = 0;
        int len = source.length();
        while (iPattern < patternLen) {
            char p;
            if ((p = wildcard.charAt(iPattern++)) == zeroOrMore) {
                if (iPattern >= patternLen) {
                    return true;
                }
                lastStar = iPattern;
                continue;
            }
            if (iText >= len) {
                return false;
            }
            char t = receiver.charAt(iText++);
            if (p == anyChar || p == t) {
                if (lastStar <= 0 || iPattern < patternLen || iText >= len) {
                    continue;
                }
            } else if (lastStar == 0) {
                return false;
            }
            int matched = iPattern - lastStar - 1;
            iPattern = lastStar;
            iText -= matched;
        }
        return iText >= len;
    }

    public static String[] removeDuplicates(String[] dups) {
        HashSet<String> nd = new HashSet<String>(dups.length);
        String[] stringArray = dups;
        int n = dups.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            nd.add(s);
            ++n2;
        }
        String[] noDups = nd.toArray(new String[nd.size()]);
        return noDups;
    }
}

